/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.StringType;

public class CapabilityStatement40_50
extends VersionConvertor_40_50 {
    public static CapabilityStatement convertCapabilityStatement(org.hl7.fhir.r4.model.CapabilityStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement tgt = new CapabilityStatement();
        CapabilityStatement40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(CapabilityStatement40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(CapabilityStatement40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(CapabilityStatement40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(CapabilityStatement40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(CapabilityStatement40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(CapabilityStatement40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(CapabilityStatement40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(CapabilityStatement40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CapabilityStatement40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(CapabilityStatement40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(CapabilityStatement40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(CapabilityStatement40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(CapabilityStatement40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(CapabilityStatement40_50.convertCapabilityStatementKind(src.getKindElement()));
        }
        for (org.hl7.fhir.r4.model.CanonicalType canonicalType : src.getInstantiates()) {
            tgt.getInstantiates().add(CapabilityStatement40_50.convertCanonical(canonicalType));
        }
        for (org.hl7.fhir.r4.model.CanonicalType canonicalType : src.getImports()) {
            tgt.getImports().add(CapabilityStatement40_50.convertCanonical(canonicalType));
        }
        if (src.hasSoftware()) {
            tgt.setSoftware(CapabilityStatement40_50.convertCapabilityStatementSoftwareComponent(src.getSoftware()));
        }
        if (src.hasImplementation()) {
            tgt.setImplementation(CapabilityStatement40_50.convertCapabilityStatementImplementationComponent(src.getImplementation()));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersionElement(Enumerations40_50.convertFHIRVersion(src.getFhirVersionElement()));
        }
        for (CodeType codeType : src.getFormat()) {
            tgt.getFormat().add(CapabilityStatement40_50.convertCode(codeType));
        }
        for (CodeType codeType : src.getPatchFormat()) {
            tgt.getPatchFormat().add(CapabilityStatement40_50.convertCode(codeType));
        }
        for (org.hl7.fhir.r4.model.CanonicalType canonicalType : src.getImplementationGuide()) {
            tgt.getImplementationGuide().add(CapabilityStatement40_50.convertCanonical(canonicalType));
        }
        for (CapabilityStatement.CapabilityStatementRestComponent capabilityStatementRestComponent : src.getRest()) {
            tgt.addRest(CapabilityStatement40_50.convertCapabilityStatementRestComponent(capabilityStatementRestComponent));
        }
        for (CapabilityStatement.CapabilityStatementMessagingComponent capabilityStatementMessagingComponent : src.getMessaging()) {
            tgt.addMessaging(CapabilityStatement40_50.convertCapabilityStatementMessagingComponent(capabilityStatementMessagingComponent));
        }
        for (CapabilityStatement.CapabilityStatementDocumentComponent capabilityStatementDocumentComponent : src.getDocument()) {
            tgt.addDocument(CapabilityStatement40_50.convertCapabilityStatementDocumentComponent(capabilityStatementDocumentComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CapabilityStatement convertCapabilityStatement(CapabilityStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CapabilityStatement tgt = new org.hl7.fhir.r4.model.CapabilityStatement();
        CapabilityStatement40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(CapabilityStatement40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(CapabilityStatement40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(CapabilityStatement40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(CapabilityStatement40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(CapabilityStatement40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(CapabilityStatement40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(CapabilityStatement40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(CapabilityStatement40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CapabilityStatement40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(CapabilityStatement40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(CapabilityStatement40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(CapabilityStatement40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(CapabilityStatement40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(CapabilityStatement40_50.convertCapabilityStatementKind(src.getKindElement()));
        }
        for (CanonicalType canonicalType : src.getInstantiates()) {
            tgt.getInstantiates().add(CapabilityStatement40_50.convertCanonical(canonicalType));
        }
        for (CanonicalType canonicalType : src.getImports()) {
            tgt.getImports().add(CapabilityStatement40_50.convertCanonical(canonicalType));
        }
        if (src.hasSoftware()) {
            tgt.setSoftware(CapabilityStatement40_50.convertCapabilityStatementSoftwareComponent(src.getSoftware()));
        }
        if (src.hasImplementation()) {
            tgt.setImplementation(CapabilityStatement40_50.convertCapabilityStatementImplementationComponent(src.getImplementation()));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersionElement(Enumerations40_50.convertFHIRVersion(src.getFhirVersionElement()));
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getFormat()) {
            tgt.getFormat().add(CapabilityStatement40_50.convertCode(codeType));
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getPatchFormat()) {
            tgt.getPatchFormat().add(CapabilityStatement40_50.convertCode(codeType));
        }
        for (CanonicalType canonicalType : src.getImplementationGuide()) {
            tgt.getImplementationGuide().add(CapabilityStatement40_50.convertCanonical(canonicalType));
        }
        for (CapabilityStatement.CapabilityStatementRestComponent capabilityStatementRestComponent : src.getRest()) {
            tgt.addRest(CapabilityStatement40_50.convertCapabilityStatementRestComponent(capabilityStatementRestComponent));
        }
        for (CapabilityStatement.CapabilityStatementMessagingComponent capabilityStatementMessagingComponent : src.getMessaging()) {
            tgt.addMessaging(CapabilityStatement40_50.convertCapabilityStatementMessagingComponent(capabilityStatementMessagingComponent));
        }
        for (CapabilityStatement.CapabilityStatementDocumentComponent capabilityStatementDocumentComponent : src.getDocument()) {
            tgt.addDocument(CapabilityStatement40_50.convertCapabilityStatementDocumentComponent(capabilityStatementDocumentComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.CapabilityStatementKind> convertCapabilityStatementKind(Enumeration<CapabilityStatement.CapabilityStatementKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.CapabilityStatementKind> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.CapabilityStatementKind>(new Enumerations.CapabilityStatementKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.CapabilityStatementKind)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.INSTANCE);
                break;
            }
            case CAPABILITY: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.CAPABILITY);
                break;
            }
            case REQUIREMENTS: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.REQUIREMENTS);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.CapabilityStatementKind> convertCapabilityStatementKind(org.hl7.fhir.r5.model.Enumeration<Enumerations.CapabilityStatementKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.CapabilityStatementKind> tgt = new Enumeration<CapabilityStatement.CapabilityStatementKind>(new CapabilityStatement.CapabilityStatementKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.CapabilityStatementKind)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)CapabilityStatement.CapabilityStatementKind.INSTANCE);
                break;
            }
            case CAPABILITY: {
                tgt.setValue((Object)CapabilityStatement.CapabilityStatementKind.CAPABILITY);
                break;
            }
            case REQUIREMENTS: {
                tgt.setValue((Object)CapabilityStatement.CapabilityStatementKind.REQUIREMENTS);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.CapabilityStatementKind.NULL);
            }
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementSoftwareComponent convertCapabilityStatementSoftwareComponent(CapabilityStatement.CapabilityStatementSoftwareComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementSoftwareComponent tgt = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(CapabilityStatement40_50.convertString(src.getNameElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(CapabilityStatement40_50.convertString(src.getVersionElement()));
        }
        if (src.hasReleaseDate()) {
            tgt.setReleaseDateElement(CapabilityStatement40_50.convertDateTime(src.getReleaseDateElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementSoftwareComponent convertCapabilityStatementSoftwareComponent(CapabilityStatement.CapabilityStatementSoftwareComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementSoftwareComponent tgt = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(CapabilityStatement40_50.convertString(src.getNameElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(CapabilityStatement40_50.convertString(src.getVersionElement()));
        }
        if (src.hasReleaseDate()) {
            tgt.setReleaseDateElement(CapabilityStatement40_50.convertDateTime(src.getReleaseDateElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementImplementationComponent convertCapabilityStatementImplementationComponent(CapabilityStatement.CapabilityStatementImplementationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementImplementationComponent tgt = new CapabilityStatement.CapabilityStatementImplementationComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CapabilityStatement40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(CapabilityStatement40_50.convertUrl(src.getUrlElement()));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(CapabilityStatement40_50.convertReference(src.getCustodian()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementImplementationComponent convertCapabilityStatementImplementationComponent(CapabilityStatement.CapabilityStatementImplementationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementImplementationComponent tgt = new CapabilityStatement.CapabilityStatementImplementationComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CapabilityStatement40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(CapabilityStatement40_50.convertUrl(src.getUrlElement()));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(CapabilityStatement40_50.convertReference(src.getCustodian()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestComponent convertCapabilityStatementRestComponent(CapabilityStatement.CapabilityStatementRestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestComponent tgt = new CapabilityStatement.CapabilityStatementRestComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(CapabilityStatement40_50.convertRestfulCapabilityMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        if (src.hasSecurity()) {
            tgt.setSecurity(CapabilityStatement40_50.convertCapabilityStatementRestSecurityComponent(src.getSecurity()));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent capabilityStatementRestResourceComponent : src.getResource()) {
            tgt.addResource(CapabilityStatement40_50.convertCapabilityStatementRestResourceComponent(capabilityStatementRestResourceComponent));
        }
        for (CapabilityStatement.SystemInteractionComponent systemInteractionComponent : src.getInteraction()) {
            tgt.addInteraction(CapabilityStatement40_50.convertSystemInteractionComponent(systemInteractionComponent));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent capabilityStatementRestResourceSearchParamComponent : src.getSearchParam()) {
            tgt.addSearchParam(CapabilityStatement40_50.convertCapabilityStatementRestResourceSearchParamComponent(capabilityStatementRestResourceSearchParamComponent));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent capabilityStatementRestResourceOperationComponent : src.getOperation()) {
            tgt.addOperation(CapabilityStatement40_50.convertCapabilityStatementRestResourceOperationComponent(capabilityStatementRestResourceOperationComponent));
        }
        for (org.hl7.fhir.r4.model.CanonicalType canonicalType : src.getCompartment()) {
            tgt.getCompartment().add(CapabilityStatement40_50.convertCanonical(canonicalType));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestComponent convertCapabilityStatementRestComponent(CapabilityStatement.CapabilityStatementRestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestComponent tgt = new CapabilityStatement.CapabilityStatementRestComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(CapabilityStatement40_50.convertRestfulCapabilityMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        if (src.hasSecurity()) {
            tgt.setSecurity(CapabilityStatement40_50.convertCapabilityStatementRestSecurityComponent(src.getSecurity()));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent capabilityStatementRestResourceComponent : src.getResource()) {
            tgt.addResource(CapabilityStatement40_50.convertCapabilityStatementRestResourceComponent(capabilityStatementRestResourceComponent));
        }
        for (CapabilityStatement.SystemInteractionComponent systemInteractionComponent : src.getInteraction()) {
            tgt.addInteraction(CapabilityStatement40_50.convertSystemInteractionComponent(systemInteractionComponent));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent capabilityStatementRestResourceSearchParamComponent : src.getSearchParam()) {
            tgt.addSearchParam(CapabilityStatement40_50.convertCapabilityStatementRestResourceSearchParamComponent(capabilityStatementRestResourceSearchParamComponent));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent capabilityStatementRestResourceOperationComponent : src.getOperation()) {
            tgt.addOperation(CapabilityStatement40_50.convertCapabilityStatementRestResourceOperationComponent(capabilityStatementRestResourceOperationComponent));
        }
        for (CanonicalType canonicalType : src.getCompartment()) {
            tgt.getCompartment().add(CapabilityStatement40_50.convertCanonical(canonicalType));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RestfulCapabilityMode> convertRestfulCapabilityMode(Enumeration<CapabilityStatement.RestfulCapabilityMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RestfulCapabilityMode> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RestfulCapabilityMode>(new Enumerations.RestfulCapabilityModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.RestfulCapabilityMode)((Object)src.getValue())) {
            case CLIENT: {
                tgt.setValue((Object)Enumerations.RestfulCapabilityMode.CLIENT);
                break;
            }
            case SERVER: {
                tgt.setValue((Object)Enumerations.RestfulCapabilityMode.SERVER);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RestfulCapabilityMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.RestfulCapabilityMode> convertRestfulCapabilityMode(org.hl7.fhir.r5.model.Enumeration<Enumerations.RestfulCapabilityMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.RestfulCapabilityMode> tgt = new Enumeration<CapabilityStatement.RestfulCapabilityMode>(new CapabilityStatement.RestfulCapabilityModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RestfulCapabilityMode)((Object)src.getValue())) {
            case CLIENT: {
                tgt.setValue((Object)CapabilityStatement.RestfulCapabilityMode.CLIENT);
                break;
            }
            case SERVER: {
                tgt.setValue((Object)CapabilityStatement.RestfulCapabilityMode.SERVER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.RestfulCapabilityMode.NULL);
            }
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestSecurityComponent convertCapabilityStatementRestSecurityComponent(CapabilityStatement.CapabilityStatementRestSecurityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestSecurityComponent tgt = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCors()) {
            tgt.setCorsElement(CapabilityStatement40_50.convertBoolean(src.getCorsElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getService()) {
            tgt.addService(CapabilityStatement40_50.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CapabilityStatement40_50.convertMarkdown(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestSecurityComponent convertCapabilityStatementRestSecurityComponent(CapabilityStatement.CapabilityStatementRestSecurityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestSecurityComponent tgt = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCors()) {
            tgt.setCorsElement(CapabilityStatement40_50.convertBoolean(src.getCorsElement()));
        }
        for (CodeableConcept t : src.getService()) {
            tgt.addService(CapabilityStatement40_50.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CapabilityStatement40_50.convertMarkdown(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceComponent convertCapabilityStatementRestResourceComponent(CapabilityStatement.CapabilityStatementRestResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(CapabilityStatement40_50.convertResourceEnum(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(CapabilityStatement40_50.convertCanonical(src.getProfileElement()));
        }
        for (org.hl7.fhir.r4.model.CanonicalType canonicalType : src.getSupportedProfile()) {
            tgt.getSupportedProfile().add(CapabilityStatement40_50.convertCanonical(canonicalType));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        for (CapabilityStatement.ResourceInteractionComponent resourceInteractionComponent : src.getInteraction()) {
            tgt.addInteraction(CapabilityStatement40_50.convertResourceInteractionComponent(resourceInteractionComponent));
        }
        if (src.hasVersioning()) {
            tgt.setVersioningElement(CapabilityStatement40_50.convertResourceVersionPolicy(src.getVersioningElement()));
        }
        if (src.hasReadHistory()) {
            tgt.setReadHistoryElement(CapabilityStatement40_50.convertBoolean(src.getReadHistoryElement()));
        }
        if (src.hasUpdateCreate()) {
            tgt.setUpdateCreateElement(CapabilityStatement40_50.convertBoolean(src.getUpdateCreateElement()));
        }
        if (src.hasConditionalCreate()) {
            tgt.setConditionalCreateElement(CapabilityStatement40_50.convertBoolean(src.getConditionalCreateElement()));
        }
        if (src.hasConditionalRead()) {
            tgt.setConditionalReadElement(CapabilityStatement40_50.convertConditionalReadStatus(src.getConditionalReadElement()));
        }
        if (src.hasConditionalUpdate()) {
            tgt.setConditionalUpdateElement(CapabilityStatement40_50.convertBoolean(src.getConditionalUpdateElement()));
        }
        if (src.hasConditionalDelete()) {
            tgt.setConditionalDeleteElement(CapabilityStatement40_50.convertConditionalDeleteStatus(src.getConditionalDeleteElement()));
        }
        tgt.setReferencePolicy(src.getReferencePolicy().stream().map(CapabilityStatement40_50::convertReferenceHandlingPolicy).collect(Collectors.toList()));
        for (org.hl7.fhir.r4.model.StringType stringType : src.getSearchInclude()) {
            tgt.getSearchInclude().add(CapabilityStatement40_50.convertString(stringType));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getSearchRevInclude()) {
            tgt.getSearchRevInclude().add(CapabilityStatement40_50.convertString(stringType));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent capabilityStatementRestResourceSearchParamComponent : src.getSearchParam()) {
            tgt.addSearchParam(CapabilityStatement40_50.convertCapabilityStatementRestResourceSearchParamComponent(capabilityStatementRestResourceSearchParamComponent));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent capabilityStatementRestResourceOperationComponent : src.getOperation()) {
            tgt.addOperation(CapabilityStatement40_50.convertCapabilityStatementRestResourceOperationComponent(capabilityStatementRestResourceOperationComponent));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceComponent convertCapabilityStatementRestResourceComponent(CapabilityStatement.CapabilityStatementRestResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(CapabilityStatement40_50.convertResourceEnum(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(CapabilityStatement40_50.convertCanonical(src.getProfileElement()));
        }
        for (CanonicalType canonicalType : src.getSupportedProfile()) {
            tgt.getSupportedProfile().add(CapabilityStatement40_50.convertCanonical(canonicalType));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        for (CapabilityStatement.ResourceInteractionComponent resourceInteractionComponent : src.getInteraction()) {
            tgt.addInteraction(CapabilityStatement40_50.convertResourceInteractionComponent(resourceInteractionComponent));
        }
        if (src.hasVersioning()) {
            tgt.setVersioningElement(CapabilityStatement40_50.convertResourceVersionPolicy(src.getVersioningElement()));
        }
        if (src.hasReadHistory()) {
            tgt.setReadHistoryElement(CapabilityStatement40_50.convertBoolean(src.getReadHistoryElement()));
        }
        if (src.hasUpdateCreate()) {
            tgt.setUpdateCreateElement(CapabilityStatement40_50.convertBoolean(src.getUpdateCreateElement()));
        }
        if (src.hasConditionalCreate()) {
            tgt.setConditionalCreateElement(CapabilityStatement40_50.convertBoolean(src.getConditionalCreateElement()));
        }
        if (src.hasConditionalRead()) {
            tgt.setConditionalReadElement(CapabilityStatement40_50.convertConditionalReadStatus(src.getConditionalReadElement()));
        }
        if (src.hasConditionalUpdate()) {
            tgt.setConditionalUpdateElement(CapabilityStatement40_50.convertBoolean(src.getConditionalUpdateElement()));
        }
        if (src.hasConditionalDelete()) {
            tgt.setConditionalDeleteElement(CapabilityStatement40_50.convertConditionalDeleteStatus(src.getConditionalDeleteElement()));
        }
        tgt.setReferencePolicy(src.getReferencePolicy().stream().map(CapabilityStatement40_50::convertReferenceHandlingPolicy).collect(Collectors.toList()));
        for (StringType stringType : src.getSearchInclude()) {
            tgt.getSearchInclude().add(CapabilityStatement40_50.convertString(stringType));
        }
        for (StringType stringType : src.getSearchRevInclude()) {
            tgt.getSearchRevInclude().add(CapabilityStatement40_50.convertString(stringType));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent capabilityStatementRestResourceSearchParamComponent : src.getSearchParam()) {
            tgt.addSearchParam(CapabilityStatement40_50.convertCapabilityStatementRestResourceSearchParamComponent(capabilityStatementRestResourceSearchParamComponent));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent capabilityStatementRestResourceOperationComponent : src.getOperation()) {
            tgt.addOperation(CapabilityStatement40_50.convertCapabilityStatementRestResourceOperationComponent(capabilityStatementRestResourceOperationComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ResourceVersionPolicy> convertResourceVersionPolicy(Enumeration<CapabilityStatement.ResourceVersionPolicy> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ResourceVersionPolicy> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ResourceVersionPolicy>(new CapabilityStatement.ResourceVersionPolicyEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ResourceVersionPolicy)((Object)src.getValue())) {
            case NOVERSION: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.NOVERSION);
                break;
            }
            case VERSIONED: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.VERSIONED);
                break;
            }
            case VERSIONEDUPDATE: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.VERSIONEDUPDATE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.ResourceVersionPolicy> convertResourceVersionPolicy(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ResourceVersionPolicy> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.ResourceVersionPolicy> tgt = new Enumeration<CapabilityStatement.ResourceVersionPolicy>(new CapabilityStatement.ResourceVersionPolicyEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ResourceVersionPolicy)((Object)src.getValue())) {
            case NOVERSION: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.NOVERSION);
                break;
            }
            case VERSIONED: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.VERSIONED);
                break;
            }
            case VERSIONEDUPDATE: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.VERSIONEDUPDATE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalReadStatus> convertConditionalReadStatus(Enumeration<CapabilityStatement.ConditionalReadStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalReadStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalReadStatus>(new CapabilityStatement.ConditionalReadStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ConditionalReadStatus)((Object)src.getValue())) {
            case NOTSUPPORTED: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.NOTSUPPORTED);
                break;
            }
            case MODIFIEDSINCE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.MODIFIEDSINCE);
                break;
            }
            case NOTMATCH: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.NOTMATCH);
                break;
            }
            case FULLSUPPORT: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.FULLSUPPORT);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.ConditionalReadStatus> convertConditionalReadStatus(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalReadStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.ConditionalReadStatus> tgt = new Enumeration<CapabilityStatement.ConditionalReadStatus>(new CapabilityStatement.ConditionalReadStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ConditionalReadStatus)((Object)src.getValue())) {
            case NOTSUPPORTED: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.NOTSUPPORTED);
                break;
            }
            case MODIFIEDSINCE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.MODIFIEDSINCE);
                break;
            }
            case NOTMATCH: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.NOTMATCH);
                break;
            }
            case FULLSUPPORT: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.FULLSUPPORT);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ConditionalReadStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalDeleteStatus> convertConditionalDeleteStatus(Enumeration<CapabilityStatement.ConditionalDeleteStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalDeleteStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalDeleteStatus>(new CapabilityStatement.ConditionalDeleteStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ConditionalDeleteStatus)((Object)src.getValue())) {
            case NOTSUPPORTED: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.NOTSUPPORTED);
                break;
            }
            case SINGLE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.SINGLE);
                break;
            }
            case MULTIPLE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.MULTIPLE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.ConditionalDeleteStatus> convertConditionalDeleteStatus(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ConditionalDeleteStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.ConditionalDeleteStatus> tgt = new Enumeration<CapabilityStatement.ConditionalDeleteStatus>(new CapabilityStatement.ConditionalDeleteStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ConditionalDeleteStatus)((Object)src.getValue())) {
            case NOTSUPPORTED: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.NOTSUPPORTED);
                break;
            }
            case SINGLE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.SINGLE);
                break;
            }
            case MULTIPLE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.MULTIPLE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ReferenceHandlingPolicy> convertReferenceHandlingPolicy(Enumeration<CapabilityStatement.ReferenceHandlingPolicy> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ReferenceHandlingPolicy> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ReferenceHandlingPolicy>(new CapabilityStatement.ReferenceHandlingPolicyEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ReferenceHandlingPolicy)((Object)src.getValue())) {
            case LITERAL: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.LITERAL);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.LOGICAL);
                break;
            }
            case RESOLVES: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.RESOLVES);
                break;
            }
            case ENFORCED: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.ENFORCED);
                break;
            }
            case LOCAL: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.LOCAL);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.ReferenceHandlingPolicy> convertReferenceHandlingPolicy(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.ReferenceHandlingPolicy> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.ReferenceHandlingPolicy> tgt = new Enumeration<CapabilityStatement.ReferenceHandlingPolicy>(new CapabilityStatement.ReferenceHandlingPolicyEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.ReferenceHandlingPolicy)((Object)src.getValue())) {
            case LITERAL: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.LITERAL);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.LOGICAL);
                break;
            }
            case RESOLVES: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.RESOLVES);
                break;
            }
            case ENFORCED: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.ENFORCED);
                break;
            }
            case LOCAL: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.LOCAL);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ReferenceHandlingPolicy.NULL);
            }
        }
        return tgt;
    }

    public static CapabilityStatement.ResourceInteractionComponent convertResourceInteractionComponent(CapabilityStatement.ResourceInteractionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.ResourceInteractionComponent tgt = new CapabilityStatement.ResourceInteractionComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CapabilityStatement40_50.convertTypeRestfulInteraction(src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.ResourceInteractionComponent convertResourceInteractionComponent(CapabilityStatement.ResourceInteractionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.ResourceInteractionComponent tgt = new CapabilityStatement.ResourceInteractionComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CapabilityStatement40_50.convertTypeRestfulInteraction(src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.TypeRestfulInteraction> convertTypeRestfulInteraction(Enumeration<CapabilityStatement.TypeRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.TypeRestfulInteraction> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.TypeRestfulInteraction>(new CapabilityStatement.TypeRestfulInteractionEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.TypeRestfulInteraction)((Object)src.getValue())) {
            case READ: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.READ);
                break;
            }
            case VREAD: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.VREAD);
                break;
            }
            case UPDATE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.UPDATE);
                break;
            }
            case PATCH: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.PATCH);
                break;
            }
            case DELETE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.DELETE);
                break;
            }
            case HISTORYINSTANCE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE);
                break;
            }
            case HISTORYTYPE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE);
                break;
            }
            case CREATE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.CREATE);
                break;
            }
            case SEARCHTYPE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.TypeRestfulInteraction> convertTypeRestfulInteraction(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.TypeRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.TypeRestfulInteraction> tgt = new Enumeration<CapabilityStatement.TypeRestfulInteraction>(new CapabilityStatement.TypeRestfulInteractionEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.TypeRestfulInteraction)((Object)src.getValue())) {
            case READ: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.READ);
                break;
            }
            case VREAD: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.VREAD);
                break;
            }
            case UPDATE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.UPDATE);
                break;
            }
            case PATCH: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.PATCH);
                break;
            }
            case DELETE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.DELETE);
                break;
            }
            case HISTORYINSTANCE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE);
                break;
            }
            case HISTORYTYPE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE);
                break;
            }
            case CREATE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.CREATE);
                break;
            }
            case SEARCHTYPE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.NULL);
            }
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent convertCapabilityStatementRestResourceSearchParamComponent(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(CapabilityStatement40_50.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(CapabilityStatement40_50.convertCanonical(src.getDefinitionElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Enumerations40_50.convertSearchParamType(src.getTypeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent convertCapabilityStatementRestResourceSearchParamComponent(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(CapabilityStatement40_50.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(CapabilityStatement40_50.convertCanonical(src.getDefinitionElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Enumerations40_50.convertSearchParamType(src.getTypeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceOperationComponent convertCapabilityStatementRestResourceOperationComponent(CapabilityStatement.CapabilityStatementRestResourceOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(CapabilityStatement40_50.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(CapabilityStatement40_50.convertCanonical(src.getDefinitionElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceOperationComponent convertCapabilityStatementRestResourceOperationComponent(CapabilityStatement.CapabilityStatementRestResourceOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(CapabilityStatement40_50.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(CapabilityStatement40_50.convertCanonical(src.getDefinitionElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.SystemInteractionComponent convertSystemInteractionComponent(CapabilityStatement.SystemInteractionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.SystemInteractionComponent tgt = new CapabilityStatement.SystemInteractionComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CapabilityStatement40_50.convertSystemRestfulInteraction(src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.SystemInteractionComponent convertSystemInteractionComponent(CapabilityStatement.SystemInteractionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.SystemInteractionComponent tgt = new CapabilityStatement.SystemInteractionComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CapabilityStatement40_50.convertSystemRestfulInteraction(src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.SystemRestfulInteraction> convertSystemRestfulInteraction(Enumeration<CapabilityStatement.SystemRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.SystemRestfulInteraction> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.SystemRestfulInteraction>(new CapabilityStatement.SystemRestfulInteractionEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.SystemRestfulInteraction)((Object)src.getValue())) {
            case TRANSACTION: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.TRANSACTION);
                break;
            }
            case BATCH: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.BATCH);
                break;
            }
            case SEARCHSYSTEM: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.SEARCHSYSTEM);
                break;
            }
            case HISTORYSYSTEM: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.SystemRestfulInteraction> convertSystemRestfulInteraction(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.SystemRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.SystemRestfulInteraction> tgt = new Enumeration<CapabilityStatement.SystemRestfulInteraction>(new CapabilityStatement.SystemRestfulInteractionEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.SystemRestfulInteraction)((Object)src.getValue())) {
            case TRANSACTION: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.TRANSACTION);
                break;
            }
            case BATCH: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.BATCH);
                break;
            }
            case SEARCHSYSTEM: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.SEARCHSYSTEM);
                break;
            }
            case HISTORYSYSTEM: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.NULL);
            }
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingComponent convertCapabilityStatementMessagingComponent(CapabilityStatement.CapabilityStatementMessagingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingComponent tgt = new CapabilityStatement.CapabilityStatementMessagingComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        for (CapabilityStatement.CapabilityStatementMessagingEndpointComponent capabilityStatementMessagingEndpointComponent : src.getEndpoint()) {
            tgt.addEndpoint(CapabilityStatement40_50.convertCapabilityStatementMessagingEndpointComponent(capabilityStatementMessagingEndpointComponent));
        }
        if (src.hasReliableCache()) {
            tgt.setReliableCacheElement(CapabilityStatement40_50.convertUnsignedInt(src.getReliableCacheElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        for (CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent capabilityStatementMessagingSupportedMessageComponent : src.getSupportedMessage()) {
            tgt.addSupportedMessage(CapabilityStatement40_50.convertCapabilityStatementMessagingSupportedMessageComponent(capabilityStatementMessagingSupportedMessageComponent));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingComponent convertCapabilityStatementMessagingComponent(CapabilityStatement.CapabilityStatementMessagingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingComponent tgt = new CapabilityStatement.CapabilityStatementMessagingComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        for (CapabilityStatement.CapabilityStatementMessagingEndpointComponent capabilityStatementMessagingEndpointComponent : src.getEndpoint()) {
            tgt.addEndpoint(CapabilityStatement40_50.convertCapabilityStatementMessagingEndpointComponent(capabilityStatementMessagingEndpointComponent));
        }
        if (src.hasReliableCache()) {
            tgt.setReliableCacheElement(CapabilityStatement40_50.convertUnsignedInt(src.getReliableCacheElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        for (CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent capabilityStatementMessagingSupportedMessageComponent : src.getSupportedMessage()) {
            tgt.addSupportedMessage(CapabilityStatement40_50.convertCapabilityStatementMessagingSupportedMessageComponent(capabilityStatementMessagingSupportedMessageComponent));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingEndpointComponent convertCapabilityStatementMessagingEndpointComponent(CapabilityStatement.CapabilityStatementMessagingEndpointComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent tgt = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProtocol()) {
            tgt.setProtocol(CapabilityStatement40_50.convertCoding(src.getProtocol()));
        }
        if (src.hasAddress()) {
            tgt.setAddressElement(CapabilityStatement40_50.convertUrl(src.getAddressElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingEndpointComponent convertCapabilityStatementMessagingEndpointComponent(CapabilityStatement.CapabilityStatementMessagingEndpointComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent tgt = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProtocol()) {
            tgt.setProtocol(CapabilityStatement40_50.convertCoding(src.getProtocol()));
        }
        if (src.hasAddress()) {
            tgt.setAddressElement(CapabilityStatement40_50.convertUrl(src.getAddressElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent convertCapabilityStatementMessagingSupportedMessageComponent(CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent tgt = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(CapabilityStatement40_50.convertEventCapabilityMode(src.getModeElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(CapabilityStatement40_50.convertCanonical(src.getDefinitionElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent convertCapabilityStatementMessagingSupportedMessageComponent(CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent tgt = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(CapabilityStatement40_50.convertEventCapabilityMode(src.getModeElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(CapabilityStatement40_50.convertCanonical(src.getDefinitionElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.EventCapabilityMode> convertEventCapabilityMode(Enumeration<CapabilityStatement.EventCapabilityMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.EventCapabilityMode> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.EventCapabilityMode>(new CapabilityStatement.EventCapabilityModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.EventCapabilityMode)((Object)src.getValue())) {
            case SENDER: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.SENDER);
                break;
            }
            case RECEIVER: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.RECEIVER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.EventCapabilityMode> convertEventCapabilityMode(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.EventCapabilityMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.EventCapabilityMode> tgt = new Enumeration<CapabilityStatement.EventCapabilityMode>(new CapabilityStatement.EventCapabilityModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.EventCapabilityMode)((Object)src.getValue())) {
            case SENDER: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.SENDER);
                break;
            }
            case RECEIVER: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.RECEIVER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.NULL);
            }
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementDocumentComponent convertCapabilityStatementDocumentComponent(CapabilityStatement.CapabilityStatementDocumentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementDocumentComponent tgt = new CapabilityStatement.CapabilityStatementDocumentComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(CapabilityStatement40_50.convertDocumentMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(CapabilityStatement40_50.convertCanonical(src.getProfileElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementDocumentComponent convertCapabilityStatementDocumentComponent(CapabilityStatement.CapabilityStatementDocumentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementDocumentComponent tgt = new CapabilityStatement.CapabilityStatementDocumentComponent();
        CapabilityStatement40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(CapabilityStatement40_50.convertDocumentMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CapabilityStatement40_50.convertMarkdown(src.getDocumentationElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(CapabilityStatement40_50.convertCanonical(src.getProfileElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.DocumentMode> convertDocumentMode(Enumeration<CapabilityStatement.DocumentMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.DocumentMode> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.DocumentMode>(new CapabilityStatement.DocumentModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.DocumentMode)((Object)src.getValue())) {
            case PRODUCER: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.PRODUCER);
                break;
            }
            case CONSUMER: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.CONSUMER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CapabilityStatement.DocumentMode> convertDocumentMode(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.DocumentMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CapabilityStatement.DocumentMode> tgt = new Enumeration<CapabilityStatement.DocumentMode>(new CapabilityStatement.DocumentModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.DocumentMode)((Object)src.getValue())) {
            case PRODUCER: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.PRODUCER);
                break;
            }
            case CONSUMER: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.CONSUMER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.NULL);
            }
        }
        return tgt;
    }
}

