/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Schedule;
import org.hl7.fhir.exceptions.FHIRException;

public class Schedule30_50 {
    public static Schedule convertSchedule(org.hl7.fhir.r5.model.Schedule src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Schedule tgt = new Schedule();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasServiceCategory()) {
            tgt.setServiceCategory(VersionConvertor_30_50.convertCodeableConcept(src.getServiceCategoryFirstRep()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addServiceType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getActor()) {
            tgt.addActor(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasPlanningHorizon()) {
            tgt.setPlanningHorizon(VersionConvertor_30_50.convertPeriod(src.getPlanningHorizon()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Schedule convertSchedule(Schedule src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Schedule tgt = new org.hl7.fhir.r5.model.Schedule();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasServiceCategory()) {
            tgt.addServiceCategory(VersionConvertor_30_50.convertCodeableConcept(src.getServiceCategory()));
        }
        for (CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addServiceType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getActor()) {
            tgt.addActor(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasPlanningHorizon()) {
            tgt.setPlanningHorizon(VersionConvertor_30_50.convertPeriod(src.getPlanningHorizon()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }
}

