/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.MedicationStatement;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.MedicationUsage;

public class MedicationStatement30_50 {
    public static MedicationUsage convertMedicationStatement(MedicationStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationUsage tgt = new MedicationUsage();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_50.convertReference(reference));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getContext()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationStatement30_50.convertMedicationStatementStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_30_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedicationCodeableConcept()) {
            tgt.getMedication().setConcept(VersionConvertor_30_50.convertCodeableConcept(src.getMedicationCodeableConcept()));
        }
        if (src.hasMedicationReference()) {
            tgt.getMedication().setReference(VersionConvertor_30_50.convertReference(src.getMedicationReference()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_50.convertType(src.getEffective()));
        }
        if (src.hasDateAsserted()) {
            tgt.setDateAssertedElement(VersionConvertor_30_50.convertDateTime(src.getDateAssertedElement()));
        }
        if (src.hasInformationSource()) {
            tgt.setInformationSource(VersionConvertor_30_50.convertReference(src.getInformationSource()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        for (Reference reference : src.getDerivedFrom()) {
            tgt.addDerivedFrom(VersionConvertor_30_50.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(VersionConvertor_30_50.convertCodeableConceptToCodableReference(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReason(VersionConvertor_30_50.convertReferenceToCodableReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.dstu3.model.Dosage dosage : src.getDosage()) {
            tgt.addDosage(VersionConvertor_30_50.convertDosage(dosage));
        }
        return tgt;
    }

    public static MedicationStatement convertMedicationStatement(MedicationUsage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationStatement tgt = new MedicationStatement();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationStatement30_50.convertMedicationStatementStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_50.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.getMedication().hasConcept()) {
            tgt.setMedication(VersionConvertor_30_50.convertType(src.getMedication().getConcept()));
        }
        if (src.getMedication().hasReference()) {
            tgt.setMedication(VersionConvertor_30_50.convertType(src.getMedication().getReference()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_50.convertType(src.getEffective()));
        }
        if (src.hasDateAsserted()) {
            tgt.setDateAssertedElement(VersionConvertor_30_50.convertDateTime(src.getDateAssertedElement()));
        }
        if (src.hasInformationSource()) {
            tgt.setInformationSource(VersionConvertor_30_50.convertReference(src.getInformationSource()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getDerivedFrom()) {
            tgt.addDerivedFrom(VersionConvertor_30_50.convertReference(reference));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(VersionConvertor_30_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(VersionConvertor_30_50.convertReference(codeableReference.getReference()));
        }
        for (org.hl7.fhir.r5.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        for (Dosage dosage : src.getDosage()) {
            tgt.addDosage(VersionConvertor_30_50.convertDosage(dosage));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MedicationStatement.MedicationStatementStatus> convertMedicationStatementStatus(Enumeration<MedicationUsage.MedicationUsageStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MedicationStatement.MedicationStatementStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MedicationStatement.MedicationStatementStatus>(new MedicationStatement.MedicationStatementStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationUsage.MedicationUsageStatusCodes)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.INTENDED);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationUsage.MedicationUsageStatusCodes> convertMedicationStatementStatus(org.hl7.fhir.dstu3.model.Enumeration<MedicationStatement.MedicationStatementStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MedicationUsage.MedicationUsageStatusCodes> tgt = new Enumeration<MedicationUsage.MedicationUsageStatusCodes>(new MedicationUsage.MedicationUsageStatusCodesEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationStatement.MedicationStatementStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.COMPLETED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.ENTEREDINERROR);
                break;
            }
            case INTENDED: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.UNKNOWN);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.UNKNOWN);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.NULL);
            }
        }
        return tgt;
    }
}

