/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.UsageContext;

public class Questionnaire30_40 {
    public static Questionnaire convertQuestionnaire(org.hl7.fhir.dstu3.model.Questionnaire src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire tgt = new Questionnaire();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_40.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_40.convertString(src.getPublisherElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_40.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(VersionConvertor_30_40.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(VersionConvertor_30_40.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(VersionConvertor_30_40.convertPeriod(src.getEffectivePeriod()));
        }
        for (org.hl7.fhir.dstu3.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_40.convertMarkdown(src.getCopyrightElement()));
        }
        for (org.hl7.fhir.dstu3.model.Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding(coding));
        }
        for (org.hl7.fhir.dstu3.model.CodeType codeType : src.getSubjectType()) {
            tgt.addSubjectType((String)codeType.getValue());
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire30_40.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Questionnaire convertQuestionnaire(Questionnaire src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Questionnaire tgt = new org.hl7.fhir.dstu3.model.Questionnaire();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_40.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_40.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_40.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_40.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_40.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDateElement()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_40.convertString(src.getPublisherElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_40.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(VersionConvertor_30_40.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(VersionConvertor_30_40.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(VersionConvertor_30_40.convertPeriod(src.getEffectivePeriod()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(contactDetail));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_40.convertMarkdown(src.getCopyrightElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding(coding));
        }
        for (CodeType codeType : src.getSubjectType()) {
            tgt.addSubjectType((String)codeType.getValue());
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire30_40.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemComponent convertQuestionnaireItemComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLinkId()) {
            tgt.setLinkIdElement(VersionConvertor_30_40.convertString(src.getLinkIdElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_30_40.convertUri(src.getDefinitionElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding(coding));
        }
        if (src.hasPrefix()) {
            tgt.setPrefixElement(VersionConvertor_30_40.convertString(src.getPrefixElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_40.convertString(src.getTextElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Questionnaire30_40.convertQuestionnaireItemType(src.getTypeElement()));
        }
        for (Questionnaire.QuestionnaireItemEnableWhenComponent questionnaireItemEnableWhenComponent : src.getEnableWhen()) {
            tgt.addEnableWhen(Questionnaire30_40.convertQuestionnaireItemEnableWhenComponent(questionnaireItemEnableWhenComponent));
        }
        if (src.hasRequired()) {
            tgt.setRequiredElement(VersionConvertor_30_40.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasRepeats()) {
            tgt.setRepeatsElement(VersionConvertor_30_40.convertBoolean(src.getRepeatsElement()));
        }
        if (src.hasReadOnly()) {
            tgt.setReadOnlyElement(VersionConvertor_30_40.convertBoolean(src.getReadOnlyElement()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_30_40.convertInteger(src.getMaxLengthElement()));
        }
        if (src.hasAnswerValueSet()) {
            tgt.setOptions(VersionConvertor_30_40.convertCanonicalToReference(src.getAnswerValueSetElement()));
        }
        for (Questionnaire.QuestionnaireItemAnswerOptionComponent questionnaireItemAnswerOptionComponent : src.getAnswerOption()) {
            tgt.addOption(Questionnaire30_40.convertQuestionnaireItemOptionComponent(questionnaireItemAnswerOptionComponent));
        }
        if (src.hasInitial()) {
            tgt.setInitial(VersionConvertor_30_40.convertType(src.getInitialFirstRep().getValue()));
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire30_40.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemComponent convertQuestionnaireItemComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasLinkId()) {
            tgt.setLinkIdElement(VersionConvertor_30_40.convertString(src.getLinkIdElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_30_40.convertUri(src.getDefinitionElement()));
        }
        for (org.hl7.fhir.dstu3.model.Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding(coding));
        }
        if (src.hasPrefix()) {
            tgt.setPrefixElement(VersionConvertor_30_40.convertString(src.getPrefixElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_40.convertString(src.getTextElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Questionnaire30_40.convertQuestionnaireItemType(src.getTypeElement()));
        }
        for (Questionnaire.QuestionnaireItemEnableWhenComponent questionnaireItemEnableWhenComponent : src.getEnableWhen()) {
            tgt.addEnableWhen(Questionnaire30_40.convertQuestionnaireItemEnableWhenComponent(questionnaireItemEnableWhenComponent));
        }
        tgt.setEnableBehavior(Questionnaire.EnableWhenBehavior.ANY);
        if (src.hasRequired()) {
            tgt.setRequiredElement(VersionConvertor_30_40.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasRepeats()) {
            tgt.setRepeatsElement(VersionConvertor_30_40.convertBoolean(src.getRepeatsElement()));
        }
        if (src.hasReadOnly()) {
            tgt.setReadOnlyElement(VersionConvertor_30_40.convertBoolean(src.getReadOnlyElement()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_30_40.convertInteger(src.getMaxLengthElement()));
        }
        if (src.hasOptions()) {
            tgt.setAnswerValueSetElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getOptions()));
        }
        for (Questionnaire.QuestionnaireItemOptionComponent questionnaireItemOptionComponent : src.getOption()) {
            tgt.addAnswerOption(Questionnaire30_40.convertQuestionnaireItemOptionComponent(questionnaireItemOptionComponent));
        }
        if (src.hasInitial()) {
            tgt.addInitial().setValue(VersionConvertor_30_40.convertType(src.getInitial()));
        }
        for (Questionnaire.QuestionnaireItemComponent questionnaireItemComponent : src.getItem()) {
            tgt.addItem(Questionnaire30_40.convertQuestionnaireItemComponent(questionnaireItemComponent));
        }
        for (Extension extension : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_30_40.convertExtension(extension));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemEnableWhenComponent convertQuestionnaireItemEnableWhenComponent(Questionnaire.QuestionnaireItemEnableWhenComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemEnableWhenComponent tgt = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasQuestion()) {
            tgt.setQuestionElement(VersionConvertor_30_40.convertString(src.getQuestionElement()));
        }
        if (src.hasOperator() && src.getOperator() == Questionnaire.QuestionnaireItemOperator.EXISTS) {
            tgt.setHasAnswer((Boolean)src.getAnswerBooleanType().getValue());
        } else if (src.hasAnswer()) {
            tgt.setAnswer(VersionConvertor_30_40.convertType(src.getAnswer()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemEnableWhenComponent convertQuestionnaireItemEnableWhenComponent(Questionnaire.QuestionnaireItemEnableWhenComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemEnableWhenComponent tgt = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasQuestion()) {
            tgt.setQuestionElement(VersionConvertor_30_40.convertString(src.getQuestionElement()));
        }
        if (src.hasHasAnswer()) {
            tgt.setOperator(Questionnaire.QuestionnaireItemOperator.EXISTS);
            if (src.hasHasAnswerElement()) {
                tgt.setAnswer(VersionConvertor_30_40.convertType(src.getHasAnswerElement()));
            }
        } else if (src.hasAnswer()) {
            tgt.setOperator(Questionnaire.QuestionnaireItemOperator.EQUAL);
            if (src.hasAnswer()) {
                tgt.setAnswer(VersionConvertor_30_40.convertType(src.getAnswer()));
            }
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemAnswerOptionComponent convertQuestionnaireItemOptionComponent(Questionnaire.QuestionnaireItemOptionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemAnswerOptionComponent tgt = new Questionnaire.QuestionnaireItemAnswerOptionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemOptionComponent convertQuestionnaireItemOptionComponent(Questionnaire.QuestionnaireItemAnswerOptionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemOptionComponent tgt = new Questionnaire.QuestionnaireItemOptionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Enumeration<Questionnaire.QuestionnaireItemType> convertQuestionnaireItemType(org.hl7.fhir.dstu3.model.Enumeration<Questionnaire.QuestionnaireItemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Questionnaire.QuestionnaireItemType> tgt = new Enumeration<Questionnaire.QuestionnaireItemType>(new Questionnaire.QuestionnaireItemTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Questionnaire.QuestionnaireItemType)((Object)src.getValue())) {
            case GROUP: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.GROUP);
                break;
            }
            case DISPLAY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DISPLAY);
                break;
            }
            case QUESTION: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.QUESTION);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.BOOLEAN);
                break;
            }
            case DECIMAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DECIMAL);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.INTEGER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATE);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATETIME);
                break;
            }
            case TIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TIME);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.STRING);
                break;
            }
            case TEXT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TEXT);
                break;
            }
            case URL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.URL);
                break;
            }
            case CHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.CHOICE);
                break;
            }
            case OPENCHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.OPENCHOICE);
                break;
            }
            case ATTACHMENT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.ATTACHMENT);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.REFERENCE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.QUANTITY);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Questionnaire.QuestionnaireItemType> convertQuestionnaireItemType(Enumeration<Questionnaire.QuestionnaireItemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Questionnaire.QuestionnaireItemType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Questionnaire.QuestionnaireItemType>(new Questionnaire.QuestionnaireItemTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Questionnaire.QuestionnaireItemType)((Object)src.getValue())) {
            case GROUP: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.GROUP);
                break;
            }
            case DISPLAY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DISPLAY);
                break;
            }
            case QUESTION: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.QUESTION);
                break;
            }
            case BOOLEAN: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.BOOLEAN);
                break;
            }
            case DECIMAL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DECIMAL);
                break;
            }
            case INTEGER: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.INTEGER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATE);
                break;
            }
            case DATETIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.DATETIME);
                break;
            }
            case TIME: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TIME);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.STRING);
                break;
            }
            case TEXT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.TEXT);
                break;
            }
            case URL: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.URL);
                break;
            }
            case CHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.CHOICE);
                break;
            }
            case OPENCHOICE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.OPENCHOICE);
                break;
            }
            case ATTACHMENT: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.ATTACHMENT);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.REFERENCE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.QUANTITY);
                break;
            }
            default: {
                tgt.setValue((Object)Questionnaire.QuestionnaireItemType.NULL);
            }
        }
        return tgt;
    }
}

