/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.PractitionerRole;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Reference;

public class PractitionerRole30_40 {
    public static PractitionerRole convertPractitionerRole(org.hl7.fhir.dstu3.model.PractitionerRole src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole tgt = new PractitionerRole();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_40.convertBoolean(src.getActiveElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasPractitioner()) {
            tgt.setPractitioner(VersionConvertor_30_40.convertReference(src.getPractitioner()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(VersionConvertor_30_40.convertReference(src.getOrganization()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getLocation()) {
            tgt.addLocation(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getHealthcareService()) {
            tgt.addHealthcareService(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint(contactPoint));
        }
        for (PractitionerRole.PractitionerRoleAvailableTimeComponent practitionerRoleAvailableTimeComponent : src.getAvailableTime()) {
            tgt.addAvailableTime(PractitionerRole30_40.convertPractitionerRoleAvailableTimeComponent(practitionerRoleAvailableTimeComponent));
        }
        for (PractitionerRole.PractitionerRoleNotAvailableComponent practitionerRoleNotAvailableComponent : src.getNotAvailable()) {
            tgt.addNotAvailable(PractitionerRole30_40.convertPractitionerRoleNotAvailableComponent(practitionerRoleNotAvailableComponent));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptionsElement(VersionConvertor_30_40.convertString(src.getAvailabilityExceptionsElement()));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_40.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.PractitionerRole convertPractitionerRole(PractitionerRole src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.PractitionerRole tgt = new org.hl7.fhir.dstu3.model.PractitionerRole();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_40.convertBoolean(src.getActiveElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasPractitioner()) {
            tgt.setPractitioner(VersionConvertor_30_40.convertReference(src.getPractitioner()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(VersionConvertor_30_40.convertReference(src.getOrganization()));
        }
        for (CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getLocation()) {
            tgt.addLocation(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getHealthcareService()) {
            tgt.addHealthcareService(VersionConvertor_30_40.convertReference(reference));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint(contactPoint));
        }
        for (PractitionerRole.PractitionerRoleAvailableTimeComponent practitionerRoleAvailableTimeComponent : src.getAvailableTime()) {
            tgt.addAvailableTime(PractitionerRole30_40.convertPractitionerRoleAvailableTimeComponent(practitionerRoleAvailableTimeComponent));
        }
        for (PractitionerRole.PractitionerRoleNotAvailableComponent practitionerRoleNotAvailableComponent : src.getNotAvailable()) {
            tgt.addNotAvailable(PractitionerRole30_40.convertPractitionerRoleNotAvailableComponent(practitionerRoleNotAvailableComponent));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptionsElement(VersionConvertor_30_40.convertString(src.getAvailabilityExceptionsElement()));
        }
        for (Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_40.convertReference(reference));
        }
        return tgt;
    }

    public static PractitionerRole.PractitionerRoleAvailableTimeComponent convertPractitionerRoleAvailableTimeComponent(PractitionerRole.PractitionerRoleAvailableTimeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole.PractitionerRoleAvailableTimeComponent tgt = new PractitionerRole.PractitionerRoleAvailableTimeComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(VersionConvertor_30_40::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDay()) {
            tgt.setAllDayElement(VersionConvertor_30_40.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTime()) {
            tgt.setAvailableStartTimeElement(VersionConvertor_30_40.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTime()) {
            tgt.setAvailableEndTimeElement(VersionConvertor_30_40.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static PractitionerRole.PractitionerRoleAvailableTimeComponent convertPractitionerRoleAvailableTimeComponent(PractitionerRole.PractitionerRoleAvailableTimeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole.PractitionerRoleAvailableTimeComponent tgt = new PractitionerRole.PractitionerRoleAvailableTimeComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(VersionConvertor_30_40::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDay()) {
            tgt.setAllDayElement(VersionConvertor_30_40.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTime()) {
            tgt.setAvailableStartTimeElement(VersionConvertor_30_40.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTime()) {
            tgt.setAvailableEndTimeElement(VersionConvertor_30_40.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static PractitionerRole.PractitionerRoleNotAvailableComponent convertPractitionerRoleNotAvailableComponent(PractitionerRole.PractitionerRoleNotAvailableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole.PractitionerRoleNotAvailableComponent tgt = new PractitionerRole.PractitionerRoleNotAvailableComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_30_40.convertPeriod(src.getDuring()));
        }
        return tgt;
    }

    public static PractitionerRole.PractitionerRoleNotAvailableComponent convertPractitionerRoleNotAvailableComponent(PractitionerRole.PractitionerRoleNotAvailableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole.PractitionerRoleNotAvailableComponent tgt = new PractitionerRole.PractitionerRoleNotAvailableComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_30_40.convertPeriod(src.getDuring()));
        }
        return tgt;
    }
}

