/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.MedicationAdministration;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.MedicationAdministration;
import org.hl7.fhir.r4.model.UriType;

public class MedicationAdministration30_40 {
    public static MedicationAdministration convertMedicationAdministration(org.hl7.fhir.r4.model.MedicationAdministration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration tgt = new MedicationAdministration();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (UriType uriType : src.getInstantiates()) {
            tgt.addDefinition().setReference((String)uriType.getValue());
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationAdministration30_40.convertMedicationAdministrationStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_30_40.convertType(src.getMedication()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        for (MedicationAdministration.MedicationAdministrationPerformerComponent medicationAdministrationPerformerComponent : src.getPerformer()) {
            tgt.addPerformer(MedicationAdministration30_40.convertMedicationAdministrationPerformerComponent(medicationAdministrationPerformerComponent));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasRequest()) {
            tgt.setPrescription(VersionConvertor_30_40.convertReference(src.getRequest()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getDevice()) {
            tgt.addDevice(VersionConvertor_30_40.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        if (src.hasDosage()) {
            tgt.setDosage(MedicationAdministration30_40.convertMedicationAdministrationDosageComponent(src.getDosage()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_40.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MedicationAdministration convertMedicationAdministration(MedicationAdministration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.MedicationAdministration tgt = new org.hl7.fhir.r4.model.MedicationAdministration();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (Reference reference : src.getDefinition()) {
            tgt.addInstantiates(reference.getReference());
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationAdministration30_40.convertMedicationAdministrationStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_30_40.convertType(src.getMedication()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        for (Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        for (MedicationAdministration.MedicationAdministrationPerformerComponent medicationAdministrationPerformerComponent : src.getPerformer()) {
            tgt.addPerformer(MedicationAdministration30_40.convertMedicationAdministrationPerformerComponent(medicationAdministrationPerformerComponent));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasPrescription()) {
            tgt.setRequest(VersionConvertor_30_40.convertReference(src.getPrescription()));
        }
        for (Reference reference : src.getDevice()) {
            tgt.addDevice(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        if (src.hasDosage()) {
            tgt.setDosage(MedicationAdministration30_40.convertMedicationAdministrationDosageComponent(src.getDosage()));
        }
        for (Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_40.convertReference(reference));
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationDosageComponent convertMedicationAdministrationDosageComponent(MedicationAdministration.MedicationAdministrationDosageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationDosageComponent tgt = new MedicationAdministration.MedicationAdministrationDosageComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_40.convertString(src.getTextElement()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_40.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_40.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose()) {
            tgt.setDose(VersionConvertor_30_40.convertSimpleQuantity(src.getDose()));
        }
        if (src.hasRate()) {
            tgt.setRate(VersionConvertor_30_40.convertType(src.getRate()));
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationDosageComponent convertMedicationAdministrationDosageComponent(MedicationAdministration.MedicationAdministrationDosageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationDosageComponent tgt = new MedicationAdministration.MedicationAdministrationDosageComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_40.convertString(src.getTextElement()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_40.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_40.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose()) {
            tgt.setDose(VersionConvertor_30_40.convertSimpleQuantity(src.getDose()));
        }
        if (src.hasRate()) {
            if (src.hasRateQuantity()) {
                tgt.setRate(new SimpleQuantity());
                VersionConvertor_30_40.copyQuantity(src.getRateQuantity(), tgt.getRateSimpleQuantity());
            } else {
                tgt.setRate(VersionConvertor_30_40.convertType(src.getRate()));
            }
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationPerformerComponent convertMedicationAdministrationPerformerComponent(MedicationAdministration.MedicationAdministrationPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationPerformerComponent tgt = new MedicationAdministration.MedicationAdministrationPerformerComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationPerformerComponent convertMedicationAdministrationPerformerComponent(MedicationAdministration.MedicationAdministrationPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationPerformerComponent tgt = new MedicationAdministration.MedicationAdministrationPerformerComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        return tgt;
    }

    private static org.hl7.fhir.dstu3.model.Enumeration<MedicationAdministration.MedicationAdministrationStatus> convertMedicationAdministrationStatus(Enumeration<MedicationAdministration.MedicationAdministrationStatus> src) {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MedicationAdministration.MedicationAdministrationStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MedicationAdministration.MedicationAdministrationStatus>(new MedicationAdministration.MedicationAdministrationStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((MedicationAdministration.MedicationAdministrationStatus)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.ENTEREDINERROR);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.INPROGRESS);
                break;
            }
            case NOTDONE: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.STOPPED);
                break;
            }
            case NULL: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.NULL);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.ONHOLD);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.STOPPED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.UNKNOWN);
            }
        }
        return tgt;
    }

    private static Enumeration<MedicationAdministration.MedicationAdministrationStatus> convertMedicationAdministrationStatus(org.hl7.fhir.dstu3.model.Enumeration<MedicationAdministration.MedicationAdministrationStatus> src) {
        if (src == null) {
            return null;
        }
        Enumeration<MedicationAdministration.MedicationAdministrationStatus> tgt = new Enumeration<MedicationAdministration.MedicationAdministrationStatus>(new MedicationAdministration.MedicationAdministrationStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((MedicationAdministration.MedicationAdministrationStatus)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.ENTEREDINERROR);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.INPROGRESS);
                break;
            }
            case NULL: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.NULL);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.ONHOLD);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.STOPPED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationAdministration.MedicationAdministrationStatus.UNKNOWN);
            }
        }
        return tgt;
    }
}

