/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Media;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Media;
import org.hl7.fhir.r4.model.Reference;

public class Media30_40 {
    private static final String CODE_SYSTEM_MEDIA_TYPE = "http://terminology.hl7.org/CodeSystem/media-type";

    public static Media convertMedia(org.hl7.fhir.r4.model.Media src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Media tgt = new Media();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasType()) {
            CodeableConcept type = src.getType();
            for (Coding c : type.getCoding()) {
                if (!CODE_SYSTEM_MEDIA_TYPE.equals(c.getSystem())) continue;
                tgt.setType(Media.DigitalMediaType.fromCode(c.getCode().replace("image", "photo")));
                break;
            }
        }
        if (src.hasModality() && src.hasModality()) {
            tgt.setSubtype(VersionConvertor_30_40.convertCodeableConcept(src.getModality()));
        }
        if (src.hasView() && src.hasView()) {
            tgt.setView(VersionConvertor_30_40.convertCodeableConcept(src.getView()));
        }
        if (src.hasSubject() && src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter() && src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasCreated() && src.hasCreated()) {
            tgt.setOccurrence(VersionConvertor_30_40.convertType(src.getCreated()));
        }
        if (src.hasOperator() && src.hasOperator()) {
            tgt.setOperator(VersionConvertor_30_40.convertReference(src.getOperator()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasBodySite() && src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_30_40.convertCodeableConcept(src.getBodySite()));
        }
        if (src.hasDevice() && src.hasDevice()) {
            tgt.setDevice(VersionConvertor_30_40.convertReference(src.getDevice()));
        }
        if (src.hasHeight() && src.hasHeightElement()) {
            tgt.setHeightElement(VersionConvertor_30_40.convertPositiveInt(src.getHeightElement()));
        }
        if (src.hasWidth() && src.hasWidthElement()) {
            tgt.setWidthElement(VersionConvertor_30_40.convertPositiveInt(src.getWidthElement()));
        }
        if (src.hasFrames() && src.hasFramesElement()) {
            tgt.setFramesElement(VersionConvertor_30_40.convertPositiveInt(src.getFramesElement()));
        }
        if (src.hasDuration()) {
            tgt.setDuration(src.getDuration().intValue());
        }
        if (src.hasContent() && src.hasContent()) {
            tgt.setContent(VersionConvertor_30_40.convertAttachment(src.getContent()));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Media convertMedia(Media src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Media tgt = new org.hl7.fhir.r4.model.Media();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasType()) {
            Coding coding = new Coding();
            coding.setSystem(CODE_SYSTEM_MEDIA_TYPE);
            coding.setCode(src.getType().toCode().replace("photo", "image"));
            CodeableConcept codeableConcept = new CodeableConcept(coding);
            tgt.setType(codeableConcept);
        }
        if (src.hasSubtype() && src.hasSubtype()) {
            tgt.setModality(VersionConvertor_30_40.convertCodeableConcept(src.getSubtype()));
        }
        if (src.hasView() && src.hasView()) {
            tgt.setView(VersionConvertor_30_40.convertCodeableConcept(src.getView()));
        }
        if (src.hasSubject() && src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext() && src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasOccurrence() && src.hasOccurrence()) {
            tgt.setCreated(VersionConvertor_30_40.convertType(src.getOccurrence()));
        }
        if (src.hasOperator() && src.hasOperator()) {
            tgt.setOperator(VersionConvertor_30_40.convertReference(src.getOperator()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasBodySite() && src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_30_40.convertCodeableConcept(src.getBodySite()));
        }
        if (src.hasDevice() && src.hasDevice()) {
            tgt.setDevice(VersionConvertor_30_40.convertReference(src.getDevice()));
        }
        if (src.hasHeight() && src.hasHeightElement()) {
            tgt.setHeightElement(VersionConvertor_30_40.convertPositiveInt(src.getHeightElement()));
        }
        if (src.hasWidth() && src.hasWidthElement()) {
            tgt.setWidthElement(VersionConvertor_30_40.convertPositiveInt(src.getWidthElement()));
        }
        if (src.hasFrames() && src.hasFramesElement()) {
            tgt.setFramesElement(VersionConvertor_30_40.convertPositiveInt(src.getFramesElement()));
        }
        if (src.hasDuration() && src.hasDuration()) {
            tgt.setDuration(src.getDuration());
        }
        if (src.hasContent() && src.hasContent()) {
            tgt.setContent(VersionConvertor_30_40.convertAttachment(src.getContent()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        tgt.setStatus(Media.MediaStatus.COMPLETED);
        return tgt;
    }
}

