/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Reference;

public class Condition30_40 {
    private static final String CODE_SYSTEM_LEGACY_CONDITION_VER_CLINICAL_URL = "http://hl7.org/fhir/condition-ver-status";
    private static final String CODE_SYSTEM_CONDITION_VER_CLINICAL_URL = "http://terminology.hl7.org/CodeSystem/condition-ver-status";
    private static final String CODE_SYSTEM_LEGACY_CONDITION_CLINICAL_URL = "http://hl7.org/fhir/condition-clinical";
    private static final String CODE_SYSTEM_CONDITION_CLINICAL_URL = "http://terminology.hl7.org/CodeSystem/condition-clinical";

    public static Condition convertCondition(org.hl7.fhir.dstu3.model.Condition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition tgt = new Condition();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(Condition30_40.convertConditionClinicalStatus(src.getClinicalStatus()));
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatus(Condition30_40.convertConditionVerificationStatus(src.getVerificationStatus()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_30_40.convertCodeableConcept(src.getSeverity()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_30_40.convertType(src.getOnset()));
        }
        if (src.hasAbatement()) {
            tgt.setAbatement(VersionConvertor_30_40.convertType(src.getAbatement()));
        }
        if (src.hasAssertedDate()) {
            tgt.setRecordedDateElement(VersionConvertor_30_40.convertDateTime(src.getAssertedDateElement()));
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(VersionConvertor_30_40.convertReference(src.getAsserter()));
        }
        if (src.hasStage()) {
            tgt.addStage(Condition30_40.convertConditionStageComponent(src.getStage()));
        }
        for (Condition.ConditionEvidenceComponent conditionEvidenceComponent : src.getEvidence()) {
            tgt.addEvidence(Condition30_40.convertConditionEvidenceComponent(conditionEvidenceComponent));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Condition convertCondition(Condition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Condition tgt = new org.hl7.fhir.dstu3.model.Condition();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(Condition30_40.convertConditionClinicalStatus(src.getClinicalStatus()));
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatus(Condition30_40.convertConditionVerificationStatus(src.getVerificationStatus()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_30_40.convertCodeableConcept(src.getSeverity()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        for (CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_30_40.convertType(src.getOnset()));
        }
        if (src.hasAbatement()) {
            tgt.setAbatement(VersionConvertor_30_40.convertType(src.getAbatement()));
        }
        if (src.hasRecordedDate()) {
            tgt.setAssertedDateElement(VersionConvertor_30_40.convertDateTime(src.getRecordedDateElement()));
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(VersionConvertor_30_40.convertReference(src.getAsserter()));
        }
        if (src.hasStage()) {
            tgt.setStage(Condition30_40.convertConditionStageComponent(src.getStageFirstRep()));
        }
        for (Condition.ConditionEvidenceComponent conditionEvidenceComponent : src.getEvidence()) {
            tgt.addEvidence(Condition30_40.convertConditionEvidenceComponent(conditionEvidenceComponent));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static Condition.ConditionClinicalStatus convertConditionClinicalStatus(CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.hasCoding(CODE_SYSTEM_CONDITION_CLINICAL_URL, "active") || src.hasCoding(CODE_SYSTEM_LEGACY_CONDITION_CLINICAL_URL, "active")) {
            return Condition.ConditionClinicalStatus.ACTIVE;
        }
        if (src.hasCoding(CODE_SYSTEM_CONDITION_CLINICAL_URL, "recurrence") || src.hasCoding(CODE_SYSTEM_LEGACY_CONDITION_CLINICAL_URL, "recurrence")) {
            return Condition.ConditionClinicalStatus.RECURRENCE;
        }
        if (src.hasCoding(CODE_SYSTEM_CONDITION_CLINICAL_URL, "inactive") || src.hasCoding(CODE_SYSTEM_LEGACY_CONDITION_CLINICAL_URL, "inactive")) {
            return Condition.ConditionClinicalStatus.INACTIVE;
        }
        if (src.hasCoding(CODE_SYSTEM_CONDITION_CLINICAL_URL, "remission") || src.hasCoding(CODE_SYSTEM_LEGACY_CONDITION_CLINICAL_URL, "remission")) {
            return Condition.ConditionClinicalStatus.REMISSION;
        }
        if (src.hasCoding(CODE_SYSTEM_CONDITION_CLINICAL_URL, "resolved") || src.hasCoding(CODE_SYSTEM_LEGACY_CONDITION_CLINICAL_URL, "resolved")) {
            return Condition.ConditionClinicalStatus.RESOLVED;
        }
        return Condition.ConditionClinicalStatus.NULL;
    }

    public static CodeableConcept convertConditionClinicalStatus(Condition.ConditionClinicalStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeableConcept cc = new CodeableConcept();
        switch (src) {
            case ACTIVE: {
                cc.addCoding().setSystem(CODE_SYSTEM_CONDITION_CLINICAL_URL).setCode("active");
                return cc;
            }
            case RECURRENCE: {
                cc.addCoding().setSystem(CODE_SYSTEM_CONDITION_CLINICAL_URL).setCode("recurrence");
                return cc;
            }
            case INACTIVE: {
                cc.addCoding().setSystem(CODE_SYSTEM_CONDITION_CLINICAL_URL).setCode("inactive");
                return cc;
            }
            case REMISSION: {
                cc.addCoding().setSystem(CODE_SYSTEM_CONDITION_CLINICAL_URL).setCode("remission");
                return cc;
            }
            case RESOLVED: {
                cc.addCoding().setSystem(CODE_SYSTEM_CONDITION_CLINICAL_URL).setCode("resolved");
                return cc;
            }
        }
        return null;
    }

    public static Condition.ConditionEvidenceComponent convertConditionEvidenceComponent(Condition.ConditionEvidenceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition.ConditionEvidenceComponent tgt = new Condition.ConditionEvidenceComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getDetail()) {
            tgt.addDetail(VersionConvertor_30_40.convertReference(reference));
        }
        return tgt;
    }

    public static Condition.ConditionEvidenceComponent convertConditionEvidenceComponent(Condition.ConditionEvidenceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition.ConditionEvidenceComponent tgt = new Condition.ConditionEvidenceComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getDetail()) {
            tgt.addDetail(VersionConvertor_30_40.convertReference(reference));
        }
        return tgt;
    }

    public static Condition.ConditionStageComponent convertConditionStageComponent(Condition.ConditionStageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition.ConditionStageComponent tgt = new Condition.ConditionStageComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasSummary()) {
            tgt.setSummary(VersionConvertor_30_40.convertCodeableConcept(src.getSummary()));
        }
        for (org.hl7.fhir.dstu3.model.Reference t : src.getAssessment()) {
            tgt.addAssessment(VersionConvertor_30_40.convertReference(t));
        }
        return tgt;
    }

    public static Condition.ConditionStageComponent convertConditionStageComponent(Condition.ConditionStageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition.ConditionStageComponent tgt = new Condition.ConditionStageComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasSummary()) {
            tgt.setSummary(VersionConvertor_30_40.convertCodeableConcept(src.getSummary()));
        }
        for (Reference t : src.getAssessment()) {
            tgt.addAssessment(VersionConvertor_30_40.convertReference(t));
        }
        return tgt;
    }

    public static CodeableConcept convertConditionVerificationStatus(Condition.ConditionVerificationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeableConcept cc = new CodeableConcept();
        switch (src) {
            case PROVISIONAL: {
                cc.addCoding().setSystem(CODE_SYSTEM_CONDITION_VER_CLINICAL_URL).setCode("provisional");
                return cc;
            }
            case DIFFERENTIAL: {
                cc.addCoding().setSystem(CODE_SYSTEM_CONDITION_VER_CLINICAL_URL).setCode("differential");
                return cc;
            }
            case CONFIRMED: {
                cc.addCoding().setSystem(CODE_SYSTEM_CONDITION_VER_CLINICAL_URL).setCode("confirmed");
                return cc;
            }
            case REFUTED: {
                cc.addCoding().setSystem(CODE_SYSTEM_CONDITION_VER_CLINICAL_URL).setCode("refuted");
                return cc;
            }
            case ENTEREDINERROR: {
                cc.addCoding().setSystem(CODE_SYSTEM_CONDITION_VER_CLINICAL_URL).setCode("entered-in-error");
                return cc;
            }
        }
        return null;
    }

    public static Condition.ConditionVerificationStatus convertConditionVerificationStatus(CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.hasCoding(CODE_SYSTEM_CONDITION_VER_CLINICAL_URL, "provisional") || src.hasCoding(CODE_SYSTEM_LEGACY_CONDITION_VER_CLINICAL_URL, "provisional")) {
            return Condition.ConditionVerificationStatus.PROVISIONAL;
        }
        if (src.hasCoding(CODE_SYSTEM_CONDITION_VER_CLINICAL_URL, "differential") || src.hasCoding(CODE_SYSTEM_LEGACY_CONDITION_VER_CLINICAL_URL, "differential")) {
            return Condition.ConditionVerificationStatus.DIFFERENTIAL;
        }
        if (src.hasCoding(CODE_SYSTEM_CONDITION_VER_CLINICAL_URL, "confirmed") || src.hasCoding(CODE_SYSTEM_LEGACY_CONDITION_VER_CLINICAL_URL, "confirmed")) {
            return Condition.ConditionVerificationStatus.CONFIRMED;
        }
        if (src.hasCoding(CODE_SYSTEM_CONDITION_VER_CLINICAL_URL, "refuted") || src.hasCoding(CODE_SYSTEM_LEGACY_CONDITION_VER_CLINICAL_URL, "refuted")) {
            return Condition.ConditionVerificationStatus.REFUTED;
        }
        if (src.hasCoding(CODE_SYSTEM_CONDITION_VER_CLINICAL_URL, "entered-in-error") || src.hasCoding(CODE_SYSTEM_LEGACY_CONDITION_VER_CLINICAL_URL, "entered-in-error")) {
            return Condition.ConditionVerificationStatus.ENTEREDINERROR;
        }
        return Condition.ConditionVerificationStatus.NULL;
    }
}

