/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import java.util.Iterator;
import java.util.List;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.CarePlan;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Type;

public class CarePlan30_40 {
    private static final String CarePlanActivityDetailComponentExtension = "http://hl7.org/fhir/3.0/StructureDefinition/extension-CarePlan.activity.detail.category";

    public static CarePlan convertCarePlan(org.hl7.fhir.r4.model.CarePlan src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CarePlan tgt = new CarePlan();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReplaces()) {
            tgt.addReplaces(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasStatus() && src.hasStatus()) {
            tgt.setStatusElement(CarePlan30_40.convertCarePlanStatus(src.getStatusElement()));
        }
        if (src.hasIntent() && src.hasIntent()) {
            tgt.setIntentElement(CarePlan30_40.convertCarePlanIntent(src.getIntentElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasTitle() && src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasDescription() && src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasSubject() && src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter() && src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasPeriod() && src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasAuthor() && src.hasAuthor()) {
            tgt.addAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getCareTeam()) {
            tgt.addCareTeam(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getAddresses()) {
            tgt.addAddresses(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInfo(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getGoal()) {
            tgt.addGoal(VersionConvertor_30_40.convertReference(reference));
        }
        for (CarePlan.CarePlanActivityComponent carePlanActivityComponent : src.getActivity()) {
            tgt.addActivity(CarePlan30_40.convertCarePlanActivityComponent(carePlanActivityComponent));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CarePlan convertCarePlan(CarePlan src) throws FHIRException {
        List<Reference> authors;
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CarePlan tgt = new org.hl7.fhir.r4.model.CarePlan();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getReplaces()) {
            tgt.addReplaces(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasStatus() && src.hasStatus()) {
            tgt.setStatusElement(CarePlan30_40.convertCarePlanStatus(src.getStatusElement()));
        }
        if (src.hasIntent() && src.hasIntent()) {
            tgt.setIntentElement(CarePlan30_40.convertCarePlanIntent(src.getIntentElement()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasTitle() && src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_30_40.convertString(src.getTitleElement()));
        }
        if (src.hasDescription() && src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasSubject() && src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext() && src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasPeriod() && src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if ((authors = src.getAuthor()).size() > 0) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(authors.get(0)));
            if (authors.size() > 1) {
                // empty if block
            }
        }
        for (Reference reference : src.getCareTeam()) {
            tgt.addCareTeam(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getAddresses()) {
            tgt.addAddresses(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInfo(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getGoal()) {
            tgt.addGoal(VersionConvertor_30_40.convertReference(reference));
        }
        for (CarePlan.CarePlanActivityComponent carePlanActivityComponent : src.getActivity()) {
            tgt.addActivity(CarePlan30_40.convertCarePlanActivityComponent(carePlanActivityComponent));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityComponent convertCarePlanActivityComponent(CarePlan.CarePlanActivityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CarePlan.CarePlanActivityComponent tgt = new CarePlan.CarePlanActivityComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getOutcomeCodeableConcept()) {
            tgt.addOutcomeCodeableConcept(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getOutcomeReference()) {
            tgt.addOutcomeReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getProgress()) {
            tgt.addProgress(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        if (src.hasReference() && src.hasReference()) {
            tgt.setReference(VersionConvertor_30_40.convertReference(src.getReference()));
        }
        if (src.hasDetail() && src.hasDetail()) {
            tgt.setDetail(CarePlan30_40.convertCarePlanActivityDetailComponent(src.getDetail()));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityComponent convertCarePlanActivityComponent(CarePlan.CarePlanActivityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CarePlan.CarePlanActivityComponent tgt = new CarePlan.CarePlanActivityComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        for (CodeableConcept codeableConcept : src.getOutcomeCodeableConcept()) {
            tgt.addOutcomeCodeableConcept(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getOutcomeReference()) {
            tgt.addOutcomeReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (Annotation annotation : src.getProgress()) {
            tgt.addProgress(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        if (src.hasReference() && src.hasReference()) {
            tgt.setReference(VersionConvertor_30_40.convertReference(src.getReference()));
        }
        if (src.hasDetail() && src.hasDetail()) {
            tgt.setDetail(CarePlan30_40.convertCarePlanActivityDetailComponent(src.getDetail()));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityDetailComponent convertCarePlanActivityDetailComponent(CarePlan.CarePlanActivityDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CarePlan.CarePlanActivityDetailComponent tgt = new CarePlan.CarePlanActivityDetailComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            Iterator<Reference> t = new Extension();
            ((Extension)((Object)t)).setUrl(CarePlanActivityDetailComponentExtension);
            ((Extension)((Object)t)).setValue(VersionConvertor_30_40.convertType(src.getCategory()));
            tgt.addExtension((Extension)((Object)t));
        }
        if (src.hasCode() && src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getGoal()) {
            tgt.addGoal(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasStatus() && src.hasStatus()) {
            tgt.setStatusElement(CarePlan30_40.convertCarePlanActivityStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            Coding code = new Coding();
            code.setCode(src.getStatusReason());
            CodeableConcept codeableConcept = new CodeableConcept(code);
            tgt.setStatusReason(codeableConcept);
        }
        if (src.hasProhibited() && src.hasProhibitedElement()) {
            tgt.setDoNotPerformElement(VersionConvertor_30_40.convertBoolean(src.getProhibitedElement()));
        }
        if (src.hasScheduled() && src.hasScheduled()) {
            tgt.setScheduled(VersionConvertor_30_40.convertType(src.getScheduled()));
        }
        if (src.hasLocation() && src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        for (Reference reference : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasProduct() && src.hasProduct()) {
            tgt.setProduct(VersionConvertor_30_40.convertType(src.getProduct()));
        }
        if (src.hasDailyAmount() && src.hasDailyAmount()) {
            tgt.setDailyAmount(VersionConvertor_30_40.convertSimpleQuantity(src.getDailyAmount()));
        }
        if (src.hasQuantity() && src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDescription() && src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityDetailComponent convertCarePlanActivityDetailComponent(CarePlan.CarePlanActivityDetailComponent src) throws FHIRException {
        List<Coding> coding;
        Type type;
        Iterator<org.hl7.fhir.r4.model.Reference> extension;
        if (src == null) {
            return null;
        }
        CarePlan.CarePlanActivityDetailComponent tgt = new CarePlan.CarePlanActivityDetailComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasExtension() && (extension = src.getExtensionByUrl(CarePlanActivityDetailComponentExtension)) != null && (type = ((Extension)((Object)extension)).getValue()) instanceof CodeableConcept) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)type));
        }
        if (src.hasCode() && src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getGoal()) {
            tgt.addGoal(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasStatus() && src.hasStatus()) {
            tgt.setStatusElement(CarePlan30_40.convertCarePlanActivityStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason() && (coding = src.getStatusReason().getCoding()).size() > 0) {
            tgt.setStatusReason(coding.get(0).getCode());
        }
        if (src.hasDoNotPerform() && src.hasDoNotPerformElement()) {
            tgt.setProhibitedElement(VersionConvertor_30_40.convertBoolean(src.getDoNotPerformElement()));
        }
        if (src.hasScheduled() && src.hasScheduled()) {
            tgt.setScheduled(VersionConvertor_30_40.convertType(src.getScheduled()));
        }
        if (src.hasLocation() && src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasProduct() && src.hasProduct()) {
            tgt.setProduct(VersionConvertor_30_40.convertType(src.getProduct()));
        }
        if (src.hasDailyAmount() && src.hasDailyAmount()) {
            tgt.setDailyAmount(VersionConvertor_30_40.convertSimpleQuantity(src.getDailyAmount()));
        }
        if (src.hasQuantity() && src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDescription() && src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanActivityStatus> convertCarePlanActivityStatus(Enumeration<CarePlan.CarePlanActivityStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanActivityStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanActivityStatus>(new CarePlan.CarePlanActivityStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanActivityStatus)((Object)src.getValue())) {
            case CANCELLED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.CANCELLED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.COMPLETED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.INPROGRESS);
                break;
            }
            case NOTSTARTED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NOTSTARTED);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.ONHOLD);
                break;
            }
            case SCHEDULED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.SCHEDULED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CarePlan.CarePlanActivityStatus> convertCarePlanActivityStatus(org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanActivityStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CarePlan.CarePlanActivityStatus> tgt = new Enumeration<CarePlan.CarePlanActivityStatus>(new CarePlan.CarePlanActivityStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanActivityStatus)((Object)src.getValue())) {
            case CANCELLED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.CANCELLED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.COMPLETED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.INPROGRESS);
                break;
            }
            case NOTSTARTED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NOTSTARTED);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.ONHOLD);
                break;
            }
            case SCHEDULED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.SCHEDULED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CarePlan.CarePlanIntent> convertCarePlanIntent(org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CarePlan.CarePlanIntent> tgt = new Enumeration<CarePlan.CarePlanIntent>(new CarePlan.CarePlanIntentEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanIntent)((Object)src.getValue())) {
            case OPTION: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.OPTION);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.ORDER);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.PLAN);
                break;
            }
            case PROPOSAL: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.PROPOSAL);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanIntent> convertCarePlanIntent(Enumeration<CarePlan.CarePlanIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanIntent> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanIntent>(new CarePlan.CarePlanIntentEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanIntent)((Object)src.getValue())) {
            case OPTION: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.OPTION);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.ORDER);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.PLAN);
                break;
            }
            case PROPOSAL: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.PROPOSAL);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanStatus> convertCarePlanStatus(Enumeration<CarePlan.CarePlanStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanStatus>(new CarePlan.CarePlanStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.ACTIVE);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.CANCELLED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.COMPLETED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.ENTEREDINERROR);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.SUSPENDED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CarePlan.CarePlanStatus> convertCarePlanStatus(org.hl7.fhir.dstu3.model.Enumeration<CarePlan.CarePlanStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CarePlan.CarePlanStatus> tgt = new Enumeration<CarePlan.CarePlanStatus>(new CarePlan.CarePlanStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.REVOKED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.COMPLETED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.ENTEREDINERROR);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.ONHOLD);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.NULL);
            }
        }
        return tgt;
    }
}

