/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.AllergyIntolerance;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Enumeration;

public class AllergyIntolerance30_40 {
    public static AllergyIntolerance convertAllergyIntolerance(org.hl7.fhir.r4.model.AllergyIntolerance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AllergyIntolerance tgt = new AllergyIntolerance();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(AllergyIntolerance30_40.convertAllergyIntoleranceClinicalStatus(src.getClinicalStatus()));
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatus(AllergyIntolerance30_40.convertAllergyIntoleranceVerificationStatus(src.getVerificationStatus()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(AllergyIntolerance30_40.convertAllergyIntoleranceType(src.getTypeElement()));
        }
        tgt.setCategory(src.getCategory().stream().map(AllergyIntolerance30_40::convertAllergyIntoleranceCategory).collect(Collectors.toList()));
        if (src.hasCriticality()) {
            tgt.setCriticalityElement(AllergyIntolerance30_40.convertAllergyIntoleranceCriticality(src.getCriticalityElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_30_40.convertType(src.getOnset()));
        }
        if (src.hasRecordedDate()) {
            tgt.setAssertedDateElement(VersionConvertor_30_40.convertDateTime(src.getRecordedDateElement()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(VersionConvertor_30_40.convertReference(src.getRecorder()));
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(VersionConvertor_30_40.convertReference(src.getAsserter()));
        }
        if (src.hasLastOccurrence()) {
            tgt.setLastOccurrenceElement(VersionConvertor_30_40.convertDateTime(src.getLastOccurrenceElement()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        for (AllergyIntolerance.AllergyIntoleranceReactionComponent allergyIntoleranceReactionComponent : src.getReaction()) {
            tgt.addReaction(AllergyIntolerance30_40.convertAllergyIntoleranceReactionComponent(allergyIntoleranceReactionComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.AllergyIntolerance convertAllergyIntolerance(AllergyIntolerance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.AllergyIntolerance tgt = new org.hl7.fhir.r4.model.AllergyIntolerance();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(AllergyIntolerance30_40.convertAllergyIntoleranceClinicalStatus(src.getClinicalStatus()));
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatus(AllergyIntolerance30_40.convertAllergyIntoleranceVerificationStatus(src.getVerificationStatus()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(AllergyIntolerance30_40.convertAllergyIntoleranceType(src.getTypeElement()));
        }
        tgt.setCategory(src.getCategory().stream().map(AllergyIntolerance30_40::convertAllergyIntoleranceCategory).collect(Collectors.toList()));
        if (src.hasCriticality()) {
            tgt.setCriticalityElement(AllergyIntolerance30_40.convertAllergyIntoleranceCriticality(src.getCriticalityElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_30_40.convertType(src.getOnset()));
        }
        if (src.hasAssertedDate()) {
            tgt.setRecordedDateElement(VersionConvertor_30_40.convertDateTime(src.getAssertedDateElement()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(VersionConvertor_30_40.convertReference(src.getRecorder()));
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(VersionConvertor_30_40.convertReference(src.getAsserter()));
        }
        if (src.hasLastOccurrence()) {
            tgt.setLastOccurrenceElement(VersionConvertor_30_40.convertDateTime(src.getLastOccurrenceElement()));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        for (AllergyIntolerance.AllergyIntoleranceReactionComponent allergyIntoleranceReactionComponent : src.getReaction()) {
            tgt.addReaction(AllergyIntolerance30_40.convertAllergyIntoleranceReactionComponent(allergyIntoleranceReactionComponent));
        }
        return tgt;
    }

    public static Enumeration<AllergyIntolerance.AllergyIntoleranceCategory> convertAllergyIntoleranceCategory(org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<AllergyIntolerance.AllergyIntoleranceCategory> tgt = new Enumeration<AllergyIntolerance.AllergyIntoleranceCategory>(new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceCategory)((Object)src.getValue())) {
            case FOOD: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.FOOD);
                break;
            }
            case MEDICATION: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.MEDICATION);
                break;
            }
            case ENVIRONMENT: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.ENVIRONMENT);
                break;
            }
            case BIOLOGIC: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.BIOLOGIC);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCategory> convertAllergyIntoleranceCategory(Enumeration<AllergyIntolerance.AllergyIntoleranceCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCategory> tgt = new org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCategory>(new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceCategory)((Object)src.getValue())) {
            case FOOD: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.FOOD);
                break;
            }
            case MEDICATION: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.MEDICATION);
                break;
            }
            case ENVIRONMENT: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.ENVIRONMENT);
                break;
            }
            case BIOLOGIC: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.BIOLOGIC);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCategory.NULL);
            }
        }
        return tgt;
    }

    public static AllergyIntolerance.AllergyIntoleranceClinicalStatus convertAllergyIntoleranceClinicalStatus(CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.hasCoding("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical", "active")) {
            return AllergyIntolerance.AllergyIntoleranceClinicalStatus.ACTIVE;
        }
        if (src.hasCoding("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical", "inactive")) {
            return AllergyIntolerance.AllergyIntoleranceClinicalStatus.INACTIVE;
        }
        if (src.hasCoding("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical", "resolved")) {
            return AllergyIntolerance.AllergyIntoleranceClinicalStatus.RESOLVED;
        }
        return AllergyIntolerance.AllergyIntoleranceClinicalStatus.NULL;
    }

    public static CodeableConcept convertAllergyIntoleranceClinicalStatus(AllergyIntolerance.AllergyIntoleranceClinicalStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return new CodeableConcept(new Coding().setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical").setCode("active"));
            }
            case INACTIVE: {
                return new CodeableConcept(new Coding().setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical").setCode("inactive"));
            }
            case RESOLVED: {
                new CodeableConcept(new Coding().setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical").setCode("resolved"));
            }
        }
        return null;
    }

    public static Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality> convertAllergyIntoleranceCriticality(org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality> tgt = new Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality>(new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceCriticality)((Object)src.getValue())) {
            case LOW: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.LOW);
                break;
            }
            case HIGH: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.HIGH);
                break;
            }
            case UNABLETOASSESS: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.UNABLETOASSESS);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality> convertAllergyIntoleranceCriticality(Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality> tgt = new org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceCriticality>(new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceCriticality)((Object)src.getValue())) {
            case LOW: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.LOW);
                break;
            }
            case HIGH: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.HIGH);
                break;
            }
            case UNABLETOASSESS: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.UNABLETOASSESS);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceCriticality.NULL);
            }
        }
        return tgt;
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent convertAllergyIntoleranceReactionComponent(AllergyIntolerance.AllergyIntoleranceReactionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AllergyIntolerance.AllergyIntoleranceReactionComponent tgt = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasSubstance()) {
            tgt.setSubstance(VersionConvertor_30_40.convertCodeableConcept(src.getSubstance()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getManifestation()) {
            tgt.addManifestation(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasOnset()) {
            tgt.setOnsetElement(VersionConvertor_30_40.convertDateTime(src.getOnsetElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(AllergyIntolerance30_40.convertAllergyIntoleranceSeverity(src.getSeverityElement()));
        }
        if (src.hasExposureRoute()) {
            tgt.setExposureRoute(VersionConvertor_30_40.convertCodeableConcept(src.getExposureRoute()));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent convertAllergyIntoleranceReactionComponent(AllergyIntolerance.AllergyIntoleranceReactionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AllergyIntolerance.AllergyIntoleranceReactionComponent tgt = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasSubstance()) {
            tgt.setSubstance(VersionConvertor_30_40.convertCodeableConcept(src.getSubstance()));
        }
        for (CodeableConcept codeableConcept : src.getManifestation()) {
            tgt.addManifestation(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasOnset()) {
            tgt.setOnsetElement(VersionConvertor_30_40.convertDateTime(src.getOnsetElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(AllergyIntolerance30_40.convertAllergyIntoleranceSeverity(src.getSeverityElement()));
        }
        if (src.hasExposureRoute()) {
            tgt.setExposureRoute(VersionConvertor_30_40.convertCodeableConcept(src.getExposureRoute()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity> convertAllergyIntoleranceSeverity(Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity> tgt = new org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity>(new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceSeverity)((Object)src.getValue())) {
            case MILD: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.MILD);
                break;
            }
            case MODERATE: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.MODERATE);
                break;
            }
            case SEVERE: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.SEVERE);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity> convertAllergyIntoleranceSeverity(org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity> tgt = new Enumeration<AllergyIntolerance.AllergyIntoleranceSeverity>(new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceSeverity)((Object)src.getValue())) {
            case MILD: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.MILD);
                break;
            }
            case MODERATE: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.MODERATE);
                break;
            }
            case SEVERE: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.SEVERE);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceSeverity.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceType> convertAllergyIntoleranceType(Enumeration<AllergyIntolerance.AllergyIntoleranceType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceType>(new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceType)((Object)src.getValue())) {
            case ALLERGY: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceType.ALLERGY);
                break;
            }
            case INTOLERANCE: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceType.INTOLERANCE);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<AllergyIntolerance.AllergyIntoleranceType> convertAllergyIntoleranceType(org.hl7.fhir.dstu3.model.Enumeration<AllergyIntolerance.AllergyIntoleranceType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<AllergyIntolerance.AllergyIntoleranceType> tgt = new Enumeration<AllergyIntolerance.AllergyIntoleranceType>(new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((AllergyIntolerance.AllergyIntoleranceType)((Object)src.getValue())) {
            case ALLERGY: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceType.ALLERGY);
                break;
            }
            case INTOLERANCE: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceType.INTOLERANCE);
                break;
            }
            default: {
                tgt.setValue((Object)AllergyIntolerance.AllergyIntoleranceType.NULL);
            }
        }
        return tgt;
    }

    public static CodeableConcept convertAllergyIntoleranceVerificationStatus(AllergyIntolerance.AllergyIntoleranceVerificationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case UNCONFIRMED: {
                return new CodeableConcept(new Coding().setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification").setCode("unconfirmed"));
            }
            case CONFIRMED: {
                return new CodeableConcept(new Coding().setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification").setCode("confirmed"));
            }
            case REFUTED: {
                return new CodeableConcept(new Coding().setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification").setCode("refuted"));
            }
            case ENTEREDINERROR: {
                return new CodeableConcept(new Coding().setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification").setCode("entered-in-error"));
            }
        }
        return null;
    }

    public static AllergyIntolerance.AllergyIntoleranceVerificationStatus convertAllergyIntoleranceVerificationStatus(CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.hasCoding("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification", "unconfirmed")) {
            return AllergyIntolerance.AllergyIntoleranceVerificationStatus.UNCONFIRMED;
        }
        if (src.hasCoding("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification", "confirmed")) {
            return AllergyIntolerance.AllergyIntoleranceVerificationStatus.CONFIRMED;
        }
        if (src.hasCoding("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification", "refuted")) {
            return AllergyIntolerance.AllergyIntoleranceVerificationStatus.REFUTED;
        }
        if (src.hasCoding("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification", "entered-in-error")) {
            return AllergyIntolerance.AllergyIntoleranceVerificationStatus.ENTEREDINERROR;
        }
        return AllergyIntolerance.AllergyIntoleranceVerificationStatus.NULL;
    }
}

