/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Account;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Account;
import org.hl7.fhir.r4.model.Enumeration;

public class Account30_40
extends VersionConvertor_30_40 {
    public static Account convertAccount(org.hl7.fhir.dstu3.model.Account src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Account tgt = new Account();
        Account30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Account30_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Account30_40.convertAccountStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Account30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Account30_40.convertString(src.getNameElement()));
        }
        if (src.hasSubject()) {
            tgt.addSubject(Account30_40.convertReference(src.getSubject()));
        }
        if (src.hasPeriod()) {
            tgt.setServicePeriod(Account30_40.convertPeriod(src.getPeriod()));
        }
        for (Account.CoverageComponent coverageComponent : src.getCoverage()) {
            tgt.addCoverage(Account30_40.convertCoverageComponent(coverageComponent));
        }
        if (src.hasOwner()) {
            tgt.setOwner(Account30_40.convertReference(src.getOwner()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Account30_40.convertString(src.getDescriptionElement()));
        }
        for (Account.GuarantorComponent guarantorComponent : src.getGuarantor()) {
            tgt.addGuarantor(Account30_40.convertGuarantorComponent(guarantorComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Account convertAccount(Account src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Account tgt = new org.hl7.fhir.dstu3.model.Account();
        Account30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Account30_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Account30_40.convertAccountStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Account30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Account30_40.convertString(src.getNameElement()));
        }
        if (src.getSubject().size() > 0) {
            tgt.setSubject(Account30_40.convertReference(src.getSubjectFirstRep()));
        }
        if (src.hasServicePeriod()) {
            tgt.setPeriod(Account30_40.convertPeriod(src.getServicePeriod()));
        }
        for (Account.CoverageComponent coverageComponent : src.getCoverage()) {
            tgt.addCoverage(Account30_40.convertCoverageComponent(coverageComponent));
        }
        if (src.hasOwner()) {
            tgt.setOwner(Account30_40.convertReference(src.getOwner()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Account30_40.convertString(src.getDescriptionElement()));
        }
        for (Account.GuarantorComponent guarantorComponent : src.getGuarantor()) {
            tgt.addGuarantor(Account30_40.convertGuarantorComponent(guarantorComponent));
        }
        return tgt;
    }

    public static Enumeration<Account.AccountStatus> convertAccountStatus(org.hl7.fhir.dstu3.model.Enumeration<Account.AccountStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Account.AccountStatus> tgt = new Enumeration<Account.AccountStatus>(new Account.AccountStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Account.AccountStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Account.AccountStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Account.AccountStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Account.AccountStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Account.AccountStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Account.AccountStatus> convertAccountStatus(Enumeration<Account.AccountStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Account.AccountStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Account.AccountStatus>(new Account.AccountStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Account.AccountStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Account.AccountStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Account.AccountStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Account.AccountStatus.ENTEREDINERROR);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Account.AccountStatus.ACTIVE);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Account.AccountStatus.ACTIVE);
                break;
            }
            default: {
                tgt.setValue((Object)Account.AccountStatus.NULL);
            }
        }
        return tgt;
    }

    public static Account.CoverageComponent convertCoverageComponent(Account.CoverageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Account.CoverageComponent tgt = new Account.CoverageComponent();
        Account30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCoverage()) {
            tgt.setCoverage(Account30_40.convertReference(src.getCoverage()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(Account30_40.convertPositiveInt(src.getPriorityElement()));
        }
        return tgt;
    }

    public static Account.CoverageComponent convertCoverageComponent(Account.CoverageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Account.CoverageComponent tgt = new Account.CoverageComponent();
        Account30_40.copyElement(src, tgt, new String[0]);
        if (src.hasCoverage()) {
            tgt.setCoverage(Account30_40.convertReference(src.getCoverage()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(Account30_40.convertPositiveInt(src.getPriorityElement()));
        }
        return tgt;
    }

    public static Account.GuarantorComponent convertGuarantorComponent(Account.GuarantorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Account.GuarantorComponent tgt = new Account.GuarantorComponent();
        Account30_40.copyElement(src, tgt, new String[0]);
        if (src.hasParty()) {
            tgt.setParty(Account30_40.convertReference(src.getParty()));
        }
        if (src.hasOnHold()) {
            tgt.setOnHoldElement(Account30_40.convertBoolean(src.getOnHoldElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Account30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Account.GuarantorComponent convertGuarantorComponent(Account.GuarantorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Account.GuarantorComponent tgt = new Account.GuarantorComponent();
        Account30_40.copyElement(src, tgt, new String[0]);
        if (src.hasParty()) {
            tgt.setParty(Account30_40.convertReference(src.getParty()));
        }
        if (src.hasOnHold()) {
            tgt.setOnHoldElement(Account30_40.convertBoolean(src.getOnHoldElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Account30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }
}

