/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_50;

import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.SearchParameter;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.UsageContext;

public class SearchParameter14_50 {
    public static org.hl7.fhir.dstu2016may.model.SearchParameter convertSearchParameter(SearchParameter src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.SearchParameter tgt = new org.hl7.fhir.dstu2016may.model.SearchParameter();
        VersionConvertor_14_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(SearchParameter14_50.convertSearchParameterContactComponent(contactDetail));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_50.convertCode(src.getCodeElement()));
        }
        for (CodeType codeType : src.getBase()) {
            tgt.setBase(codeType.asStringValue());
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_50.convertSearchParamType(src.getTypeElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasExpression()) {
            tgt.setExpression(VersionConvertor_14_50.convertTo2016MayExpression(src.getExpression()));
        }
        if (src.hasXpath()) {
            tgt.setXpathElement(VersionConvertor_14_50.convertString(src.getXpathElement()));
        }
        if (src.hasXpathUsage()) {
            tgt.setXpathUsageElement(SearchParameter14_50.convertXPathUsageType(src.getXpathUsageElement()));
        }
        for (CodeType codeType : src.getTarget()) {
            tgt.addTarget((String)codeType.getValue());
        }
        return tgt;
    }

    public static SearchParameter convertSearchParameter(org.hl7.fhir.dstu2016may.model.SearchParameter src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SearchParameter tgt = new SearchParameter();
        VersionConvertor_14_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_50.convertConformanceResourceStatus((org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (SearchParameter.SearchParameterContactComponent t : src.getContact()) {
            tgt.addContact(SearchParameter14_50.convertSearchParameterContactComponent(t));
        }
        for (SearchParameter.SearchParameterContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_50.isJurisdiction((org.hl7.fhir.dstu2016may.model.CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_50.convertCodeableConcept((org.hl7.fhir.dstu2016may.model.CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConceptToUsageContext((org.hl7.fhir.dstu2016may.model.CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_50.convertCode(src.getCodeElement()));
        }
        tgt.addBase(src.getBase());
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_50.convertSearchParamType((org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.SearchParamType>)src.getTypeElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasExpression()) {
            tgt.setExpression(VersionConvertor_14_50.convertToR4Expression(src.getExpression()));
        }
        if (src.hasXpath()) {
            tgt.setXpathElement(VersionConvertor_14_50.convertString(src.getXpathElement()));
        }
        if (src.hasXpathUsage()) {
            tgt.setXpathUsageElement(SearchParameter14_50.convertXPathUsageType((org.hl7.fhir.dstu2016may.model.Enumeration<SearchParameter.XPathUsageType>)src.getXpathUsageElement()));
        }
        for (SearchParameter.SearchParameterContactComponent t : src.getTarget()) {
            tgt.addTarget((String)t.getValue());
        }
        return tgt;
    }

    public static ContactDetail convertSearchParameterContactComponent(SearchParameter.SearchParameterContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static SearchParameter.SearchParameterContactComponent convertSearchParameterContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SearchParameter.SearchParameterContactComponent tgt = new SearchParameter.SearchParameterContactComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<SearchParameter.XPathUsageType> convertXPathUsageType(Enumeration<SearchParameter.XPathUsageType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new SearchParameter.XPathUsageTypeEnumFactory());
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((SearchParameter.XPathUsageType)((Object)src.getValue())) {
            case NORMAL: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NORMAL);
                break;
            }
            case PHONETIC: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.PHONETIC);
                break;
            }
            case NEARBY: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NEARBY);
                break;
            }
            case DISTANCE: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.DISTANCE);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<SearchParameter.XPathUsageType> convertXPathUsageType(org.hl7.fhir.dstu2016may.model.Enumeration<SearchParameter.XPathUsageType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<SearchParameter.XPathUsageType> tgt = new Enumeration<SearchParameter.XPathUsageType>(new SearchParameter.XPathUsageTypeEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((SearchParameter.XPathUsageType)src.getValue()) {
            case NORMAL: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NORMAL);
                break;
            }
            case PHONETIC: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.PHONETIC);
                break;
            }
            case NEARBY: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NEARBY);
                break;
            }
            case DISTANCE: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.DISTANCE);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NULL);
            }
        }
        return tgt;
    }
}

