/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_50;

import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.dstu2016may.model.CompartmentDefinition;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.StringType;

public class CompartmentDefinition14_50 {
    public static CompartmentDefinition convertCompartmentDefinition(org.hl7.fhir.r5.model.CompartmentDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CompartmentDefinition tgt = new CompartmentDefinition();
        VersionConvertor_14_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(CompartmentDefinition14_50.convertCompartmentDefinitionContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCode()) {
            tgt.setCodeElement(CompartmentDefinition14_50.convertCompartmentType(src.getCodeElement()));
        }
        if (src.hasSearchElement()) {
            tgt.setSearchElement(VersionConvertor_14_50.convertBoolean(src.getSearchElement()));
        }
        for (CompartmentDefinition.CompartmentDefinitionResourceComponent compartmentDefinitionResourceComponent : src.getResource()) {
            tgt.addResource(CompartmentDefinition14_50.convertCompartmentDefinitionResourceComponent(compartmentDefinitionResourceComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.CompartmentDefinition convertCompartmentDefinition(CompartmentDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.CompartmentDefinition tgt = new org.hl7.fhir.r5.model.CompartmentDefinition();
        VersionConvertor_14_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_50.convertConformanceResourceStatus((org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (CompartmentDefinition.CompartmentDefinitionContactComponent t : src.getContact()) {
            tgt.addContact(CompartmentDefinition14_50.convertCompartmentDefinitionContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCode()) {
            tgt.setCodeElement(CompartmentDefinition14_50.convertCompartmentType((org.hl7.fhir.dstu2016may.model.Enumeration<CompartmentDefinition.CompartmentType>)src.getCodeElement()));
        }
        if (src.hasSearchElement()) {
            tgt.setSearchElement(VersionConvertor_14_50.convertBoolean(src.getSearchElement()));
        }
        for (CompartmentDefinition.CompartmentDefinitionContactComponent t : src.getResource()) {
            tgt.addResource(CompartmentDefinition14_50.convertCompartmentDefinitionResourceComponent((CompartmentDefinition.CompartmentDefinitionResourceComponent)t));
        }
        return tgt;
    }

    public static CompartmentDefinition.CompartmentDefinitionContactComponent convertCompartmentDefinitionContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CompartmentDefinition.CompartmentDefinitionContactComponent tgt = new CompartmentDefinition.CompartmentDefinitionContactComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertCompartmentDefinitionContactComponent(CompartmentDefinition.CompartmentDefinitionContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static CompartmentDefinition.CompartmentDefinitionResourceComponent convertCompartmentDefinitionResourceComponent(CompartmentDefinition.CompartmentDefinitionResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CompartmentDefinition.CompartmentDefinitionResourceComponent tgt = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasCode() && src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_50.convertCode(src.getCodeElement()));
        }
        for (StringType t : src.getParam()) {
            tgt.addParam((String)t.getValue());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static CompartmentDefinition.CompartmentDefinitionResourceComponent convertCompartmentDefinitionResourceComponent(CompartmentDefinition.CompartmentDefinitionResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CompartmentDefinition.CompartmentDefinitionResourceComponent tgt = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_14_50.convertCode(src.getCodeElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getParam()) {
            tgt.addParam((String)t.getValue());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static Enumeration<Enumerations.CompartmentType> convertCompartmentType(org.hl7.fhir.dstu2016may.model.Enumeration<CompartmentDefinition.CompartmentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.CompartmentType> tgt = new Enumeration<Enumerations.CompartmentType>(new Enumerations.CompartmentTypeEnumFactory());
        VersionConvertor_14_50.copyElement(src, tgt, new String[0]);
        switch ((CompartmentDefinition.CompartmentType)src.getValue()) {
            case PATIENT: {
                tgt.setValue((Object)Enumerations.CompartmentType.PATIENT);
                break;
            }
            case ENCOUNTER: {
                tgt.setValue((Object)Enumerations.CompartmentType.ENCOUNTER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)Enumerations.CompartmentType.RELATEDPERSON);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)Enumerations.CompartmentType.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)Enumerations.CompartmentType.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.CompartmentType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Enumeration<CompartmentDefinition.CompartmentType> convertCompartmentType(Enumeration<Enumerations.CompartmentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Enumeration tgt = new org.hl7.fhir.dstu2016may.model.Enumeration((EnumFactory)new CompartmentDefinition.CompartmentTypeEnumFactory());
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((Enumerations.CompartmentType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.PATIENT);
                break;
            }
            case ENCOUNTER: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.ENCOUNTER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.RELATEDPERSON);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.NULL);
            }
        }
        return tgt;
    }
}

