/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_30;

import org.hl7.fhir.convertors.VersionConvertor_14_30;
import org.hl7.fhir.dstu2016may.model.Conformance;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu3.model.CapabilityStatement;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;

public class Conformance14_30 {
    public static org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.ConditionalDeleteStatus> convertConditionalDeleteStatus(Enumeration<Conformance.ConditionalDeleteStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.ConditionalDeleteStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.ConditionalDeleteStatus>(new CapabilityStatement.ConditionalDeleteStatusEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Conformance.ConditionalDeleteStatus)src.getValue()) {
            case NOTSUPPORTED: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.NOTSUPPORTED);
                break;
            }
            case SINGLE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.SINGLE);
                break;
            }
            case MULTIPLE: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.MULTIPLE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ConditionalDeleteStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Conformance.ConditionalDeleteStatus> convertConditionalDeleteStatus(org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.ConditionalDeleteStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Conformance.ConditionalDeleteStatusEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.ConditionalDeleteStatus)((Object)src.getValue())) {
            case NOTSUPPORTED: {
                tgt.setValue((Object)Conformance.ConditionalDeleteStatus.NOTSUPPORTED);
                break;
            }
            case SINGLE: {
                tgt.setValue((Object)Conformance.ConditionalDeleteStatus.SINGLE);
                break;
            }
            case MULTIPLE: {
                tgt.setValue((Object)Conformance.ConditionalDeleteStatus.MULTIPLE);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.ConditionalDeleteStatus.NULL);
            }
        }
        return tgt;
    }

    public static Conformance convertConformance(CapabilityStatement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance tgt = new Conformance();
        VersionConvertor_14_30.copyDomainResource(src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(Conformance14_30.convertConformanceContactComponent(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasKind()) {
            tgt.setKindElement(Conformance14_30.convertConformanceStatementKind(src.getKindElement()));
        }
        if (src.hasSoftware()) {
            tgt.setSoftware(Conformance14_30.convertConformanceSoftwareComponent(src.getSoftware()));
        }
        if (src.hasImplementation()) {
            tgt.setImplementation(Conformance14_30.convertConformanceImplementationComponent(src.getImplementation()));
        }
        if (src.hasFhirVersionElement()) {
            tgt.setFhirVersionElement(VersionConvertor_14_30.convertId(src.getFhirVersionElement()));
        }
        if (src.hasAcceptUnknown()) {
            tgt.setAcceptUnknownElement(Conformance14_30.convertUnknownContentCode(src.getAcceptUnknownElement()));
        }
        for (CodeType codeType : src.getFormat()) {
            tgt.addFormat((String)codeType.getValue());
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getProfile()) {
            tgt.addProfile(VersionConvertor_14_30.convertReference(reference));
        }
        for (CapabilityStatement.CapabilityStatementRestComponent capabilityStatementRestComponent : src.getRest()) {
            tgt.addRest(Conformance14_30.convertConformanceRestComponent(capabilityStatementRestComponent));
        }
        for (CapabilityStatement.CapabilityStatementMessagingComponent capabilityStatementMessagingComponent : src.getMessaging()) {
            tgt.addMessaging(Conformance14_30.convertConformanceMessagingComponent(capabilityStatementMessagingComponent));
        }
        for (CapabilityStatement.CapabilityStatementDocumentComponent capabilityStatementDocumentComponent : src.getDocument()) {
            tgt.addDocument(Conformance14_30.convertConformanceDocumentComponent(capabilityStatementDocumentComponent));
        }
        return tgt;
    }

    public static CapabilityStatement convertConformance(Conformance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement tgt = new CapabilityStatement();
        VersionConvertor_14_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_14_30.convertConformanceResourceStatus((Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_30.convertString(src.getPublisherElement()));
        }
        for (Conformance.ConformanceContactComponent t : src.getContact()) {
            tgt.addContact(Conformance14_30.convertConformanceContactComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (Conformance.ConformanceContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_30.isJurisdiction((org.hl7.fhir.dstu2016may.model.CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_30.convertCodeableConcept((org.hl7.fhir.dstu2016may.model.CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_30.convertCodeableConceptToUsageContext((org.hl7.fhir.dstu2016may.model.CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasKind()) {
            tgt.setKindElement(Conformance14_30.convertConformanceStatementKind((Enumeration<Conformance.ConformanceStatementKind>)src.getKindElement()));
        }
        if (src.hasSoftware()) {
            tgt.setSoftware(Conformance14_30.convertConformanceSoftwareComponent(src.getSoftware()));
        }
        if (src.hasImplementation()) {
            tgt.setImplementation(Conformance14_30.convertConformanceImplementationComponent(src.getImplementation()));
        }
        if (src.hasFhirVersionElement()) {
            tgt.setFhirVersionElement(VersionConvertor_14_30.convertId(src.getFhirVersionElement()));
        }
        if (src.hasAcceptUnknown()) {
            tgt.setAcceptUnknownElement(Conformance14_30.convertUnknownContentCode((Enumeration<Conformance.UnknownContentCode>)src.getAcceptUnknownElement()));
        }
        for (Conformance.ConformanceContactComponent t : src.getFormat()) {
            tgt.addFormat((String)t.getValue());
        }
        for (Conformance.ConformanceContactComponent t : src.getProfile()) {
            tgt.addProfile(VersionConvertor_14_30.convertReference((Reference)t));
        }
        for (Conformance.ConformanceContactComponent t : src.getRest()) {
            tgt.addRest(Conformance14_30.convertConformanceRestComponent((Conformance.ConformanceRestComponent)t));
        }
        for (Conformance.ConformanceContactComponent t : src.getMessaging()) {
            tgt.addMessaging(Conformance14_30.convertConformanceMessagingComponent((Conformance.ConformanceMessagingComponent)t));
        }
        for (Conformance.ConformanceContactComponent t : src.getDocument()) {
            tgt.addDocument(Conformance14_30.convertConformanceDocumentComponent((Conformance.ConformanceDocumentComponent)t));
        }
        return tgt;
    }

    public static ContactDetail convertConformanceContactComponent(Conformance.ConformanceContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static Conformance.ConformanceContactComponent convertConformanceContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceContactComponent tgt = new Conformance.ConformanceContactComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static Conformance.ConformanceDocumentComponent convertConformanceDocumentComponent(CapabilityStatement.CapabilityStatementDocumentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceDocumentComponent tgt = new Conformance.ConformanceDocumentComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(Conformance14_30.convertDocumentMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_14_30.convertReference(src.getProfile()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementDocumentComponent convertConformanceDocumentComponent(Conformance.ConformanceDocumentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementDocumentComponent tgt = new CapabilityStatement.CapabilityStatementDocumentComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(Conformance14_30.convertDocumentMode((Enumeration<Conformance.DocumentMode>)src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_14_30.convertReference(src.getProfile()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.EventCapabilityMode> convertConformanceEventMode(Enumeration<Conformance.ConformanceEventMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.EventCapabilityMode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.EventCapabilityMode>(new CapabilityStatement.EventCapabilityModeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Conformance.ConformanceEventMode)src.getValue()) {
            case SENDER: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.SENDER);
                break;
            }
            case RECEIVER: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.RECEIVER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Conformance.ConformanceEventMode> convertConformanceEventMode(org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.EventCapabilityMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Conformance.ConformanceEventModeEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.EventCapabilityMode)((Object)src.getValue())) {
            case SENDER: {
                tgt.setValue((Object)Conformance.ConformanceEventMode.SENDER);
                break;
            }
            case RECEIVER: {
                tgt.setValue((Object)Conformance.ConformanceEventMode.RECEIVER);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.ConformanceEventMode.NULL);
            }
        }
        return tgt;
    }

    public static Conformance.ConformanceImplementationComponent convertConformanceImplementationComponent(CapabilityStatement.CapabilityStatementImplementationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceImplementationComponent tgt = new Conformance.ConformanceImplementationComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementImplementationComponent convertConformanceImplementationComponent(Conformance.ConformanceImplementationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementImplementationComponent tgt = new CapabilityStatement.CapabilityStatementImplementationComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_14_30.convertUri(src.getUrlElement()));
        }
        return tgt;
    }

    public static Conformance.ConformanceMessagingComponent convertConformanceMessagingComponent(CapabilityStatement.CapabilityStatementMessagingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceMessagingComponent tgt = new Conformance.ConformanceMessagingComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        for (CapabilityStatement.CapabilityStatementMessagingEndpointComponent capabilityStatementMessagingEndpointComponent : src.getEndpoint()) {
            tgt.addEndpoint(Conformance14_30.convertConformanceMessagingEndpointComponent(capabilityStatementMessagingEndpointComponent));
        }
        if (src.hasReliableCache()) {
            tgt.setReliableCacheElement(VersionConvertor_14_30.convertUnsignedInt(src.getReliableCacheElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        for (CapabilityStatement.CapabilityStatementMessagingEventComponent capabilityStatementMessagingEventComponent : src.getEvent()) {
            tgt.addEvent(Conformance14_30.convertConformanceMessagingEventComponent(capabilityStatementMessagingEventComponent));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingComponent convertConformanceMessagingComponent(Conformance.ConformanceMessagingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingComponent tgt = new CapabilityStatement.CapabilityStatementMessagingComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        for (Conformance.ConformanceMessagingEndpointComponent t : src.getEndpoint()) {
            tgt.addEndpoint(Conformance14_30.convertConformanceMessagingEndpointComponent(t));
        }
        if (src.hasReliableCache()) {
            tgt.setReliableCacheElement(VersionConvertor_14_30.convertUnsignedInt(src.getReliableCacheElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        for (Conformance.ConformanceMessagingEndpointComponent t : src.getEvent()) {
            tgt.addEvent(Conformance14_30.convertConformanceMessagingEventComponent((Conformance.ConformanceMessagingEventComponent)t));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingEndpointComponent convertConformanceMessagingEndpointComponent(Conformance.ConformanceMessagingEndpointComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent tgt = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasProtocol()) {
            tgt.setProtocol(VersionConvertor_14_30.convertCoding(src.getProtocol()));
        }
        if (src.hasAddressElement()) {
            tgt.setAddressElement(VersionConvertor_14_30.convertUri(src.getAddressElement()));
        }
        return tgt;
    }

    public static Conformance.ConformanceMessagingEndpointComponent convertConformanceMessagingEndpointComponent(CapabilityStatement.CapabilityStatementMessagingEndpointComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceMessagingEndpointComponent tgt = new Conformance.ConformanceMessagingEndpointComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasProtocol()) {
            tgt.setProtocol(VersionConvertor_14_30.convertCoding(src.getProtocol()));
        }
        if (src.hasAddressElement()) {
            tgt.setAddressElement(VersionConvertor_14_30.convertUri(src.getAddressElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingEventComponent convertConformanceMessagingEventComponent(Conformance.ConformanceMessagingEventComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingEventComponent tgt = new CapabilityStatement.CapabilityStatementMessagingEventComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_14_30.convertCoding(src.getCode()));
        }
        if (src.hasCategory()) {
            tgt.setCategoryElement(Conformance14_30.convertMessageSignificanceCategory((Enumeration<Conformance.MessageSignificanceCategory>)src.getCategoryElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(Conformance14_30.convertConformanceEventMode((Enumeration<Conformance.ConformanceEventMode>)src.getModeElement()));
        }
        if (src.hasFocusElement()) {
            tgt.setFocusElement(VersionConvertor_14_30.convertCode(src.getFocusElement()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(VersionConvertor_14_30.convertReference(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(VersionConvertor_14_30.convertReference(src.getResponse()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static Conformance.ConformanceMessagingEventComponent convertConformanceMessagingEventComponent(CapabilityStatement.CapabilityStatementMessagingEventComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceMessagingEventComponent tgt = new Conformance.ConformanceMessagingEventComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_14_30.convertCoding(src.getCode()));
        }
        if (src.hasCategory()) {
            tgt.setCategoryElement(Conformance14_30.convertMessageSignificanceCategory(src.getCategoryElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(Conformance14_30.convertConformanceEventMode(src.getModeElement()));
        }
        if (src.hasFocusElement()) {
            tgt.setFocusElement(VersionConvertor_14_30.convertCode(src.getFocusElement()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(VersionConvertor_14_30.convertReference(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(VersionConvertor_14_30.convertReference(src.getResponse()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestComponent convertConformanceRestComponent(Conformance.ConformanceRestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestComponent tgt = new CapabilityStatement.CapabilityStatementRestComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(Conformance14_30.convertRestfulConformanceMode((Enumeration<Conformance.RestfulConformanceMode>)src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        if (src.hasSecurity()) {
            tgt.setSecurity(Conformance14_30.convertConformanceRestSecurityComponent(src.getSecurity()));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getResource()) {
            tgt.addResource(Conformance14_30.convertConformanceRestResourceComponent(t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getInteraction()) {
            tgt.addInteraction(Conformance14_30.convertSystemInteractionComponent((Conformance.SystemInteractionComponent)t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getSearchParam()) {
            tgt.addSearchParam(Conformance14_30.convertConformanceRestResourceSearchParamComponent((Conformance.ConformanceRestResourceSearchParamComponent)t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getOperation()) {
            tgt.addOperation(Conformance14_30.convertConformanceRestOperationComponent((Conformance.ConformanceRestOperationComponent)t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getCompartment()) {
            tgt.addCompartment((String)t.getValue());
        }
        return tgt;
    }

    public static Conformance.ConformanceRestComponent convertConformanceRestComponent(CapabilityStatement.CapabilityStatementRestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestComponent tgt = new Conformance.ConformanceRestComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(Conformance14_30.convertRestfulConformanceMode(src.getModeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        if (src.hasSecurity()) {
            tgt.setSecurity(Conformance14_30.convertConformanceRestSecurityComponent(src.getSecurity()));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent capabilityStatementRestResourceComponent : src.getResource()) {
            tgt.addResource(Conformance14_30.convertConformanceRestResourceComponent(capabilityStatementRestResourceComponent));
        }
        for (CapabilityStatement.SystemInteractionComponent systemInteractionComponent : src.getInteraction()) {
            tgt.addInteraction(Conformance14_30.convertSystemInteractionComponent(systemInteractionComponent));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent capabilityStatementRestResourceSearchParamComponent : src.getSearchParam()) {
            tgt.addSearchParam(Conformance14_30.convertConformanceRestResourceSearchParamComponent(capabilityStatementRestResourceSearchParamComponent));
        }
        for (CapabilityStatement.CapabilityStatementRestOperationComponent capabilityStatementRestOperationComponent : src.getOperation()) {
            tgt.addOperation(Conformance14_30.convertConformanceRestOperationComponent(capabilityStatementRestOperationComponent));
        }
        for (UriType uriType : src.getCompartment()) {
            tgt.addCompartment((String)uriType.getValue());
        }
        return tgt;
    }

    public static Conformance.ConformanceRestOperationComponent convertConformanceRestOperationComponent(CapabilityStatement.CapabilityStatementRestOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestOperationComponent tgt = new Conformance.ConformanceRestOperationComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(VersionConvertor_14_30.convertReference(src.getDefinition()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestOperationComponent convertConformanceRestOperationComponent(Conformance.ConformanceRestOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestOperationComponent tgt = new CapabilityStatement.CapabilityStatementRestOperationComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(VersionConvertor_14_30.convertReference(src.getDefinition()));
        }
        return tgt;
    }

    public static Conformance.ConformanceRestResourceComponent convertConformanceRestResourceComponent(CapabilityStatement.CapabilityStatementRestResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestResourceComponent tgt = new Conformance.ConformanceRestResourceComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_14_30.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_14_30.convertReference(src.getProfile()));
        }
        for (CapabilityStatement.ResourceInteractionComponent resourceInteractionComponent : src.getInteraction()) {
            tgt.addInteraction(Conformance14_30.convertResourceInteractionComponent(resourceInteractionComponent));
        }
        if (src.hasVersioning()) {
            tgt.setVersioningElement(Conformance14_30.convertResourceVersionPolicy(src.getVersioningElement()));
        }
        if (src.hasReadHistory()) {
            tgt.setReadHistoryElement(VersionConvertor_14_30.convertBoolean(src.getReadHistoryElement()));
        }
        if (src.hasUpdateCreate()) {
            tgt.setUpdateCreateElement(VersionConvertor_14_30.convertBoolean(src.getUpdateCreateElement()));
        }
        if (src.hasConditionalCreate()) {
            tgt.setConditionalCreateElement(VersionConvertor_14_30.convertBoolean(src.getConditionalCreateElement()));
        }
        if (src.hasConditionalUpdate()) {
            tgt.setConditionalUpdateElement(VersionConvertor_14_30.convertBoolean(src.getConditionalUpdateElement()));
        }
        if (src.hasConditionalDelete()) {
            tgt.setConditionalDeleteElement(Conformance14_30.convertConditionalDeleteStatus(src.getConditionalDeleteElement()));
        }
        for (StringType stringType : src.getSearchInclude()) {
            tgt.addSearchInclude((String)stringType.getValue());
        }
        for (StringType stringType : src.getSearchRevInclude()) {
            tgt.addSearchRevInclude((String)stringType.getValue());
        }
        for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent capabilityStatementRestResourceSearchParamComponent : src.getSearchParam()) {
            tgt.addSearchParam(Conformance14_30.convertConformanceRestResourceSearchParamComponent(capabilityStatementRestResourceSearchParamComponent));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceComponent convertConformanceRestResourceComponent(Conformance.ConformanceRestResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_14_30.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_14_30.convertReference(src.getProfile()));
        }
        for (Conformance.ResourceInteractionComponent t : src.getInteraction()) {
            tgt.addInteraction(Conformance14_30.convertResourceInteractionComponent(t));
        }
        if (src.hasVersioning()) {
            tgt.setVersioningElement(Conformance14_30.convertResourceVersionPolicy((Enumeration<Conformance.ResourceVersionPolicy>)src.getVersioningElement()));
        }
        if (src.hasReadHistory()) {
            tgt.setReadHistoryElement(VersionConvertor_14_30.convertBoolean(src.getReadHistoryElement()));
        }
        if (src.hasUpdateCreate()) {
            tgt.setUpdateCreateElement(VersionConvertor_14_30.convertBoolean(src.getUpdateCreateElement()));
        }
        if (src.hasConditionalCreate()) {
            tgt.setConditionalCreateElement(VersionConvertor_14_30.convertBoolean(src.getConditionalCreateElement()));
        }
        if (src.hasConditionalUpdate()) {
            tgt.setConditionalUpdateElement(VersionConvertor_14_30.convertBoolean(src.getConditionalUpdateElement()));
        }
        if (src.hasConditionalDelete()) {
            tgt.setConditionalDeleteElement(Conformance14_30.convertConditionalDeleteStatus((Enumeration<Conformance.ConditionalDeleteStatus>)src.getConditionalDeleteElement()));
        }
        for (Conformance.ResourceInteractionComponent t : src.getSearchInclude()) {
            tgt.addSearchInclude((String)t.getValue());
        }
        for (Conformance.ResourceInteractionComponent t : src.getSearchRevInclude()) {
            tgt.addSearchRevInclude((String)t.getValue());
        }
        for (Conformance.ResourceInteractionComponent t : src.getSearchParam()) {
            tgt.addSearchParam(Conformance14_30.convertConformanceRestResourceSearchParamComponent((Conformance.ConformanceRestResourceSearchParamComponent)t));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent convertConformanceRestResourceSearchParamComponent(Conformance.ConformanceRestResourceSearchParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_14_30.convertUri(src.getDefinitionElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_30.convertSearchParamType((Enumeration<Enumerations.SearchParamType>)src.getTypeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static Conformance.ConformanceRestResourceSearchParamComponent convertConformanceRestResourceSearchParamComponent(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestResourceSearchParamComponent tgt = new Conformance.ConformanceRestResourceSearchParamComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_14_30.convertUri(src.getDefinitionElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_30.convertSearchParamType(src.getTypeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent convertConformanceRestSecurityCertificateComponent(Conformance.ConformanceRestSecurityCertificateComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent tgt = new CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_30.convertCode(src.getTypeElement()));
        }
        if (src.hasBlob()) {
            tgt.setBlobElement(VersionConvertor_14_30.convertBase64Binary(src.getBlobElement()));
        }
        return tgt;
    }

    public static Conformance.ConformanceRestSecurityCertificateComponent convertConformanceRestSecurityCertificateComponent(CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestSecurityCertificateComponent tgt = new Conformance.ConformanceRestSecurityCertificateComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_14_30.convertCode(src.getTypeElement()));
        }
        if (src.hasBlob()) {
            tgt.setBlobElement(VersionConvertor_14_30.convertBase64Binary(src.getBlobElement()));
        }
        return tgt;
    }

    public static Conformance.ConformanceRestSecurityComponent convertConformanceRestSecurityComponent(CapabilityStatement.CapabilityStatementRestSecurityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestSecurityComponent tgt = new Conformance.ConformanceRestSecurityComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasCors()) {
            tgt.setCorsElement(VersionConvertor_14_30.convertBoolean(src.getCorsElement()));
        }
        for (CodeableConcept codeableConcept : src.getService()) {
            tgt.addService(VersionConvertor_14_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        for (CapabilityStatement.CapabilityStatementRestSecurityCertificateComponent capabilityStatementRestSecurityCertificateComponent : src.getCertificate()) {
            tgt.addCertificate(Conformance14_30.convertConformanceRestSecurityCertificateComponent(capabilityStatementRestSecurityCertificateComponent));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestSecurityComponent convertConformanceRestSecurityComponent(Conformance.ConformanceRestSecurityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestSecurityComponent tgt = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasCors()) {
            tgt.setCorsElement(VersionConvertor_14_30.convertBoolean(src.getCorsElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.CodeableConcept t : src.getService()) {
            tgt.addService(VersionConvertor_14_30.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_30.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu2016may.model.CodeableConcept t : src.getCertificate()) {
            tgt.addCertificate(Conformance14_30.convertConformanceRestSecurityCertificateComponent((Conformance.ConformanceRestSecurityCertificateComponent)t));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementSoftwareComponent convertConformanceSoftwareComponent(Conformance.ConformanceSoftwareComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementSoftwareComponent tgt = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasReleaseDate()) {
            tgt.setReleaseDateElement(VersionConvertor_14_30.convertDateTime(src.getReleaseDateElement()));
        }
        return tgt;
    }

    public static Conformance.ConformanceSoftwareComponent convertConformanceSoftwareComponent(CapabilityStatement.CapabilityStatementSoftwareComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceSoftwareComponent tgt = new Conformance.ConformanceSoftwareComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_30.convertString(src.getNameElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_30.convertString(src.getVersionElement()));
        }
        if (src.hasReleaseDate()) {
            tgt.setReleaseDateElement(VersionConvertor_14_30.convertDateTime(src.getReleaseDateElement()));
        }
        return tgt;
    }

    public static Enumeration<Conformance.ConformanceStatementKind> convertConformanceStatementKind(org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.CapabilityStatementKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Conformance.ConformanceStatementKindEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.CapabilityStatementKind)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)Conformance.ConformanceStatementKind.INSTANCE);
                break;
            }
            case CAPABILITY: {
                tgt.setValue((Object)Conformance.ConformanceStatementKind.CAPABILITY);
                break;
            }
            case REQUIREMENTS: {
                tgt.setValue((Object)Conformance.ConformanceStatementKind.REQUIREMENTS);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.ConformanceStatementKind.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.CapabilityStatementKind> convertConformanceStatementKind(Enumeration<Conformance.ConformanceStatementKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.CapabilityStatementKind> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.CapabilityStatementKind>(new CapabilityStatement.CapabilityStatementKindEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Conformance.ConformanceStatementKind)src.getValue()) {
            case INSTANCE: {
                tgt.setValue((Object)CapabilityStatement.CapabilityStatementKind.INSTANCE);
                break;
            }
            case CAPABILITY: {
                tgt.setValue((Object)CapabilityStatement.CapabilityStatementKind.CAPABILITY);
                break;
            }
            case REQUIREMENTS: {
                tgt.setValue((Object)CapabilityStatement.CapabilityStatementKind.REQUIREMENTS);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.CapabilityStatementKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Conformance.DocumentMode> convertDocumentMode(org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.DocumentMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Conformance.DocumentModeEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.DocumentMode)((Object)src.getValue())) {
            case PRODUCER: {
                tgt.setValue((Object)Conformance.DocumentMode.PRODUCER);
                break;
            }
            case CONSUMER: {
                tgt.setValue((Object)Conformance.DocumentMode.CONSUMER);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.DocumentMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.DocumentMode> convertDocumentMode(Enumeration<Conformance.DocumentMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.DocumentMode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.DocumentMode>(new CapabilityStatement.DocumentModeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Conformance.DocumentMode)src.getValue()) {
            case PRODUCER: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.PRODUCER);
                break;
            }
            case CONSUMER: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.CONSUMER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.DocumentMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.MessageSignificanceCategory> convertMessageSignificanceCategory(Enumeration<Conformance.MessageSignificanceCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.MessageSignificanceCategory> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.MessageSignificanceCategory>(new CapabilityStatement.MessageSignificanceCategoryEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Conformance.MessageSignificanceCategory)src.getValue()) {
            case CONSEQUENCE: {
                tgt.setValue((Object)CapabilityStatement.MessageSignificanceCategory.CONSEQUENCE);
                break;
            }
            case CURRENCY: {
                tgt.setValue((Object)CapabilityStatement.MessageSignificanceCategory.CURRENCY);
                break;
            }
            case NOTIFICATION: {
                tgt.setValue((Object)CapabilityStatement.MessageSignificanceCategory.NOTIFICATION);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.MessageSignificanceCategory.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Conformance.MessageSignificanceCategory> convertMessageSignificanceCategory(org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.MessageSignificanceCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Conformance.MessageSignificanceCategoryEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.MessageSignificanceCategory)((Object)src.getValue())) {
            case CONSEQUENCE: {
                tgt.setValue((Object)Conformance.MessageSignificanceCategory.CONSEQUENCE);
                break;
            }
            case CURRENCY: {
                tgt.setValue((Object)Conformance.MessageSignificanceCategory.CURRENCY);
                break;
            }
            case NOTIFICATION: {
                tgt.setValue((Object)Conformance.MessageSignificanceCategory.NOTIFICATION);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.MessageSignificanceCategory.NULL);
            }
        }
        return tgt;
    }

    public static CapabilityStatement.ResourceInteractionComponent convertResourceInteractionComponent(Conformance.ResourceInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.ResourceInteractionComponent tgt = new CapabilityStatement.ResourceInteractionComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(Conformance14_30.convertTypeRestfulInteraction((Enumeration<Conformance.TypeRestfulInteraction>)src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static Conformance.ResourceInteractionComponent convertResourceInteractionComponent(CapabilityStatement.ResourceInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ResourceInteractionComponent tgt = new Conformance.ResourceInteractionComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(Conformance14_30.convertTypeRestfulInteraction(src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.ResourceVersionPolicy> convertResourceVersionPolicy(Enumeration<Conformance.ResourceVersionPolicy> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.ResourceVersionPolicy> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.ResourceVersionPolicy>(new CapabilityStatement.ResourceVersionPolicyEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Conformance.ResourceVersionPolicy)src.getValue()) {
            case NOVERSION: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.NOVERSION);
                break;
            }
            case VERSIONED: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.VERSIONED);
                break;
            }
            case VERSIONEDUPDATE: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.VERSIONEDUPDATE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.ResourceVersionPolicy.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Conformance.ResourceVersionPolicy> convertResourceVersionPolicy(org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.ResourceVersionPolicy> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Conformance.ResourceVersionPolicyEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.ResourceVersionPolicy)((Object)src.getValue())) {
            case NOVERSION: {
                tgt.setValue((Object)Conformance.ResourceVersionPolicy.NOVERSION);
                break;
            }
            case VERSIONED: {
                tgt.setValue((Object)Conformance.ResourceVersionPolicy.VERSIONED);
                break;
            }
            case VERSIONEDUPDATE: {
                tgt.setValue((Object)Conformance.ResourceVersionPolicy.VERSIONEDUPDATE);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.ResourceVersionPolicy.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.RestfulCapabilityMode> convertRestfulConformanceMode(Enumeration<Conformance.RestfulConformanceMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.RestfulCapabilityMode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.RestfulCapabilityMode>(new CapabilityStatement.RestfulCapabilityModeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Conformance.RestfulConformanceMode)src.getValue()) {
            case CLIENT: {
                tgt.setValue((Object)CapabilityStatement.RestfulCapabilityMode.CLIENT);
                break;
            }
            case SERVER: {
                tgt.setValue((Object)CapabilityStatement.RestfulCapabilityMode.SERVER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.RestfulCapabilityMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Conformance.RestfulConformanceMode> convertRestfulConformanceMode(org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.RestfulCapabilityMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Conformance.RestfulConformanceModeEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.RestfulCapabilityMode)((Object)src.getValue())) {
            case CLIENT: {
                tgt.setValue((Object)Conformance.RestfulConformanceMode.CLIENT);
                break;
            }
            case SERVER: {
                tgt.setValue((Object)Conformance.RestfulConformanceMode.SERVER);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.RestfulConformanceMode.NULL);
            }
        }
        return tgt;
    }

    public static Conformance.SystemInteractionComponent convertSystemInteractionComponent(CapabilityStatement.SystemInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.SystemInteractionComponent tgt = new Conformance.SystemInteractionComponent();
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(Conformance14_30.convertSystemRestfulInteraction(src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.SystemInteractionComponent convertSystemInteractionComponent(Conformance.SystemInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.SystemInteractionComponent tgt = new CapabilityStatement.SystemInteractionComponent();
        VersionConvertor_14_30.copyElement((Element)src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(Conformance14_30.convertSystemRestfulInteraction((Enumeration<Conformance.SystemRestfulInteraction>)src.getCodeElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_14_30.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.SystemRestfulInteraction> convertSystemRestfulInteraction(Enumeration<Conformance.SystemRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.SystemRestfulInteraction> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.SystemRestfulInteraction>(new CapabilityStatement.SystemRestfulInteractionEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Conformance.SystemRestfulInteraction)src.getValue()) {
            case TRANSACTION: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.TRANSACTION);
                break;
            }
            case SEARCHSYSTEM: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.SEARCHSYSTEM);
                break;
            }
            case HISTORYSYSTEM: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.SystemRestfulInteraction.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Conformance.SystemRestfulInteraction> convertSystemRestfulInteraction(org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.SystemRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Conformance.SystemRestfulInteractionEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.SystemRestfulInteraction)((Object)src.getValue())) {
            case TRANSACTION: {
                tgt.setValue((Object)Conformance.SystemRestfulInteraction.TRANSACTION);
                break;
            }
            case SEARCHSYSTEM: {
                tgt.setValue((Object)Conformance.SystemRestfulInteraction.SEARCHSYSTEM);
                break;
            }
            case HISTORYSYSTEM: {
                tgt.setValue((Object)Conformance.SystemRestfulInteraction.HISTORYSYSTEM);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.SystemRestfulInteraction.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.TypeRestfulInteraction> convertTypeRestfulInteraction(Enumeration<Conformance.TypeRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.TypeRestfulInteraction> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.TypeRestfulInteraction>(new CapabilityStatement.TypeRestfulInteractionEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Conformance.TypeRestfulInteraction)src.getValue()) {
            case READ: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.READ);
                break;
            }
            case VREAD: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.VREAD);
                break;
            }
            case UPDATE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.UPDATE);
                break;
            }
            case DELETE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.DELETE);
                break;
            }
            case HISTORYINSTANCE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE);
                break;
            }
            case HISTORYTYPE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE);
                break;
            }
            case CREATE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.CREATE);
                break;
            }
            case SEARCHTYPE: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.TypeRestfulInteraction.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Conformance.TypeRestfulInteraction> convertTypeRestfulInteraction(org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.TypeRestfulInteraction> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Conformance.TypeRestfulInteractionEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.TypeRestfulInteraction)((Object)src.getValue())) {
            case READ: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.READ);
                break;
            }
            case VREAD: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.VREAD);
                break;
            }
            case UPDATE: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.UPDATE);
                break;
            }
            case DELETE: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.DELETE);
                break;
            }
            case HISTORYINSTANCE: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.HISTORYINSTANCE);
                break;
            }
            case HISTORYTYPE: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.HISTORYTYPE);
                break;
            }
            case CREATE: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.CREATE);
                break;
            }
            case SEARCHTYPE: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.SEARCHTYPE);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.TypeRestfulInteraction.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Conformance.UnknownContentCode> convertUnknownContentCode(org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.UnknownContentCode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Conformance.UnknownContentCodeEnumFactory());
        VersionConvertor_14_30.copyElement(src, (Element)tgt, new String[0]);
        switch ((CapabilityStatement.UnknownContentCode)((Object)src.getValue())) {
            case NO: {
                tgt.setValue((Object)Conformance.UnknownContentCode.NO);
                break;
            }
            case EXTENSIONS: {
                tgt.setValue((Object)Conformance.UnknownContentCode.EXTENSIONS);
                break;
            }
            case ELEMENTS: {
                tgt.setValue((Object)Conformance.UnknownContentCode.ELEMENTS);
                break;
            }
            case BOTH: {
                tgt.setValue((Object)Conformance.UnknownContentCode.BOTH);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.UnknownContentCode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.UnknownContentCode> convertUnknownContentCode(Enumeration<Conformance.UnknownContentCode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.UnknownContentCode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CapabilityStatement.UnknownContentCode>(new CapabilityStatement.UnknownContentCodeEnumFactory());
        VersionConvertor_14_30.copyElement(src, tgt, new String[0]);
        switch ((Conformance.UnknownContentCode)src.getValue()) {
            case NO: {
                tgt.setValue((Object)CapabilityStatement.UnknownContentCode.NO);
                break;
            }
            case EXTENSIONS: {
                tgt.setValue((Object)CapabilityStatement.UnknownContentCode.EXTENSIONS);
                break;
            }
            case ELEMENTS: {
                tgt.setValue((Object)CapabilityStatement.UnknownContentCode.ELEMENTS);
                break;
            }
            case BOTH: {
                tgt.setValue((Object)CapabilityStatement.UnknownContentCode.BOTH);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.UnknownContentCode.NULL);
            }
        }
        return tgt;
    }
}

