/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.Practitioner;

public class Practitioner10_50 {
    public static org.hl7.fhir.r5.model.Practitioner convertPractitioner(Practitioner src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Practitioner tgt = new org.hl7.fhir.r5.model.Practitioner();
        VersionConvertor_10_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(t));
        }
        if (src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_10_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasName()) {
            tgt.addName(VersionConvertor_10_50.convertHumanName(src.getName()));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint((ContactPoint)t));
        }
        for (Identifier t : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_50.convertAddress((org.hl7.fhir.dstu2.model.Address)t));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_10_50.convertAdministrativeGender((Enumeration<Enumerations.AdministrativeGender>)src.getGenderElement()));
        }
        if (src.hasBirthDateElement()) {
            tgt.setBirthDateElement(VersionConvertor_10_50.convertDate(src.getBirthDateElement()));
        }
        for (Identifier t : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_10_50.convertAttachment((org.hl7.fhir.dstu2.model.Attachment)t));
        }
        for (Identifier t : src.getQualification()) {
            tgt.addQualification(Practitioner10_50.convertPractitionerQualificationComponent((Practitioner.PractitionerQualificationComponent)t));
        }
        for (Identifier t : src.getCommunication()) {
            tgt.addCommunication(VersionConvertor_10_50.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        return tgt;
    }

    public static Practitioner convertPractitioner(org.hl7.fhir.r5.model.Practitioner src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Practitioner tgt = new Practitioner();
        VersionConvertor_10_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_10_50.convertBoolean(src.getActiveElement()));
        }
        for (HumanName humanName : src.getName()) {
            tgt.setName(VersionConvertor_10_50.convertHumanName(humanName));
        }
        for (org.hl7.fhir.r5.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(contactPoint));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_50.convertAddress(address));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(VersionConvertor_10_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDateElement()) {
            tgt.setBirthDateElement(VersionConvertor_10_50.convertDate(src.getBirthDateElement()));
        }
        for (Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_10_50.convertAttachment(attachment));
        }
        for (Practitioner.PractitionerQualificationComponent practitionerQualificationComponent : src.getQualification()) {
            tgt.addQualification(Practitioner10_50.convertPractitionerQualificationComponent(practitionerQualificationComponent));
        }
        for (CodeableConcept codeableConcept : src.getCommunication()) {
            tgt.addCommunication(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static Practitioner.PractitionerQualificationComponent convertPractitionerQualificationComponent(Practitioner.PractitionerQualificationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Practitioner.PractitionerQualificationComponent tgt = new Practitioner.PractitionerQualificationComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasIssuer()) {
            tgt.setIssuer(VersionConvertor_10_50.convertReference(src.getIssuer()));
        }
        return tgt;
    }

    public static Practitioner.PractitionerQualificationComponent convertPractitionerQualificationComponent(Practitioner.PractitionerQualificationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Practitioner.PractitionerQualificationComponent tgt = new Practitioner.PractitionerQualificationComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasIssuer()) {
            tgt.setIssuer(VersionConvertor_10_50.convertReference(src.getIssuer()));
        }
        return tgt;
    }
}

