/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.HealthcareService;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Reference;

public class HealthcareService10_50 {
    public static Enumeration<HealthcareService.DaysOfWeek> convertDaysOfWeek(org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new HealthcareService.DaysOfWeekEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((Enumerations.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)HealthcareService.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> convertDaysOfWeek(Enumeration<HealthcareService.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((HealthcareService.DaysOfWeek)src.getValue()) {
            case MON: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.HealthcareService convertHealthcareService(HealthcareService src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.HealthcareService tgt = new org.hl7.fhir.dstu2.model.HealthcareService();
        VersionConvertor_10_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasProvidedBy()) {
            tgt.setProvidedBy(VersionConvertor_10_50.convertReference(src.getProvidedBy()));
        }
        for (CodeableConcept codeableConcept : src.getSpecialty()) {
            if (!tgt.hasServiceType()) {
                tgt.addServiceType();
            }
            ((HealthcareService.ServiceTypeComponent)tgt.getServiceType().get(0)).addSpecialty(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getLocation()) {
            tgt.setLocation(VersionConvertor_10_50.convertReference(reference));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_50.convertString(src.getCommentElement()));
        }
        if (src.hasExtraDetails()) {
            tgt.setExtraDetails(src.getExtraDetails());
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_10_50.convertAttachment(src.getPhoto()));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(contactPoint));
        }
        for (Reference reference : src.getCoverageArea()) {
            tgt.addCoverageArea(VersionConvertor_10_50.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        tgt.setEligibility(VersionConvertor_10_50.convertCodeableConcept(src.getEligibilityFirstRep().getCode()));
        if (src.hasCommentElement()) {
            tgt.setEligibilityNoteElement(VersionConvertor_10_50.convertString(src.getCommentElement()));
        }
        for (CodeableConcept codeableConcept : src.getProgram()) {
            if (!codeableConcept.hasText()) continue;
            tgt.addProgramName(codeableConcept.getText());
        }
        for (CodeableConcept codeableConcept : src.getCharacteristic()) {
            tgt.addCharacteristic(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getReferralMethod()) {
            tgt.addReferralMethod(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentRequiredElement()) {
            tgt.setAppointmentRequiredElement(VersionConvertor_10_50.convertBoolean(src.getAppointmentRequiredElement()));
        }
        for (HealthcareService.HealthcareServiceAvailableTimeComponent healthcareServiceAvailableTimeComponent : src.getAvailableTime()) {
            tgt.addAvailableTime(HealthcareService10_50.convertHealthcareServiceAvailableTimeComponent(healthcareServiceAvailableTimeComponent));
        }
        for (HealthcareService.HealthcareServiceNotAvailableComponent healthcareServiceNotAvailableComponent : src.getNotAvailable()) {
            tgt.addNotAvailable(HealthcareService10_50.convertHealthcareServiceNotAvailableComponent(healthcareServiceNotAvailableComponent));
        }
        if (src.hasAvailabilityExceptionsElement()) {
            tgt.setAvailabilityExceptionsElement(VersionConvertor_10_50.convertString(src.getAvailabilityExceptionsElement()));
        }
        return tgt;
    }

    public static HealthcareService convertHealthcareService(org.hl7.fhir.dstu2.model.HealthcareService src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService tgt = new HealthcareService();
        VersionConvertor_10_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(t));
        }
        if (src.hasProvidedBy()) {
            tgt.setProvidedBy(VersionConvertor_10_50.convertReference(src.getProvidedBy()));
        }
        for (Identifier t : src.getServiceType()) {
            for (org.hl7.fhir.dstu2.model.CodeableConcept tj : t.getSpecialty()) {
                tgt.addSpecialty(VersionConvertor_10_50.convertCodeableConcept(tj));
            }
        }
        if (src.hasLocation()) {
            tgt.addLocation(VersionConvertor_10_50.convertReference(src.getLocation()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_50.convertString(src.getCommentElement()));
        }
        if (src.hasExtraDetails()) {
            tgt.setExtraDetails(src.getExtraDetails());
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_10_50.convertAttachment(src.getPhoto()));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint((org.hl7.fhir.dstu2.model.ContactPoint)t));
        }
        for (Identifier t : src.getCoverageArea()) {
            tgt.addCoverageArea(VersionConvertor_10_50.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        for (Identifier t : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(VersionConvertor_10_50.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        if (src.hasEligibility()) {
            tgt.getEligibilityFirstRep().setCode(VersionConvertor_10_50.convertCodeableConcept(src.getEligibility()));
        }
        if (src.hasEligibilityNote()) {
            tgt.getEligibilityFirstRep().setComment(src.getEligibilityNote());
        }
        for (Identifier t : src.getProgramName()) {
            tgt.addProgram().setText((String)t.getValue());
        }
        for (Identifier t : src.getCharacteristic()) {
            tgt.addCharacteristic(VersionConvertor_10_50.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        for (Identifier t : src.getReferralMethod()) {
            tgt.addReferralMethod(VersionConvertor_10_50.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        if (src.hasAppointmentRequiredElement()) {
            tgt.setAppointmentRequiredElement(VersionConvertor_10_50.convertBoolean(src.getAppointmentRequiredElement()));
        }
        for (Identifier t : src.getAvailableTime()) {
            tgt.addAvailableTime(HealthcareService10_50.convertHealthcareServiceAvailableTimeComponent((HealthcareService.HealthcareServiceAvailableTimeComponent)t));
        }
        for (Identifier t : src.getNotAvailable()) {
            tgt.addNotAvailable(HealthcareService10_50.convertHealthcareServiceNotAvailableComponent((HealthcareService.HealthcareServiceNotAvailableComponent)t));
        }
        if (src.hasAvailabilityExceptionsElement()) {
            tgt.setAvailabilityExceptionsElement(VersionConvertor_10_50.convertString(src.getAvailabilityExceptionsElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(HealthcareService10_50::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDayElement()) {
            tgt.setAllDayElement(VersionConvertor_10_50.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTimeElement()) {
            tgt.setAvailableStartTimeElement(VersionConvertor_10_50.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTimeElement()) {
            tgt.setAvailableEndTimeElement(VersionConvertor_10_50.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(HealthcareService10_50::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDayElement()) {
            tgt.setAllDayElement(VersionConvertor_10_50.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTimeElement()) {
            tgt.setAvailableStartTimeElement(VersionConvertor_10_50.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTimeElement()) {
            tgt.setAvailableEndTimeElement(VersionConvertor_10_50.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_10_50.convertPeriod(src.getDuring()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_10_50.convertPeriod(src.getDuring()));
        }
        return tgt;
    }
}

