/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import java.util.ArrayList;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DataElement;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.ElementDefinition;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.StructureDefinition;

public class DataElement10_50 {
    public static StructureDefinition convertDataElement(DataElement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition tgt = new StructureDefinition();
        VersionConvertor_10_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl().replace("/DataElement/", "/StructureDefinition/de-"));
        }
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(t));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_50.convertString(src.getVersionElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)VersionConvertor_10_50.convertConformanceResourceStatus((Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_50.convertString(src.getPublisherElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (Identifier t : src.getContact()) {
            tgt.addContact(DataElement10_50.convertDataElementContactComponent((DataElement.DataElementContactComponent)t));
        }
        for (Identifier t : src.getUseContext()) {
            if (VersionConvertor_10_50.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_10_50.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_50.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (Identifier t : src.getMapping()) {
            tgt.addMapping(DataElement10_50.convertDataElementMappingComponent((DataElement.DataElementMappingComponent)t));
        }
        ArrayList<String> slicePaths = new ArrayList<String>();
        for (ElementDefinition t : src.getElement()) {
            if (t.hasSlicing()) {
                slicePaths.add(t.getPath());
            }
            tgt.getSnapshot().addElement(VersionConvertor_10_50.convertElementDefinition(t, slicePaths, src.getElement(), src.getElement().indexOf(t)));
        }
        tgt.setKind(StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
        tgt.setAbstract(false);
        tgt.setType(tgt.getName());
        tgt.setBaseDefinition("http://hl7.org/fhir/StructureDefinition/Element");
        tgt.setDerivation(StructureDefinition.TypeDerivationRule.SPECIALIZATION);
        return tgt;
    }

    public static DataElement.DataElementContactComponent convertDataElementContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DataElement.DataElementContactComponent tgt = new DataElement.DataElementContactComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertDataElementContactComponent(DataElement.DataElementContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertDataElementMappingComponent(DataElement.DataElementMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_10_50.convertId(src.getIdentityElement()));
        }
        if (src.hasUriElement()) {
            tgt.setUriElement(VersionConvertor_10_50.convertUri(src.getUriElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasCommentsElement()) {
            tgt.setCommentElement(VersionConvertor_10_50.convertString(src.getCommentsElement()));
        }
        return tgt;
    }
}

