/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.convertors.SourceElementComponentWrapper;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.ConceptMap;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.utils.ToolingExtensions;

public class ConceptMap10_50 {
    public static org.hl7.fhir.r5.model.ConceptMap convertConceptMap(ConceptMap src) throws FHIRException {
        DataType r;
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.ConceptMap tgt = new org.hl7.fhir.r5.model.ConceptMap();
        VersionConvertor_10_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_50.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_50.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)VersionConvertor_10_50.convertConformanceResourceStatus((Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_50.convertString(src.getPublisherElement()));
        }
        for (ConceptMap.ConceptMapContactComponent t : src.getContact()) {
            tgt.addContact(ConceptMap10_50.convertConceptMapContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ConceptMap.ConceptMapContactComponent t : src.getUseContext()) {
            if (VersionConvertor_10_50.isJurisdiction((org.hl7.fhir.dstu2.model.CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_10_50.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_50.convertCodeableConceptToUsageContext((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        tgt.setSource((r = VersionConvertor_10_50.convertType(src.getSource())) instanceof Reference ? new CanonicalType(((Reference)r).getReference()) : r);
        r = VersionConvertor_10_50.convertType(src.getTarget());
        tgt.setTarget(r instanceof Reference ? new CanonicalType(((Reference)r).getReference()) : r);
        for (ConceptMap.SourceElementComponent t : src.getElement()) {
            List<SourceElementComponentWrapper<ConceptMap.SourceElementComponent>> ws = ConceptMap10_50.convertSourceElementComponent(t);
            for (SourceElementComponentWrapper<ConceptMap.SourceElementComponent> w : ws) {
                ConceptMap10_50.getGroup(tgt, w.getSource(), w.getTarget()).addElement(w.getComp());
            }
        }
        return tgt;
    }

    public static ConceptMap convertConceptMap(org.hl7.fhir.r5.model.ConceptMap src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap tgt = new ConceptMap();
        VersionConvertor_10_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_50.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier() && src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_50.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ConceptMap10_50.convertConceptMapContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_10_50.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_10_50.convertType(src.getSource()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_50.convertType(src.getTarget()));
        }
        for (ConceptMap.ConceptMapGroupComponent conceptMapGroupComponent : src.getGroup()) {
            for (ConceptMap.SourceElementComponent t : conceptMapGroupComponent.getElement()) {
                tgt.addElement(ConceptMap10_50.convertSourceElementComponent(t, conceptMapGroupComponent));
            }
        }
        return tgt;
    }

    public static ContactDetail convertConceptMapContactComponent(ConceptMap.ConceptMapContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapContactComponent convertConceptMapContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.ConceptMapContactComponent tgt = new ConceptMap.ConceptMapContactComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static Enumeration<Enumerations.ConceptMapEquivalence> convertConceptMapEquivalence(org.hl7.fhir.r5.model.Enumeration<Enumerations.ConceptMapRelationship> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Enumerations.ConceptMapEquivalenceEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence");
        if (src.hasExtension("http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence")) {
            tgt.setValueAsString(src.getExtensionString("http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence"));
        } else {
            switch ((Enumerations.ConceptMapRelationship)((Object)src.getValue())) {
                case EQUIVALENT: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUIVALENT);
                    break;
                }
                case SOURCEISNARROWERTHANTARGET: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.WIDER);
                    break;
                }
                case SOURCEISBROADERTHANTARGET: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NARROWER);
                    break;
                }
                case NOTRELATEDTO: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.DISJOINT);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ConceptMapRelationship> convertConceptMapRelationship(Enumeration<Enumerations.ConceptMapEquivalence> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ConceptMapRelationship> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ConceptMapRelationship>(new Enumerations.ConceptMapRelationshipEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        ToolingExtensions.setCodeExtension(tgt, "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence", src.getValueAsString());
        switch ((Enumerations.ConceptMapEquivalence)src.getValue()) {
            case EQUIVALENT: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.EQUIVALENT);
                break;
            }
            case EQUAL: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.EQUIVALENT);
                break;
            }
            case WIDER: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET);
                break;
            }
            case SUBSUMES: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET);
                break;
            }
            case NARROWER: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET);
                break;
            }
            case SPECIALIZES: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET);
                break;
            }
            case INEXACT: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.RELATEDTO);
                break;
            }
            case UNMATCHED: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.NULL);
                break;
            }
            case DISJOINT: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.NOTRELATEDTO);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.NULL);
            }
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasPropertyElement()) {
            tgt.setElementElement(VersionConvertor_10_50.convertUri(src.getPropertyElement()));
        }
        if (src.hasSystem()) {
            tgt.setCodeSystem(src.getSystem());
        }
        if (src.hasValueElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasElementElement()) {
            tgt.setPropertyElement(VersionConvertor_10_50.convertUri(src.getElementElement()));
        }
        if (src.hasCodeSystem()) {
            tgt.setSystem(src.getCodeSystem());
        }
        if (src.hasCodeElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertString(src.getCodeElement()));
        }
        return tgt;
    }

    public static ConceptMap.SourceElementComponent convertSourceElementComponent(ConceptMap.SourceElementComponent src, ConceptMap.ConceptMapGroupComponent g2) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        tgt.setCodeSystem(g2.getSource());
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        if (src.hasNoMap() && src.getNoMap()) {
            tgt.addTarget(new ConceptMap.TargetElementComponent().setEquivalence(Enumerations.ConceptMapEquivalence.UNMATCHED));
        } else {
            for (ConceptMap.TargetElementComponent t : src.getTarget()) {
                tgt.addTarget(ConceptMap10_50.convertTargetElementComponent(t, g2));
            }
        }
        return tgt;
    }

    public static List<SourceElementComponentWrapper<ConceptMap.SourceElementComponent>> convertSourceElementComponent(ConceptMap.SourceElementComponent src) throws FHIRException {
        ArrayList<SourceElementComponentWrapper<ConceptMap.SourceElementComponent>> res = new ArrayList<SourceElementComponentWrapper<ConceptMap.SourceElementComponent>>();
        if (src == null || src.isEmpty()) {
            return res;
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
            VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
            tgt.setCode(src.getCode());
            if (t.getEquivalence() == Enumerations.ConceptMapEquivalence.UNMATCHED) {
                tgt.setNoMap(true);
            } else {
                tgt.addTarget(ConceptMap10_50.convertTargetElementComponent(t));
            }
            res.add(new SourceElementComponentWrapper<ConceptMap.SourceElementComponent>(tgt, src.getCodeSystem(), t.getCodeSystem()));
        }
        return res;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src, ConceptMap.ConceptMapGroupComponent g2) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        tgt.setCodeSystem(g2.getTarget());
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        if (src.hasRelationship()) {
            tgt.setEquivalenceElement(ConceptMap10_50.convertConceptMapEquivalence(src.getRelationshipElement()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentsElement(VersionConvertor_10_50.convertString(src.getCommentElement()));
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(ConceptMap10_50.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(ConceptMap10_50.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        if (src.hasEquivalence()) {
            tgt.setRelationshipElement(ConceptMap10_50.convertConceptMapRelationship((Enumeration<Enumerations.ConceptMapEquivalence>)src.getEquivalenceElement()));
        }
        if (src.hasCommentsElement()) {
            tgt.setCommentElement(VersionConvertor_10_50.convertString(src.getCommentsElement()));
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(ConceptMap10_50.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(ConceptMap10_50.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupComponent getGroup(org.hl7.fhir.r5.model.ConceptMap map, String srcs, String tgts) {
        for (ConceptMap.ConceptMapGroupComponent grp : map.getGroup()) {
            if (!grp.getSource().equals(srcs) || !grp.getTarget().equals(tgts)) continue;
            return grp;
        }
        ConceptMap.ConceptMapGroupComponent grp = map.addGroup();
        grp.setSource(srcs);
        grp.setTarget(tgts);
        return grp;
    }
}

