/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import java.util.Collections;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.Composition;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class Composition10_50 {
    public static org.hl7.fhir.r5.model.Composition convertComposition(Composition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Composition tgt = new org.hl7.fhir.r5.model.Composition();
        VersionConvertor_10_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasClass_()) {
            tgt.addCategory(VersionConvertor_10_50.convertCodeableConcept(src.getClass_()));
        }
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Composition10_50.convertCompositionStatus((Enumeration<Composition.CompositionStatus>)src.getStatusElement()));
        }
        try {
            if (src.hasConfidentiality()) {
                tgt.setConfidentiality(src.getConfidentiality());
            }
        }
        catch (FHIRException e) {
            throw new FHIRException(e);
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getAuthor()) {
            tgt.addAuthor(VersionConvertor_10_50.convertReference(t));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getAttester()) {
            tgt.addAttester(Composition10_50.convertCompositionAttesterComponent((Composition.CompositionAttesterComponent)t));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_10_50.convertReference(src.getCustodian()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getEvent()) {
            tgt.addEvent(Composition10_50.convertCompositionEventComponent((Composition.CompositionEventComponent)t));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_50.convertReference(src.getEncounter()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getSection()) {
            tgt.addSection(Composition10_50.convertSectionComponent((Composition.SectionComponent)t));
        }
        return tgt;
    }

    public static Composition convertComposition(org.hl7.fhir.r5.model.Composition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition tgt = new Composition();
        VersionConvertor_10_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasCategory()) {
            tgt.setClass_(VersionConvertor_10_50.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Composition10_50.convertCompositionStatus(src.getStatusElement()));
        }
        tgt.setConfidentiality(src.getConfidentiality());
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        for (Reference reference : src.getAuthor()) {
            tgt.addAuthor(VersionConvertor_10_50.convertReference(reference));
        }
        for (Composition.CompositionAttesterComponent compositionAttesterComponent : src.getAttester()) {
            tgt.addAttester(Composition10_50.convertCompositionAttesterComponent(compositionAttesterComponent));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_10_50.convertReference(src.getCustodian()));
        }
        for (Composition.CompositionEventComponent compositionEventComponent : src.getEvent()) {
            tgt.addEvent(Composition10_50.convertCompositionEventComponent(compositionEventComponent));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_50.convertReference(src.getEncounter()));
        }
        for (Composition.SectionComponent sectionComponent : src.getSection()) {
            tgt.addSection(Composition10_50.convertSectionComponent(sectionComponent));
        }
        return tgt;
    }

    public static Enumeration<Composition.CompositionAttestationMode> convertCompositionAttestationMode(org.hl7.fhir.r5.model.Enumeration<Composition.CompositionAttestationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Composition.CompositionAttestationModeEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((Composition.CompositionAttestationMode)((Object)src.getValue())) {
            case PERSONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PERSONAL);
                break;
            }
            case PROFESSIONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PROFESSIONAL);
                break;
            }
            case LEGAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.LEGAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.OFFICIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Composition.CompositionAttestationMode> convertCompositionAttestationMode(Enumeration<Composition.CompositionAttestationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Composition.CompositionAttestationMode> tgt = new org.hl7.fhir.r5.model.Enumeration<Composition.CompositionAttestationMode>(new Composition.CompositionAttestationModeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Composition.CompositionAttestationMode)src.getValue()) {
            case PERSONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PERSONAL);
                break;
            }
            case PROFESSIONAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.PROFESSIONAL);
                break;
            }
            case LEGAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.LEGAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.OFFICIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.CompositionAttestationMode.NULL);
            }
        }
        return tgt;
    }

    public static Composition.CompositionAttesterComponent convertCompositionAttesterComponent(Composition.CompositionAttesterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.CompositionAttesterComponent tgt = new Composition.CompositionAttesterComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setMode(Collections.singletonList(Composition10_50.convertCompositionAttestationMode(src.getModeElement())));
        }
        if (src.hasTimeElement()) {
            tgt.setTimeElement(VersionConvertor_10_50.convertDateTime(src.getTimeElement()));
        }
        if (src.hasParty()) {
            tgt.setParty(VersionConvertor_10_50.convertReference(src.getParty()));
        }
        return tgt;
    }

    public static Composition.CompositionAttesterComponent convertCompositionAttesterComponent(Composition.CompositionAttesterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.CompositionAttesterComponent tgt = new Composition.CompositionAttesterComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(Composition10_50.convertCompositionAttestationMode((Enumeration<Composition.CompositionAttestationMode>)((Enumeration)src.getMode().get(0))));
        }
        if (src.hasTimeElement()) {
            tgt.setTimeElement(VersionConvertor_10_50.convertDateTime(src.getTimeElement()));
        }
        if (src.hasParty()) {
            tgt.setParty(VersionConvertor_10_50.convertReference(src.getParty()));
        }
        return tgt;
    }

    public static Composition.CompositionEventComponent convertCompositionEventComponent(Composition.CompositionEventComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.CompositionEventComponent tgt = new Composition.CompositionEventComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        for (CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        for (Reference reference : src.getDetail()) {
            tgt.addDetail(VersionConvertor_10_50.convertReference(reference));
        }
        return tgt;
    }

    public static Composition.CompositionEventComponent convertCompositionEventComponent(Composition.CompositionEventComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.CompositionEventComponent tgt = new Composition.CompositionEventComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getCode()) {
            tgt.addCode(VersionConvertor_10_50.convertCodeableConcept(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept t : src.getDetail()) {
            tgt.addDetail(VersionConvertor_10_50.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.CompositionStatus> convertCompositionStatus(Enumeration<Composition.CompositionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.CompositionStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.CompositionStatus>(new Enumerations.CompositionStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Composition.CompositionStatus)src.getValue()) {
            case PRELIMINARY: {
                tgt.setValue((Object)Enumerations.CompositionStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Enumerations.CompositionStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Enumerations.CompositionStatus.AMENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.CompositionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.CompositionStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Composition.CompositionStatus> convertCompositionStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.CompositionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Composition.CompositionStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((Enumerations.CompositionStatus)((Object)src.getValue())) {
            case PRELIMINARY: {
                tgt.setValue((Object)Composition.CompositionStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Composition.CompositionStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Composition.CompositionStatus.AMENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Composition.CompositionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Composition.CompositionStatus.NULL);
            }
        }
        return tgt;
    }

    public static Composition.SectionComponent convertSectionComponent(Composition.SectionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.SectionComponent tgt = new Composition.SectionComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_50.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasText()) {
            tgt.setText(VersionConvertor_10_50.convertNarrative(src.getText()));
        }
        tgt.setMode(src.getMode().toCode());
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_10_50.convertCodeableConcept(src.getOrderedBy()));
        }
        for (Reference reference : src.getEntry()) {
            tgt.addEntry(VersionConvertor_10_50.convertReference(reference));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(VersionConvertor_10_50.convertCodeableConcept(src.getEmptyReason()));
        }
        for (Composition.SectionComponent sectionComponent : src.getSection()) {
            tgt.addSection(Composition10_50.convertSectionComponent(sectionComponent));
        }
        return tgt;
    }

    public static Composition.SectionComponent convertSectionComponent(Composition.SectionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.SectionComponent tgt = new Composition.SectionComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_50.convertString(src.getTitleElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasText()) {
            tgt.setText(VersionConvertor_10_50.convertNarrative(src.getText()));
        }
        try {
            if (src.hasMode()) {
                tgt.setMode(Enumerations.ListMode.fromCode(src.getMode()));
            }
        }
        catch (FHIRException e) {
            throw new FHIRException(e);
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_10_50.convertCodeableConcept(src.getOrderedBy()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getEntry()) {
            tgt.addEntry(VersionConvertor_10_50.convertReference(t));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(VersionConvertor_10_50.convertCodeableConcept(src.getEmptyReason()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getSection()) {
            tgt.addSection(Composition10_50.convertSectionComponent((Composition.SectionComponent)t));
        }
        return tgt;
    }
}

