/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.Communication;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class Communication10_50 {
    public static Communication convertCommunication(org.hl7.fhir.dstu2.model.Communication src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Communication tgt = new Communication();
        VersionConvertor_10_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(t));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_10_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasSender()) {
            tgt.setSender(VersionConvertor_10_50.convertReference(src.getSender()));
        }
        for (Identifier t : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_10_50.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        for (Identifier t : src.getPayload()) {
            tgt.addPayload(Communication10_50.convertCommunicationPayloadComponent((Communication.CommunicationPayloadComponent)t));
        }
        for (Identifier t : src.getMedium()) {
            tgt.addMedium(VersionConvertor_10_50.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Communication10_50.convertCommunicationStatus((Enumeration<Communication.CommunicationStatus>)src.getStatusElement()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_50.convertReference(src.getEncounter()));
        }
        if (src.hasSentElement()) {
            tgt.setSentElement(VersionConvertor_10_50.convertDateTime(src.getSentElement()));
        }
        if (src.hasReceivedElement()) {
            tgt.setReceivedElement(VersionConvertor_10_50.convertDateTime(src.getReceivedElement()));
        }
        for (Identifier t : src.getReason()) {
            tgt.addReason(VersionConvertor_10_50.convertCodeableConceptToCodableReference((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Communication convertCommunication(Communication src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Communication tgt = new org.hl7.fhir.dstu2.model.Communication();
        VersionConvertor_10_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_50.convertIdentifier(identifier));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_10_50.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasSender()) {
            tgt.setSender(VersionConvertor_10_50.convertReference(src.getSender()));
        }
        for (Reference reference : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_10_50.convertReference(reference));
        }
        for (Communication.CommunicationPayloadComponent communicationPayloadComponent : src.getPayload()) {
            tgt.addPayload(Communication10_50.convertCommunicationPayloadComponent(communicationPayloadComponent));
        }
        for (CodeableConcept codeableConcept : src.getMedium()) {
            tgt.addMedium(VersionConvertor_10_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Communication10_50.convertCommunicationStatus(src.getStatusElement()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_50.convertReference(src.getEncounter()));
        }
        if (src.hasSentElement()) {
            tgt.setSentElement(VersionConvertor_10_50.convertDateTime(src.getSentElement()));
        }
        if (src.hasReceivedElement()) {
            tgt.setReceivedElement(VersionConvertor_10_50.convertDateTime(src.getReceivedElement()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReason(VersionConvertor_10_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_50.convertReference(src.getSubject()));
        }
        return tgt;
    }

    public static Communication.CommunicationPayloadComponent convertCommunicationPayloadComponent(Communication.CommunicationPayloadComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Communication.CommunicationPayloadComponent tgt = new Communication.CommunicationPayloadComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_10_50.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Communication.CommunicationPayloadComponent convertCommunicationPayloadComponent(Communication.CommunicationPayloadComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Communication.CommunicationPayloadComponent tgt = new Communication.CommunicationPayloadComponent();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_10_50.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Enumeration<Communication.CommunicationStatus> convertCommunicationStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Communication.CommunicationStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((Enumerations.EventStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)Communication.CommunicationStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Communication.CommunicationStatus.COMPLETED);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Communication.CommunicationStatus.SUSPENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Communication.CommunicationStatus.REJECTED);
                break;
            }
            case NOTDONE: {
                tgt.setValue((Object)Communication.CommunicationStatus.FAILED);
                break;
            }
            default: {
                tgt.setValue((Object)Communication.CommunicationStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus> convertCommunicationStatus(Enumeration<Communication.CommunicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus>(new Enumerations.EventStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Communication.CommunicationStatus)src.getValue()) {
            case INPROGRESS: {
                tgt.setValue((Object)Enumerations.EventStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Enumerations.EventStatus.COMPLETED);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)Enumerations.EventStatus.ONHOLD);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Enumerations.EventStatus.ENTEREDINERROR);
                break;
            }
            case FAILED: {
                tgt.setValue((Object)Enumerations.EventStatus.NOTDONE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.EventStatus.NULL);
            }
        }
        return tgt;
    }
}

