/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Substance;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Substance;

public class Substance10_40 {
    public static org.hl7.fhir.r4.model.Substance convertSubstance(Substance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Substance tgt = new org.hl7.fhir.r4.model.Substance();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(t));
        }
        for (Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_10_40.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_40.convertString(src.getDescriptionElement()));
        }
        for (Identifier t : src.getInstance()) {
            tgt.addInstance(Substance10_40.convertSubstanceInstanceComponent((Substance.SubstanceInstanceComponent)t));
        }
        for (Identifier t : src.getIngredient()) {
            tgt.addIngredient(Substance10_40.convertSubstanceIngredientComponent((Substance.SubstanceIngredientComponent)t));
        }
        return tgt;
    }

    public static Substance convertSubstance(org.hl7.fhir.r4.model.Substance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance tgt = new Substance();
        VersionConvertor_10_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_40.convertString(src.getDescriptionElement()));
        }
        for (Substance.SubstanceInstanceComponent substanceInstanceComponent : src.getInstance()) {
            tgt.addInstance(Substance10_40.convertSubstanceInstanceComponent(substanceInstanceComponent));
        }
        for (Substance.SubstanceIngredientComponent substanceIngredientComponent : src.getIngredient()) {
            tgt.addIngredient(Substance10_40.convertSubstanceIngredientComponent(substanceIngredientComponent));
        }
        return tgt;
    }

    public static Substance.SubstanceIngredientComponent convertSubstanceIngredientComponent(Substance.SubstanceIngredientComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance.SubstanceIngredientComponent tgt = new Substance.SubstanceIngredientComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_40.convertRatio(src.getQuantity()));
        }
        return tgt;
    }

    public static Substance.SubstanceIngredientComponent convertSubstanceIngredientComponent(Substance.SubstanceIngredientComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance.SubstanceIngredientComponent tgt = new Substance.SubstanceIngredientComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_40.convertRatio(src.getQuantity()));
        }
        if (src.hasSubstance()) {
            tgt.setSubstance(VersionConvertor_10_40.convertReference(src.getSubstance()));
        }
        return tgt;
    }

    public static Substance.SubstanceInstanceComponent convertSubstanceInstanceComponent(Substance.SubstanceInstanceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance.SubstanceInstanceComponent tgt = new Substance.SubstanceInstanceComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasExpiryElement()) {
            tgt.setExpiryElement(VersionConvertor_10_40.convertDateTime(src.getExpiryElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_40.convertSimpleQuantity(src.getQuantity()));
        }
        return tgt;
    }

    public static Substance.SubstanceInstanceComponent convertSubstanceInstanceComponent(Substance.SubstanceInstanceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance.SubstanceInstanceComponent tgt = new Substance.SubstanceInstanceComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasExpiryElement()) {
            tgt.setExpiryElement(VersionConvertor_10_40.convertDateTime(src.getExpiryElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_10_40.convertSimpleQuantity(src.getQuantity()));
        }
        return tgt;
    }
}

