/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Schedule;
import org.hl7.fhir.exceptions.FHIRException;

public class Schedule10_40 {
    public static org.hl7.fhir.r4.model.Schedule convertSchedule(Schedule src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Schedule tgt = new org.hl7.fhir.r4.model.Schedule();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(t));
        }
        for (Identifier t : src.getType()) {
            tgt.addServiceType(VersionConvertor_10_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasActor()) {
            tgt.addActor(VersionConvertor_10_40.convertReference(src.getActor()));
        }
        if (src.hasPlanningHorizon()) {
            tgt.setPlanningHorizon(VersionConvertor_10_40.convertPeriod(src.getPlanningHorizon()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_40.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static Schedule convertSchedule(org.hl7.fhir.r4.model.Schedule src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Schedule tgt = new Schedule();
        VersionConvertor_10_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addType(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_10_40.convertReference(src.getActorFirstRep()));
        }
        if (src.hasPlanningHorizon()) {
            tgt.setPlanningHorizon(VersionConvertor_10_40.convertPeriod(src.getPlanningHorizon()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_40.convertString(src.getCommentElement()));
        }
        return tgt;
    }
}

