/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.RiskAssessment;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RiskAssessment;

public class RiskAssessment10_40 {
    public static org.hl7.fhir.dstu2.model.RiskAssessment convertRiskAssessment(RiskAssessment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.RiskAssessment tgt = new org.hl7.fhir.dstu2.model.RiskAssessment();
        VersionConvertor_10_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_40.convertReference(src.getSubject()));
        }
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_10_40.convertReference(src.getCondition()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_40.convertReference(src.getEncounter()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_10_40.convertReference(src.getPerformer()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_40.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_40.convertCodeableConcept(src.getMethod()));
        }
        for (Reference reference : src.getBasis()) {
            tgt.addBasis(VersionConvertor_10_40.convertReference(reference));
        }
        for (RiskAssessment.RiskAssessmentPredictionComponent riskAssessmentPredictionComponent : src.getPrediction()) {
            tgt.addPrediction(RiskAssessment10_40.convertRiskAssessmentPredictionComponent(riskAssessmentPredictionComponent));
        }
        if (src.hasMitigationElement()) {
            tgt.setMitigationElement(VersionConvertor_10_40.convertString(src.getMitigationElement()));
        }
        return tgt;
    }

    public static RiskAssessment convertRiskAssessment(org.hl7.fhir.dstu2.model.RiskAssessment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        RiskAssessment tgt = new RiskAssessment();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_40.convertReference(src.getSubject()));
        }
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_10_40.convertReference(src.getCondition()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_40.convertReference(src.getEncounter()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_10_40.convertReference(src.getPerformer()));
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_40.convertCodeableConcept(src.getMethod()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getBasis()) {
            tgt.addBasis(VersionConvertor_10_40.convertReference(t));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getPrediction()) {
            tgt.addPrediction(RiskAssessment10_40.convertRiskAssessmentPredictionComponent((RiskAssessment.RiskAssessmentPredictionComponent)t));
        }
        if (src.hasMitigationElement()) {
            tgt.setMitigationElement(VersionConvertor_10_40.convertString(src.getMitigationElement()));
        }
        return tgt;
    }

    public static RiskAssessment.RiskAssessmentPredictionComponent convertRiskAssessmentPredictionComponent(RiskAssessment.RiskAssessmentPredictionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        RiskAssessment.RiskAssessmentPredictionComponent tgt = new RiskAssessment.RiskAssessmentPredictionComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_10_40.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasProbability()) {
            tgt.setProbability(VersionConvertor_10_40.convertType(src.getProbability()));
        }
        if (src.hasRelativeRiskElement()) {
            tgt.setRelativeRiskElement(VersionConvertor_10_40.convertDecimal(src.getRelativeRiskElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhen(VersionConvertor_10_40.convertType(src.getWhen()));
        }
        if (src.hasRationaleElement()) {
            tgt.setRationaleElement(VersionConvertor_10_40.convertString(src.getRationaleElement()));
        }
        return tgt;
    }

    public static RiskAssessment.RiskAssessmentPredictionComponent convertRiskAssessmentPredictionComponent(RiskAssessment.RiskAssessmentPredictionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        RiskAssessment.RiskAssessmentPredictionComponent tgt = new RiskAssessment.RiskAssessmentPredictionComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_10_40.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasProbability()) {
            tgt.setProbability(VersionConvertor_10_40.convertType(src.getProbability()));
        }
        if (src.hasRelativeRiskElement()) {
            tgt.setRelativeRiskElement(VersionConvertor_10_40.convertDecimal(src.getRelativeRiskElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhen(VersionConvertor_10_40.convertType(src.getWhen()));
        }
        if (src.hasRationaleElement()) {
            tgt.setRationaleElement(VersionConvertor_10_40.convertString(src.getRationaleElement()));
        }
        return tgt;
    }
}

