/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.Annotation;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Procedure;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Procedure;

public class Procedure10_40 {
    public static org.hl7.fhir.r4.model.Procedure convertProcedure(Procedure src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Procedure tgt = new org.hl7.fhir.r4.model.Procedure();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(t));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_40.convertReference(src.getSubject()));
        }
        if (src.hasStatus() && src.hasNotPerformed()) {
            if (src.getNotPerformed()) {
                tgt.setStatus(Procedure.ProcedureStatus.NOTDONE);
            } else {
                tgt.setStatus(Procedure10_40.convertProcedureStatus(src.getStatus()));
            }
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_10_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasReasonNotPerformed()) {
            tgt.setStatusReason(VersionConvertor_10_40.convertCodeableConcept((CodeableConcept)src.getReasonNotPerformed().get(0)));
        }
        for (Identifier t : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_10_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasReasonCodeableConcept()) {
            tgt.addReasonCode(VersionConvertor_10_40.convertCodeableConcept(src.getReasonCodeableConcept()));
        }
        if (src.hasReasonReference()) {
            tgt.addReasonReference(VersionConvertor_10_40.convertReference(src.getReasonReference()));
        }
        if (src.hasPerformed()) {
            tgt.setPerformed(VersionConvertor_10_40.convertType(src.getPerformed()));
        }
        for (Identifier t : src.getPerformer()) {
            tgt.addPerformer(Procedure10_40.convertProcedurePerformerComponent((Procedure.ProcedurePerformerComponent)t));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_40.convertReference(src.getEncounter()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_40.convertReference(src.getLocation()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_10_40.convertCodeableConcept(src.getOutcome()));
        }
        for (Identifier t : src.getReport()) {
            tgt.addReport(VersionConvertor_10_40.convertReference((Reference)t));
        }
        for (Identifier t : src.getComplication()) {
            tgt.addComplication(VersionConvertor_10_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (Identifier t : src.getFollowUp()) {
            tgt.addFollowUp(VersionConvertor_10_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasRequest()) {
            tgt.addBasedOn(VersionConvertor_10_40.convertReference(src.getRequest()));
        }
        for (Identifier t : src.getFocalDevice()) {
            tgt.addFocalDevice(Procedure10_40.convertProcedureFocalDeviceComponent((Procedure.ProcedureFocalDeviceComponent)t));
        }
        for (Annotation note : src.getNotes()) {
            tgt.addNote(VersionConvertor_10_40.convertAnnotation(note));
        }
        for (Reference r : src.getUsed()) {
            tgt.addUsedReference(VersionConvertor_10_40.convertReference(r));
        }
        return tgt;
    }

    private static Procedure.ProcedureStatus convertProcedureStatus(Procedure.ProcedureStatus src) {
        switch (src) {
            case ENTEREDINERROR: {
                return Procedure.ProcedureStatus.ENTEREDINERROR;
            }
            case INPROGRESS: {
                return Procedure.ProcedureStatus.INPROGRESS;
            }
            case ABORTED: {
                return Procedure.ProcedureStatus.STOPPED;
            }
            case COMPLETED: {
                return Procedure.ProcedureStatus.COMPLETED;
            }
        }
        return Procedure.ProcedureStatus.NULL;
    }

    public static Procedure.ProcedurePerformerComponent convertProcedurePerformerComponent(Procedure.ProcedurePerformerComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Procedure.ProcedurePerformerComponent tgt = new Procedure.ProcedurePerformerComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_10_40.convertReference(src.getActor()));
        }
        if (src.hasRole()) {
            tgt.setFunction(VersionConvertor_10_40.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static Procedure.ProcedureFocalDeviceComponent convertProcedureFocalDeviceComponent(Procedure.ProcedureFocalDeviceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Procedure.ProcedureFocalDeviceComponent tgt = new Procedure.ProcedureFocalDeviceComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasAction()) {
            tgt.setAction(VersionConvertor_10_40.convertCodeableConcept(src.getAction()));
        }
        if (src.hasManipulated()) {
            tgt.setManipulated(VersionConvertor_10_40.convertReference(src.getManipulated()));
        }
        return tgt;
    }
}

