/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Location;

public class Location10_40 {
    public static org.hl7.fhir.dstu2.model.Location convertLocation(Location src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Location tgt = new org.hl7.fhir.dstu2.model.Location();
        VersionConvertor_10_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Location10_40.convertLocationStatus(src.getStatusElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(Location10_40.convertLocationMode(src.getModeElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_40.convertCodeableConcept(src.getTypeFirstRep()));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint(contactPoint));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_10_40.convertAddress(src.getAddress()));
        }
        if (src.hasPhysicalType()) {
            tgt.setPhysicalType(VersionConvertor_10_40.convertCodeableConcept(src.getPhysicalType()));
        }
        if (src.hasPosition()) {
            tgt.setPosition(Location10_40.convertLocationPositionComponent(src.getPosition()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_10_40.convertReference(src.getManagingOrganization()));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_10_40.convertReference(src.getPartOf()));
        }
        return tgt;
    }

    public static Location convertLocation(org.hl7.fhir.dstu2.model.Location src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Location tgt = new Location();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Location10_40.convertLocationStatus((org.hl7.fhir.dstu2.model.Enumeration<Location.LocationStatus>)src.getStatusElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_40.convertString(src.getNameElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(Location10_40.convertLocationMode((org.hl7.fhir.dstu2.model.Enumeration<Location.LocationMode>)src.getModeElement()));
        }
        if (src.hasType()) {
            tgt.addType(VersionConvertor_10_40.convertCodeableConcept(src.getType()));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_40.convertContactPoint((org.hl7.fhir.dstu2.model.ContactPoint)t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_10_40.convertAddress(src.getAddress()));
        }
        if (src.hasPhysicalType()) {
            tgt.setPhysicalType(VersionConvertor_10_40.convertCodeableConcept(src.getPhysicalType()));
        }
        if (src.hasPosition()) {
            tgt.setPosition(Location10_40.convertLocationPositionComponent(src.getPosition()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_10_40.convertReference(src.getManagingOrganization()));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_10_40.convertReference(src.getPartOf()));
        }
        return tgt;
    }

    public static Enumeration<Location.LocationMode> convertLocationMode(org.hl7.fhir.dstu2.model.Enumeration<Location.LocationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Location.LocationMode> tgt = new Enumeration<Location.LocationMode>(new Location.LocationModeEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((Location.LocationMode)src.getValue()) {
            case INSTANCE: {
                tgt.setValue((Object)Location.LocationMode.INSTANCE);
                break;
            }
            case KIND: {
                tgt.setValue((Object)Location.LocationMode.KIND);
                break;
            }
            default: {
                tgt.setValue((Object)Location.LocationMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Location.LocationMode> convertLocationMode(Enumeration<Location.LocationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Location.LocationModeEnumFactory());
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        switch ((Location.LocationMode)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)Location.LocationMode.INSTANCE);
                break;
            }
            case KIND: {
                tgt.setValue((Object)Location.LocationMode.KIND);
                break;
            }
            default: {
                tgt.setValue((Object)Location.LocationMode.NULL);
            }
        }
        return tgt;
    }

    public static Location.LocationPositionComponent convertLocationPositionComponent(Location.LocationPositionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Location.LocationPositionComponent tgt = new Location.LocationPositionComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasLongitudeElement()) {
            tgt.setLongitudeElement(VersionConvertor_10_40.convertDecimal(src.getLongitudeElement()));
        }
        if (src.hasLatitudeElement()) {
            tgt.setLatitudeElement(VersionConvertor_10_40.convertDecimal(src.getLatitudeElement()));
        }
        if (src.hasAltitudeElement()) {
            tgt.setAltitudeElement(VersionConvertor_10_40.convertDecimal(src.getAltitudeElement()));
        }
        return tgt;
    }

    public static Location.LocationPositionComponent convertLocationPositionComponent(Location.LocationPositionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Location.LocationPositionComponent tgt = new Location.LocationPositionComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasLongitudeElement()) {
            tgt.setLongitudeElement(VersionConvertor_10_40.convertDecimal(src.getLongitudeElement()));
        }
        if (src.hasLatitudeElement()) {
            tgt.setLatitudeElement(VersionConvertor_10_40.convertDecimal(src.getLatitudeElement()));
        }
        if (src.hasAltitudeElement()) {
            tgt.setAltitudeElement(VersionConvertor_10_40.convertDecimal(src.getAltitudeElement()));
        }
        return tgt;
    }

    public static Enumeration<Location.LocationStatus> convertLocationStatus(org.hl7.fhir.dstu2.model.Enumeration<Location.LocationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Location.LocationStatus> tgt = new Enumeration<Location.LocationStatus>(new Location.LocationStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((Location.LocationStatus)src.getValue()) {
            case ACTIVE: {
                tgt.setValue((Object)Location.LocationStatus.ACTIVE);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)Location.LocationStatus.SUSPENDED);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Location.LocationStatus.INACTIVE);
                break;
            }
            default: {
                tgt.setValue((Object)Location.LocationStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<Location.LocationStatus> convertLocationStatus(Enumeration<Location.LocationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new Location.LocationStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        switch ((Location.LocationStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Location.LocationStatus.ACTIVE);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)Location.LocationStatus.SUSPENDED);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Location.LocationStatus.INACTIVE);
                break;
            }
            default: {
                tgt.setValue((Object)Location.LocationStatus.NULL);
            }
        }
        return tgt;
    }
}

