/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.EpisodeOfCare;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.EpisodeOfCare;
import org.hl7.fhir.r4.model.Reference;

public class EpisodeOfCare10_40 {
    public static org.hl7.fhir.dstu2.model.EpisodeOfCare convertEpisodeOfCare(EpisodeOfCare src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.EpisodeOfCare tgt = new org.hl7.fhir.dstu2.model.EpisodeOfCare();
        VersionConvertor_10_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(EpisodeOfCare10_40.convertEpisodeOfCareStatus(src.getStatusElement()));
        }
        for (EpisodeOfCare.EpisodeOfCareStatusHistoryComponent episodeOfCareStatusHistoryComponent : src.getStatusHistory()) {
            tgt.addStatusHistory(EpisodeOfCare10_40.convertEpisodeOfCareStatusHistoryComponent(episodeOfCareStatusHistoryComponent));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_40.convertReference(src.getPatient()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_10_40.convertReference(src.getManagingOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_40.convertPeriod(src.getPeriod()));
        }
        for (Reference reference : src.getReferralRequest()) {
            tgt.addReferralRequest(VersionConvertor_10_40.convertReference(reference));
        }
        if (src.hasCareManager()) {
            tgt.setCareManager(VersionConvertor_10_40.convertReference(src.getCareManager()));
        }
        return tgt;
    }

    public static EpisodeOfCare convertEpisodeOfCare(org.hl7.fhir.dstu2.model.EpisodeOfCare src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        EpisodeOfCare tgt = new EpisodeOfCare();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(EpisodeOfCare10_40.convertEpisodeOfCareStatus((org.hl7.fhir.dstu2.model.Enumeration<EpisodeOfCare.EpisodeOfCareStatus>)src.getStatusElement()));
        }
        for (Identifier t : src.getStatusHistory()) {
            tgt.addStatusHistory(EpisodeOfCare10_40.convertEpisodeOfCareStatusHistoryComponent((EpisodeOfCare.EpisodeOfCareStatusHistoryComponent)t));
        }
        for (Identifier t : src.getType()) {
            tgt.addType(VersionConvertor_10_40.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_40.convertReference(src.getPatient()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_10_40.convertReference(src.getManagingOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_40.convertPeriod(src.getPeriod()));
        }
        for (Identifier t : src.getReferralRequest()) {
            tgt.addReferralRequest(VersionConvertor_10_40.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        if (src.hasCareManager()) {
            tgt.setCareManager(VersionConvertor_10_40.convertReference(src.getCareManager()));
        }
        return tgt;
    }

    public static Enumeration<EpisodeOfCare.EpisodeOfCareStatus> convertEpisodeOfCareStatus(org.hl7.fhir.dstu2.model.Enumeration<EpisodeOfCare.EpisodeOfCareStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<EpisodeOfCare.EpisodeOfCareStatus> tgt = new Enumeration<EpisodeOfCare.EpisodeOfCareStatus>(new EpisodeOfCare.EpisodeOfCareStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, tgt);
        switch ((EpisodeOfCare.EpisodeOfCareStatus)src.getValue()) {
            case PLANNED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.PLANNED);
                break;
            }
            case WAITLIST: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.WAITLIST);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ONHOLD);
                break;
            }
            case FINISHED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.FINISHED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.CANCELLED);
                break;
            }
            default: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Enumeration<EpisodeOfCare.EpisodeOfCareStatus> convertEpisodeOfCareStatus(Enumeration<EpisodeOfCare.EpisodeOfCareStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Enumeration tgt = new org.hl7.fhir.dstu2.model.Enumeration((EnumFactory)new EpisodeOfCare.EpisodeOfCareStatusEnumFactory());
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        switch ((EpisodeOfCare.EpisodeOfCareStatus)((Object)src.getValue())) {
            case PLANNED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.PLANNED);
                break;
            }
            case WAITLIST: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.WAITLIST);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.ONHOLD);
                break;
            }
            case FINISHED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.FINISHED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.CANCELLED);
                break;
            }
            default: {
                tgt.setValue((Object)EpisodeOfCare.EpisodeOfCareStatus.NULL);
            }
        }
        return tgt;
    }

    public static EpisodeOfCare.EpisodeOfCareStatusHistoryComponent convertEpisodeOfCareStatusHistoryComponent(EpisodeOfCare.EpisodeOfCareStatusHistoryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent tgt = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        if (src.hasStatus()) {
            tgt.setStatusElement(EpisodeOfCare10_40.convertEpisodeOfCareStatus((org.hl7.fhir.dstu2.model.Enumeration<EpisodeOfCare.EpisodeOfCareStatus>)src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static EpisodeOfCare.EpisodeOfCareStatusHistoryComponent convertEpisodeOfCareStatusHistoryComponent(EpisodeOfCare.EpisodeOfCareStatusHistoryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent tgt = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        VersionConvertor_10_40.copyElement(src, (Element)tgt);
        if (src.hasStatus()) {
            tgt.setStatusElement(EpisodeOfCare10_40.convertEpisodeOfCareStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }
}

