/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.DeviceUseStatement;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.CodeableConcept;

public class DeviceUseStatement10_40 {
    public static DeviceUseStatement convertDeviceUseStatement(org.hl7.fhir.r4.model.DeviceUseStatement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DeviceUseStatement tgt = new DeviceUseStatement();
        VersionConvertor_10_40.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_10_40.convertType(src.getBodySite()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_10_40.convertReference(src.getDevice()));
        }
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(identifier));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addIndication(VersionConvertor_10_40.convertCodeableConcept(codeableConcept));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNotes(annotation.getText());
        }
        if (src.hasRecordedOnElement()) {
            tgt.setRecordedOnElement(VersionConvertor_10_40.convertDateTime(src.getRecordedOnElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_40.convertReference(src.getSubject()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_10_40.convertType(src.getTiming()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.DeviceUseStatement convertDeviceUseStatement(DeviceUseStatement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.DeviceUseStatement tgt = new org.hl7.fhir.r4.model.DeviceUseStatement();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasBodySiteCodeableConcept()) {
            tgt.setBodySite(VersionConvertor_10_40.convertCodeableConcept(src.getBodySiteCodeableConcept()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_10_40.convertReference(src.getDevice()));
        }
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(t));
        }
        for (Identifier t : src.getIndication()) {
            tgt.addReasonCode(VersionConvertor_10_40.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)t));
        }
        for (Identifier t : src.getNotes()) {
            tgt.addNote().setText((String)t.getValue());
        }
        if (src.hasRecordedOnElement()) {
            tgt.setRecordedOnElement(VersionConvertor_10_40.convertDateTime(src.getRecordedOnElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_40.convertReference(src.getSubject()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_10_40.convertType(src.getTiming()));
        }
        return tgt;
    }
}

