/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_40;

import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.dstu2.model.AllergyIntolerance;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.StringType;

public class AllergyIntolerance10_40 {
    public static org.hl7.fhir.r4.model.AllergyIntolerance convertAllergyIntolerance(AllergyIntolerance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.AllergyIntolerance tgt = new org.hl7.fhir.r4.model.AllergyIntolerance();
        VersionConvertor_10_40.copyDomainResource((DomainResource)src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_40.convertIdentifier(t));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_10_40.convertType((Type)src.getOnsetElement()));
        }
        if (src.hasRecordedDate()) {
            tgt.setRecordedDateElement(VersionConvertor_10_40.convertDateTime(src.getRecordedDateElement()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(VersionConvertor_10_40.convertReference(src.getRecorder()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_40.convertReference(src.getPatient()));
        }
        if (src.hasReporter()) {
            tgt.setAsserter(VersionConvertor_10_40.convertReference(src.getReporter()));
        }
        if (src.hasSubstance()) {
            tgt.setCode(VersionConvertor_10_40.convertCodeableConcept(src.getSubstance()));
        }
        if (src.hasStatus()) {
            Coding code;
            if (src.getStatus() != AllergyIntolerance.AllergyIntoleranceStatus.REFUTED && src.getStatus() != AllergyIntolerance.AllergyIntoleranceStatus.ENTEREDINERROR) {
                code = new Coding();
                code.setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical");
                code.setCode(src.getStatus().toCode());
                tgt.setClinicalStatus(new org.hl7.fhir.r4.model.CodeableConcept(code));
            }
            if (src.getStatus() != AllergyIntolerance.AllergyIntoleranceStatus.ACTIVE && src.getStatus() != AllergyIntolerance.AllergyIntoleranceStatus.RESOLVED) {
                code = new Coding();
                code.setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification");
                code.setCode(src.getStatus().toCode());
                tgt.setVerificationStatus(new org.hl7.fhir.r4.model.CodeableConcept(code));
            }
        }
        if (src.hasCriticality()) {
            tgt.setCriticality(AllergyIntolerance10_40.translateAllergyIntoleranceCriticality(src.getCriticality()));
        }
        if (src.hasType()) {
            tgt.setType(AllergyIntolerance.AllergyIntoleranceType.fromCode(src.getType().toCode()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(AllergyIntolerance.AllergyIntoleranceCategory.fromCode(src.getCategory().toCode()));
        }
        if (src.hasLastOccurenceElement()) {
            tgt.setLastOccurrenceElement(VersionConvertor_10_40.convertDateTime(src.getLastOccurenceElement()));
        }
        if (src.hasNote()) {
            tgt.addNote(VersionConvertor_10_40.convertAnnotation(src.getNote()));
        }
        for (AllergyIntolerance.AllergyIntoleranceReactionComponent reaction : src.getReaction()) {
            tgt.addReaction(AllergyIntolerance10_40.algReaction(reaction));
        }
        return tgt;
    }

    private static AllergyIntolerance.AllergyIntoleranceReactionComponent algReaction(AllergyIntolerance.AllergyIntoleranceReactionComponent src) {
        if (src == null) {
            return null;
        }
        AllergyIntolerance.AllergyIntoleranceReactionComponent tgt = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        VersionConvertor_10_40.copyElement((Element)src, tgt);
        for (org.hl7.fhir.dstu2.model.Extension extension : src.getModifierExtension()) {
            tgt.addExtension(VersionConvertor_10_40.convertExtension(extension));
        }
        if (src.hasSubstance()) {
            tgt.setSubstance(VersionConvertor_10_40.convertCodeableConcept(src.getSubstance()));
        }
        if (src.hasCertainty()) {
            tgt.addExtension(new Extension("http://hl7.org/fhir/AllergyIntolerance-r2-certainty", new StringType(src.getCertainty().toCode())));
        }
        for (CodeableConcept concept : src.getManifestation()) {
            tgt.addManifestation(VersionConvertor_10_40.convertCodeableConcept(concept));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_10_40.convertString(src.getDescriptionElement()));
        }
        if (src.hasOnset()) {
            tgt.setOnsetElement(VersionConvertor_10_40.convertDateTime(src.getOnsetElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(AllergyIntolerance.AllergyIntoleranceSeverity.fromCode(src.getSeverity().toCode()));
        }
        if (src.hasExposureRoute()) {
            tgt.setExposureRoute(VersionConvertor_10_40.convertCodeableConcept(src.getExposureRoute()));
        }
        if (src.hasNote()) {
            tgt.addNote(VersionConvertor_10_40.convertAnnotation(src.getNote()));
        }
        return tgt;
    }

    public static AllergyIntolerance.AllergyIntoleranceCriticality translateAllergyIntoleranceCriticality(AllergyIntolerance.AllergyIntoleranceCriticality src) {
        switch (src) {
            case CRITL: {
                return AllergyIntolerance.AllergyIntoleranceCriticality.LOW;
            }
            case CRITH: {
                return AllergyIntolerance.AllergyIntoleranceCriticality.HIGH;
            }
            case CRITU: {
                return AllergyIntolerance.AllergyIntoleranceCriticality.UNABLETOASSESS;
            }
        }
        return AllergyIntolerance.AllergyIntoleranceCriticality.NULL;
    }
}

