/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.TestScript;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.TestScript;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;

public class TestScript10_30 {
    public static Enumeration<TestScript.AssertionDirectionType> convertAssertionDirectionType(org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionDirectionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new TestScript.AssertionDirectionTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((TestScript.AssertionDirectionType)((Object)src.getValue())) {
            case RESPONSE: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.RESPONSE);
                break;
            }
            case REQUEST: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.REQUEST);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionDirectionType> convertAssertionDirectionType(Enumeration<TestScript.AssertionDirectionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionDirectionType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionDirectionType>(new TestScript.AssertionDirectionTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((TestScript.AssertionDirectionType)src.getValue()) {
            case RESPONSE: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.RESPONSE);
                break;
            }
            case REQUEST: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.REQUEST);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionOperatorType> convertAssertionOperatorType(Enumeration<TestScript.AssertionOperatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionOperatorType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionOperatorType>(new TestScript.AssertionOperatorTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((TestScript.AssertionOperatorType)src.getValue()) {
            case EQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EQUALS);
                break;
            }
            case NOTEQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEQUALS);
                break;
            }
            case IN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTIN);
                break;
            }
            case GREATERTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.GREATERTHAN);
                break;
            }
            case LESSTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.LESSTHAN);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EMPTY);
                break;
            }
            case NOTEMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEMPTY);
                break;
            }
            case CONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.CONTAINS);
                break;
            }
            case NOTCONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTCONTAINS);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionOperatorType> convertAssertionOperatorType(org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionOperatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new TestScript.AssertionOperatorTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((TestScript.AssertionOperatorType)((Object)src.getValue())) {
            case EQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EQUALS);
                break;
            }
            case NOTEQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEQUALS);
                break;
            }
            case IN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTIN);
                break;
            }
            case GREATERTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.GREATERTHAN);
                break;
            }
            case LESSTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.LESSTHAN);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EMPTY);
                break;
            }
            case NOTEMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEMPTY);
                break;
            }
            case CONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.CONTAINS);
                break;
            }
            case NOTCONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTCONTAINS);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionResponseTypes> convertAssertionResponseTypes(org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionResponseTypes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new TestScript.AssertionResponseTypesEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((TestScript.AssertionResponseTypes)((Object)src.getValue())) {
            case OKAY: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.OKAY);
                break;
            }
            case CREATED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CREATED);
                break;
            }
            case NOCONTENT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOCONTENT);
                break;
            }
            case NOTMODIFIED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTMODIFIED);
                break;
            }
            case BAD: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.BAD);
                break;
            }
            case FORBIDDEN: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.FORBIDDEN);
                break;
            }
            case NOTFOUND: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTFOUND);
                break;
            }
            case METHODNOTALLOWED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.METHODNOTALLOWED);
                break;
            }
            case CONFLICT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CONFLICT);
                break;
            }
            case GONE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.GONE);
                break;
            }
            case PRECONDITIONFAILED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.PRECONDITIONFAILED);
                break;
            }
            case UNPROCESSABLE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.UNPROCESSABLE);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionResponseTypes> convertAssertionResponseTypes(Enumeration<TestScript.AssertionResponseTypes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionResponseTypes> tgt = new org.hl7.fhir.dstu3.model.Enumeration<TestScript.AssertionResponseTypes>(new TestScript.AssertionResponseTypesEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((TestScript.AssertionResponseTypes)src.getValue()) {
            case OKAY: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.OKAY);
                break;
            }
            case CREATED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CREATED);
                break;
            }
            case NOCONTENT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOCONTENT);
                break;
            }
            case NOTMODIFIED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTMODIFIED);
                break;
            }
            case BAD: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.BAD);
                break;
            }
            case FORBIDDEN: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.FORBIDDEN);
                break;
            }
            case NOTFOUND: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTFOUND);
                break;
            }
            case METHODNOTALLOWED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.METHODNOTALLOWED);
                break;
            }
            case CONFLICT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CONFLICT);
                break;
            }
            case GONE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.GONE);
                break;
            }
            case PRECONDITIONFAILED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.PRECONDITIONFAILED);
                break;
            }
            case UNPROCESSABLE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.UNPROCESSABLE);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.ContentType> convertContentType(org.hl7.fhir.dstu3.model.Enumeration<TestScript.ContentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new TestScript.ContentTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((TestScript.ContentType)((Object)src.getValue())) {
            case XML: {
                tgt.setValue((Object)TestScript.ContentType.XML);
                break;
            }
            case JSON: {
                tgt.setValue((Object)TestScript.ContentType.JSON);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.ContentType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<TestScript.ContentType> convertContentType(Enumeration<TestScript.ContentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<TestScript.ContentType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<TestScript.ContentType>(new TestScript.ContentTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((TestScript.ContentType)src.getValue()) {
            case XML: {
                tgt.setValue((Object)TestScript.ContentType.XML);
                break;
            }
            case JSON: {
                tgt.setValue((Object)TestScript.ContentType.JSON);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.ContentType.NULL);
            }
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertComponent convertSetupActionAssertComponent(TestScript.TestScriptSetupActionAssertComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertComponent tgt = new TestScript.SetupActionAssertComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasLabelElement()) {
            tgt.setLabelElement(VersionConvertor_10_30.convertString(src.getLabelElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasDirection()) {
            tgt.setDirectionElement(TestScript10_30.convertAssertionDirectionType((Enumeration<TestScript.AssertionDirectionType>)src.getDirectionElement()));
        }
        if (src.hasCompareToSourceIdElement()) {
            tgt.setCompareToSourceIdElement(VersionConvertor_10_30.convertString(src.getCompareToSourceIdElement()));
        }
        if (src.hasCompareToSourcePathElement()) {
            tgt.setCompareToSourcePathElement(VersionConvertor_10_30.convertString(src.getCompareToSourcePathElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentTypeElement(TestScript10_30.convertContentType((Enumeration<TestScript.ContentType>)src.getContentTypeElement()));
        }
        if (src.hasHeaderFieldElement()) {
            tgt.setHeaderFieldElement(VersionConvertor_10_30.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasMinimumIdElement()) {
            tgt.setMinimumIdElement(VersionConvertor_10_30.convertString(src.getMinimumIdElement()));
        }
        if (src.hasNavigationLinksElement()) {
            tgt.setNavigationLinksElement(VersionConvertor_10_30.convertBoolean(src.getNavigationLinksElement()));
        }
        if (src.hasOperator()) {
            tgt.setOperatorElement(TestScript10_30.convertAssertionOperatorType((Enumeration<TestScript.AssertionOperatorType>)src.getOperatorElement()));
        }
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_30.convertString(src.getPathElement()));
        }
        if (src.hasResourceElement()) {
            tgt.setResourceElement(VersionConvertor_10_30.convertCode(src.getResourceElement()));
        }
        if (src.hasResponse()) {
            tgt.setResponseElement(TestScript10_30.convertAssertionResponseTypes((Enumeration<TestScript.AssertionResponseTypes>)src.getResponseElement()));
        }
        if (src.hasResponseCodeElement()) {
            tgt.setResponseCodeElement(VersionConvertor_10_30.convertString(src.getResponseCodeElement()));
        }
        if (src.hasSourceIdElement()) {
            tgt.setSourceIdElement(VersionConvertor_10_30.convertId(src.getSourceIdElement()));
        }
        if (src.hasValidateProfileIdElement()) {
            tgt.setValidateProfileIdElement(VersionConvertor_10_30.convertId(src.getValidateProfileIdElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertString(src.getValueElement()));
        }
        if (src.hasWarningOnlyElement()) {
            tgt.setWarningOnlyElement(VersionConvertor_10_30.convertBoolean(src.getWarningOnlyElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupActionAssertComponent convertSetupActionAssertComponent(TestScript.SetupActionAssertComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupActionAssertComponent tgt = new TestScript.TestScriptSetupActionAssertComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasLabelElement()) {
            tgt.setLabelElement(VersionConvertor_10_30.convertString(src.getLabelElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasDirection()) {
            tgt.setDirectionElement(TestScript10_30.convertAssertionDirectionType(src.getDirectionElement()));
        }
        if (src.hasCompareToSourceIdElement()) {
            tgt.setCompareToSourceIdElement(VersionConvertor_10_30.convertString(src.getCompareToSourceIdElement()));
        }
        if (src.hasCompareToSourcePathElement()) {
            tgt.setCompareToSourcePathElement(VersionConvertor_10_30.convertString(src.getCompareToSourcePathElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentTypeElement(TestScript10_30.convertContentType(src.getContentTypeElement()));
        }
        if (src.hasHeaderFieldElement()) {
            tgt.setHeaderFieldElement(VersionConvertor_10_30.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasMinimumIdElement()) {
            tgt.setMinimumIdElement(VersionConvertor_10_30.convertString(src.getMinimumIdElement()));
        }
        if (src.hasNavigationLinksElement()) {
            tgt.setNavigationLinksElement(VersionConvertor_10_30.convertBoolean(src.getNavigationLinksElement()));
        }
        if (src.hasOperator()) {
            tgt.setOperatorElement(TestScript10_30.convertAssertionOperatorType(src.getOperatorElement()));
        }
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_30.convertString(src.getPathElement()));
        }
        if (src.hasResourceElement()) {
            tgt.setResourceElement(VersionConvertor_10_30.convertCode(src.getResourceElement()));
        }
        if (src.hasResponse()) {
            tgt.setResponseElement(TestScript10_30.convertAssertionResponseTypes(src.getResponseElement()));
        }
        if (src.hasResponseCodeElement()) {
            tgt.setResponseCodeElement(VersionConvertor_10_30.convertString(src.getResponseCodeElement()));
        }
        if (src.hasSourceIdElement()) {
            tgt.setSourceIdElement(VersionConvertor_10_30.convertId(src.getSourceIdElement()));
        }
        if (src.hasValidateProfileIdElement()) {
            tgt.setValidateProfileIdElement(VersionConvertor_10_30.convertId(src.getValidateProfileIdElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertString(src.getValueElement()));
        }
        if (src.hasWarningOnlyElement()) {
            tgt.setWarningOnlyElement(VersionConvertor_10_30.convertBoolean(src.getWarningOnlyElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionComponent convertSetupActionComponent(TestScript.TestScriptSetupActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionComponent tgt = new TestScript.SetupActionComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript10_30.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript10_30.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupActionComponent convertSetupActionComponent(TestScript.SetupActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupActionComponent tgt = new TestScript.TestScriptSetupActionComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript10_30.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript10_30.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupActionOperationComponent convertSetupActionOperationComponent(TestScript.SetupActionOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupActionOperationComponent tgt = new TestScript.TestScriptSetupActionOperationComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCoding(src.getType()));
        }
        if (src.hasResourceElement()) {
            tgt.setResourceElement(VersionConvertor_10_30.convertCode(src.getResourceElement()));
        }
        if (src.hasLabelElement()) {
            tgt.setLabelElement(VersionConvertor_10_30.convertString(src.getLabelElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasAccept()) {
            tgt.setAcceptElement(TestScript10_30.convertContentType(src.getAcceptElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentTypeElement(TestScript10_30.convertContentType(src.getContentTypeElement()));
        }
        if (src.hasDestinationElement()) {
            tgt.setDestinationElement(VersionConvertor_10_30.convertInteger(src.getDestinationElement()));
        }
        if (src.hasEncodeRequestUrlElement()) {
            tgt.setEncodeRequestUrlElement(VersionConvertor_10_30.convertBoolean(src.getEncodeRequestUrlElement()));
        }
        if (src.hasParamsElement()) {
            tgt.setParamsElement(VersionConvertor_10_30.convertString(src.getParamsElement()));
        }
        for (TestScript.SetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(TestScript10_30.convertSetupActionOperationRequestHeaderComponent(t));
        }
        if (src.hasResponseIdElement()) {
            tgt.setResponseIdElement(VersionConvertor_10_30.convertId(src.getResponseIdElement()));
        }
        if (src.hasSourceIdElement()) {
            tgt.setSourceIdElement(VersionConvertor_10_30.convertId(src.getSourceIdElement()));
        }
        if (src.hasTargetId()) {
            tgt.setTargetId(src.getTargetId());
        }
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertString(src.getUrlElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationComponent convertSetupActionOperationComponent(TestScript.TestScriptSetupActionOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionOperationComponent tgt = new TestScript.SetupActionOperationComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCoding(src.getType()));
        }
        if (src.hasResourceElement()) {
            tgt.setResourceElement(VersionConvertor_10_30.convertCode(src.getResourceElement()));
        }
        if (src.hasLabelElement()) {
            tgt.setLabelElement(VersionConvertor_10_30.convertString(src.getLabelElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasAccept()) {
            tgt.setAcceptElement(TestScript10_30.convertContentType((Enumeration<TestScript.ContentType>)src.getAcceptElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentTypeElement(TestScript10_30.convertContentType((Enumeration<TestScript.ContentType>)src.getContentTypeElement()));
        }
        if (src.hasDestinationElement()) {
            tgt.setDestinationElement(VersionConvertor_10_30.convertInteger(src.getDestinationElement()));
        }
        if (src.hasEncodeRequestUrlElement()) {
            tgt.setEncodeRequestUrlElement(VersionConvertor_10_30.convertBoolean(src.getEncodeRequestUrlElement()));
        }
        if (src.hasParamsElement()) {
            tgt.setParamsElement(VersionConvertor_10_30.convertString(src.getParamsElement()));
        }
        for (TestScript.TestScriptSetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(TestScript10_30.convertSetupActionOperationRequestHeaderComponent(t));
        }
        if (src.hasResponseIdElement()) {
            tgt.setResponseIdElement(VersionConvertor_10_30.convertId(src.getResponseIdElement()));
        }
        if (src.hasSourceIdElement()) {
            tgt.setSourceIdElement(VersionConvertor_10_30.convertId(src.getSourceIdElement()));
        }
        if (src.hasTargetId()) {
            tgt.setTargetId(src.getTargetId());
        }
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertString(src.getUrlElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.TestScriptSetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionOperationRequestHeaderComponent tgt = new TestScript.SetupActionOperationRequestHeaderComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasFieldElement()) {
            tgt.setFieldElement(VersionConvertor_10_30.convertString(src.getFieldElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.SetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupActionOperationRequestHeaderComponent tgt = new TestScript.TestScriptSetupActionOperationRequestHeaderComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasFieldElement()) {
            tgt.setFieldElement(VersionConvertor_10_30.convertString(src.getFieldElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptTeardownActionComponent convertTeardownActionComponent(TestScript.TeardownActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTeardownActionComponent tgt = new TestScript.TestScriptTeardownActionComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript10_30.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static TestScript.TeardownActionComponent convertTeardownActionComponent(TestScript.TestScriptTeardownActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TeardownActionComponent tgt = new TestScript.TeardownActionComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript10_30.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static TestScript.TestActionComponent convertTestActionComponent(TestScript.TestScriptTestActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestActionComponent tgt = new TestScript.TestActionComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript10_30.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript10_30.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.TestScriptTestActionComponent convertTestActionComponent(TestScript.TestActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTestActionComponent tgt = new TestScript.TestScriptTestActionComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript10_30.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript10_30.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.TestScript convertTestScript(TestScript src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.TestScript tgt = new org.hl7.fhir.dstu2.model.TestScript();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_30.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(TestScript10_30.convertTestScriptContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasMetadata()) {
            tgt.setMetadata(TestScript10_30.convertTestScriptMetadataComponent(src.getMetadata()));
        }
        for (TestScript.TestScriptFixtureComponent testScriptFixtureComponent : src.getFixture()) {
            tgt.addFixture(TestScript10_30.convertTestScriptFixtureComponent(testScriptFixtureComponent));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getProfile()) {
            tgt.addProfile(VersionConvertor_10_30.convertReference(reference));
        }
        for (TestScript.TestScriptVariableComponent testScriptVariableComponent : src.getVariable()) {
            tgt.addVariable(TestScript10_30.convertTestScriptVariableComponent(testScriptVariableComponent));
        }
        if (src.hasSetup()) {
            tgt.setSetup(TestScript10_30.convertTestScriptSetupComponent(src.getSetup()));
        }
        for (TestScript.TestScriptTestComponent testScriptTestComponent : src.getTest()) {
            tgt.addTest(TestScript10_30.convertTestScriptTestComponent(testScriptTestComponent));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(TestScript10_30.convertTestScriptTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static TestScript convertTestScript(org.hl7.fhir.dstu2.model.TestScript src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript tgt = new TestScript();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_10_30.convertConformanceResourceStatus((Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_30.convertString(src.getPublisherElement()));
        }
        for (TestScript.TestScriptContactComponent t : src.getContact()) {
            tgt.addContact(TestScript10_30.convertTestScriptContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (TestScript.TestScriptContactComponent t : src.getUseContext()) {
            if (VersionConvertor_10_30.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_10_30.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasMetadata()) {
            tgt.setMetadata(TestScript10_30.convertTestScriptMetadataComponent(src.getMetadata()));
        }
        for (TestScript.TestScriptContactComponent t : src.getFixture()) {
            tgt.addFixture(TestScript10_30.convertTestScriptFixtureComponent((TestScript.TestScriptFixtureComponent)t));
        }
        for (TestScript.TestScriptContactComponent t : src.getProfile()) {
            tgt.addProfile(VersionConvertor_10_30.convertReference((Reference)t));
        }
        for (TestScript.TestScriptContactComponent t : src.getVariable()) {
            tgt.addVariable(TestScript10_30.convertTestScriptVariableComponent((TestScript.TestScriptVariableComponent)t));
        }
        if (src.hasSetup()) {
            tgt.setSetup(TestScript10_30.convertTestScriptSetupComponent(src.getSetup()));
        }
        for (TestScript.TestScriptContactComponent t : src.getTest()) {
            tgt.addTest(TestScript10_30.convertTestScriptTestComponent((TestScript.TestScriptTestComponent)t));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(TestScript10_30.convertTestScriptTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static ContactDetail convertTestScriptContactComponent(TestScript.TestScriptContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptContactComponent convertTestScriptContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptContactComponent tgt = new TestScript.TestScriptContactComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptFixtureComponent convertTestScriptFixtureComponent(TestScript.TestScriptFixtureComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptFixtureComponent tgt = new TestScript.TestScriptFixtureComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasAutocreateElement()) {
            tgt.setAutocreateElement(VersionConvertor_10_30.convertBoolean(src.getAutocreateElement()));
        }
        if (src.hasAutodeleteElement()) {
            tgt.setAutodeleteElement(VersionConvertor_10_30.convertBoolean(src.getAutodeleteElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_10_30.convertReference(src.getResource()));
        }
        return tgt;
    }

    public static TestScript.TestScriptFixtureComponent convertTestScriptFixtureComponent(TestScript.TestScriptFixtureComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptFixtureComponent tgt = new TestScript.TestScriptFixtureComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasAutocreateElement()) {
            tgt.setAutocreateElement(VersionConvertor_10_30.convertBoolean(src.getAutocreateElement()));
        }
        if (src.hasAutodeleteElement()) {
            tgt.setAutodeleteElement(VersionConvertor_10_30.convertBoolean(src.getAutodeleteElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_10_30.convertReference(src.getResource()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataCapabilityComponent convertTestScriptMetadataCapabilityComponent(TestScript.TestScriptMetadataCapabilityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataCapabilityComponent tgt = new TestScript.TestScriptMetadataCapabilityComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasRequiredElement()) {
            tgt.setRequiredElement(VersionConvertor_10_30.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasValidatedElement()) {
            tgt.setValidatedElement(VersionConvertor_10_30.convertBoolean(src.getValidatedElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasDestinationElement()) {
            tgt.setDestinationElement(VersionConvertor_10_30.convertInteger(src.getDestinationElement()));
        }
        for (UriType t : src.getLink()) {
            tgt.addLink((String)t.getValue());
        }
        if (src.hasCapabilities()) {
            tgt.setConformance(VersionConvertor_10_30.convertReference(src.getCapabilities()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataCapabilityComponent convertTestScriptMetadataCapabilityComponent(TestScript.TestScriptMetadataCapabilityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataCapabilityComponent tgt = new TestScript.TestScriptMetadataCapabilityComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasRequiredElement()) {
            tgt.setRequiredElement(VersionConvertor_10_30.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasValidatedElement()) {
            tgt.setValidatedElement(VersionConvertor_10_30.convertBoolean(src.getValidatedElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasDestinationElement()) {
            tgt.setDestinationElement(VersionConvertor_10_30.convertInteger(src.getDestinationElement()));
        }
        for (org.hl7.fhir.dstu2.model.UriType t : src.getLink()) {
            tgt.addLink((String)t.getValue());
        }
        if (src.hasConformance()) {
            tgt.setCapabilities(VersionConvertor_10_30.convertReference(src.getConformance()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataComponent convertTestScriptMetadataComponent(TestScript.TestScriptMetadataComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataComponent tgt = new TestScript.TestScriptMetadataComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        for (TestScript.TestScriptMetadataLinkComponent t : src.getLink()) {
            tgt.addLink(TestScript10_30.convertTestScriptMetadataLinkComponent(t));
        }
        for (TestScript.TestScriptMetadataLinkComponent t : src.getCapability()) {
            tgt.addCapability(TestScript10_30.convertTestScriptMetadataCapabilityComponent((TestScript.TestScriptMetadataCapabilityComponent)t));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataComponent convertTestScriptMetadataComponent(TestScript.TestScriptMetadataComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataComponent tgt = new TestScript.TestScriptMetadataComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        for (TestScript.TestScriptMetadataLinkComponent testScriptMetadataLinkComponent : src.getLink()) {
            tgt.addLink(TestScript10_30.convertTestScriptMetadataLinkComponent(testScriptMetadataLinkComponent));
        }
        for (TestScript.TestScriptMetadataCapabilityComponent testScriptMetadataCapabilityComponent : src.getCapability()) {
            tgt.addCapability(TestScript10_30.convertTestScriptMetadataCapabilityComponent(testScriptMetadataCapabilityComponent));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataLinkComponent convertTestScriptMetadataLinkComponent(TestScript.TestScriptMetadataLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataLinkComponent tgt = new TestScript.TestScriptMetadataLinkComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataLinkComponent convertTestScriptMetadataLinkComponent(TestScript.TestScriptMetadataLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataLinkComponent tgt = new TestScript.TestScriptMetadataLinkComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupComponent convertTestScriptSetupComponent(TestScript.TestScriptSetupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupComponent tgt = new TestScript.TestScriptSetupComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        for (TestScript.TestScriptSetupActionComponent t : src.getAction()) {
            tgt.addAction(TestScript10_30.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupComponent convertTestScriptSetupComponent(TestScript.TestScriptSetupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupComponent tgt = new TestScript.TestScriptSetupComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        for (TestScript.SetupActionComponent t : src.getAction()) {
            tgt.addAction(TestScript10_30.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTeardownComponent convertTestScriptTeardownComponent(TestScript.TestScriptTeardownComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTeardownComponent tgt = new TestScript.TestScriptTeardownComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        for (TestScript.TestScriptTeardownActionComponent t : src.getAction()) {
            tgt.addAction(TestScript10_30.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTeardownComponent convertTestScriptTeardownComponent(TestScript.TestScriptTeardownComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTeardownComponent tgt = new TestScript.TestScriptTeardownComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        for (TestScript.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(TestScript10_30.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTestComponent convertTestScriptTestComponent(TestScript.TestScriptTestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTestComponent tgt = new TestScript.TestScriptTestComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (TestScript.TestScriptTestActionComponent t : src.getAction()) {
            tgt.addAction(TestScript10_30.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTestComponent convertTestScriptTestComponent(TestScript.TestScriptTestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTestComponent tgt = new TestScript.TestScriptTestComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (TestScript.TestActionComponent t : src.getAction()) {
            tgt.addAction(TestScript10_30.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptVariableComponent convertTestScriptVariableComponent(TestScript.TestScriptVariableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptVariableComponent tgt = new TestScript.TestScriptVariableComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasHeaderFieldElement()) {
            tgt.setHeaderFieldElement(VersionConvertor_10_30.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_30.convertString(src.getPathElement()));
        }
        if (src.hasSourceIdElement()) {
            tgt.setSourceIdElement(VersionConvertor_10_30.convertId(src.getSourceIdElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptVariableComponent convertTestScriptVariableComponent(TestScript.TestScriptVariableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptVariableComponent tgt = new TestScript.TestScriptVariableComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasHeaderFieldElement()) {
            tgt.setHeaderFieldElement(VersionConvertor_10_30.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_30.convertString(src.getPathElement()));
        }
        if (src.hasSourceIdElement()) {
            tgt.setSourceIdElement(VersionConvertor_10_30.convertId(src.getSourceIdElement()));
        }
        return tgt;
    }
}

