/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.exceptions.FHIRException;

public class Organization10_30 {
    public static org.hl7.fhir.dstu3.model.Organization convertOrganization(Organization src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Organization tgt = new org.hl7.fhir.dstu3.model.Organization();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(t));
        }
        if (src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_10_30.convertBoolean(src.getActiveElement()));
        }
        if (src.hasType()) {
            tgt.addType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint((ContactPoint)t));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_30.convertAddress((org.hl7.fhir.dstu2.model.Address)t));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_10_30.convertReference(src.getPartOf()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getContact()) {
            tgt.addContact(Organization10_30.convertOrganizationContactComponent((Organization.OrganizationContactComponent)t));
        }
        return tgt;
    }

    public static Organization convertOrganization(org.hl7.fhir.dstu3.model.Organization src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Organization tgt = new Organization();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasActiveElement()) {
            tgt.setActiveElement(VersionConvertor_10_30.convertBoolean(src.getActiveElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getTypeFirstRep()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(VersionConvertor_10_30.convertAddress(address));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_10_30.convertReference(src.getPartOf()));
        }
        for (Organization.OrganizationContactComponent organizationContactComponent : src.getContact()) {
            tgt.addContact(Organization10_30.convertOrganizationContactComponent(organizationContactComponent));
        }
        return tgt;
    }

    public static Organization.OrganizationContactComponent convertOrganizationContactComponent(Organization.OrganizationContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Organization.OrganizationContactComponent tgt = new Organization.OrganizationContactComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasPurpose()) {
            tgt.setPurpose(VersionConvertor_10_30.convertCodeableConcept(src.getPurpose()));
        }
        if (src.hasName()) {
            tgt.setName(VersionConvertor_10_30.convertHumanName(src.getName()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_10_30.convertAddress(src.getAddress()));
        }
        return tgt;
    }

    public static Organization.OrganizationContactComponent convertOrganizationContactComponent(Organization.OrganizationContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Organization.OrganizationContactComponent tgt = new Organization.OrganizationContactComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasPurpose()) {
            tgt.setPurpose(VersionConvertor_10_30.convertCodeableConcept(src.getPurpose()));
        }
        if (src.hasName()) {
            tgt.setName(VersionConvertor_10_30.convertHumanName(src.getName()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_10_30.convertAddress(src.getAddress()));
        }
        return tgt;
    }
}

