/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.DocumentReference;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class DocumentReference10_30 {
    public static DocumentReference.ReferredDocumentStatus convertDocStatus(CodeableConcept cc) {
        if (VersionConvertor_10_30.hasConcept(cc, "http://hl7.org/fhir/composition-status", "preliminary")) {
            return DocumentReference.ReferredDocumentStatus.PRELIMINARY;
        }
        if (VersionConvertor_10_30.hasConcept(cc, "http://hl7.org/fhir/composition-status", "final")) {
            return DocumentReference.ReferredDocumentStatus.FINAL;
        }
        if (VersionConvertor_10_30.hasConcept(cc, "http://hl7.org/fhir/composition-status", "amended")) {
            return DocumentReference.ReferredDocumentStatus.AMENDED;
        }
        if (VersionConvertor_10_30.hasConcept(cc, "http://hl7.org/fhir/composition-status", "entered-in-error")) {
            return DocumentReference.ReferredDocumentStatus.ENTEREDINERROR;
        }
        return null;
    }

    public static CodeableConcept convertDocStatus(DocumentReference.ReferredDocumentStatus docStatus) {
        CodeableConcept cc = new CodeableConcept();
        switch (docStatus) {
            case AMENDED: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("amended");
                break;
            }
            case ENTEREDINERROR: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("entered-in-error");
                break;
            }
            case FINAL: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("final");
                break;
            }
            case PRELIMINARY: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("preliminary");
                break;
            }
            default: {
                return null;
            }
        }
        return cc;
    }

    public static DocumentReference convertDocumentReference(org.hl7.fhir.dstu2.model.DocumentReference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference tgt = new DocumentReference();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasMasterIdentifier()) {
            tgt.setMasterIdentifier(VersionConvertor_10_30.convertIdentifier(src.getMasterIdentifier()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(t));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasClass_()) {
            tgt.setClass_(VersionConvertor_10_30.convertCodeableConcept(src.getClass_()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getAuthor()) {
            tgt.addAuthor(VersionConvertor_10_30.convertReference((org.hl7.fhir.dstu2.model.Reference)t));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_10_30.convertReference(src.getCustodian()));
        }
        if (src.hasAuthenticator()) {
            tgt.setAuthenticator(VersionConvertor_10_30.convertReference(src.getAuthenticator()));
        }
        if (src.hasCreatedElement()) {
            tgt.setCreatedElement(VersionConvertor_10_30.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasIndexedElement()) {
            tgt.setIndexedElement(VersionConvertor_10_30.convertInstant(src.getIndexedElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_30.convertDocumentReferenceStatus((Enumeration<Enumerations.DocumentReferenceStatus>)src.getStatusElement()));
        }
        if (src.hasDocStatus()) {
            tgt.setDocStatus(DocumentReference10_30.convertDocStatus(src.getDocStatus()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getRelatesTo()) {
            tgt.addRelatesTo(DocumentReference10_30.convertDocumentReferenceRelatesToComponent((DocumentReference.DocumentReferenceRelatesToComponent)t));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_10_30.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getContent()) {
            tgt.addContent(DocumentReference10_30.convertDocumentReferenceContentComponent((DocumentReference.DocumentReferenceContentComponent)t));
        }
        if (src.hasContext()) {
            tgt.setContext(DocumentReference10_30.convertDocumentReferenceContextComponent(src.getContext()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.DocumentReference convertDocumentReference(DocumentReference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.DocumentReference tgt = new org.hl7.fhir.dstu2.model.DocumentReference();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        if (src.hasMasterIdentifier()) {
            tgt.setMasterIdentifier(VersionConvertor_10_30.convertIdentifier(src.getMasterIdentifier()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasClass_()) {
            tgt.setClass_(VersionConvertor_10_30.convertCodeableConcept(src.getClass_()));
        }
        for (Reference reference : src.getAuthor()) {
            tgt.addAuthor(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_10_30.convertReference(src.getCustodian()));
        }
        if (src.hasAuthenticator()) {
            tgt.setAuthenticator(VersionConvertor_10_30.convertReference(src.getAuthenticator()));
        }
        if (src.hasCreatedElement()) {
            tgt.setCreatedElement(VersionConvertor_10_30.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasIndexedElement()) {
            tgt.setIndexedElement(VersionConvertor_10_30.convertInstant(src.getIndexedElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_30.convertDocumentReferenceStatus(src.getStatusElement()));
        }
        if (src.hasDocStatus()) {
            tgt.setDocStatus(DocumentReference10_30.convertDocStatus(src.getDocStatus()));
        }
        for (DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : src.getRelatesTo()) {
            tgt.addRelatesTo(DocumentReference10_30.convertDocumentReferenceRelatesToComponent(documentReferenceRelatesToComponent));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (DocumentReference.DocumentReferenceContentComponent documentReferenceContentComponent : src.getContent()) {
            tgt.addContent(DocumentReference10_30.convertDocumentReferenceContentComponent(documentReferenceContentComponent));
        }
        if (src.hasContext()) {
            tgt.setContext(DocumentReference10_30.convertDocumentReferenceContextComponent(src.getContext()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContentComponent convertDocumentReferenceContentComponent(DocumentReference.DocumentReferenceContentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContentComponent tgt = new DocumentReference.DocumentReferenceContentComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasAttachment()) {
            tgt.setAttachment(VersionConvertor_10_30.convertAttachment(src.getAttachment()));
        }
        if (src.hasFormat()) {
            tgt.addFormat(VersionConvertor_10_30.convertCoding(src.getFormat()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContentComponent convertDocumentReferenceContentComponent(DocumentReference.DocumentReferenceContentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContentComponent tgt = new DocumentReference.DocumentReferenceContentComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasAttachment()) {
            tgt.setAttachment(VersionConvertor_10_30.convertAttachment(src.getAttachment()));
        }
        for (Coding t : src.getFormat()) {
            tgt.setFormat(VersionConvertor_10_30.convertCoding(t));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextComponent convertDocumentReferenceContextComponent(DocumentReference.DocumentReferenceContextComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContextComponent tgt = new DocumentReference.DocumentReferenceContextComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_30.convertReference(src.getEncounter()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getEvent()) {
            tgt.addEvent(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        if (src.hasFacilityType()) {
            tgt.setFacilityType(VersionConvertor_10_30.convertCodeableConcept(src.getFacilityType()));
        }
        if (src.hasPracticeSetting()) {
            tgt.setPracticeSetting(VersionConvertor_10_30.convertCodeableConcept(src.getPracticeSetting()));
        }
        if (src.hasSourcePatientInfo()) {
            tgt.setSourcePatientInfo(VersionConvertor_10_30.convertReference(src.getSourcePatientInfo()));
        }
        for (DocumentReference.DocumentReferenceContextRelatedComponent documentReferenceContextRelatedComponent : src.getRelated()) {
            tgt.addRelated(DocumentReference10_30.convertDocumentReferenceContextRelatedComponent(documentReferenceContextRelatedComponent));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextComponent convertDocumentReferenceContextComponent(DocumentReference.DocumentReferenceContextComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContextComponent tgt = new DocumentReference.DocumentReferenceContextComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_10_30.convertReference(src.getEncounter()));
        }
        for (CodeableConcept t : src.getEvent()) {
            tgt.addEvent(VersionConvertor_10_30.convertCodeableConcept(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        if (src.hasFacilityType()) {
            tgt.setFacilityType(VersionConvertor_10_30.convertCodeableConcept(src.getFacilityType()));
        }
        if (src.hasPracticeSetting()) {
            tgt.setPracticeSetting(VersionConvertor_10_30.convertCodeableConcept(src.getPracticeSetting()));
        }
        if (src.hasSourcePatientInfo()) {
            tgt.setSourcePatientInfo(VersionConvertor_10_30.convertReference(src.getSourcePatientInfo()));
        }
        for (CodeableConcept t : src.getRelated()) {
            tgt.addRelated(DocumentReference10_30.convertDocumentReferenceContextRelatedComponent((DocumentReference.DocumentReferenceContextRelatedComponent)t));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextRelatedComponent convertDocumentReferenceContextRelatedComponent(DocumentReference.DocumentReferenceContextRelatedComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContextRelatedComponent tgt = new DocumentReference.DocumentReferenceContextRelatedComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasRef()) {
            tgt.setRef(VersionConvertor_10_30.convertReference(src.getRef()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextRelatedComponent convertDocumentReferenceContextRelatedComponent(DocumentReference.DocumentReferenceContextRelatedComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContextRelatedComponent tgt = new DocumentReference.DocumentReferenceContextRelatedComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasRef()) {
            tgt.setRef(VersionConvertor_10_30.convertReference(src.getRef()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceRelatesToComponent convertDocumentReferenceRelatesToComponent(DocumentReference.DocumentReferenceRelatesToComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceRelatesToComponent tgt = new DocumentReference.DocumentReferenceRelatesToComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCodeElement(DocumentReference10_30.convertDocumentRelationshipType(src.getCodeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_30.convertReference(src.getTarget()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceRelatesToComponent convertDocumentReferenceRelatesToComponent(DocumentReference.DocumentReferenceRelatesToComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceRelatesToComponent tgt = new DocumentReference.DocumentReferenceRelatesToComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasCode()) {
            tgt.setCodeElement(DocumentReference10_30.convertDocumentRelationshipType((Enumeration<DocumentReference.DocumentRelationshipType>)src.getCodeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_30.convertReference(src.getTarget()));
        }
        return tgt;
    }

    public static Enumeration<DocumentReference.DocumentRelationshipType> convertDocumentRelationshipType(org.hl7.fhir.dstu3.model.Enumeration<DocumentReference.DocumentRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new DocumentReference.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((DocumentReference.DocumentRelationshipType)((Object)src.getValue())) {
            case REPLACES: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.REPLACES);
                break;
            }
            case TRANSFORMS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.TRANSFORMS);
                break;
            }
            case SIGNS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.SIGNS);
                break;
            }
            case APPENDS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.APPENDS);
                break;
            }
            default: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<DocumentReference.DocumentRelationshipType> convertDocumentRelationshipType(Enumeration<DocumentReference.DocumentRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<DocumentReference.DocumentRelationshipType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<DocumentReference.DocumentRelationshipType>(new DocumentReference.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((DocumentReference.DocumentRelationshipType)src.getValue()) {
            case REPLACES: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.REPLACES);
                break;
            }
            case TRANSFORMS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.TRANSFORMS);
                break;
            }
            case SIGNS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.SIGNS);
                break;
            }
            case APPENDS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.APPENDS);
                break;
            }
            default: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.NULL);
            }
        }
        return tgt;
    }
}

