/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.convertors.SourceElementComponentWrapper;
import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.ConceptMap;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;

public class ConceptMap10_30 {
    public static ConceptMap convertConceptMap(org.hl7.fhir.dstu3.model.ConceptMap src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap tgt = new ConceptMap();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_30.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ConceptMap10_30.convertConceptMapContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_10_30.convertType(src.getSource()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_30.convertType(src.getTarget()));
        }
        for (ConceptMap.ConceptMapGroupComponent conceptMapGroupComponent : src.getGroup()) {
            for (ConceptMap.SourceElementComponent t : conceptMapGroupComponent.getElement()) {
                tgt.addElement(ConceptMap10_30.convertSourceElementComponent(t, conceptMapGroupComponent));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ConceptMap convertConceptMap(ConceptMap src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ConceptMap tgt = new org.hl7.fhir.dstu3.model.ConceptMap();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_30.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_10_30.convertConformanceResourceStatus((Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_30.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_30.convertString(src.getPublisherElement()));
        }
        for (ConceptMap.ConceptMapContactComponent t : src.getContact()) {
            tgt.addContact(ConceptMap10_30.convertConceptMapContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ConceptMap.ConceptMapContactComponent t : src.getUseContext()) {
            if (VersionConvertor_10_30.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_10_30.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_10_30.convertType(src.getSource()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_30.convertType(src.getTarget()));
        }
        for (ConceptMap.ConceptMapContactComponent t : src.getElement()) {
            List<SourceElementComponentWrapper<ConceptMap.SourceElementComponent>> ws = ConceptMap10_30.convertSourceElementComponent((ConceptMap.SourceElementComponent)t);
            for (SourceElementComponentWrapper<ConceptMap.SourceElementComponent> w : ws) {
                ConceptMap10_30.getGroup(tgt, w.getSource(), w.getTarget()).addElement(w.getComp());
            }
        }
        return tgt;
    }

    public static ContactDetail convertConceptMapContactComponent(ConceptMap.ConceptMapContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapContactComponent convertConceptMapContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.ConceptMapContactComponent tgt = new ConceptMap.ConceptMapContactComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Enumerations.ConceptMapEquivalence> convertConceptMapEquivalence(Enumeration<Enumerations.ConceptMapEquivalence> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Enumerations.ConceptMapEquivalence> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Enumerations.ConceptMapEquivalence>(new Enumerations.ConceptMapEquivalenceEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Enumerations.ConceptMapEquivalence)src.getValue()) {
            case EQUIVALENT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUIVALENT);
                break;
            }
            case EQUAL: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUAL);
                break;
            }
            case WIDER: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.WIDER);
                break;
            }
            case SUBSUMES: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.SUBSUMES);
                break;
            }
            case NARROWER: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NARROWER);
                break;
            }
            case SPECIALIZES: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.SPECIALIZES);
                break;
            }
            case INEXACT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.INEXACT);
                break;
            }
            case UNMATCHED: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.UNMATCHED);
                break;
            }
            case DISJOINT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.DISJOINT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.ConceptMapEquivalence> convertConceptMapEquivalence(org.hl7.fhir.dstu3.model.Enumeration<Enumerations.ConceptMapEquivalence> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new Enumerations.ConceptMapEquivalenceEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((Enumerations.ConceptMapEquivalence)((Object)src.getValue())) {
            case EQUIVALENT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUIVALENT);
                break;
            }
            case EQUAL: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUAL);
                break;
            }
            case WIDER: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.WIDER);
                break;
            }
            case SUBSUMES: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.SUBSUMES);
                break;
            }
            case NARROWER: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NARROWER);
                break;
            }
            case SPECIALIZES: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.SPECIALIZES);
                break;
            }
            case INEXACT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.INEXACT);
                break;
            }
            case UNMATCHED: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.UNMATCHED);
                break;
            }
            case DISJOINT: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.DISJOINT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NULL);
            }
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasElementElement()) {
            tgt.setPropertyElement(VersionConvertor_10_30.convertUri(src.getElementElement()));
        }
        if (src.hasCodeSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_30.convertUri(src.getCodeSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertString(src.getCodeElement()));
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasPropertyElement()) {
            tgt.setElementElement(VersionConvertor_10_30.convertUri(src.getPropertyElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setCodeSystemElement(VersionConvertor_10_30.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertString(src.getCodeElement()));
        }
        return tgt;
    }

    public static List<SourceElementComponentWrapper<ConceptMap.SourceElementComponent>> convertSourceElementComponent(ConceptMap.SourceElementComponent src) throws FHIRException {
        ArrayList<SourceElementComponentWrapper<ConceptMap.SourceElementComponent>> res = new ArrayList<SourceElementComponentWrapper<ConceptMap.SourceElementComponent>>();
        if (src == null || src.isEmpty()) {
            return res;
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
            VersionConvertor_10_30.copyElement((Element)src, tgt);
            tgt.setCode(src.getCode());
            tgt.addTarget(ConceptMap10_30.convertTargetElementComponent(t));
            res.add(new SourceElementComponentWrapper<ConceptMap.SourceElementComponent>(tgt, src.getCodeSystem(), t.getCodeSystem()));
        }
        return res;
    }

    public static ConceptMap.SourceElementComponent convertSourceElementComponent(ConceptMap.SourceElementComponent src, ConceptMap.ConceptMapGroupComponent g2) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        tgt.setCodeSystem(g2.getSource());
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            tgt.addTarget(ConceptMap10_30.convertTargetElementComponent(t, g2));
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src, ConceptMap.ConceptMapGroupComponent g2) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        tgt.setCodeSystem(g2.getTarget());
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        if (src.hasEquivalence()) {
            tgt.setEquivalenceElement(ConceptMap10_30.convertConceptMapEquivalence(src.getEquivalenceElement()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentsElement(VersionConvertor_10_30.convertString(src.getCommentElement()));
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(ConceptMap10_30.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(ConceptMap10_30.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_30.convertCode(src.getCodeElement()));
        }
        if (src.hasEquivalence()) {
            tgt.setEquivalenceElement(ConceptMap10_30.convertConceptMapEquivalence((Enumeration<Enumerations.ConceptMapEquivalence>)src.getEquivalenceElement()));
        }
        if (src.hasCommentsElement()) {
            tgt.setCommentElement(VersionConvertor_10_30.convertString(src.getCommentsElement()));
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(ConceptMap10_30.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(ConceptMap10_30.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupComponent getGroup(org.hl7.fhir.dstu3.model.ConceptMap map, String srcs, String tgts) {
        for (ConceptMap.ConceptMapGroupComponent grp : map.getGroup()) {
            if (!grp.getSource().equals(srcs) || !grp.getTarget().equals(tgts)) continue;
            return grp;
        }
        ConceptMap.ConceptMapGroupComponent grp = map.addGroup();
        grp.setSource(srcs);
        grp.setTarget(tgts);
        return grp;
    }
}

