/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.ClinicalImpression;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu3.model.ClinicalImpression;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;

public class ClinicalImpression10_30 {
    public static org.hl7.fhir.dstu3.model.ClinicalImpression convertClinicalImpression(ClinicalImpression src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ClinicalImpression tgt = new org.hl7.fhir.dstu3.model.ClinicalImpression();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        if (src.hasPatient()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getPatient()));
        }
        if (src.hasAssessor()) {
            tgt.setAssessor(VersionConvertor_10_30.convertReference(src.getAssessor()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ClinicalImpression10_30.convertClinicalImpressionStatus((Enumeration<ClinicalImpression.ClinicalImpressionStatus>)src.getStatusElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasPrevious()) {
            tgt.setPrevious(VersionConvertor_10_30.convertReference(src.getPrevious()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getProblem()) {
            tgt.addProblem(VersionConvertor_10_30.convertReference(t));
        }
        tgt.addProtocol(src.getProtocol());
        if (src.hasSummaryElement()) {
            tgt.setSummaryElement(VersionConvertor_10_30.convertString(src.getSummaryElement()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getFinding()) {
            tgt.addFinding(ClinicalImpression10_30.convertClinicalImpressionFindingComponent((ClinicalImpression.ClinicalImpressionFindingComponent)t));
        }
        if (src.hasPrognosis()) {
            tgt.addPrognosisCodeableConcept().setText(src.getPrognosis());
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getAction()) {
            tgt.addAction(VersionConvertor_10_30.convertReference(t));
        }
        return tgt;
    }

    public static ClinicalImpression convertClinicalImpression(org.hl7.fhir.dstu3.model.ClinicalImpression src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ClinicalImpression tgt = new ClinicalImpression();
        VersionConvertor_10_30.copyDomainResource(src, (DomainResource)tgt);
        if (src.hasSubject()) {
            tgt.setPatient(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasAssessor()) {
            tgt.setAssessor(VersionConvertor_10_30.convertReference(src.getAssessor()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ClinicalImpression10_30.convertClinicalImpressionStatus(src.getStatusElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasPrevious()) {
            tgt.setPrevious(VersionConvertor_10_30.convertReference(src.getPrevious()));
        }
        for (Reference reference : src.getProblem()) {
            tgt.addProblem(VersionConvertor_10_30.convertReference(reference));
        }
        for (UriType uriType : src.getProtocol()) {
            tgt.setProtocol(uriType.asStringValue());
        }
        if (src.hasSummaryElement()) {
            tgt.setSummaryElement(VersionConvertor_10_30.convertString(src.getSummaryElement()));
        }
        for (ClinicalImpression.ClinicalImpressionFindingComponent clinicalImpressionFindingComponent : src.getFinding()) {
            tgt.addFinding(ClinicalImpression10_30.convertClinicalImpressionFindingComponent(clinicalImpressionFindingComponent));
        }
        if (src.hasText()) {
            tgt.setPrognosis(src.getPrognosisCodeableConceptFirstRep().getText());
        }
        for (Reference reference : src.getAction()) {
            tgt.addAction(VersionConvertor_10_30.convertReference(reference));
        }
        return tgt;
    }

    public static ClinicalImpression.ClinicalImpressionFindingComponent convertClinicalImpressionFindingComponent(ClinicalImpression.ClinicalImpressionFindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ClinicalImpression.ClinicalImpressionFindingComponent tgt = new ClinicalImpression.ClinicalImpressionFindingComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_10_30.convertCodeableConcept(src.getItem()));
        }
        return tgt;
    }

    public static ClinicalImpression.ClinicalImpressionFindingComponent convertClinicalImpressionFindingComponent(ClinicalImpression.ClinicalImpressionFindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ClinicalImpression.ClinicalImpressionFindingComponent tgt = new ClinicalImpression.ClinicalImpressionFindingComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasItemCodeableConcept()) {
            try {
                if (src.hasItemCodeableConcept()) {
                    tgt.setItem(VersionConvertor_10_30.convertCodeableConcept(src.getItemCodeableConcept()));
                }
            }
            catch (FHIRException fHIRException) {
                // empty catch block
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ClinicalImpression.ClinicalImpressionStatus> convertClinicalImpressionStatus(Enumeration<ClinicalImpression.ClinicalImpressionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ClinicalImpression.ClinicalImpressionStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ClinicalImpression.ClinicalImpressionStatus>(new ClinicalImpression.ClinicalImpressionStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((ClinicalImpression.ClinicalImpressionStatus)src.getValue()) {
            case INPROGRESS: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.DRAFT);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ClinicalImpression.ClinicalImpressionStatus> convertClinicalImpressionStatus(org.hl7.fhir.dstu3.model.Enumeration<ClinicalImpression.ClinicalImpressionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new ClinicalImpression.ClinicalImpressionStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        switch ((ClinicalImpression.ClinicalImpressionStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.NULL);
            }
        }
        return tgt;
    }
}

