/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.AllergyIntolerance;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu3.model.AllergyIntolerance;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;

public class AllergyIntolerance10_30 {
    public static org.hl7.fhir.dstu3.model.AllergyIntolerance convertAllergyIntolerance(AllergyIntolerance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.AllergyIntolerance tgt = new org.hl7.fhir.dstu3.model.AllergyIntolerance();
        VersionConvertor_10_30.copyDomainResource((DomainResource)src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_10_30.convertDateTime(src.getOnsetElement()));
        }
        if (src.hasRecordedDate()) {
            tgt.setAssertedDateElement(VersionConvertor_10_30.convertDateTime(src.getRecordedDateElement()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(VersionConvertor_10_30.convertReference(src.getRecorder()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_30.convertReference(src.getPatient()));
        }
        if (src.hasReporter()) {
            tgt.setAsserter(VersionConvertor_10_30.convertReference(src.getReporter()));
        }
        if (src.hasSubstance()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getSubstance()));
        }
        if (src.hasStatus()) {
            if (src.getStatus() != AllergyIntolerance.AllergyIntoleranceStatus.REFUTED && src.getStatus() != AllergyIntolerance.AllergyIntoleranceStatus.ENTEREDINERROR) {
                tgt.setClinicalStatus(AllergyIntolerance10_30.translateAllergyIntoleranceClinicalStatus(src.getStatus()));
            }
            if (src.getStatus() != AllergyIntolerance.AllergyIntoleranceStatus.ACTIVE && src.getStatus() != AllergyIntolerance.AllergyIntoleranceStatus.RESOLVED) {
                tgt.setVerificationStatus(AllergyIntolerance10_30.translateAllergyIntoleranceVerificationStatus(src.getStatus()));
            }
        }
        if (src.hasCriticality()) {
            tgt.setCriticality(AllergyIntolerance10_30.translateAllergyIntoleranceCriticality(src.getCriticality()));
        }
        if (src.hasType()) {
            tgt.setType(AllergyIntolerance.AllergyIntoleranceType.fromCode(src.getType().toCode()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(AllergyIntolerance.AllergyIntoleranceCategory.fromCode(src.getCategory().toCode()));
        }
        if (src.hasLastOccurence()) {
            tgt.setLastOccurrenceElement(VersionConvertor_10_30.convertDateTime(src.getLastOccurenceElement()));
        }
        if (src.hasNote()) {
            tgt.addNote(VersionConvertor_10_30.convertAnnotation(src.getNote()));
        }
        for (AllergyIntolerance.AllergyIntoleranceReactionComponent reaction : src.getReaction()) {
            tgt.addReaction(AllergyIntolerance10_30.algReaction(reaction));
        }
        return tgt;
    }

    private static AllergyIntolerance.AllergyIntoleranceReactionComponent algReaction(AllergyIntolerance.AllergyIntoleranceReactionComponent src) {
        if (src == null) {
            return null;
        }
        AllergyIntolerance.AllergyIntoleranceReactionComponent tgt = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        VersionConvertor_10_30.copyElement((Element)src, tgt);
        for (org.hl7.fhir.dstu2.model.Extension extension : src.getModifierExtension()) {
            tgt.addExtension(VersionConvertor_10_30.convertExtension(extension));
        }
        if (src.hasSubstance()) {
            tgt.setSubstance(VersionConvertor_10_30.convertCodeableConcept(src.getSubstance()));
        }
        if (src.hasCertainty()) {
            tgt.addExtension(new Extension("http://hl7.org/fhir/AllergyIntolerance-r2-certainty", new StringType(src.getCertainty().toCode())));
        }
        for (CodeableConcept concept : src.getManifestation()) {
            tgt.addManifestation(VersionConvertor_10_30.convertCodeableConcept(concept));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        if (src.hasOnset()) {
            tgt.setOnsetElement(VersionConvertor_10_30.convertDateTime(src.getOnsetElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(AllergyIntolerance.AllergyIntoleranceSeverity.fromCode(src.getSeverity().toCode()));
        }
        if (src.hasExposureRoute()) {
            tgt.setExposureRoute(VersionConvertor_10_30.convertCodeableConcept(src.getExposureRoute()));
        }
        if (src.hasNote()) {
            tgt.addNote(VersionConvertor_10_30.convertAnnotation(src.getNote()));
        }
        return tgt;
    }

    public static AllergyIntolerance.AllergyIntoleranceVerificationStatus translateAllergyIntoleranceVerificationStatus(AllergyIntolerance.AllergyIntoleranceStatus src) {
        switch (src) {
            case UNCONFIRMED: 
            case INACTIVE: {
                return AllergyIntolerance.AllergyIntoleranceVerificationStatus.UNCONFIRMED;
            }
            case CONFIRMED: {
                return AllergyIntolerance.AllergyIntoleranceVerificationStatus.CONFIRMED;
            }
            case REFUTED: {
                return AllergyIntolerance.AllergyIntoleranceVerificationStatus.REFUTED;
            }
            case ENTEREDINERROR: {
                return AllergyIntolerance.AllergyIntoleranceVerificationStatus.ENTEREDINERROR;
            }
        }
        return AllergyIntolerance.AllergyIntoleranceVerificationStatus.NULL;
    }

    public static AllergyIntolerance.AllergyIntoleranceClinicalStatus translateAllergyIntoleranceClinicalStatus(AllergyIntolerance.AllergyIntoleranceStatus src) {
        switch (src) {
            case UNCONFIRMED: 
            case CONFIRMED: 
            case ACTIVE: {
                return AllergyIntolerance.AllergyIntoleranceClinicalStatus.ACTIVE;
            }
            case INACTIVE: {
                return AllergyIntolerance.AllergyIntoleranceClinicalStatus.INACTIVE;
            }
            case RESOLVED: {
                return AllergyIntolerance.AllergyIntoleranceClinicalStatus.RESOLVED;
            }
        }
        return AllergyIntolerance.AllergyIntoleranceClinicalStatus.NULL;
    }

    public static AllergyIntolerance.AllergyIntoleranceCriticality translateAllergyIntoleranceCriticality(AllergyIntolerance.AllergyIntoleranceCriticality src) {
        switch (src) {
            case CRITL: {
                return AllergyIntolerance.AllergyIntoleranceCriticality.LOW;
            }
            case CRITH: {
                return AllergyIntolerance.AllergyIntoleranceCriticality.HIGH;
            }
            case CRITU: {
                return AllergyIntolerance.AllergyIntoleranceCriticality.UNABLETOASSESS;
            }
        }
        return AllergyIntolerance.AllergyIntoleranceCriticality.NULL;
    }
}

