/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertorConstants;
import org.hl7.fhir.convertors.VersionConvertorResourceNameMapper;
import org.hl7.fhir.convertors.VersionConvertor_Base;
import org.hl7.fhir.convertors.conv30_50.ActivityDefinition30_50;
import org.hl7.fhir.convertors.conv30_50.AllergyIntolerance30_50;
import org.hl7.fhir.convertors.conv30_50.Appointment30_50;
import org.hl7.fhir.convertors.conv30_50.AppointmentResponse30_50;
import org.hl7.fhir.convertors.conv30_50.AuditEvent30_50;
import org.hl7.fhir.convertors.conv30_50.Basic30_50;
import org.hl7.fhir.convertors.conv30_50.Binary30_50;
import org.hl7.fhir.convertors.conv30_50.BodySite30_50;
import org.hl7.fhir.convertors.conv30_50.Bundle30_50;
import org.hl7.fhir.convertors.conv30_50.CapabilityStatement30_50;
import org.hl7.fhir.convertors.conv30_50.CarePlan30_50;
import org.hl7.fhir.convertors.conv30_50.CareTeam30_50;
import org.hl7.fhir.convertors.conv30_50.ClinicalImpression30_50;
import org.hl7.fhir.convertors.conv30_50.CodeSystem30_50;
import org.hl7.fhir.convertors.conv30_50.Communication30_50;
import org.hl7.fhir.convertors.conv30_50.CompartmentDefinition30_50;
import org.hl7.fhir.convertors.conv30_50.Composition30_50;
import org.hl7.fhir.convertors.conv30_50.ConceptMap30_50;
import org.hl7.fhir.convertors.conv30_50.Condition30_50;
import org.hl7.fhir.convertors.conv30_50.Consent30_50;
import org.hl7.fhir.convertors.conv30_50.DataElement30_50;
import org.hl7.fhir.convertors.conv30_50.DetectedIssue30_50;
import org.hl7.fhir.convertors.conv30_50.DeviceUseStatement30_50;
import org.hl7.fhir.convertors.conv30_50.DiagnosticReport30_50;
import org.hl7.fhir.convertors.conv30_50.DocumentReference30_50;
import org.hl7.fhir.convertors.conv30_50.Encounter30_50;
import org.hl7.fhir.convertors.conv30_50.Endpoint30_50;
import org.hl7.fhir.convertors.conv30_50.EpisodeOfCare30_50;
import org.hl7.fhir.convertors.conv30_50.ExpansionProfile30_50;
import org.hl7.fhir.convertors.conv30_50.FamilyMemberHistory30_50;
import org.hl7.fhir.convertors.conv30_50.Flag30_50;
import org.hl7.fhir.convertors.conv30_50.Goal30_50;
import org.hl7.fhir.convertors.conv30_50.GraphDefinition30_50;
import org.hl7.fhir.convertors.conv30_50.Group30_50;
import org.hl7.fhir.convertors.conv30_50.HealthcareService30_50;
import org.hl7.fhir.convertors.conv30_50.ImagingStudy30_50;
import org.hl7.fhir.convertors.conv30_50.Immunization30_50;
import org.hl7.fhir.convertors.conv30_50.ImplementationGuide30_50;
import org.hl7.fhir.convertors.conv30_50.Library30_50;
import org.hl7.fhir.convertors.conv30_50.Linkage30_50;
import org.hl7.fhir.convertors.conv30_50.List30_50;
import org.hl7.fhir.convertors.conv30_50.Location30_50;
import org.hl7.fhir.convertors.conv30_50.Measure30_50;
import org.hl7.fhir.convertors.conv30_50.Media30_50;
import org.hl7.fhir.convertors.conv30_50.Medication30_50;
import org.hl7.fhir.convertors.conv30_50.MedicationAdministration30_50;
import org.hl7.fhir.convertors.conv30_50.MedicationDispense30_50;
import org.hl7.fhir.convertors.conv30_50.MedicationRequest30_50;
import org.hl7.fhir.convertors.conv30_50.MedicationStatement30_50;
import org.hl7.fhir.convertors.conv30_50.MessageDefinition30_50;
import org.hl7.fhir.convertors.conv30_50.MessageHeader30_50;
import org.hl7.fhir.convertors.conv30_50.NamingSystem30_50;
import org.hl7.fhir.convertors.conv30_50.Observation30_50;
import org.hl7.fhir.convertors.conv30_50.OperationDefinition30_50;
import org.hl7.fhir.convertors.conv30_50.OperationOutcome30_50;
import org.hl7.fhir.convertors.conv30_50.Organization30_50;
import org.hl7.fhir.convertors.conv30_50.Parameters30_50;
import org.hl7.fhir.convertors.conv30_50.Patient30_50;
import org.hl7.fhir.convertors.conv30_50.PaymentNotice30_50;
import org.hl7.fhir.convertors.conv30_50.Person30_50;
import org.hl7.fhir.convertors.conv30_50.PlanDefinition30_50;
import org.hl7.fhir.convertors.conv30_50.Practitioner30_50;
import org.hl7.fhir.convertors.conv30_50.PractitionerRole30_50;
import org.hl7.fhir.convertors.conv30_50.Provenance30_50;
import org.hl7.fhir.convertors.conv30_50.Questionnaire30_50;
import org.hl7.fhir.convertors.conv30_50.QuestionnaireResponse30_50;
import org.hl7.fhir.convertors.conv30_50.RelatedPerson30_50;
import org.hl7.fhir.convertors.conv30_50.RiskAssessment30_50;
import org.hl7.fhir.convertors.conv30_50.Schedule30_50;
import org.hl7.fhir.convertors.conv30_50.SearchParameter30_50;
import org.hl7.fhir.convertors.conv30_50.Sequence30_50;
import org.hl7.fhir.convertors.conv30_50.Slot30_50;
import org.hl7.fhir.convertors.conv30_50.Specimen30_50;
import org.hl7.fhir.convertors.conv30_50.StructureDefinition30_50;
import org.hl7.fhir.convertors.conv30_50.StructureMap30_50;
import org.hl7.fhir.convertors.conv30_50.Substance30_50;
import org.hl7.fhir.convertors.conv30_50.SupplyDelivery30_50;
import org.hl7.fhir.convertors.conv30_50.TestReport30_50;
import org.hl7.fhir.convertors.conv30_50.TestScript30_50;
import org.hl7.fhir.convertors.conv30_50.ValueSet30_50;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Age;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Appointment;
import org.hl7.fhir.dstu3.model.AppointmentResponse;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.AuditEvent;
import org.hl7.fhir.dstu3.model.Basic;
import org.hl7.fhir.dstu3.model.BodySite;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Communication;
import org.hl7.fhir.dstu3.model.Composition;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Consent;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.Contributor;
import org.hl7.fhir.dstu3.model.Count;
import org.hl7.fhir.dstu3.model.DataElement;
import org.hl7.fhir.dstu3.model.DataRequirement;
import org.hl7.fhir.dstu3.model.DeviceUseStatement;
import org.hl7.fhir.dstu3.model.Distance;
import org.hl7.fhir.dstu3.model.DocumentManifest;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.Endpoint;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.ExpansionProfile;
import org.hl7.fhir.dstu3.model.Flag;
import org.hl7.fhir.dstu3.model.Goal;
import org.hl7.fhir.dstu3.model.GraphDefinition;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Immunization;
import org.hl7.fhir.dstu3.model.ImplementationGuide;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.ListResource;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.Media;
import org.hl7.fhir.dstu3.model.MedicationDispense;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.MedicationStatement;
import org.hl7.fhir.dstu3.model.Money;
import org.hl7.fhir.dstu3.model.Narrative;
import org.hl7.fhir.dstu3.model.OperationDefinition;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.ParameterDefinition;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.PaymentNotice;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.PractitionerRole;
import org.hl7.fhir.dstu3.model.Provenance;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Ratio;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.RiskAssessment;
import org.hl7.fhir.dstu3.model.Sequence;
import org.hl7.fhir.dstu3.model.Signature;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.Specimen;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Substance;
import org.hl7.fhir.dstu3.model.TestReport;
import org.hl7.fhir.dstu3.model.TestScript;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.TriggerDefinition;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.dstu3.model.UuidType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Contributor;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.ParameterDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TriggerDefinition;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.utilities.Utilities;

public class VersionConvertor_30_50
extends VersionConvertor_Base {
    public static final String EXT_SRC_TYPE = "http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type";
    public static List<String> CANONICAL_URLS = new ArrayList<String>();
    private static final String CODE_SYSTEM_MEDIA_TYPE = "http://terminology.hl7.org/CodeSystem/media-type";

    public static void copyElement(org.hl7.fhir.dstu3.model.Element src, Element tgt, String ... extensionsToIgnore) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (org.hl7.fhir.dstu3.model.Extension e : src.getExtension()) {
            if (VersionConvertor_30_50.isExemptExtension(e.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_30_50.convertExtension(e));
        }
    }

    public static void copyElement(Element src, org.hl7.fhir.dstu3.model.Element tgt, String ... extensionsToIgnore) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (Extension e : src.getExtension()) {
            if (VersionConvertor_30_50.isExemptExtension(e.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_30_50.convertExtension(e));
        }
    }

    public static void copyBackboneElement(org.hl7.fhir.dstu3.model.BackboneElement src, BackboneElement tgt) throws FHIRException {
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_30_50.convertExtension(e));
        }
    }

    public static void copyBackboneElement(BackboneElement src, org.hl7.fhir.dstu3.model.BackboneElement tgt) throws FHIRException {
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_30_50.convertExtension(e));
        }
    }

    public static Base64BinaryType convertBase64Binary(org.hl7.fhir.dstu3.model.Base64BinaryType src) throws FHIRException {
        Base64BinaryType tgt = src.hasValue() ? new Base64BinaryType(src.getValue()) : new Base64BinaryType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Base64BinaryType convertBase64Binary(Base64BinaryType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.Base64BinaryType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.Base64BinaryType(src.getValue()) : new org.hl7.fhir.dstu3.model.Base64BinaryType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.BooleanType convertBoolean(BooleanType src) throws FHIRException {
        org.hl7.fhir.r5.model.BooleanType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.BooleanType((Boolean)src.getValue()) : new org.hl7.fhir.r5.model.BooleanType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static BooleanType convertBoolean(org.hl7.fhir.r5.model.BooleanType src) throws FHIRException {
        BooleanType tgt = src.hasValue() ? new BooleanType((Boolean)src.getValue()) : new BooleanType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.CodeType convertCode(CodeType src) throws FHIRException {
        org.hl7.fhir.r5.model.CodeType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.CodeType((String)src.getValue()) : new org.hl7.fhir.r5.model.CodeType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static CodeType convertCode(org.hl7.fhir.r5.model.CodeType src) throws FHIRException {
        CodeType tgt = src.hasValue() ? new CodeType((String)src.getValue()) : new CodeType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.CodeType convertStringToCode(StringType src) throws FHIRException {
        org.hl7.fhir.r5.model.CodeType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.CodeType((String)src.getValue()) : new org.hl7.fhir.r5.model.CodeType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static StringType convertCodeToString(org.hl7.fhir.r5.model.CodeType src) throws FHIRException {
        StringType tgt = src.hasValue() ? new StringType((String)src.getValue()) : new StringType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static CodeType convertStringToCode(org.hl7.fhir.r5.model.StringType src) throws FHIRException {
        CodeType tgt = src.hasValue() ? new CodeType((String)src.getValue()) : new CodeType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.StringType convertCodeToString(CodeType src) throws FHIRException {
        org.hl7.fhir.r5.model.StringType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.StringType((String)src.getValue()) : new org.hl7.fhir.r5.model.StringType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateType convertDate(org.hl7.fhir.dstu3.model.DateType src) throws FHIRException {
        DateType tgt = src.hasValue() ? new DateType(src.getValueAsString()) : new DateType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateTimeType convertDateToDateTime(org.hl7.fhir.dstu3.model.DateType src) throws FHIRException {
        DateTimeType tgt = src.hasValue() ? new DateTimeType(src.getValueAsString()) : new DateTimeType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DateType convertDateTimeToDate(DateTimeType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DateType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.DateType(src.getValueAsString()) : new org.hl7.fhir.dstu3.model.DateType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DateType convertDate(DateType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DateType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.DateType(src.getValueAsString()) : new org.hl7.fhir.dstu3.model.DateType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateTimeType convertDateTime(org.hl7.fhir.dstu3.model.DateTimeType src) throws FHIRException {
        DateTimeType tgt = src.hasValue() ? new DateTimeType(src.getValueAsString()) : new DateTimeType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DateTimeType convertDateTime(DateTimeType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DateTimeType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.DateTimeType(src.getValueAsString()) : new org.hl7.fhir.dstu3.model.DateTimeType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DecimalType convertDecimal(org.hl7.fhir.dstu3.model.DecimalType src) throws FHIRException {
        DecimalType tgt = src.hasValue() ? new DecimalType((BigDecimal)src.getValue()) : new DecimalType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DecimalType convertDecimal(DecimalType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DecimalType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.DecimalType((BigDecimal)src.getValue()) : new org.hl7.fhir.dstu3.model.DecimalType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static IdType convertId(org.hl7.fhir.dstu3.model.IdType src) throws FHIRException {
        IdType tgt = src.hasValue() ? new IdType(src.getValue()) : new IdType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.IdType convertId(IdType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.IdType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.IdType(src.getValue()) : new org.hl7.fhir.dstu3.model.IdType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static InstantType convertInstant(org.hl7.fhir.dstu3.model.InstantType src) throws FHIRException {
        InstantType tgt = src.hasValue() ? new InstantType(src.getValueAsString()) : new InstantType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.InstantType convertInstant(InstantType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.InstantType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.InstantType(src.getValueAsString()) : new org.hl7.fhir.dstu3.model.InstantType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static IntegerType convertInteger(org.hl7.fhir.dstu3.model.IntegerType src) throws FHIRException {
        IntegerType tgt = src.hasValue() ? new IntegerType((Integer)src.getValue()) : new IntegerType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.IntegerType convertInteger(IntegerType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.IntegerType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.IntegerType((Integer)src.getValue()) : new org.hl7.fhir.dstu3.model.IntegerType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DecimalType convertInteger64(Integer64Type src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DecimalType tgt = new org.hl7.fhir.dstu3.model.DecimalType(((Long)src.getValue()).toString());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static MarkdownType convertMarkdown(org.hl7.fhir.dstu3.model.MarkdownType src) throws FHIRException {
        MarkdownType tgt = src.hasValue() ? new MarkdownType((String)src.getValue()) : new MarkdownType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.MarkdownType convertMarkdown(MarkdownType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.MarkdownType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.MarkdownType((String)src.getValue()) : new org.hl7.fhir.dstu3.model.MarkdownType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static OidType convertOid(org.hl7.fhir.dstu3.model.OidType src) throws FHIRException {
        OidType tgt = src.hasValue() ? new OidType((String)src.getValue()) : new OidType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.OidType convertOid(OidType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.OidType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.OidType((String)src.getValue()) : new org.hl7.fhir.dstu3.model.OidType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static PositiveIntType convertPositiveInt(org.hl7.fhir.dstu3.model.PositiveIntType src) throws FHIRException {
        PositiveIntType tgt = src.hasValue() ? new PositiveIntType((int)((Integer)src.getValue())) : new PositiveIntType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.PositiveIntType convertPositiveInt(PositiveIntType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.PositiveIntType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.PositiveIntType((Integer)src.getValue()) : new org.hl7.fhir.dstu3.model.PositiveIntType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.StringType convertString(StringType src) throws FHIRException {
        org.hl7.fhir.r5.model.StringType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.StringType((String)src.getValue()) : new org.hl7.fhir.r5.model.StringType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static StringType convertString(org.hl7.fhir.r5.model.StringType src) throws FHIRException {
        StringType tgt = src.hasValue() ? new StringType((String)src.getValue()) : new StringType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static MarkdownType convertStringToMarkdown(StringType src) throws FHIRException {
        MarkdownType tgt = src.hasValue() ? new MarkdownType((String)src.getValue()) : new MarkdownType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static StringType convertMarkdownToString(MarkdownType src) throws FHIRException {
        StringType tgt = src.hasValue() ? new StringType((String)src.getValue()) : new StringType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static TimeType convertTime(org.hl7.fhir.dstu3.model.TimeType src) throws FHIRException {
        TimeType tgt = src.hasValue() ? new TimeType((String)src.getValue()) : new TimeType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.TimeType convertTime(TimeType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.TimeType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.TimeType((String)src.getValue()) : new org.hl7.fhir.dstu3.model.TimeType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UnsignedIntType convertUnsignedInt(org.hl7.fhir.dstu3.model.UnsignedIntType src) throws FHIRException {
        UnsignedIntType tgt = src.hasValue() ? new UnsignedIntType((int)((Integer)src.getValue())) : new UnsignedIntType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.UnsignedIntType convertUnsignedInt(UnsignedIntType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.UnsignedIntType tgt = src.hasValue() ? new org.hl7.fhir.dstu3.model.UnsignedIntType((Integer)src.getValue()) : new org.hl7.fhir.dstu3.model.UnsignedIntType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.UriType convertUri(UriType src) throws FHIRException {
        org.hl7.fhir.r5.model.UriType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.UriType((String)src.getValue()) : new org.hl7.fhir.r5.model.UriType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UriType convertUri(org.hl7.fhir.r5.model.UriType src) throws FHIRException {
        UriType tgt = src.hasValue() ? new UriType((String)src.getValue()) : new UriType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.UriType convertCodeToUri(CodeType src) throws FHIRException {
        org.hl7.fhir.r5.model.UriType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.UriType((String)src.getValue()) : new org.hl7.fhir.r5.model.UriType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static CodeType convertUriToCode(org.hl7.fhir.r5.model.UriType src) throws FHIRException {
        CodeType tgt = src.hasValue() ? new CodeType((String)src.getValue()) : new CodeType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.UuidType convertUuid(UuidType src) throws FHIRException {
        org.hl7.fhir.r5.model.UuidType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.UuidType((String)src.getValue()) : new org.hl7.fhir.r5.model.UuidType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UuidType convertUuid(org.hl7.fhir.r5.model.UuidType src) throws FHIRException {
        UuidType tgt = src.hasValue() ? new UuidType((String)src.getValue()) : new UuidType();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static Extension convertExtension(org.hl7.fhir.dstu3.model.Extension src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Extension tgt = new Extension();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        if (src.hasValue()) {
            if (CANONICAL_URLS.contains(src.getUrl()) && src.getValue() instanceof org.hl7.fhir.dstu3.model.Reference) {
                tgt.setValue(VersionConvertor_30_50.convertReferenceToCanonical((org.hl7.fhir.dstu3.model.Reference)src.getValue()));
            } else {
                tgt.setValue(VersionConvertor_30_50.convertType(src.getValue()));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Extension convertExtension(Extension src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Extension tgt = new org.hl7.fhir.dstu3.model.Extension();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        if (src.hasValue()) {
            if (CANONICAL_URLS.contains(src.getUrl()) && src.getValue() instanceof CanonicalType) {
                tgt.setValue(VersionConvertor_30_50.convertCanonicalToReference((CanonicalType)src.getValue()));
            } else {
                tgt.setValue(VersionConvertor_30_50.convertType(src.getValue()));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Narrative convertNarrative(Narrative src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Narrative tgt = new org.hl7.fhir.r5.model.Narrative();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_30_50.convertNarrativeStatus(src.getStatusElement()));
        }
        if (src.hasDiv()) {
            tgt.setDiv(src.getDiv());
        }
        return tgt;
    }

    public static Narrative convertNarrative(org.hl7.fhir.r5.model.Narrative src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Narrative tgt = new Narrative();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_30_50.convertNarrativeStatus(src.getStatusElement()));
        }
        if (src.hasDiv()) {
            tgt.setDiv(src.getDiv());
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Narrative.NarrativeStatus> convertNarrativeStatus(Enumeration<Narrative.NarrativeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Narrative.NarrativeStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Narrative.NarrativeStatus>(new Narrative.NarrativeStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
        } else {
            switch ((Narrative.NarrativeStatus)((Object)src.getValue())) {
                case GENERATED: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.GENERATED);
                    break;
                }
                case EXTENSIONS: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.EXTENSIONS);
                    break;
                }
                case ADDITIONAL: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.ADDITIONAL);
                    break;
                }
                case EMPTY: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.EMPTY);
                    break;
                }
                default: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Narrative.NarrativeStatus> convertNarrativeStatus(org.hl7.fhir.r5.model.Enumeration<Narrative.NarrativeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Narrative.NarrativeStatus> tgt = new Enumeration<Narrative.NarrativeStatus>(new Narrative.NarrativeStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
        } else {
            switch ((Narrative.NarrativeStatus)((Object)src.getValue())) {
                case GENERATED: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.GENERATED);
                    break;
                }
                case EXTENSIONS: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.EXTENSIONS);
                    break;
                }
                case ADDITIONAL: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.ADDITIONAL);
                    break;
                }
                case EMPTY: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.EMPTY);
                    break;
                }
                default: {
                    tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Age convertAge(Age src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Age tgt = new org.hl7.fhir.r5.model.Age();
        VersionConvertor_30_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static Age convertAge(org.hl7.fhir.r5.model.Age src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Age tgt = new Age();
        VersionConvertor_30_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Annotation convertAnnotation(Annotation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Annotation tgt = new org.hl7.fhir.r5.model.Annotation();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_50.convertType(src.getAuthor()));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(VersionConvertor_30_50.convertDateTime(src.getTimeElement()));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        return tgt;
    }

    public static Annotation convertAnnotation(org.hl7.fhir.r5.model.Annotation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Annotation tgt = new Annotation();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_50.convertType(src.getAuthor()));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(VersionConvertor_30_50.convertDateTime(src.getTimeElement()));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Attachment convertAttachment(Attachment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Attachment tgt = new org.hl7.fhir.r5.model.Attachment();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasContentType()) {
            tgt.setContentTypeElement(VersionConvertor_30_50.convertCode(src.getContentTypeElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_30_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_30_50.convertBase64Binary(src.getDataElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasSize()) {
            tgt.setSize(src.getSize());
        }
        if (src.hasHash()) {
            tgt.setHashElement(VersionConvertor_30_50.convertBase64Binary(src.getHashElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasCreation()) {
            tgt.setCreationElement(VersionConvertor_30_50.convertDateTime(src.getCreationElement()));
        }
        return tgt;
    }

    public static Attachment convertAttachment(org.hl7.fhir.r5.model.Attachment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Attachment tgt = new Attachment();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasContentType()) {
            tgt.setContentTypeElement(VersionConvertor_30_50.convertCode(src.getContentTypeElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_30_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_30_50.convertBase64Binary(src.getDataElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasSize()) {
            tgt.setSize(Math.toIntExact(src.getSize()));
        }
        if (src.hasHash()) {
            tgt.setHashElement(VersionConvertor_30_50.convertBase64Binary(src.getHashElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasCreation()) {
            tgt.setCreationElement(VersionConvertor_30_50.convertDateTime(src.getCreationElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.CodeableConcept convertCodeableConcept(CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.CodeableConcept tgt = new org.hl7.fhir.r5.model.CodeableConcept();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_30_50.convertCoding(t));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_50.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static CodeableConcept convertCodeableConcept(org.hl7.fhir.r5.model.CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeableConcept tgt = new CodeableConcept();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_30_50.convertCoding(t));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_50.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Coding convertCoding(Coding src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Coding tgt = new org.hl7.fhir.r5.model.Coding();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        if (src.hasUserSelected()) {
            tgt.setUserSelectedElement(VersionConvertor_30_50.convertBoolean(src.getUserSelectedElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Coding convertCoding(CodeType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Coding tgt = new org.hl7.fhir.r5.model.Coding();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        tgt.setCode((String)src.getValue());
        return tgt;
    }

    public static org.hl7.fhir.r5.model.CodeableConcept convertCodingToCodeableConcept(Coding src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.CodeableConcept tgt = new org.hl7.fhir.r5.model.CodeableConcept();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.getCodingFirstRep().setSystem(src.getSystem());
        }
        if (src.hasVersion()) {
            tgt.getCodingFirstRep().setVersion(src.getVersion());
        }
        if (src.hasCode()) {
            tgt.getCodingFirstRep().setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.getCodingFirstRep().setDisplay(src.getDisplay());
        }
        if (src.hasUserSelected()) {
            tgt.getCodingFirstRep().setUserSelected(src.getUserSelected());
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Coding convertCoding(CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Coding tgt = new org.hl7.fhir.r5.model.Coding();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCoding()) {
            if (src.getCodingFirstRep().hasSystem()) {
                tgt.setSystem(src.getCodingFirstRep().getSystem());
            }
            if (src.getCodingFirstRep().hasVersion()) {
                tgt.setVersion(src.getCodingFirstRep().getVersion());
            }
            if (src.getCodingFirstRep().hasCode()) {
                tgt.setCode(src.getCodingFirstRep().getCode());
            }
            if (src.getCodingFirstRep().hasDisplay()) {
                tgt.setDisplay(src.getCodingFirstRep().getDisplay());
            }
            if (src.getCodingFirstRep().hasUserSelected()) {
                tgt.setUserSelected(src.getCodingFirstRep().getUserSelected());
            }
        }
        return tgt;
    }

    public static Coding convertCoding(org.hl7.fhir.r5.model.CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coding tgt = new Coding();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCoding()) {
            if (src.getCodingFirstRep().hasSystem()) {
                tgt.setSystem(src.getCodingFirstRep().getSystem());
            }
            if (src.getCodingFirstRep().hasVersion()) {
                tgt.setVersion(src.getCodingFirstRep().getVersion());
            }
            if (src.getCodingFirstRep().hasCode()) {
                tgt.setCode(src.getCodingFirstRep().getCode());
            }
            if (src.getCodingFirstRep().hasDisplay()) {
                tgt.setDisplay(src.getCodingFirstRep().getDisplay());
            }
            if (src.getCodingFirstRep().hasUserSelected()) {
                tgt.setUserSelected(src.getCodingFirstRep().getUserSelected());
            }
        }
        return tgt;
    }

    public static Coding convertCoding(org.hl7.fhir.r5.model.Coding src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coding tgt = new Coding();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        if (src.hasUserSelected()) {
            tgt.setUserSelectedElement(VersionConvertor_30_50.convertBoolean(src.getUserSelectedElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Count convertCount(Count src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Count tgt = new org.hl7.fhir.r5.model.Count();
        VersionConvertor_30_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static Count convertCount(org.hl7.fhir.r5.model.Count src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Count tgt = new Count();
        VersionConvertor_30_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Distance convertDistance(Distance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Distance tgt = new org.hl7.fhir.r5.model.Distance();
        VersionConvertor_30_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static Distance convertDistance(org.hl7.fhir.r5.model.Distance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Distance tgt = new Distance();
        VersionConvertor_30_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static Duration convertDuration(org.hl7.fhir.dstu3.model.Duration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Duration tgt = new Duration();
        VersionConvertor_30_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Duration convertDuration(Duration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Duration tgt = new org.hl7.fhir.dstu3.model.Duration();
        VersionConvertor_30_50.copyQuantity(src, tgt);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Identifier convertIdentifier(Identifier src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Identifier tgt = new org.hl7.fhir.r5.model.Identifier();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_50.convertIdentifierUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertUri(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertString(src.getValueElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_30_50.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static Identifier convertIdentifier(org.hl7.fhir.r5.model.Identifier src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Identifier tgt = new Identifier();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_50.convertIdentifierUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertUri(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertString(src.getValueElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_30_50.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Identifier.IdentifierUse> convertIdentifierUse(Enumeration<Identifier.IdentifierUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Identifier.IdentifierUse> tgt = new org.hl7.fhir.r5.model.Enumeration<Identifier.IdentifierUse>(new Identifier.IdentifierUseEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Identifier.IdentifierUse.NULL);
        } else {
            switch ((Identifier.IdentifierUse)((Object)src.getValue())) {
                case USUAL: {
                    tgt.setValue((Object)Identifier.IdentifierUse.USUAL);
                    break;
                }
                case OFFICIAL: {
                    tgt.setValue((Object)Identifier.IdentifierUse.OFFICIAL);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)Identifier.IdentifierUse.TEMP);
                    break;
                }
                case SECONDARY: {
                    tgt.setValue((Object)Identifier.IdentifierUse.SECONDARY);
                    break;
                }
                default: {
                    tgt.setValue((Object)Identifier.IdentifierUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Identifier.IdentifierUse> convertIdentifierUse(org.hl7.fhir.r5.model.Enumeration<Identifier.IdentifierUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Identifier.IdentifierUse> tgt = new Enumeration<Identifier.IdentifierUse>(new Identifier.IdentifierUseEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Identifier.IdentifierUse.NULL);
        } else {
            switch ((Identifier.IdentifierUse)((Object)src.getValue())) {
                case USUAL: {
                    tgt.setValue((Object)Identifier.IdentifierUse.USUAL);
                    break;
                }
                case OFFICIAL: {
                    tgt.setValue((Object)Identifier.IdentifierUse.OFFICIAL);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)Identifier.IdentifierUse.TEMP);
                    break;
                }
                case SECONDARY: {
                    tgt.setValue((Object)Identifier.IdentifierUse.SECONDARY);
                    break;
                }
                default: {
                    tgt.setValue((Object)Identifier.IdentifierUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Money convertMoney(Money src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Money tgt = new org.hl7.fhir.r5.model.Money();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasCode()) {
            tgt.setCurrencyElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Money convertMoney(org.hl7.fhir.r5.model.Money src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Money tgt = new Money();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasCurrency()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCurrencyElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Period convertPeriod(Period src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Period tgt = new org.hl7.fhir.r5.model.Period();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_50.convertDateTime(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_50.convertDateTime(src.getEndElement()));
        }
        return tgt;
    }

    public static Period convertPeriod(org.hl7.fhir.r5.model.Period src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Period tgt = new Period();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_50.convertDateTime(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_50.convertDateTime(src.getEndElement()));
        }
        return tgt;
    }

    public static void copyQuantity(org.hl7.fhir.dstu3.model.Quantity src, Quantity tgt) throws FHIRException {
        if (src == null || tgt == null) {
            return;
        }
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_30_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_30_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
    }

    public static void copyQuantity(Quantity src, org.hl7.fhir.dstu3.model.Quantity tgt) throws FHIRException {
        if (src == null || tgt == null) {
            return;
        }
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_30_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_30_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
    }

    public static Quantity convertQuantity(org.hl7.fhir.dstu3.model.Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Quantity tgt = new Quantity();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_30_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_30_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Quantity convertQuantity(Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Quantity tgt = new org.hl7.fhir.dstu3.model.Quantity();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_30_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_30_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.QuantityComparator> convertQuantityComparator(Enumeration<Quantity.QuantityComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.QuantityComparator> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.QuantityComparator>(new Enumerations.QuantityComparatorEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.QuantityComparator.NULL);
        } else {
            switch ((Quantity.QuantityComparator)((Object)src.getValue())) {
                case LESS_THAN: {
                    tgt.setValue((Object)Enumerations.QuantityComparator.LESS_THAN);
                    break;
                }
                case LESS_OR_EQUAL: {
                    tgt.setValue((Object)Enumerations.QuantityComparator.LESS_OR_EQUAL);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    tgt.setValue((Object)Enumerations.QuantityComparator.GREATER_OR_EQUAL);
                    break;
                }
                case GREATER_THAN: {
                    tgt.setValue((Object)Enumerations.QuantityComparator.GREATER_THAN);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.QuantityComparator.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Quantity.QuantityComparator> convertQuantityComparator(org.hl7.fhir.r5.model.Enumeration<Enumerations.QuantityComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Quantity.QuantityComparator> tgt = new Enumeration<Quantity.QuantityComparator>(new Quantity.QuantityComparatorEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Quantity.QuantityComparator.NULL);
        } else {
            switch ((Enumerations.QuantityComparator)((Object)src.getValue())) {
                case LESS_THAN: {
                    tgt.setValue((Object)Quantity.QuantityComparator.LESS_THAN);
                    break;
                }
                case LESS_OR_EQUAL: {
                    tgt.setValue((Object)Quantity.QuantityComparator.LESS_OR_EQUAL);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    tgt.setValue((Object)Quantity.QuantityComparator.GREATER_OR_EQUAL);
                    break;
                }
                case GREATER_THAN: {
                    tgt.setValue((Object)Quantity.QuantityComparator.GREATER_THAN);
                    break;
                }
                default: {
                    tgt.setValue((Object)Quantity.QuantityComparator.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Range convertRange(Range src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Range tgt = new org.hl7.fhir.r5.model.Range();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_30_50.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_30_50.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static Range convertRange(org.hl7.fhir.r5.model.Range src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Range tgt = new Range();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_30_50.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_30_50.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Ratio convertRatio(Ratio src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Ratio tgt = new org.hl7.fhir.r5.model.Ratio();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_30_50.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_30_50.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static Ratio convertRatio(org.hl7.fhir.r5.model.Ratio src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Ratio tgt = new Ratio();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_30_50.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_30_50.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static Reference convertReference(org.hl7.fhir.dstu3.model.Reference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Reference tgt = new Reference();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Reference convertReference(Reference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Reference tgt = new org.hl7.fhir.dstu3.model.Reference();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static SampledData convertSampledData(org.hl7.fhir.dstu3.model.SampledData src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SampledData tgt = new SampledData();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_30_50.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_30_50.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(VersionConvertor_30_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasLowerLimit()) {
            tgt.setLowerLimitElement(VersionConvertor_30_50.convertDecimal(src.getLowerLimitElement()));
        }
        if (src.hasUpperLimit()) {
            tgt.setUpperLimitElement(VersionConvertor_30_50.convertDecimal(src.getUpperLimitElement()));
        }
        if (src.hasDimensions()) {
            tgt.setDimensionsElement(VersionConvertor_30_50.convertPositiveInt(src.getDimensionsElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_30_50.convertString(src.getDataElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.SampledData convertSampledData(SampledData src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.SampledData tgt = new org.hl7.fhir.dstu3.model.SampledData();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_30_50.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_30_50.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(VersionConvertor_30_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasLowerLimit()) {
            tgt.setLowerLimitElement(VersionConvertor_30_50.convertDecimal(src.getLowerLimitElement()));
        }
        if (src.hasUpperLimit()) {
            tgt.setUpperLimitElement(VersionConvertor_30_50.convertDecimal(src.getUpperLimitElement()));
        }
        if (src.hasDimensions()) {
            tgt.setDimensionsElement(VersionConvertor_30_50.convertPositiveInt(src.getDimensionsElement()));
        }
        if (src.hasData()) {
            tgt.setDataElement(VersionConvertor_30_50.convertString(src.getDataElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Signature convertSignature(Signature src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Signature tgt = new org.hl7.fhir.r5.model.Signature();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (Coding t : src.getType()) {
            tgt.addType(VersionConvertor_30_50.convertCoding(t));
        }
        if (src.hasWhen()) {
            tgt.setWhenElement(VersionConvertor_30_50.convertInstant(src.getWhenElement()));
        }
        if (src.hasWho()) {
            if (src.hasWhoUriType()) {
                tgt.setWho(new Reference((String)src.getWhoUriType().getValue()));
            } else {
                tgt.setWho(VersionConvertor_30_50.convertReference(src.getWhoReference()));
            }
        }
        if (src.hasOnBehalfOf()) {
            if (src.hasOnBehalfOfUriType()) {
                tgt.setOnBehalfOf(new Reference(src.getOnBehalfOfUriType().primitiveValue()));
            } else {
                tgt.setOnBehalfOf(VersionConvertor_30_50.convertReference(src.getOnBehalfOfReference()));
            }
        }
        if (src.hasContentType()) {
            tgt.setSigFormatElement(VersionConvertor_30_50.convertCode(src.getContentTypeElement()));
        }
        if (src.hasBlob()) {
            tgt.setDataElement(VersionConvertor_30_50.convertBase64Binary(src.getBlobElement()));
        }
        return tgt;
    }

    public static Signature convertSignature(org.hl7.fhir.r5.model.Signature src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Signature tgt = new Signature();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Coding t : src.getType()) {
            tgt.addType(VersionConvertor_30_50.convertCoding(t));
        }
        if (src.hasWhen()) {
            tgt.setWhenElement(VersionConvertor_30_50.convertInstant(src.getWhenElement()));
        }
        if (src.hasWho()) {
            tgt.setWho(VersionConvertor_30_50.convertType(src.getWho()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VersionConvertor_30_50.convertType(src.getOnBehalfOf()));
        }
        if (src.hasSigFormat()) {
            tgt.setContentTypeElement(VersionConvertor_30_50.convertCode(src.getSigFormatElement()));
        }
        if (src.hasData()) {
            tgt.setBlobElement(VersionConvertor_30_50.convertBase64Binary(src.getDataElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Address convertAddress(Address src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Address tgt = new org.hl7.fhir.r5.model.Address();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_50.convertAddressUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertAddressType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_50.convertString(src.getTextElement()));
        }
        for (StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCity()) {
            tgt.setCityElement(VersionConvertor_30_50.convertString(src.getCityElement()));
        }
        if (src.hasDistrict()) {
            tgt.setDistrictElement(VersionConvertor_30_50.convertString(src.getDistrictElement()));
        }
        if (src.hasState()) {
            tgt.setStateElement(VersionConvertor_30_50.convertString(src.getStateElement()));
        }
        if (src.hasPostalCode()) {
            tgt.setPostalCodeElement(VersionConvertor_30_50.convertString(src.getPostalCodeElement()));
        }
        if (src.hasCountry()) {
            tgt.setCountryElement(VersionConvertor_30_50.convertString(src.getCountryElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Address convertAddress(org.hl7.fhir.r5.model.Address src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Address tgt = new Address();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_50.convertAddressUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertAddressType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_50.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.r5.model.StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCity()) {
            tgt.setCityElement(VersionConvertor_30_50.convertString(src.getCityElement()));
        }
        if (src.hasDistrict()) {
            tgt.setDistrictElement(VersionConvertor_30_50.convertString(src.getDistrictElement()));
        }
        if (src.hasState()) {
            tgt.setStateElement(VersionConvertor_30_50.convertString(src.getStateElement()));
        }
        if (src.hasPostalCode()) {
            tgt.setPostalCodeElement(VersionConvertor_30_50.convertString(src.getPostalCodeElement()));
        }
        if (src.hasCountry()) {
            tgt.setCountryElement(VersionConvertor_30_50.convertString(src.getCountryElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Address.AddressUse> convertAddressUse(Enumeration<Address.AddressUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Address.AddressUse> tgt = new org.hl7.fhir.r5.model.Enumeration<Address.AddressUse>(new Address.AddressUseEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Address.AddressUse.NULL);
        } else {
            switch ((Address.AddressUse)((Object)src.getValue())) {
                case HOME: {
                    tgt.setValue((Object)Address.AddressUse.HOME);
                    break;
                }
                case WORK: {
                    tgt.setValue((Object)Address.AddressUse.WORK);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)Address.AddressUse.TEMP);
                    break;
                }
                case OLD: {
                    tgt.setValue((Object)Address.AddressUse.OLD);
                    break;
                }
                default: {
                    tgt.setValue((Object)Address.AddressUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Address.AddressUse> convertAddressUse(org.hl7.fhir.r5.model.Enumeration<Address.AddressUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Address.AddressUse> tgt = new Enumeration<Address.AddressUse>(new Address.AddressUseEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Address.AddressUse.NULL);
        } else {
            switch ((Address.AddressUse)((Object)src.getValue())) {
                case HOME: {
                    tgt.setValue((Object)Address.AddressUse.HOME);
                    break;
                }
                case WORK: {
                    tgt.setValue((Object)Address.AddressUse.WORK);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)Address.AddressUse.TEMP);
                    break;
                }
                case OLD: {
                    tgt.setValue((Object)Address.AddressUse.OLD);
                    break;
                }
                default: {
                    tgt.setValue((Object)Address.AddressUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Address.AddressType> convertAddressType(Enumeration<Address.AddressType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Address.AddressType> tgt = new org.hl7.fhir.r5.model.Enumeration<Address.AddressType>(new Address.AddressTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Address.AddressType.NULL);
        } else {
            switch ((Address.AddressType)((Object)src.getValue())) {
                case POSTAL: {
                    tgt.setValue((Object)Address.AddressType.POSTAL);
                    break;
                }
                case PHYSICAL: {
                    tgt.setValue((Object)Address.AddressType.PHYSICAL);
                    break;
                }
                case BOTH: {
                    tgt.setValue((Object)Address.AddressType.BOTH);
                    break;
                }
                default: {
                    tgt.setValue((Object)Address.AddressType.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Address.AddressType> convertAddressType(org.hl7.fhir.r5.model.Enumeration<Address.AddressType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Address.AddressType> tgt = new Enumeration<Address.AddressType>(new Address.AddressTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Address.AddressType.NULL);
        } else {
            switch ((Address.AddressType)((Object)src.getValue())) {
                case POSTAL: {
                    tgt.setValue((Object)Address.AddressType.POSTAL);
                    break;
                }
                case PHYSICAL: {
                    tgt.setValue((Object)Address.AddressType.PHYSICAL);
                    break;
                }
                case BOTH: {
                    tgt.setValue((Object)Address.AddressType.BOTH);
                    break;
                }
                default: {
                    tgt.setValue((Object)Address.AddressType.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.ContactDetail convertContactDetail(ContactDetail src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ContactDetail tgt = new org.hl7.fhir.r5.model.ContactDetail();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertContactDetail(org.hl7.fhir.r5.model.ContactDetail src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactPoint convertContactPoint(org.hl7.fhir.dstu3.model.ContactPoint src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ContactPoint tgt = new ContactPoint();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertContactPointSystem(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertString(src.getValueElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_50.convertContactPointUse(src.getUseElement()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_30_50.convertPositiveInt(src.getRankElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ContactPoint convertContactPoint(ContactPoint src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ContactPoint tgt = new org.hl7.fhir.dstu3.model.ContactPoint();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertContactPointSystem(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertString(src.getValueElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_50.convertContactPointUse(src.getUseElement()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_30_50.convertPositiveInt(src.getRankElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointSystem> convertContactPointSystem(Enumeration<ContactPoint.ContactPointSystem> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointSystem> tgt = new org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointSystem>(new ContactPoint.ContactPointSystemEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
        } else {
            switch ((ContactPoint.ContactPointSystem)((Object)src.getValue())) {
                case PHONE: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.PHONE);
                    break;
                }
                case FAX: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.FAX);
                    break;
                }
                case EMAIL: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.EMAIL);
                    break;
                }
                case PAGER: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.PAGER);
                    break;
                }
                case URL: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.URL);
                    break;
                }
                case SMS: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.SMS);
                    break;
                }
                case OTHER: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.OTHER);
                    break;
                }
                default: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<ContactPoint.ContactPointSystem> convertContactPointSystem(org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointSystem> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ContactPoint.ContactPointSystem> tgt = new Enumeration<ContactPoint.ContactPointSystem>(new ContactPoint.ContactPointSystemEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
        } else {
            switch ((ContactPoint.ContactPointSystem)((Object)src.getValue())) {
                case PHONE: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.PHONE);
                    break;
                }
                case FAX: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.FAX);
                    break;
                }
                case EMAIL: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.EMAIL);
                    break;
                }
                case PAGER: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.PAGER);
                    break;
                }
                case URL: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.URL);
                    break;
                }
                case SMS: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.SMS);
                    break;
                }
                case OTHER: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.OTHER);
                    break;
                }
                default: {
                    tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointUse> convertContactPointUse(Enumeration<ContactPoint.ContactPointUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointUse> tgt = new org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointUse>(new ContactPoint.ContactPointUseEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
        } else {
            switch ((ContactPoint.ContactPointUse)((Object)src.getValue())) {
                case HOME: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.HOME);
                    break;
                }
                case WORK: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.WORK);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.TEMP);
                    break;
                }
                case OLD: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.OLD);
                    break;
                }
                case MOBILE: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.MOBILE);
                    break;
                }
                default: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<ContactPoint.ContactPointUse> convertContactPointUse(org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ContactPoint.ContactPointUse> tgt = new Enumeration<ContactPoint.ContactPointUse>(new ContactPoint.ContactPointUseEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
        } else {
            switch ((ContactPoint.ContactPointUse)((Object)src.getValue())) {
                case HOME: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.HOME);
                    break;
                }
                case WORK: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.WORK);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.TEMP);
                    break;
                }
                case OLD: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.OLD);
                    break;
                }
                case MOBILE: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.MOBILE);
                    break;
                }
                default: {
                    tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static Contributor convertContributor(org.hl7.fhir.dstu3.model.Contributor src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contributor tgt = new Contributor();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertContributorType(src.getTypeElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Contributor convertContributor(Contributor src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Contributor tgt = new org.hl7.fhir.dstu3.model.Contributor();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertContributorType(src.getTypeElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r5.model.ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Contributor.ContributorType> convertContributorType(Enumeration<Contributor.ContributorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Contributor.ContributorType> tgt = new org.hl7.fhir.r5.model.Enumeration<Contributor.ContributorType>(new Contributor.ContributorTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Contributor.ContributorType.NULL);
        } else {
            switch ((Contributor.ContributorType)((Object)src.getValue())) {
                case AUTHOR: {
                    tgt.setValue((Object)Contributor.ContributorType.AUTHOR);
                    break;
                }
                case EDITOR: {
                    tgt.setValue((Object)Contributor.ContributorType.EDITOR);
                    break;
                }
                case REVIEWER: {
                    tgt.setValue((Object)Contributor.ContributorType.REVIEWER);
                    break;
                }
                case ENDORSER: {
                    tgt.setValue((Object)Contributor.ContributorType.ENDORSER);
                    break;
                }
                default: {
                    tgt.setValue((Object)Contributor.ContributorType.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Contributor.ContributorType> convertContributorType(org.hl7.fhir.r5.model.Enumeration<Contributor.ContributorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Contributor.ContributorType> tgt = new Enumeration<Contributor.ContributorType>(new Contributor.ContributorTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Contributor.ContributorType.NULL);
        } else {
            switch ((Contributor.ContributorType)((Object)src.getValue())) {
                case AUTHOR: {
                    tgt.setValue((Object)Contributor.ContributorType.AUTHOR);
                    break;
                }
                case EDITOR: {
                    tgt.setValue((Object)Contributor.ContributorType.EDITOR);
                    break;
                }
                case REVIEWER: {
                    tgt.setValue((Object)Contributor.ContributorType.REVIEWER);
                    break;
                }
                case ENDORSER: {
                    tgt.setValue((Object)Contributor.ContributorType.ENDORSER);
                    break;
                }
                default: {
                    tgt.setValue((Object)Contributor.ContributorType.NULL);
                }
            }
        }
        return tgt;
    }

    public static Dosage convertDosage(org.hl7.fhir.dstu3.model.Dosage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Dosage tgt = new Dosage();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(VersionConvertor_30_50.convertInteger(src.getSequenceElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_50.convertString(src.getTextElement()));
        }
        for (CodeableConcept t : src.getAdditionalInstruction()) {
            tgt.addAdditionalInstruction(VersionConvertor_30_50.convertCodeableConcept(t));
        }
        if (src.hasPatientInstruction()) {
            tgt.setPatientInstructionElement(VersionConvertor_30_50.convertString(src.getPatientInstructionElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_50.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_30_50.convertType(src.getAsNeeded()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_50.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose() || src.hasRate()) {
            Dosage.DosageDoseAndRateComponent dr = tgt.addDoseAndRate();
            if (src.hasDose()) {
                dr.setDose(VersionConvertor_30_50.convertType(src.getDose()));
            }
            if (src.hasRate()) {
                dr.setRate(VersionConvertor_30_50.convertType(src.getRate()));
            }
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_30_50.convertRatio(src.getMaxDosePerPeriod()));
        }
        if (src.hasMaxDosePerAdministration()) {
            tgt.setMaxDosePerAdministration(VersionConvertor_30_50.convertSimpleQuantity(src.getMaxDosePerAdministration()));
        }
        if (src.hasMaxDosePerLifetime()) {
            tgt.setMaxDosePerLifetime(VersionConvertor_30_50.convertSimpleQuantity(src.getMaxDosePerLifetime()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Dosage convertDosage(Dosage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Dosage tgt = new org.hl7.fhir.dstu3.model.Dosage();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(VersionConvertor_30_50.convertInteger(src.getSequenceElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_50.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept t : src.getAdditionalInstruction()) {
            tgt.addAdditionalInstruction(VersionConvertor_30_50.convertCodeableConcept(t));
        }
        if (src.hasPatientInstruction()) {
            tgt.setPatientInstructionElement(VersionConvertor_30_50.convertString(src.getPatientInstructionElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_50.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_30_50.convertType(src.getAsNeeded()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_50.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDoseAndRate() && src.getDoseAndRate().get(0).hasDose()) {
            tgt.setDose(VersionConvertor_30_50.convertType(src.getDoseAndRate().get(0).getDose()));
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_30_50.convertRatio(src.getMaxDosePerPeriod()));
        }
        if (src.hasMaxDosePerAdministration()) {
            tgt.setMaxDosePerAdministration(VersionConvertor_30_50.convertSimpleQuantity(src.getMaxDosePerAdministration()));
        }
        if (src.hasMaxDosePerLifetime()) {
            tgt.setMaxDosePerLifetime(VersionConvertor_30_50.convertSimpleQuantity(src.getMaxDosePerLifetime()));
        }
        if (src.hasDoseAndRate() && src.getDoseAndRate().get(0).hasRate()) {
            tgt.setRate(VersionConvertor_30_50.convertType(src.getDoseAndRate().get(0).getRate()));
        }
        return tgt;
    }

    public static ElementDefinition convertElementDefinition(org.hl7.fhir.dstu3.model.ElementDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition tgt = new ElementDefinition();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_50.convertString(src.getPathElement()));
        }
        tgt.setRepresentation(src.getRepresentation().stream().map(VersionConvertor_30_50::convertPropertyRepresentation).collect(Collectors.toList()));
        if (src.hasSliceName()) {
            tgt.setSliceNameElement(VersionConvertor_30_50.convertString(src.getSliceNameElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_50.convertString(src.getLabelElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_30_50.convertCoding(coding));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_30_50.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShort()) {
            tgt.setShortElement(VersionConvertor_30_50.convertString(src.getShortElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_30_50.convertMarkdown(src.getDefinitionElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertMarkdown(src.getCommentElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_30_50.convertMarkdown(src.getRequirementsElement()));
        }
        for (StringType stringType : src.getAlias()) {
            tgt.addAlias((String)stringType.getValue());
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_50.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_50.convertString(src.getMaxElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_30_50.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setContentReferenceElement(VersionConvertor_30_50.convertUri(src.getContentReferenceElement()));
        }
        for (ElementDefinition.TypeRefComponent typeRefComponent : src.getType()) {
            VersionConvertor_30_50.convertTypeRefComponent(typeRefComponent, tgt.getType());
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_30_50.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissingElement(VersionConvertor_30_50.convertMarkdown(src.getMeaningWhenMissingElement()));
        }
        if (src.hasOrderMeaning()) {
            tgt.setOrderMeaningElement(VersionConvertor_30_50.convertString(src.getOrderMeaningElement()));
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_30_50.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_30_50.convertType(src.getPattern()));
        }
        for (ElementDefinition.ElementDefinitionExampleComponent elementDefinitionExampleComponent : src.getExample()) {
            tgt.addExample(VersionConvertor_30_50.convertElementDefinitionExampleComponent(elementDefinitionExampleComponent));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_30_50.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_30_50.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_30_50.convertInteger(src.getMaxLengthElement()));
        }
        for (org.hl7.fhir.dstu3.model.IdType idType : src.getCondition()) {
            tgt.addCondition(idType.getValue());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_30_50.convertElementDefinitionConstraintComponent(elementDefinitionConstraintComponent));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupportElement(VersionConvertor_30_50.convertBoolean(src.getMustSupportElement()));
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifierElement(VersionConvertor_30_50.convertBoolean(src.getIsModifierElement()));
        }
        if (tgt.getIsModifier()) {
            String reason = ToolingExtensions.readStringExtension(src, "http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.isModifierReason");
            if (Utilities.noString(reason)) {
                reason = "No Modifier Reason provideed in previous versions of FHIR";
            }
            tgt.setIsModifierReason(reason);
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummaryElement(VersionConvertor_30_50.convertBoolean(src.getIsSummaryElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_30_50.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(VersionConvertor_30_50.convertElementDefinitionMappingComponent(elementDefinitionMappingComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ElementDefinition convertElementDefinition(ElementDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ElementDefinition tgt = new org.hl7.fhir.dstu3.model.ElementDefinition();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_50.convertString(src.getPathElement()));
        }
        tgt.setRepresentation(src.getRepresentation().stream().map(VersionConvertor_30_50::convertPropertyRepresentation).collect(Collectors.toList()));
        if (src.hasSliceName()) {
            tgt.setSliceNameElement(VersionConvertor_30_50.convertString(src.getSliceNameElement()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_50.convertString(src.getLabelElement()));
        }
        for (org.hl7.fhir.r5.model.Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_30_50.convertCoding(coding));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_30_50.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShort()) {
            tgt.setShortElement(VersionConvertor_30_50.convertString(src.getShortElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_30_50.convertMarkdown(src.getDefinitionElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertMarkdown(src.getCommentElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_30_50.convertMarkdown(src.getRequirementsElement()));
        }
        for (org.hl7.fhir.r5.model.StringType stringType : src.getAlias()) {
            tgt.addAlias((String)stringType.getValue());
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_50.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_50.convertString(src.getMaxElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_30_50.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setContentReferenceElement(VersionConvertor_30_50.convertUri(src.getContentReferenceElement()));
        }
        for (ElementDefinition.TypeRefComponent typeRefComponent : src.getType()) {
            VersionConvertor_30_50.convertTypeRefComponent(typeRefComponent, tgt.getType());
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_30_50.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissingElement(VersionConvertor_30_50.convertMarkdown(src.getMeaningWhenMissingElement()));
        }
        if (src.hasOrderMeaning()) {
            tgt.setOrderMeaningElement(VersionConvertor_30_50.convertString(src.getOrderMeaningElement()));
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_30_50.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_30_50.convertType(src.getPattern()));
        }
        for (ElementDefinition.ElementDefinitionExampleComponent elementDefinitionExampleComponent : src.getExample()) {
            tgt.addExample(VersionConvertor_30_50.convertElementDefinitionExampleComponent(elementDefinitionExampleComponent));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_30_50.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_30_50.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_30_50.convertInteger(src.getMaxLengthElement()));
        }
        for (IdType idType : src.getCondition()) {
            tgt.addCondition(idType.getValue());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_30_50.convertElementDefinitionConstraintComponent(elementDefinitionConstraintComponent));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupportElement(VersionConvertor_30_50.convertBoolean(src.getMustSupportElement()));
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifierElement(VersionConvertor_30_50.convertBoolean(src.getIsModifierElement()));
        }
        if (src.hasIsModifierReason() && !"No Modifier Reason provideed in previous versions of FHIR".equals(src.getIsModifierReason())) {
            ToolingExtensions.setStringExtension(tgt, "http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.isModifierReason", src.getIsModifierReason());
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummaryElement(VersionConvertor_30_50.convertBoolean(src.getIsSummaryElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_30_50.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(VersionConvertor_30_50.convertElementDefinitionMappingComponent(elementDefinitionMappingComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ElementDefinition.PropertyRepresentation> convertPropertyRepresentation(Enumeration<ElementDefinition.PropertyRepresentation> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ElementDefinition.PropertyRepresentation> tgt = new org.hl7.fhir.r5.model.Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
        } else {
            switch ((ElementDefinition.PropertyRepresentation)((Object)src.getValue())) {
                case XMLATTR: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLATTR);
                    break;
                }
                case XMLTEXT: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLTEXT);
                    break;
                }
                case TYPEATTR: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.TYPEATTR);
                    break;
                }
                case CDATEXT: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.CDATEXT);
                    break;
                }
                case XHTML: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XHTML);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.PropertyRepresentation> convertPropertyRepresentation(org.hl7.fhir.r5.model.Enumeration<ElementDefinition.PropertyRepresentation> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.PropertyRepresentation> tgt = new Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
        } else {
            switch ((ElementDefinition.PropertyRepresentation)((Object)src.getValue())) {
                case XMLATTR: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLATTR);
                    break;
                }
                case XMLTEXT: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLTEXT);
                    break;
                }
                case TYPEATTR: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.TYPEATTR);
                    break;
                }
                case CDATEXT: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.CDATEXT);
                    break;
                }
                case XHTML: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XHTML);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
                }
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : src.getDiscriminator()) {
            tgt.addDiscriminator(VersionConvertor_30_50.convertElementDefinitionSlicingDiscriminatorComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasOrdered()) {
            tgt.setOrderedElement(VersionConvertor_30_50.convertBoolean(src.getOrderedElement()));
        }
        if (src.hasRules()) {
            tgt.setRulesElement(VersionConvertor_30_50.convertSlicingRules(src.getRulesElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : src.getDiscriminator()) {
            tgt.addDiscriminator(VersionConvertor_30_50.convertElementDefinitionSlicingDiscriminatorComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasOrdered()) {
            tgt.setOrderedElement(VersionConvertor_30_50.convertBoolean(src.getOrderedElement()));
        }
        if (src.hasRules()) {
            tgt.setRulesElement(VersionConvertor_30_50.convertSlicingRules(src.getRulesElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ElementDefinition.SlicingRules> convertSlicingRules(Enumeration<ElementDefinition.SlicingRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ElementDefinition.SlicingRules> tgt = new org.hl7.fhir.r5.model.Enumeration<ElementDefinition.SlicingRules>(new ElementDefinition.SlicingRulesEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
        } else {
            switch ((ElementDefinition.SlicingRules)((Object)src.getValue())) {
                case CLOSED: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.CLOSED);
                    break;
                }
                case OPEN: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.OPEN);
                    break;
                }
                case OPENATEND: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.OPENATEND);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.SlicingRules> convertSlicingRules(org.hl7.fhir.r5.model.Enumeration<ElementDefinition.SlicingRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.SlicingRules> tgt = new Enumeration<ElementDefinition.SlicingRules>(new ElementDefinition.SlicingRulesEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
        } else {
            switch ((ElementDefinition.SlicingRules)((Object)src.getValue())) {
                case CLOSED: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.CLOSED);
                    break;
                }
                case OPEN: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.OPEN);
                    break;
                }
                case OPENATEND: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.OPENATEND);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
                }
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent convertElementDefinitionSlicingDiscriminatorComponent(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent tgt = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertDiscriminatorType(src.getTypeElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_50.convertString(src.getPathElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent convertElementDefinitionSlicingDiscriminatorComponent(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent tgt = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertDiscriminatorType(src.getTypeElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_50.convertString(src.getPathElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ElementDefinition.DiscriminatorType> convertDiscriminatorType(Enumeration<ElementDefinition.DiscriminatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ElementDefinition.DiscriminatorType> tgt = new org.hl7.fhir.r5.model.Enumeration<ElementDefinition.DiscriminatorType>(new ElementDefinition.DiscriminatorTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.DiscriminatorType.NULL);
        } else {
            switch ((ElementDefinition.DiscriminatorType)((Object)src.getValue())) {
                case VALUE: {
                    tgt.setValue((Object)ElementDefinition.DiscriminatorType.VALUE);
                    break;
                }
                case EXISTS: {
                    tgt.setValue((Object)ElementDefinition.DiscriminatorType.EXISTS);
                    break;
                }
                case PATTERN: {
                    tgt.setValue((Object)ElementDefinition.DiscriminatorType.PATTERN);
                    break;
                }
                case TYPE: {
                    tgt.setValue((Object)ElementDefinition.DiscriminatorType.TYPE);
                    break;
                }
                case PROFILE: {
                    tgt.setValue((Object)ElementDefinition.DiscriminatorType.PROFILE);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.DiscriminatorType.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.DiscriminatorType> convertDiscriminatorType(org.hl7.fhir.r5.model.Enumeration<ElementDefinition.DiscriminatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.DiscriminatorType> tgt = new Enumeration<ElementDefinition.DiscriminatorType>(new ElementDefinition.DiscriminatorTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.DiscriminatorType.NULL);
        } else {
            switch ((ElementDefinition.DiscriminatorType)((Object)src.getValue())) {
                case VALUE: {
                    tgt.setValue((Object)ElementDefinition.DiscriminatorType.VALUE);
                    break;
                }
                case EXISTS: {
                    tgt.setValue((Object)ElementDefinition.DiscriminatorType.EXISTS);
                    break;
                }
                case PATTERN: {
                    tgt.setValue((Object)ElementDefinition.DiscriminatorType.PATTERN);
                    break;
                }
                case TYPE: {
                    tgt.setValue((Object)ElementDefinition.DiscriminatorType.TYPE);
                    break;
                }
                case PROFILE: {
                    tgt.setValue((Object)ElementDefinition.DiscriminatorType.PROFILE);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.DiscriminatorType.NULL);
                }
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_50.convertString(src.getPathElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_50.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_50.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_50.convertString(src.getPathElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_50.convertUnsignedInt(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_50.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static void convertTypeRefComponent(ElementDefinition.TypeRefComponent src, List<ElementDefinition.TypeRefComponent> list) throws FHIRException {
        if (src == null) {
            return;
        }
        ElementDefinition.TypeRefComponent tgt = null;
        for (ElementDefinition.TypeRefComponent typeRefComponent : list) {
            if (!typeRefComponent.getCode().equals(src.getCode())) continue;
            tgt = typeRefComponent;
        }
        if (tgt == null) {
            tgt = new ElementDefinition.TypeRefComponent();
            list.add(tgt);
            VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
            tgt.setCodeElement(VersionConvertor_30_50.convertUri(src.getCodeElement()));
        }
        if (src.hasProfile()) {
            boolean found = false;
            for (CanonicalType p : tgt.getProfile()) {
                if (!p.equals(src.getProfile())) continue;
                found = true;
            }
            if (!found) {
                tgt.addProfile(src.getProfile());
            }
        }
        if (src.hasTargetProfile()) {
            tgt.addTargetProfile(src.getTargetProfile());
        }
        for (Enumeration enumeration : src.getAggregation()) {
            org.hl7.fhir.r5.model.Enumeration<ElementDefinition.AggregationMode> a = VersionConvertor_30_50.convertAggregationMode(enumeration);
            if (tgt.hasAggregation((ElementDefinition.AggregationMode)((Object)a.getValue()))) continue;
            VersionConvertor_30_50.copyElement(enumeration, tgt.addAggregation((ElementDefinition.AggregationMode)((Object)a.getValue())), new String[0]);
        }
        if (src.hasVersioning()) {
            tgt.setVersioningElement(VersionConvertor_30_50.convertReferenceVersionRules(src.getVersioningElement()));
        }
    }

    public static void convertTypeRefComponent(ElementDefinition.TypeRefComponent src, List<ElementDefinition.TypeRefComponent> list) throws FHIRException {
        if (src == null) {
            return;
        }
        ElementDefinition.TypeRefComponent tgt = new ElementDefinition.TypeRefComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        tgt.setCodeElement(VersionConvertor_30_50.convertUri(src.getCodeElement()));
        list.add(tgt);
        if (src.hasTarget()) {
            if (src.hasProfile()) {
                tgt.setProfile((String)src.getProfile().get(0).getValue());
            }
            for (org.hl7.fhir.r5.model.UriType uriType : src.getTargetProfile()) {
                if (tgt.hasTargetProfile()) {
                    tgt = new ElementDefinition.TypeRefComponent();
                    list.add(tgt);
                    VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
                    tgt.setCode(src.getCode());
                    if (src.hasProfile()) {
                        tgt.setProfile((String)src.getProfile().get(0).getValue());
                    }
                }
                tgt.setTargetProfile((String)uriType.getValue());
            }
        } else {
            for (org.hl7.fhir.r5.model.UriType uriType : src.getProfile()) {
                if (tgt.hasProfile()) {
                    tgt = new ElementDefinition.TypeRefComponent();
                    list.add(tgt);
                    VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
                    tgt.setCode(src.getCode());
                }
                tgt.setProfile((String)uriType.getValue());
            }
        }
    }

    public static org.hl7.fhir.r5.model.Enumeration<ElementDefinition.AggregationMode> convertAggregationMode(Enumeration<ElementDefinition.AggregationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ElementDefinition.AggregationMode> tgt = new org.hl7.fhir.r5.model.Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
        } else {
            switch ((ElementDefinition.AggregationMode)((Object)src.getValue())) {
                case CONTAINED: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.CONTAINED);
                    break;
                }
                case REFERENCED: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.REFERENCED);
                    break;
                }
                case BUNDLED: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.BUNDLED);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.AggregationMode> convertAggregationMode(org.hl7.fhir.r5.model.Enumeration<ElementDefinition.AggregationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.AggregationMode> tgt = new Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
        } else {
            switch ((ElementDefinition.AggregationMode)((Object)src.getValue())) {
                case CONTAINED: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.CONTAINED);
                    break;
                }
                case REFERENCED: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.REFERENCED);
                    break;
                }
                case BUNDLED: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.BUNDLED);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ElementDefinition.ReferenceVersionRules> convertReferenceVersionRules(Enumeration<ElementDefinition.ReferenceVersionRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ElementDefinition.ReferenceVersionRules> tgt = new org.hl7.fhir.r5.model.Enumeration<ElementDefinition.ReferenceVersionRules>(new ElementDefinition.ReferenceVersionRulesEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.NULL);
        } else {
            switch ((ElementDefinition.ReferenceVersionRules)((Object)src.getValue())) {
                case EITHER: {
                    tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.EITHER);
                    break;
                }
                case INDEPENDENT: {
                    tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.INDEPENDENT);
                    break;
                }
                case SPECIFIC: {
                    tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.SPECIFIC);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.ReferenceVersionRules> convertReferenceVersionRules(org.hl7.fhir.r5.model.Enumeration<ElementDefinition.ReferenceVersionRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.ReferenceVersionRules> tgt = new Enumeration<ElementDefinition.ReferenceVersionRules>(new ElementDefinition.ReferenceVersionRulesEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.NULL);
        } else {
            switch ((ElementDefinition.ReferenceVersionRules)((Object)src.getValue())) {
                case EITHER: {
                    tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.EITHER);
                    break;
                }
                case INDEPENDENT: {
                    tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.INDEPENDENT);
                    break;
                }
                case SPECIFIC: {
                    tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.SPECIFIC);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.ReferenceVersionRules.NULL);
                }
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionExampleComponent convertElementDefinitionExampleComponent(ElementDefinition.ElementDefinitionExampleComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionExampleComponent tgt = new ElementDefinition.ElementDefinitionExampleComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_50.convertString(src.getLabelElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionExampleComponent convertElementDefinitionExampleComponent(ElementDefinition.ElementDefinitionExampleComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionExampleComponent tgt = new ElementDefinition.ElementDefinitionExampleComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_50.convertString(src.getLabelElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasKey()) {
            tgt.setKeyElement(VersionConvertor_30_50.convertId(src.getKeyElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_30_50.convertString(src.getRequirementsElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(VersionConvertor_30_50.convertConstraintSeverity(src.getSeverityElement()));
        }
        if (src.hasHuman()) {
            tgt.setHumanElement(VersionConvertor_30_50.convertString(src.getHumanElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_50.convertString(src.getExpressionElement()));
        }
        if (src.hasXpath()) {
            tgt.setXpathElement(VersionConvertor_30_50.convertString(src.getXpathElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(src.getSource());
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasKey()) {
            tgt.setKeyElement(VersionConvertor_30_50.convertId(src.getKeyElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_30_50.convertString(src.getRequirementsElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(VersionConvertor_30_50.convertConstraintSeverity(src.getSeverityElement()));
        }
        if (src.hasHuman()) {
            tgt.setHumanElement(VersionConvertor_30_50.convertString(src.getHumanElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_50.convertString(src.getExpressionElement()));
        }
        if (src.hasXpath()) {
            tgt.setXpathElement(VersionConvertor_30_50.convertString(src.getXpathElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(src.getSource());
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ElementDefinition.ConstraintSeverity> convertConstraintSeverity(Enumeration<ElementDefinition.ConstraintSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ElementDefinition.ConstraintSeverity> tgt = new org.hl7.fhir.r5.model.Enumeration<ElementDefinition.ConstraintSeverity>(new ElementDefinition.ConstraintSeverityEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
        } else {
            switch ((ElementDefinition.ConstraintSeverity)((Object)src.getValue())) {
                case ERROR: {
                    tgt.setValue((Object)ElementDefinition.ConstraintSeverity.ERROR);
                    break;
                }
                case WARNING: {
                    tgt.setValue((Object)ElementDefinition.ConstraintSeverity.WARNING);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.ConstraintSeverity> convertConstraintSeverity(org.hl7.fhir.r5.model.Enumeration<ElementDefinition.ConstraintSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.ConstraintSeverity> tgt = new Enumeration<ElementDefinition.ConstraintSeverity>(new ElementDefinition.ConstraintSeverityEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
        } else {
            switch ((ElementDefinition.ConstraintSeverity)((Object)src.getValue())) {
                case ERROR: {
                    tgt.setValue((Object)ElementDefinition.ConstraintSeverity.ERROR);
                    break;
                }
                case WARNING: {
                    tgt.setValue((Object)ElementDefinition.ConstraintSeverity.WARNING);
                    break;
                }
                default: {
                    tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
                }
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_30_50.copyElement(src, tgt, EXT_SRC_TYPE);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_30_50.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasValueSet()) {
            DataType t = VersionConvertor_30_50.convertType(src.getValueSet());
            if (t instanceof Reference) {
                tgt.setValueSet(((Reference)t).getReference());
                tgt.getValueSetElement().addExtension(EXT_SRC_TYPE, new org.hl7.fhir.r5.model.UriType("Reference"));
            } else {
                tgt.setValueSet(t.primitiveValue());
                tgt.getValueSetElement().addExtension(EXT_SRC_TYPE, new org.hl7.fhir.r5.model.UriType("uri"));
            }
            tgt.setValueSet(VersionConvertorConstants.refToVS(tgt.getValueSet()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_30_50.copyElement(src, tgt, EXT_SRC_TYPE);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_30_50.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasValueSet()) {
            Extension ex = src.getValueSetElement().getExtensionByUrl(EXT_SRC_TYPE);
            String vsr = VersionConvertorConstants.vsToRef(src.getValueSet());
            if (ex != null) {
                if ("uri".equals(ex.getValue().primitiveValue())) {
                    tgt.setValueSet(new UriType(vsr == null ? src.getValueSet() : vsr));
                } else {
                    tgt.setValueSet(new org.hl7.fhir.dstu3.model.Reference(src.getValueSet()));
                }
            } else if (vsr != null) {
                tgt.setValueSet(new UriType(vsr));
            } else {
                tgt.setValueSet(new org.hl7.fhir.dstu3.model.Reference(src.getValueSet()));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.BindingStrength> convertBindingStrength(Enumeration<Enumerations.BindingStrength> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.BindingStrength> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.BindingStrength.NULL);
        } else {
            switch ((Enumerations.BindingStrength)((Object)src.getValue())) {
                case REQUIRED: {
                    tgt.setValue((Object)Enumerations.BindingStrength.REQUIRED);
                    break;
                }
                case EXTENSIBLE: {
                    tgt.setValue((Object)Enumerations.BindingStrength.EXTENSIBLE);
                    break;
                }
                case PREFERRED: {
                    tgt.setValue((Object)Enumerations.BindingStrength.PREFERRED);
                    break;
                }
                case EXAMPLE: {
                    tgt.setValue((Object)Enumerations.BindingStrength.EXAMPLE);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.BindingStrength.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.BindingStrength> convertBindingStrength(org.hl7.fhir.r5.model.Enumeration<Enumerations.BindingStrength> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.BindingStrength> tgt = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.BindingStrength.NULL);
        } else {
            switch ((Enumerations.BindingStrength)((Object)src.getValue())) {
                case REQUIRED: {
                    tgt.setValue((Object)Enumerations.BindingStrength.REQUIRED);
                    break;
                }
                case EXTENSIBLE: {
                    tgt.setValue((Object)Enumerations.BindingStrength.EXTENSIBLE);
                    break;
                }
                case PREFERRED: {
                    tgt.setValue((Object)Enumerations.BindingStrength.PREFERRED);
                    break;
                }
                case EXAMPLE: {
                    tgt.setValue((Object)Enumerations.BindingStrength.EXAMPLE);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.BindingStrength.NULL);
                }
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentity()) {
            tgt.setIdentityElement(VersionConvertor_30_50.convertId(src.getIdentityElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_30_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasMap()) {
            tgt.setMapElement(VersionConvertor_30_50.convertString(src.getMapElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentity()) {
            tgt.setIdentityElement(VersionConvertor_30_50.convertId(src.getIdentityElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_30_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasMap()) {
            tgt.setMapElement(VersionConvertor_30_50.convertString(src.getMapElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.HumanName convertHumanName(HumanName src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.HumanName tgt = new org.hl7.fhir.r5.model.HumanName();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_50.convertNameUse(src.getUseElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_50.convertString(src.getTextElement()));
        }
        if (src.hasFamily()) {
            tgt.setFamilyElement(VersionConvertor_30_50.convertString(src.getFamilyElement()));
        }
        for (StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static HumanName convertHumanName(org.hl7.fhir.r5.model.HumanName src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HumanName tgt = new HumanName();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_50.convertNameUse(src.getUseElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(VersionConvertor_30_50.convertString(src.getTextElement()));
        }
        if (src.hasFamily()) {
            tgt.setFamilyElement(VersionConvertor_30_50.convertString(src.getFamilyElement()));
        }
        for (org.hl7.fhir.r5.model.StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (org.hl7.fhir.r5.model.StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (org.hl7.fhir.r5.model.StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<HumanName.NameUse> convertNameUse(Enumeration<HumanName.NameUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<HumanName.NameUse> tgt = new org.hl7.fhir.r5.model.Enumeration<HumanName.NameUse>(new HumanName.NameUseEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)HumanName.NameUse.NULL);
        } else {
            switch ((HumanName.NameUse)((Object)src.getValue())) {
                case USUAL: {
                    tgt.setValue((Object)HumanName.NameUse.USUAL);
                    break;
                }
                case OFFICIAL: {
                    tgt.setValue((Object)HumanName.NameUse.OFFICIAL);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)HumanName.NameUse.TEMP);
                    break;
                }
                case NICKNAME: {
                    tgt.setValue((Object)HumanName.NameUse.NICKNAME);
                    break;
                }
                case ANONYMOUS: {
                    tgt.setValue((Object)HumanName.NameUse.ANONYMOUS);
                    break;
                }
                case OLD: {
                    tgt.setValue((Object)HumanName.NameUse.OLD);
                    break;
                }
                case MAIDEN: {
                    tgt.setValue((Object)HumanName.NameUse.MAIDEN);
                    break;
                }
                default: {
                    tgt.setValue((Object)HumanName.NameUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<HumanName.NameUse> convertNameUse(org.hl7.fhir.r5.model.Enumeration<HumanName.NameUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<HumanName.NameUse> tgt = new Enumeration<HumanName.NameUse>(new HumanName.NameUseEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)HumanName.NameUse.NULL);
        } else {
            switch ((HumanName.NameUse)((Object)src.getValue())) {
                case USUAL: {
                    tgt.setValue((Object)HumanName.NameUse.USUAL);
                    break;
                }
                case OFFICIAL: {
                    tgt.setValue((Object)HumanName.NameUse.OFFICIAL);
                    break;
                }
                case TEMP: {
                    tgt.setValue((Object)HumanName.NameUse.TEMP);
                    break;
                }
                case NICKNAME: {
                    tgt.setValue((Object)HumanName.NameUse.NICKNAME);
                    break;
                }
                case ANONYMOUS: {
                    tgt.setValue((Object)HumanName.NameUse.ANONYMOUS);
                    break;
                }
                case OLD: {
                    tgt.setValue((Object)HumanName.NameUse.OLD);
                    break;
                }
                case MAIDEN: {
                    tgt.setValue((Object)HumanName.NameUse.MAIDEN);
                    break;
                }
                default: {
                    tgt.setValue((Object)HumanName.NameUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static Meta convertMeta(org.hl7.fhir.dstu3.model.Meta src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Meta tgt = new Meta();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasVersionId()) {
            tgt.setVersionIdElement(VersionConvertor_30_50.convertId(src.getVersionIdElement()));
        }
        if (src.hasLastUpdated()) {
            tgt.setLastUpdatedElement(VersionConvertor_30_50.convertInstant(src.getLastUpdatedElement()));
        }
        for (UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (Coding coding : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_30_50.convertCoding(coding));
        }
        for (Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_30_50.convertCoding(coding));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Meta convertMeta(Meta src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Meta tgt = new org.hl7.fhir.dstu3.model.Meta();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasVersionId()) {
            tgt.setVersionIdElement(VersionConvertor_30_50.convertId(src.getVersionIdElement()));
        }
        if (src.hasLastUpdated()) {
            tgt.setLastUpdatedElement(VersionConvertor_30_50.convertInstant(src.getLastUpdatedElement()));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (org.hl7.fhir.r5.model.Coding coding : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_30_50.convertCoding(coding));
        }
        for (org.hl7.fhir.r5.model.Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_30_50.convertCoding(coding));
        }
        return tgt;
    }

    public static ParameterDefinition convertParameterDefinition(org.hl7.fhir.dstu3.model.ParameterDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ParameterDefinition tgt = new ParameterDefinition();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_50.convertParameterUse(src.getUseElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_50.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertString(src.getDocumentationElement()));
        }
        if (src.hasType()) {
            tgt.setType(Enumerations.FHIRAllTypes.fromCode(src.getType()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_50.convertReference(src.getProfile()).getReference());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ParameterDefinition convertParameterDefinition(ParameterDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ParameterDefinition tgt = new org.hl7.fhir.dstu3.model.ParameterDefinition();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_30_50.convertParameterUse(src.getUseElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_50.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertString(src.getDocumentationElement()));
        }
        if (src.hasType()) {
            tgt.setType(src.getType().toCode());
        }
        if (src.hasProfile()) {
            tgt.setProfile(new org.hl7.fhir.dstu3.model.Reference(src.getProfile()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.OperationParameterUse> convertParameterUse(Enumeration<ParameterDefinition.ParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.OperationParameterUse> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.OperationParameterUse>(new Enumerations.OperationParameterUseEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.OperationParameterUse.NULL);
        } else {
            switch ((ParameterDefinition.ParameterUse)((Object)src.getValue())) {
                case IN: {
                    tgt.setValue((Object)Enumerations.OperationParameterUse.IN);
                    break;
                }
                case OUT: {
                    tgt.setValue((Object)Enumerations.OperationParameterUse.OUT);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.OperationParameterUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<ParameterDefinition.ParameterUse> convertParameterUse(org.hl7.fhir.r5.model.Enumeration<Enumerations.OperationParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ParameterDefinition.ParameterUse> tgt = new Enumeration<ParameterDefinition.ParameterUse>(new ParameterDefinition.ParameterUseEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)ParameterDefinition.ParameterUse.NULL);
        } else {
            switch ((Enumerations.OperationParameterUse)((Object)src.getValue())) {
                case IN: {
                    tgt.setValue((Object)ParameterDefinition.ParameterUse.IN);
                    break;
                }
                case OUT: {
                    tgt.setValue((Object)ParameterDefinition.ParameterUse.OUT);
                    break;
                }
                default: {
                    tgt.setValue((Object)ParameterDefinition.ParameterUse.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.RelatedArtifact convertRelatedArtifact(RelatedArtifact src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.RelatedArtifact tgt = new org.hl7.fhir.r5.model.RelatedArtifact();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertRelatedArtifactType(src.getTypeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        if (src.hasCitation()) {
            tgt.setCitation(src.getCitation());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasDocument()) {
            tgt.setDocument(VersionConvertor_30_50.convertAttachment(src.getDocument()));
        }
        if (src.hasResource()) {
            tgt.setResourceElement(VersionConvertor_30_50.convertReferenceToCanonical(src.getResource()));
        }
        return tgt;
    }

    public static RelatedArtifact convertRelatedArtifact(org.hl7.fhir.r5.model.RelatedArtifact src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RelatedArtifact tgt = new RelatedArtifact();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertRelatedArtifactType(src.getTypeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        if (src.hasCitation()) {
            tgt.setCitation(src.getCitation());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasDocument()) {
            tgt.setDocument(VersionConvertor_30_50.convertAttachment(src.getDocument()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_30_50.convertCanonicalToReference(src.getResourceElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<RelatedArtifact.RelatedArtifactType> convertRelatedArtifactType(Enumeration<RelatedArtifact.RelatedArtifactType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<RelatedArtifact.RelatedArtifactType> tgt = new org.hl7.fhir.r5.model.Enumeration<RelatedArtifact.RelatedArtifactType>(new RelatedArtifact.RelatedArtifactTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.NULL);
        } else {
            switch ((RelatedArtifact.RelatedArtifactType)((Object)src.getValue())) {
                case DOCUMENTATION: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DOCUMENTATION);
                    break;
                }
                case JUSTIFICATION: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.JUSTIFICATION);
                    break;
                }
                case CITATION: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.CITATION);
                    break;
                }
                case PREDECESSOR: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.PREDECESSOR);
                    break;
                }
                case SUCCESSOR: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.SUCCESSOR);
                    break;
                }
                case DERIVEDFROM: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DERIVEDFROM);
                    break;
                }
                case DEPENDSON: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DEPENDSON);
                    break;
                }
                case COMPOSEDOF: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.COMPOSEDOF);
                    break;
                }
                default: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<RelatedArtifact.RelatedArtifactType> convertRelatedArtifactType(org.hl7.fhir.r5.model.Enumeration<RelatedArtifact.RelatedArtifactType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RelatedArtifact.RelatedArtifactType> tgt = new Enumeration<RelatedArtifact.RelatedArtifactType>(new RelatedArtifact.RelatedArtifactTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.NULL);
        } else {
            switch ((RelatedArtifact.RelatedArtifactType)((Object)src.getValue())) {
                case DOCUMENTATION: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DOCUMENTATION);
                    break;
                }
                case JUSTIFICATION: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.JUSTIFICATION);
                    break;
                }
                case CITATION: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.CITATION);
                    break;
                }
                case PREDECESSOR: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.PREDECESSOR);
                    break;
                }
                case SUCCESSOR: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.SUCCESSOR);
                    break;
                }
                case DERIVEDFROM: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DERIVEDFROM);
                    break;
                }
                case DEPENDSON: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.DEPENDSON);
                    break;
                }
                case COMPOSEDOF: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.COMPOSEDOF);
                    break;
                }
                default: {
                    tgt.setValue((Object)RelatedArtifact.RelatedArtifactType.NULL);
                }
            }
        }
        return tgt;
    }

    public static Timing convertTiming(org.hl7.fhir.dstu3.model.Timing src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Timing tgt = new Timing();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_30_50.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Timing convertTiming(Timing src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Timing tgt = new org.hl7.fhir.dstu3.model.Timing();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_30_50.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_30_50.convertType(src.getBounds()));
        }
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        if (src.hasCountMax()) {
            tgt.setCountMax(src.getCountMax());
        }
        if (src.hasDuration()) {
            tgt.setDurationElement(VersionConvertor_30_50.convertDecimal(src.getDurationElement()));
        }
        if (src.hasDurationMax()) {
            tgt.setDurationMaxElement(VersionConvertor_30_50.convertDecimal(src.getDurationMaxElement()));
        }
        if (src.hasDurationUnit()) {
            tgt.setDurationUnitElement(VersionConvertor_30_50.convertUnitsOfTime(src.getDurationUnitElement()));
        }
        if (src.hasFrequency()) {
            tgt.setFrequency(src.getFrequency());
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMax(src.getFrequencyMax());
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_30_50.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasPeriodMax()) {
            tgt.setPeriodMaxElement(VersionConvertor_30_50.convertDecimal(src.getPeriodMaxElement()));
        }
        if (src.hasPeriodUnit()) {
            tgt.setPeriodUnitElement(VersionConvertor_30_50.convertUnitsOfTime(src.getPeriodUnitElement()));
        }
        tgt.setDayOfWeek(src.getDayOfWeek().stream().map(VersionConvertor_30_50::convertDayOfWeek).collect(Collectors.toList()));
        if (src.hasWhen()) {
            tgt.setWhen(src.getWhen().stream().map(VersionConvertor_30_50::convertEventTiming).collect(Collectors.toList()));
        }
        for (org.hl7.fhir.dstu3.model.TimeType t : src.getTimeOfDay()) {
            tgt.addTimeOfDay((String)t.getValue());
        }
        if (src.hasOffset()) {
            tgt.setOffsetElement(VersionConvertor_30_50.convertUnsignedInt(src.getOffsetElement()));
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_30_50.convertType(src.getBounds()));
        }
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        if (src.hasCountMax()) {
            tgt.setCountMax(src.getCountMax());
        }
        if (src.hasDuration()) {
            tgt.setDurationElement(VersionConvertor_30_50.convertDecimal(src.getDurationElement()));
        }
        if (src.hasDurationMax()) {
            tgt.setDurationMaxElement(VersionConvertor_30_50.convertDecimal(src.getDurationMaxElement()));
        }
        if (src.hasDurationUnit()) {
            tgt.setDurationUnitElement(VersionConvertor_30_50.convertUnitsOfTime(src.getDurationUnitElement()));
        }
        if (src.hasFrequency()) {
            tgt.setFrequency(src.getFrequency());
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMax(src.getFrequencyMax());
        }
        if (src.hasPeriod()) {
            tgt.setPeriodElement(VersionConvertor_30_50.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasPeriodMax()) {
            tgt.setPeriodMaxElement(VersionConvertor_30_50.convertDecimal(src.getPeriodMaxElement()));
        }
        if (src.hasPeriodUnit()) {
            tgt.setPeriodUnitElement(VersionConvertor_30_50.convertUnitsOfTime(src.getPeriodUnitElement()));
        }
        tgt.setDayOfWeek(src.getDayOfWeek().stream().map(VersionConvertor_30_50::convertDayOfWeek).collect(Collectors.toList()));
        if (src.hasWhen()) {
            tgt.setWhen(src.getWhen().stream().map(VersionConvertor_30_50::convertEventTiming).collect(Collectors.toList()));
        }
        for (TimeType t : src.getTimeOfDay()) {
            tgt.addTimeOfDay((String)t.getValue());
        }
        if (src.hasOffset()) {
            tgt.setOffsetElement(VersionConvertor_30_50.convertUnsignedInt(src.getOffsetElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Timing.UnitsOfTime> convertUnitsOfTime(Enumeration<Timing.UnitsOfTime> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Timing.UnitsOfTime> tgt = new org.hl7.fhir.r5.model.Enumeration<Timing.UnitsOfTime>(new Timing.UnitsOfTimeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Timing.UnitsOfTime.NULL);
        } else {
            switch ((Timing.UnitsOfTime)((Object)src.getValue())) {
                case S: {
                    tgt.setValue((Object)Timing.UnitsOfTime.S);
                    break;
                }
                case MIN: {
                    tgt.setValue((Object)Timing.UnitsOfTime.MIN);
                    break;
                }
                case H: {
                    tgt.setValue((Object)Timing.UnitsOfTime.H);
                    break;
                }
                case D: {
                    tgt.setValue((Object)Timing.UnitsOfTime.D);
                    break;
                }
                case WK: {
                    tgt.setValue((Object)Timing.UnitsOfTime.WK);
                    break;
                }
                case MO: {
                    tgt.setValue((Object)Timing.UnitsOfTime.MO);
                    break;
                }
                case A: {
                    tgt.setValue((Object)Timing.UnitsOfTime.A);
                    break;
                }
                default: {
                    tgt.setValue((Object)Timing.UnitsOfTime.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Timing.UnitsOfTime> convertUnitsOfTime(org.hl7.fhir.r5.model.Enumeration<Timing.UnitsOfTime> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.UnitsOfTime> tgt = new Enumeration<Timing.UnitsOfTime>(new Timing.UnitsOfTimeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Timing.UnitsOfTime.NULL);
        } else {
            switch ((Timing.UnitsOfTime)((Object)src.getValue())) {
                case S: {
                    tgt.setValue((Object)Timing.UnitsOfTime.S);
                    break;
                }
                case MIN: {
                    tgt.setValue((Object)Timing.UnitsOfTime.MIN);
                    break;
                }
                case H: {
                    tgt.setValue((Object)Timing.UnitsOfTime.H);
                    break;
                }
                case D: {
                    tgt.setValue((Object)Timing.UnitsOfTime.D);
                    break;
                }
                case WK: {
                    tgt.setValue((Object)Timing.UnitsOfTime.WK);
                    break;
                }
                case MO: {
                    tgt.setValue((Object)Timing.UnitsOfTime.MO);
                    break;
                }
                case A: {
                    tgt.setValue((Object)Timing.UnitsOfTime.A);
                    break;
                }
                default: {
                    tgt.setValue((Object)Timing.UnitsOfTime.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> convertDayOfWeek(Enumeration<Timing.DayOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.DaysOfWeek.NULL);
        } else {
            switch ((Timing.DayOfWeek)((Object)src.getValue())) {
                case MON: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.MON);
                    break;
                }
                case TUE: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.TUE);
                    break;
                }
                case WED: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.WED);
                    break;
                }
                case THU: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.THU);
                    break;
                }
                case FRI: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.FRI);
                    break;
                }
                case SAT: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.SAT);
                    break;
                }
                case SUN: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.SUN);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Timing.DayOfWeek> convertDayOfWeek(org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.DayOfWeek> tgt = new Enumeration<Timing.DayOfWeek>(new Timing.DayOfWeekEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Timing.DayOfWeek.NULL);
        } else {
            switch ((Enumerations.DaysOfWeek)((Object)src.getValue())) {
                case MON: {
                    tgt.setValue((Object)Timing.DayOfWeek.MON);
                    break;
                }
                case TUE: {
                    tgt.setValue((Object)Timing.DayOfWeek.TUE);
                    break;
                }
                case WED: {
                    tgt.setValue((Object)Timing.DayOfWeek.WED);
                    break;
                }
                case THU: {
                    tgt.setValue((Object)Timing.DayOfWeek.THU);
                    break;
                }
                case FRI: {
                    tgt.setValue((Object)Timing.DayOfWeek.FRI);
                    break;
                }
                case SAT: {
                    tgt.setValue((Object)Timing.DayOfWeek.SAT);
                    break;
                }
                case SUN: {
                    tgt.setValue((Object)Timing.DayOfWeek.SUN);
                    break;
                }
                default: {
                    tgt.setValue((Object)Timing.DayOfWeek.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Timing.EventTiming> convertEventTiming(Enumeration<Timing.EventTiming> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Timing.EventTiming> tgt = new org.hl7.fhir.r5.model.Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Timing.EventTiming.NULL);
        } else {
            switch ((Timing.EventTiming)((Object)src.getValue())) {
                case MORN: {
                    tgt.setValue((Object)Timing.EventTiming.MORN);
                    break;
                }
                case AFT: {
                    tgt.setValue((Object)Timing.EventTiming.AFT);
                    break;
                }
                case EVE: {
                    tgt.setValue((Object)Timing.EventTiming.EVE);
                    break;
                }
                case NIGHT: {
                    tgt.setValue((Object)Timing.EventTiming.NIGHT);
                    break;
                }
                case PHS: {
                    tgt.setValue((Object)Timing.EventTiming.PHS);
                    break;
                }
                case HS: {
                    tgt.setValue((Object)Timing.EventTiming.HS);
                    break;
                }
                case WAKE: {
                    tgt.setValue((Object)Timing.EventTiming.WAKE);
                    break;
                }
                case C: {
                    tgt.setValue((Object)Timing.EventTiming.C);
                    break;
                }
                case CM: {
                    tgt.setValue((Object)Timing.EventTiming.CM);
                    break;
                }
                case CD: {
                    tgt.setValue((Object)Timing.EventTiming.CD);
                    break;
                }
                case CV: {
                    tgt.setValue((Object)Timing.EventTiming.CV);
                    break;
                }
                case AC: {
                    tgt.setValue((Object)Timing.EventTiming.AC);
                    break;
                }
                case ACM: {
                    tgt.setValue((Object)Timing.EventTiming.ACM);
                    break;
                }
                case ACD: {
                    tgt.setValue((Object)Timing.EventTiming.ACD);
                    break;
                }
                case ACV: {
                    tgt.setValue((Object)Timing.EventTiming.ACV);
                    break;
                }
                case PC: {
                    tgt.setValue((Object)Timing.EventTiming.PC);
                    break;
                }
                case PCM: {
                    tgt.setValue((Object)Timing.EventTiming.PCM);
                    break;
                }
                case PCD: {
                    tgt.setValue((Object)Timing.EventTiming.PCD);
                    break;
                }
                case PCV: {
                    tgt.setValue((Object)Timing.EventTiming.PCV);
                    break;
                }
                default: {
                    tgt.setValue((Object)Timing.EventTiming.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Timing.EventTiming> convertEventTiming(org.hl7.fhir.r5.model.Enumeration<Timing.EventTiming> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.EventTiming> tgt = new Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Timing.EventTiming.NULL);
        } else {
            switch ((Timing.EventTiming)((Object)src.getValue())) {
                case MORN: {
                    tgt.setValue((Object)Timing.EventTiming.MORN);
                    break;
                }
                case AFT: {
                    tgt.setValue((Object)Timing.EventTiming.AFT);
                    break;
                }
                case EVE: {
                    tgt.setValue((Object)Timing.EventTiming.EVE);
                    break;
                }
                case NIGHT: {
                    tgt.setValue((Object)Timing.EventTiming.NIGHT);
                    break;
                }
                case PHS: {
                    tgt.setValue((Object)Timing.EventTiming.PHS);
                    break;
                }
                case HS: {
                    tgt.setValue((Object)Timing.EventTiming.HS);
                    break;
                }
                case WAKE: {
                    tgt.setValue((Object)Timing.EventTiming.WAKE);
                    break;
                }
                case C: {
                    tgt.setValue((Object)Timing.EventTiming.C);
                    break;
                }
                case CM: {
                    tgt.setValue((Object)Timing.EventTiming.CM);
                    break;
                }
                case CD: {
                    tgt.setValue((Object)Timing.EventTiming.CD);
                    break;
                }
                case CV: {
                    tgt.setValue((Object)Timing.EventTiming.CV);
                    break;
                }
                case AC: {
                    tgt.setValue((Object)Timing.EventTiming.AC);
                    break;
                }
                case ACM: {
                    tgt.setValue((Object)Timing.EventTiming.ACM);
                    break;
                }
                case ACD: {
                    tgt.setValue((Object)Timing.EventTiming.ACD);
                    break;
                }
                case ACV: {
                    tgt.setValue((Object)Timing.EventTiming.ACV);
                    break;
                }
                case PC: {
                    tgt.setValue((Object)Timing.EventTiming.PC);
                    break;
                }
                case PCM: {
                    tgt.setValue((Object)Timing.EventTiming.PCM);
                    break;
                }
                case PCD: {
                    tgt.setValue((Object)Timing.EventTiming.PCD);
                    break;
                }
                case PCV: {
                    tgt.setValue((Object)Timing.EventTiming.PCV);
                    break;
                }
                default: {
                    tgt.setValue((Object)Timing.EventTiming.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.UsageContext convertUsageContext(UsageContext src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.UsageContext tgt = new org.hl7.fhir.r5.model.UsageContext();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCoding(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static UsageContext convertUsageContext(org.hl7.fhir.r5.model.UsageContext src) throws FHIRException {
        if (src == null) {
            return null;
        }
        UsageContext tgt = new UsageContext();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCoding(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Quantity convertSimpleQuantity(SimpleQuantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.SimpleQuantity tgt = new org.hl7.fhir.r5.model.SimpleQuantity();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_30_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_30_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static SimpleQuantity convertSimpleQuantity(Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SimpleQuantity tgt = new SimpleQuantity();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_30_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnit()) {
            tgt.setUnitElement(VersionConvertor_30_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.TriggerDefinition convertTriggerDefinition(TriggerDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.TriggerDefinition tgt = new org.hl7.fhir.r5.model.TriggerDefinition();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertTriggerType(src.getTypeElement()));
        }
        if (src.hasEventName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getEventNameElement()));
        }
        if (src.hasEventTiming()) {
            tgt.setTiming(VersionConvertor_30_50.convertType(src.getEventTiming()));
        }
        if (src.hasEventData()) {
            tgt.addData(VersionConvertor_30_50.convertDataRequirement(src.getEventData()));
        }
        return tgt;
    }

    public static TriggerDefinition convertTriggerDefinition(org.hl7.fhir.r5.model.TriggerDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TriggerDefinition tgt = new TriggerDefinition();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertTriggerType(src.getTypeElement()));
        }
        if (src.hasName()) {
            tgt.setEventNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTiming()) {
            tgt.setEventTiming(VersionConvertor_30_50.convertType(src.getTiming()));
        }
        if (src.hasData()) {
            tgt.setEventData(VersionConvertor_30_50.convertDataRequirement(src.getDataFirstRep()));
        }
        return tgt;
    }

    public static DataRequirement convertDataRequirement(org.hl7.fhir.dstu3.model.DataRequirement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement tgt = new DataRequirement();
        VersionConvertor_30_50.copyElement(src, tgt, "http://hl7.org/fhir/tools/StructureDefinition/original-resource-name");
        if (src.hasType()) {
            if (src.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/original-resource-name")) {
                tgt.setType(Enumerations.FHIRAllTypes.fromCode(src.getExtensionString("http://hl7.org/fhir/tools/StructureDefinition/original-resource-name")));
            } else {
                String n = VersionConvertorResourceNameMapper.mapName3to5(src.getType());
                if (n != null) {
                    tgt.setType(Enumerations.FHIRAllTypes.fromCode(n));
                }
                tgt.addExtension("http://hl7.org/fhir/tools/StructureDefinition/original-resource-name", new org.hl7.fhir.r5.model.CodeType(src.getType()));
            }
        }
        for (UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (StringType stringType : src.getMustSupport()) {
            tgt.addMustSupport((String)stringType.getValue());
        }
        for (DataRequirement.DataRequirementCodeFilterComponent dataRequirementCodeFilterComponent : src.getCodeFilter()) {
            tgt.addCodeFilter(VersionConvertor_30_50.convertDataRequirementCodeFilterComponent(dataRequirementCodeFilterComponent));
        }
        for (DataRequirement.DataRequirementDateFilterComponent dataRequirementDateFilterComponent : src.getDateFilter()) {
            tgt.addDateFilter(VersionConvertor_30_50.convertDataRequirementDateFilterComponent(dataRequirementDateFilterComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DataRequirement convertDataRequirement(DataRequirement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.DataRequirement tgt = new org.hl7.fhir.dstu3.model.DataRequirement();
        VersionConvertor_30_50.copyElement(src, tgt, "http://hl7.org/fhir/tools/StructureDefinition/original-resource-name");
        if (src.hasType() || src.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/original-resource-name")) {
            if (src.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/original-resource-name")) {
                tgt.setType(src.getExtensionString("http://hl7.org/fhir/tools/StructureDefinition/original-resource-name"));
            } else {
                String n = VersionConvertorResourceNameMapper.mapName5to3(src.getType().toCode());
                if (n != null) {
                    tgt.setType(n);
                }
                tgt.addExtension("http://hl7.org/fhir/tools/StructureDefinition/original-resource-name", new CodeType(src.getType().toCode()));
            }
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (org.hl7.fhir.r5.model.StringType stringType : src.getMustSupport()) {
            tgt.addMustSupport((String)stringType.getValue());
        }
        for (DataRequirement.DataRequirementCodeFilterComponent dataRequirementCodeFilterComponent : src.getCodeFilter()) {
            tgt.addCodeFilter(VersionConvertor_30_50.convertDataRequirementCodeFilterComponent(dataRequirementCodeFilterComponent));
        }
        for (DataRequirement.DataRequirementDateFilterComponent dataRequirementDateFilterComponent : src.getDateFilter()) {
            tgt.addDateFilter(VersionConvertor_30_50.convertDataRequirementDateFilterComponent(dataRequirementDateFilterComponent));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementCodeFilterComponent convertDataRequirementCodeFilterComponent(DataRequirement.DataRequirementCodeFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementCodeFilterComponent tgt = new DataRequirement.DataRequirementCodeFilterComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_50.convertString(src.getPathElement()));
        }
        if (src.hasValueSet()) {
            DataType t = VersionConvertor_30_50.convertType(src.getValueSet());
            if (t instanceof Reference) {
                tgt.setValueSet(((Reference)t).getReference());
            } else {
                tgt.setValueSet(t.primitiveValue());
            }
            tgt.setValueSet(VersionConvertorConstants.refToVS(tgt.getValueSet()));
        }
        for (CodeType codeType : src.getValueCode()) {
            tgt.addCode(VersionConvertor_30_50.convertCoding(codeType));
        }
        for (Coding coding : src.getValueCoding()) {
            tgt.addCode(VersionConvertor_30_50.convertCoding(coding));
        }
        for (CodeableConcept codeableConcept : src.getValueCodeableConcept()) {
            tgt.addCode(VersionConvertor_30_50.convertCoding(codeableConcept));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementCodeFilterComponent convertDataRequirementCodeFilterComponent(DataRequirement.DataRequirementCodeFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementCodeFilterComponent tgt = new DataRequirement.DataRequirementCodeFilterComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_50.convertString(src.getPathElement()));
        }
        if (src.hasValueSet()) {
            String vsr = VersionConvertorConstants.vsToRef(src.getValueSet());
            if (vsr != null) {
                tgt.setValueSet(new UriType(vsr));
            } else {
                tgt.setValueSet(new org.hl7.fhir.dstu3.model.Reference(src.getValueSet()));
            }
        }
        for (org.hl7.fhir.r5.model.Coding t : src.getCode()) {
            tgt.addValueCoding(VersionConvertor_30_50.convertCoding(t));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementDateFilterComponent convertDataRequirementDateFilterComponent(DataRequirement.DataRequirementDateFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementDateFilterComponent tgt = new DataRequirement.DataRequirementDateFilterComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_50.convertString(src.getPathElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementDateFilterComponent convertDataRequirementDateFilterComponent(DataRequirement.DataRequirementDateFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementDateFilterComponent tgt = new DataRequirement.DataRequirementDateFilterComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_50.convertString(src.getPathElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TriggerDefinition.TriggerType> convertTriggerType(Enumeration<TriggerDefinition.TriggerType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TriggerDefinition.TriggerType> tgt = new org.hl7.fhir.r5.model.Enumeration<TriggerDefinition.TriggerType>(new TriggerDefinition.TriggerTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)TriggerDefinition.TriggerType.NULL);
        } else {
            switch ((TriggerDefinition.TriggerType)((Object)src.getValue())) {
                case NAMEDEVENT: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.NAMEDEVENT);
                    break;
                }
                case PERIODIC: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.PERIODIC);
                    break;
                }
                case DATAADDED: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.DATAADDED);
                    break;
                }
                case DATAMODIFIED: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.DATAMODIFIED);
                    break;
                }
                case DATAREMOVED: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.DATAREMOVED);
                    break;
                }
                case DATAACCESSED: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.DATAACCESSED);
                    break;
                }
                case DATAACCESSENDED: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.DATAACCESSENDED);
                    break;
                }
                default: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<TriggerDefinition.TriggerType> convertTriggerType(org.hl7.fhir.r5.model.Enumeration<TriggerDefinition.TriggerType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TriggerDefinition.TriggerType> tgt = new Enumeration<TriggerDefinition.TriggerType>(new TriggerDefinition.TriggerTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)TriggerDefinition.TriggerType.NULL);
        } else {
            switch ((TriggerDefinition.TriggerType)((Object)src.getValue())) {
                case NAMEDEVENT: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.NAMEDEVENT);
                    break;
                }
                case PERIODIC: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.PERIODIC);
                    break;
                }
                case DATAADDED: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.DATAADDED);
                    break;
                }
                case DATAMODIFIED: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.DATAMODIFIED);
                    break;
                }
                case DATAREMOVED: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.DATAREMOVED);
                    break;
                }
                case DATAACCESSED: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.DATAACCESSED);
                    break;
                }
                case DATAACCESSENDED: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.DATAACCESSENDED);
                    break;
                }
                default: {
                    tgt.setValue((Object)TriggerDefinition.TriggerType.NULL);
                }
            }
        }
        return tgt;
    }

    public static DataType convertType(Type src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Base64BinaryType) {
            return VersionConvertor_30_50.convertBase64Binary((org.hl7.fhir.dstu3.model.Base64BinaryType)src);
        }
        if (src instanceof BooleanType) {
            return VersionConvertor_30_50.convertBoolean((BooleanType)src);
        }
        if (src instanceof CodeType) {
            return VersionConvertor_30_50.convertCode((CodeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DateType) {
            return VersionConvertor_30_50.convertDate((org.hl7.fhir.dstu3.model.DateType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DateTimeType) {
            return VersionConvertor_30_50.convertDateTime((org.hl7.fhir.dstu3.model.DateTimeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DecimalType) {
            return VersionConvertor_30_50.convertDecimal((org.hl7.fhir.dstu3.model.DecimalType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.IdType) {
            return VersionConvertor_30_50.convertId((org.hl7.fhir.dstu3.model.IdType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.InstantType) {
            return VersionConvertor_30_50.convertInstant((org.hl7.fhir.dstu3.model.InstantType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.PositiveIntType) {
            return VersionConvertor_30_50.convertPositiveInt((org.hl7.fhir.dstu3.model.PositiveIntType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.UnsignedIntType) {
            return VersionConvertor_30_50.convertUnsignedInt((org.hl7.fhir.dstu3.model.UnsignedIntType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.IntegerType) {
            return VersionConvertor_30_50.convertInteger((org.hl7.fhir.dstu3.model.IntegerType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.MarkdownType) {
            return VersionConvertor_30_50.convertMarkdown((org.hl7.fhir.dstu3.model.MarkdownType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.OidType) {
            return VersionConvertor_30_50.convertOid((org.hl7.fhir.dstu3.model.OidType)src);
        }
        if (src instanceof StringType) {
            return VersionConvertor_30_50.convertString((StringType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.TimeType) {
            return VersionConvertor_30_50.convertTime((org.hl7.fhir.dstu3.model.TimeType)src);
        }
        if (src instanceof UriType) {
            return VersionConvertor_30_50.convertUri((UriType)src);
        }
        if (src instanceof UuidType) {
            return VersionConvertor_30_50.convertUuid((UuidType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Extension) {
            return VersionConvertor_30_50.convertExtension((org.hl7.fhir.dstu3.model.Extension)src);
        }
        if (src instanceof Narrative) {
            return VersionConvertor_30_50.convertNarrative((Narrative)src);
        }
        if (src instanceof Age) {
            return VersionConvertor_30_50.convertAge((Age)src);
        }
        if (src instanceof Annotation) {
            return VersionConvertor_30_50.convertAnnotation((Annotation)src);
        }
        if (src instanceof Attachment) {
            return VersionConvertor_30_50.convertAttachment((Attachment)src);
        }
        if (src instanceof CodeableConcept) {
            return VersionConvertor_30_50.convertCodeableConcept((CodeableConcept)src);
        }
        if (src instanceof Coding) {
            return VersionConvertor_30_50.convertCoding((Coding)src);
        }
        if (src instanceof Count) {
            return VersionConvertor_30_50.convertCount((Count)src);
        }
        if (src instanceof Distance) {
            return VersionConvertor_30_50.convertDistance((Distance)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Duration) {
            return VersionConvertor_30_50.convertDuration((org.hl7.fhir.dstu3.model.Duration)src);
        }
        if (src instanceof Identifier) {
            return VersionConvertor_30_50.convertIdentifier((Identifier)src);
        }
        if (src instanceof Money) {
            return VersionConvertor_30_50.convertMoney((Money)src);
        }
        if (src instanceof Period) {
            return VersionConvertor_30_50.convertPeriod((Period)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Quantity) {
            return VersionConvertor_30_50.convertQuantity((org.hl7.fhir.dstu3.model.Quantity)src);
        }
        if (src instanceof Range) {
            return VersionConvertor_30_50.convertRange((Range)src);
        }
        if (src instanceof Ratio) {
            return VersionConvertor_30_50.convertRatio((Ratio)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Reference) {
            return VersionConvertor_30_50.convertReference((org.hl7.fhir.dstu3.model.Reference)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.SampledData) {
            return VersionConvertor_30_50.convertSampledData((org.hl7.fhir.dstu3.model.SampledData)src);
        }
        if (src instanceof Signature) {
            return VersionConvertor_30_50.convertSignature((Signature)src);
        }
        if (src instanceof Address) {
            return VersionConvertor_30_50.convertAddress((Address)src);
        }
        if (src instanceof ContactDetail) {
            return VersionConvertor_30_50.convertContactDetail((ContactDetail)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ContactPoint) {
            return VersionConvertor_30_50.convertContactPoint((org.hl7.fhir.dstu3.model.ContactPoint)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Contributor) {
            return VersionConvertor_30_50.convertContributor((org.hl7.fhir.dstu3.model.Contributor)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Dosage) {
            return VersionConvertor_30_50.convertDosage((org.hl7.fhir.dstu3.model.Dosage)src);
        }
        if (src instanceof HumanName) {
            return VersionConvertor_30_50.convertHumanName((HumanName)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Meta) {
            return VersionConvertor_30_50.convertMeta((org.hl7.fhir.dstu3.model.Meta)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ParameterDefinition) {
            return VersionConvertor_30_50.convertParameterDefinition((org.hl7.fhir.dstu3.model.ParameterDefinition)src);
        }
        if (src instanceof RelatedArtifact) {
            return VersionConvertor_30_50.convertRelatedArtifact((RelatedArtifact)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Timing) {
            return VersionConvertor_30_50.convertTiming((org.hl7.fhir.dstu3.model.Timing)src);
        }
        if (src instanceof UsageContext) {
            return VersionConvertor_30_50.convertUsageContext((UsageContext)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ElementDefinition) {
            return VersionConvertor_30_50.convertElementDefinition((org.hl7.fhir.dstu3.model.ElementDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DataRequirement) {
            return VersionConvertor_30_50.convertDataRequirement((org.hl7.fhir.dstu3.model.DataRequirement)src);
        }
        if (src instanceof TriggerDefinition) {
            return VersionConvertor_30_50.convertTriggerDefinition((TriggerDefinition)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public static Type convertType(DataType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src instanceof Base64BinaryType) {
            return VersionConvertor_30_50.convertBase64Binary((Base64BinaryType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.BooleanType) {
            return VersionConvertor_30_50.convertBoolean((org.hl7.fhir.r5.model.BooleanType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.CodeType) {
            return VersionConvertor_30_50.convertCode((org.hl7.fhir.r5.model.CodeType)src);
        }
        if (src instanceof DateType) {
            return VersionConvertor_30_50.convertDate((DateType)src);
        }
        if (src instanceof DateTimeType) {
            return VersionConvertor_30_50.convertDateTime((DateTimeType)src);
        }
        if (src instanceof DecimalType) {
            return VersionConvertor_30_50.convertDecimal((DecimalType)src);
        }
        if (src instanceof IdType) {
            return VersionConvertor_30_50.convertId((IdType)src);
        }
        if (src instanceof InstantType) {
            return VersionConvertor_30_50.convertInstant((InstantType)src);
        }
        if (src instanceof PositiveIntType) {
            return VersionConvertor_30_50.convertPositiveInt((PositiveIntType)src);
        }
        if (src instanceof UnsignedIntType) {
            return VersionConvertor_30_50.convertUnsignedInt((UnsignedIntType)src);
        }
        if (src instanceof Integer64Type) {
            return VersionConvertor_30_50.convertInteger64((Integer64Type)src);
        }
        if (src instanceof IntegerType) {
            return VersionConvertor_30_50.convertInteger((IntegerType)src);
        }
        if (src instanceof MarkdownType) {
            return VersionConvertor_30_50.convertMarkdown((MarkdownType)src);
        }
        if (src instanceof OidType) {
            return VersionConvertor_30_50.convertOid((OidType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.StringType) {
            return VersionConvertor_30_50.convertString((org.hl7.fhir.r5.model.StringType)src);
        }
        if (src instanceof TimeType) {
            return VersionConvertor_30_50.convertTime((TimeType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.UriType) {
            return VersionConvertor_30_50.convertUri((org.hl7.fhir.r5.model.UriType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.UuidType) {
            return VersionConvertor_30_50.convertUuid((org.hl7.fhir.r5.model.UuidType)src);
        }
        if (src instanceof Extension) {
            return VersionConvertor_30_50.convertExtension((Extension)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Narrative) {
            return VersionConvertor_30_50.convertNarrative((org.hl7.fhir.r5.model.Narrative)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Age) {
            return VersionConvertor_30_50.convertAge((org.hl7.fhir.r5.model.Age)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Annotation) {
            return VersionConvertor_30_50.convertAnnotation((org.hl7.fhir.r5.model.Annotation)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Attachment) {
            return VersionConvertor_30_50.convertAttachment((org.hl7.fhir.r5.model.Attachment)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.CodeableConcept) {
            return VersionConvertor_30_50.convertCodeableConcept((org.hl7.fhir.r5.model.CodeableConcept)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Coding) {
            return VersionConvertor_30_50.convertCoding((org.hl7.fhir.r5.model.Coding)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Count) {
            return VersionConvertor_30_50.convertCount((org.hl7.fhir.r5.model.Count)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Distance) {
            return VersionConvertor_30_50.convertDistance((org.hl7.fhir.r5.model.Distance)src);
        }
        if (src instanceof Duration) {
            return VersionConvertor_30_50.convertDuration((Duration)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Identifier) {
            return VersionConvertor_30_50.convertIdentifier((org.hl7.fhir.r5.model.Identifier)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Money) {
            return VersionConvertor_30_50.convertMoney((org.hl7.fhir.r5.model.Money)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Period) {
            return VersionConvertor_30_50.convertPeriod((org.hl7.fhir.r5.model.Period)src);
        }
        if (src instanceof Quantity) {
            return VersionConvertor_30_50.convertQuantity((Quantity)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Range) {
            return VersionConvertor_30_50.convertRange((org.hl7.fhir.r5.model.Range)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Ratio) {
            return VersionConvertor_30_50.convertRatio((org.hl7.fhir.r5.model.Ratio)src);
        }
        if (src instanceof Reference) {
            return VersionConvertor_30_50.convertReference((Reference)src);
        }
        if (src instanceof SampledData) {
            return VersionConvertor_30_50.convertSampledData((SampledData)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Signature) {
            return VersionConvertor_30_50.convertSignature((org.hl7.fhir.r5.model.Signature)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Address) {
            return VersionConvertor_30_50.convertAddress((org.hl7.fhir.r5.model.Address)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ContactDetail) {
            return VersionConvertor_30_50.convertContactDetail((org.hl7.fhir.r5.model.ContactDetail)src);
        }
        if (src instanceof ContactPoint) {
            return VersionConvertor_30_50.convertContactPoint((ContactPoint)src);
        }
        if (src instanceof Contributor) {
            return VersionConvertor_30_50.convertContributor((Contributor)src);
        }
        if (src instanceof Dosage) {
            return VersionConvertor_30_50.convertDosage((Dosage)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.HumanName) {
            return VersionConvertor_30_50.convertHumanName((org.hl7.fhir.r5.model.HumanName)src);
        }
        if (src instanceof Meta) {
            return VersionConvertor_30_50.convertMeta((Meta)src);
        }
        if (src instanceof ParameterDefinition) {
            return VersionConvertor_30_50.convertParameterDefinition((ParameterDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.RelatedArtifact) {
            return VersionConvertor_30_50.convertRelatedArtifact((org.hl7.fhir.r5.model.RelatedArtifact)src);
        }
        if (src instanceof Timing) {
            return VersionConvertor_30_50.convertTiming((Timing)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.UsageContext) {
            return VersionConvertor_30_50.convertUsageContext((org.hl7.fhir.r5.model.UsageContext)src);
        }
        if (src instanceof ElementDefinition) {
            return VersionConvertor_30_50.convertElementDefinition((ElementDefinition)src);
        }
        if (src instanceof DataRequirement) {
            return VersionConvertor_30_50.convertDataRequirement((DataRequirement)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.TriggerDefinition) {
            return VersionConvertor_30_50.convertTriggerDefinition((org.hl7.fhir.r5.model.TriggerDefinition)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public static void copyDomainResource(org.hl7.fhir.dstu3.model.DomainResource src, DomainResource tgt, String ... extensionsToIgnore) throws FHIRException {
        VersionConvertor_30_50.copyResource(src, tgt);
        if (src.hasText()) {
            tgt.setText(VersionConvertor_30_50.convertNarrative(src.getText()));
        }
        for (org.hl7.fhir.dstu3.model.Resource t1 : src.getContained()) {
            tgt.addContained(VersionConvertor_30_50.convertResource(t1, false));
        }
        for (org.hl7.fhir.dstu3.model.Extension t2 : src.getExtension()) {
            if (VersionConvertor_30_50.isExemptExtension(t2.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_30_50.convertExtension(t2));
        }
        for (org.hl7.fhir.dstu3.model.Extension t3 : src.getModifierExtension()) {
            if (VersionConvertor_30_50.isExemptExtension(t3.getUrl(), extensionsToIgnore)) continue;
            tgt.addModifierExtension(VersionConvertor_30_50.convertExtension(t3));
        }
    }

    public static boolean isExemptExtension(String url, String[] extensionsToIgnore) {
        boolean ok = false;
        for (String s2 : extensionsToIgnore) {
            if (!s2.equals(url)) continue;
            ok = true;
        }
        return ok;
    }

    public static void copyDomainResource(DomainResource src, org.hl7.fhir.dstu3.model.DomainResource tgt, String ... extensionsToIgnore) throws FHIRException {
        VersionConvertor_30_50.copyResource(src, tgt);
        if (src.hasText()) {
            tgt.setText(VersionConvertor_30_50.convertNarrative(src.getText()));
        }
        for (Resource t1 : src.getContained()) {
            tgt.addContained(VersionConvertor_30_50.convertResource(t1, false));
        }
        for (Extension t2 : src.getExtension()) {
            if (VersionConvertor_30_50.isExemptExtension(t2.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_30_50.convertExtension(t2));
        }
        for (Extension t3 : src.getModifierExtension()) {
            if (VersionConvertor_30_50.isExemptExtension(t3.getUrl(), extensionsToIgnore)) continue;
            tgt.addModifierExtension(VersionConvertor_30_50.convertExtension(t3));
        }
    }

    public static void copyResource(org.hl7.fhir.dstu3.model.Resource src, Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setIdElement(VersionConvertor_30_50.convertId(src.getIdElement()));
        }
        if (src.hasMeta()) {
            tgt.setMeta(VersionConvertor_30_50.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_30_50.convertCode(src.getLanguageElement()));
        }
    }

    public static void copyResource(Resource src, org.hl7.fhir.dstu3.model.Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setIdElement(VersionConvertor_30_50.convertId(src.getIdElement()));
        }
        if (src.hasMeta()) {
            tgt.setMeta(VersionConvertor_30_50.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_30_50.convertCode(src.getLanguageElement()));
        }
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.PublicationStatus> convertPublicationStatus(Enumeration<Enumerations.PublicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.PublicationStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.PublicationStatus.NULL);
        } else {
            switch ((Enumerations.PublicationStatus)((Object)src.getValue())) {
                case DRAFT: {
                    tgt.setValue((Object)Enumerations.PublicationStatus.DRAFT);
                    break;
                }
                case ACTIVE: {
                    tgt.setValue((Object)Enumerations.PublicationStatus.ACTIVE);
                    break;
                }
                case RETIRED: {
                    tgt.setValue((Object)Enumerations.PublicationStatus.RETIRED);
                    break;
                }
                case UNKNOWN: {
                    tgt.setValue((Object)Enumerations.PublicationStatus.UNKNOWN);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.PublicationStatus.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.PublicationStatus> convertPublicationStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.PublicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.PublicationStatus> tgt = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.PublicationStatus.NULL);
        } else {
            switch ((Enumerations.PublicationStatus)((Object)src.getValue())) {
                case DRAFT: {
                    tgt.setValue((Object)Enumerations.PublicationStatus.DRAFT);
                    break;
                }
                case ACTIVE: {
                    tgt.setValue((Object)Enumerations.PublicationStatus.ACTIVE);
                    break;
                }
                case RETIRED: {
                    tgt.setValue((Object)Enumerations.PublicationStatus.RETIRED);
                    break;
                }
                case UNKNOWN: {
                    tgt.setValue((Object)Enumerations.PublicationStatus.UNKNOWN);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.PublicationStatus.NULL);
                }
            }
        }
        return tgt;
    }

    public static CodeableReference convertReferenceToCodableReference(org.hl7.fhir.dstu3.model.Reference src) {
        CodeableReference tgt = new CodeableReference();
        tgt.setReference(VersionConvertor_30_50.convertReference(src));
        return tgt;
    }

    public static CodeableReference convertCodeableConceptToCodableReference(CodeableConcept src) {
        CodeableReference tgt = new CodeableReference();
        tgt.setConcept(VersionConvertor_30_50.convertCodeableConcept(src));
        return tgt;
    }

    public static CanonicalType convertReferenceToCanonical(org.hl7.fhir.dstu3.model.Reference src) throws FHIRException {
        CanonicalType dst = new CanonicalType(src.getReference());
        VersionConvertor_30_50.copyElement(src, dst, new String[0]);
        return dst;
    }

    public static org.hl7.fhir.dstu3.model.Reference convertCanonicalToReference(CanonicalType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.Reference dst = new org.hl7.fhir.dstu3.model.Reference((String)src.getValue());
        VersionConvertor_30_50.copyElement(src, dst, new String[0]);
        return dst;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.SearchParamType> convertSearchParamType(Enumeration<Enumerations.SearchParamType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.SearchParamType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.SearchParamType.NULL);
        } else {
            switch ((Enumerations.SearchParamType)((Object)src.getValue())) {
                case NUMBER: {
                    tgt.setValue((Object)Enumerations.SearchParamType.NUMBER);
                    break;
                }
                case DATE: {
                    tgt.setValue((Object)Enumerations.SearchParamType.DATE);
                    break;
                }
                case STRING: {
                    tgt.setValue((Object)Enumerations.SearchParamType.STRING);
                    break;
                }
                case TOKEN: {
                    tgt.setValue((Object)Enumerations.SearchParamType.TOKEN);
                    break;
                }
                case REFERENCE: {
                    tgt.setValue((Object)Enumerations.SearchParamType.REFERENCE);
                    break;
                }
                case COMPOSITE: {
                    tgt.setValue((Object)Enumerations.SearchParamType.COMPOSITE);
                    break;
                }
                case QUANTITY: {
                    tgt.setValue((Object)Enumerations.SearchParamType.QUANTITY);
                    break;
                }
                case URI: {
                    tgt.setValue((Object)Enumerations.SearchParamType.URI);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.SearchParamType.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.SearchParamType> convertSearchParamType(org.hl7.fhir.r5.model.Enumeration<Enumerations.SearchParamType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.SearchParamType> tgt = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.SearchParamType.NULL);
        } else {
            switch ((Enumerations.SearchParamType)((Object)src.getValue())) {
                case NUMBER: {
                    tgt.setValue((Object)Enumerations.SearchParamType.NUMBER);
                    break;
                }
                case DATE: {
                    tgt.setValue((Object)Enumerations.SearchParamType.DATE);
                    break;
                }
                case STRING: {
                    tgt.setValue((Object)Enumerations.SearchParamType.STRING);
                    break;
                }
                case TOKEN: {
                    tgt.setValue((Object)Enumerations.SearchParamType.TOKEN);
                    break;
                }
                case REFERENCE: {
                    tgt.setValue((Object)Enumerations.SearchParamType.REFERENCE);
                    break;
                }
                case COMPOSITE: {
                    tgt.setValue((Object)Enumerations.SearchParamType.COMPOSITE);
                    break;
                }
                case QUANTITY: {
                    tgt.setValue((Object)Enumerations.SearchParamType.QUANTITY);
                    break;
                }
                case URI: {
                    tgt.setValue((Object)Enumerations.SearchParamType.URI);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.SearchParamType.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<CodeSystem.FilterOperator> convertFilterOperator(org.hl7.fhir.r5.model.Enumeration<Enumerations.FilterOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CodeSystem.FilterOperator> tgt = new Enumeration<CodeSystem.FilterOperator>(new CodeSystem.FilterOperatorEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)CodeSystem.FilterOperator.NULL);
        } else {
            switch ((Enumerations.FilterOperator)((Object)src.getValue())) {
                case EQUAL: {
                    tgt.setValue((Object)CodeSystem.FilterOperator.EQUAL);
                    break;
                }
                case ISA: {
                    tgt.setValue((Object)CodeSystem.FilterOperator.ISA);
                    break;
                }
                case DESCENDENTOF: {
                    tgt.setValue((Object)CodeSystem.FilterOperator.DESCENDENTOF);
                    break;
                }
                case ISNOTA: {
                    tgt.setValue((Object)CodeSystem.FilterOperator.ISNOTA);
                    break;
                }
                case REGEX: {
                    tgt.setValue((Object)CodeSystem.FilterOperator.REGEX);
                    break;
                }
                case IN: {
                    tgt.setValue((Object)CodeSystem.FilterOperator.IN);
                    break;
                }
                case NOTIN: {
                    tgt.setValue((Object)CodeSystem.FilterOperator.NOTIN);
                    break;
                }
                case GENERALIZES: {
                    tgt.setValue((Object)CodeSystem.FilterOperator.GENERALIZES);
                    break;
                }
                case EXISTS: {
                    tgt.setValue((Object)CodeSystem.FilterOperator.EXISTS);
                    break;
                }
                default: {
                    tgt.setValue((Object)CodeSystem.FilterOperator.NULL);
                }
            }
        }
        return tgt;
    }

    public static Consent.ConsentPolicyComponent convertConsentPolicyComponent(Consent.ConsentPolicyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ConsentPolicyComponent tgt = new Consent.ConsentPolicyComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasAuthority()) {
            tgt.setAuthorityElement(VersionConvertor_30_50.convertUri(src.getAuthorityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_30_50.convertUri(src.getUriElement()));
        }
        return tgt;
    }

    public static Consent.ConsentPolicyComponent convertConsentPolicyComponent(Consent.ConsentPolicyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ConsentPolicyComponent tgt = new Consent.ConsentPolicyComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasAuthority()) {
            tgt.setAuthorityElement(VersionConvertor_30_50.convertUri(src.getAuthorityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_30_50.convertUri(src.getUriElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Consent.ConsentDataMeaning> convertConsentDataMeaning(Enumeration<Consent.ConsentDataMeaning> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Consent.ConsentDataMeaning> tgt = new org.hl7.fhir.r5.model.Enumeration<Consent.ConsentDataMeaning>(new Consent.ConsentDataMeaningEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Consent.ConsentDataMeaning.NULL);
        } else {
            switch ((Consent.ConsentDataMeaning)((Object)src.getValue())) {
                case INSTANCE: {
                    tgt.setValue((Object)Consent.ConsentDataMeaning.INSTANCE);
                    break;
                }
                case RELATED: {
                    tgt.setValue((Object)Consent.ConsentDataMeaning.RELATED);
                    break;
                }
                case DEPENDENTS: {
                    tgt.setValue((Object)Consent.ConsentDataMeaning.DEPENDENTS);
                    break;
                }
                case AUTHOREDBY: {
                    tgt.setValue((Object)Consent.ConsentDataMeaning.AUTHOREDBY);
                    break;
                }
                default: {
                    tgt.setValue((Object)Consent.ConsentDataMeaning.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Consent.ConsentDataMeaning> convertConsentDataMeaning(org.hl7.fhir.r5.model.Enumeration<Consent.ConsentDataMeaning> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Consent.ConsentDataMeaning> tgt = new Enumeration<Consent.ConsentDataMeaning>(new Consent.ConsentDataMeaningEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Consent.ConsentDataMeaning.NULL);
        } else {
            switch ((Consent.ConsentDataMeaning)((Object)src.getValue())) {
                case INSTANCE: {
                    tgt.setValue((Object)Consent.ConsentDataMeaning.INSTANCE);
                    break;
                }
                case RELATED: {
                    tgt.setValue((Object)Consent.ConsentDataMeaning.RELATED);
                    break;
                }
                case DEPENDENTS: {
                    tgt.setValue((Object)Consent.ConsentDataMeaning.DEPENDENTS);
                    break;
                }
                case AUTHOREDBY: {
                    tgt.setValue((Object)Consent.ConsentDataMeaning.AUTHOREDBY);
                    break;
                }
                default: {
                    tgt.setValue((Object)Consent.ConsentDataMeaning.NULL);
                }
            }
        }
        return tgt;
    }

    public static DocumentManifest.DocumentManifestRelatedComponent convertDocumentManifestRelatedComponent(DocumentManifest.DocumentManifestRelatedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentManifest.DocumentManifestRelatedComponent tgt = new DocumentManifest.DocumentManifestRelatedComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasRef()) {
            tgt.setRef(VersionConvertor_30_50.convertReference(src.getRef()));
        }
        return tgt;
    }

    public static DocumentManifest.DocumentManifestRelatedComponent convertDocumentManifestRelatedComponent(DocumentManifest.DocumentManifestRelatedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentManifest.DocumentManifestRelatedComponent tgt = new DocumentManifest.DocumentManifestRelatedComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasRef()) {
            tgt.setRef(VersionConvertor_30_50.convertReference(src.getRef()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType> convertDocumentRelationshipType(Enumeration<DocumentReference.DocumentRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType>(new Enumerations.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.DocumentRelationshipType.NULL);
        } else {
            switch ((DocumentReference.DocumentRelationshipType)((Object)src.getValue())) {
                case REPLACES: {
                    tgt.setValue((Object)Enumerations.DocumentRelationshipType.REPLACES);
                    break;
                }
                case TRANSFORMS: {
                    tgt.setValue((Object)Enumerations.DocumentRelationshipType.TRANSFORMS);
                    break;
                }
                case SIGNS: {
                    tgt.setValue((Object)Enumerations.DocumentRelationshipType.SIGNS);
                    break;
                }
                case APPENDS: {
                    tgt.setValue((Object)Enumerations.DocumentRelationshipType.APPENDS);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.DocumentRelationshipType.NULL);
                }
            }
        }
        return tgt;
    }

    public static Encounter.DiagnosisComponent convertDiagnosisComponent(Encounter.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.DiagnosisComponent tgt = new Encounter.DiagnosisComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_50.convertReference(src.getCondition()));
        }
        if (src.hasRole()) {
            tgt.setUse(VersionConvertor_30_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_30_50.convertPositiveInt(src.getRankElement()));
        }
        return tgt;
    }

    public static Encounter.DiagnosisComponent convertDiagnosisComponent(Encounter.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.DiagnosisComponent tgt = new Encounter.DiagnosisComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_50.convertReference(src.getCondition()));
        }
        if (src.hasUse()) {
            tgt.setRole(VersionConvertor_30_50.convertCodeableConcept(src.getUse()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_30_50.convertPositiveInt(src.getRankElement()));
        }
        return tgt;
    }

    public static EpisodeOfCare.DiagnosisComponent convertDiagnosisComponent(EpisodeOfCare.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare.DiagnosisComponent tgt = new EpisodeOfCare.DiagnosisComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_50.convertReference(src.getCondition()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_30_50.convertPositiveInt(src.getRankElement()));
        }
        return tgt;
    }

    public static EpisodeOfCare.DiagnosisComponent convertDiagnosisComponent(EpisodeOfCare.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare.DiagnosisComponent tgt = new EpisodeOfCare.DiagnosisComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_50.convertReference(src.getCondition()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasRank()) {
            tgt.setRankElement(VersionConvertor_30_50.convertPositiveInt(src.getRankElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.AdministrativeGender> convertAdministrativeGender(Enumeration<Enumerations.AdministrativeGender> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.AdministrativeGender> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.AdministrativeGender.NULL);
        } else {
            switch ((Enumerations.AdministrativeGender)((Object)src.getValue())) {
                case MALE: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.MALE);
                    break;
                }
                case FEMALE: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.FEMALE);
                    break;
                }
                case OTHER: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.OTHER);
                    break;
                }
                case UNKNOWN: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.UNKNOWN);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.AdministrativeGender> convertAdministrativeGender(org.hl7.fhir.r5.model.Enumeration<Enumerations.AdministrativeGender> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.AdministrativeGender> tgt = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.AdministrativeGender.NULL);
        } else {
            switch ((Enumerations.AdministrativeGender)((Object)src.getValue())) {
                case MALE: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.MALE);
                    break;
                }
                case FEMALE: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.FEMALE);
                    break;
                }
                case OTHER: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.OTHER);
                    break;
                }
                case UNKNOWN: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.UNKNOWN);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.AdministrativeGender.NULL);
                }
            }
        }
        return tgt;
    }

    public static String convertCoding2Uri(Coding code) {
        return code.getSystem() + "/" + code.getCode();
    }

    public static Coding convertUri2Coding(String uri) {
        int i2 = uri.lastIndexOf("/");
        return new Coding().setSystem(uri.substring(0, i2)).setCode(uri.substring(i2 + 1));
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> convertDaysOfWeek(Enumeration<PractitionerRole.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.DaysOfWeek.NULL);
        } else {
            switch ((PractitionerRole.DaysOfWeek)((Object)src.getValue())) {
                case MON: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.MON);
                    break;
                }
                case TUE: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.TUE);
                    break;
                }
                case WED: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.WED);
                    break;
                }
                case THU: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.THU);
                    break;
                }
                case FRI: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.FRI);
                    break;
                }
                case SAT: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.SAT);
                    break;
                }
                case SUN: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.SUN);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.DaysOfWeek.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Provenance convertProvenance(Provenance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Provenance tgt = new org.hl7.fhir.r5.model.Provenance();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getTarget()) {
            tgt.addTarget(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasPeriod()) {
            tgt.setOccurred(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasRecorded()) {
            tgt.setRecordedElement(VersionConvertor_30_50.convertInstant(src.getRecordedElement()));
        }
        for (UriType uriType : src.getPolicy()) {
            tgt.addPolicy((String)uriType.getValue());
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_50.convertReference(src.getLocation()));
        }
        for (Coding coding : src.getReason()) {
            tgt.addReason(VersionConvertor_30_50.convertCodingToCodeableConcept(coding));
        }
        if (src.hasActivity()) {
            tgt.setActivity(VersionConvertor_30_50.convertCodingToCodeableConcept(src.getActivity()));
        }
        for (Provenance.ProvenanceAgentComponent provenanceAgentComponent : src.getAgent()) {
            tgt.addAgent(VersionConvertor_30_50.convertProvenanceAgentComponent(provenanceAgentComponent));
        }
        for (Provenance.ProvenanceEntityComponent provenanceEntityComponent : src.getEntity()) {
            tgt.addEntity(VersionConvertor_30_50.convertProvenanceEntityComponent(provenanceEntityComponent));
        }
        for (Signature signature : src.getSignature()) {
            tgt.addSignature(VersionConvertor_30_50.convertSignature(signature));
        }
        return tgt;
    }

    public static Provenance convertProvenance(org.hl7.fhir.r5.model.Provenance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance tgt = new Provenance();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Reference reference : src.getTarget()) {
            tgt.addTarget(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasOccurredPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getOccurredPeriod()));
        }
        if (src.hasRecorded()) {
            tgt.setRecordedElement(VersionConvertor_30_50.convertInstant(src.getRecordedElement()));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getPolicy()) {
            tgt.addPolicy((String)uriType.getValue());
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_50.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getReason()) {
            for (org.hl7.fhir.r5.model.Coding tc : codeableConcept.getCoding()) {
                tgt.addReason(VersionConvertor_30_50.convertCoding(tc));
            }
        }
        if (src.hasActivity()) {
            tgt.setActivity(VersionConvertor_30_50.convertCoding(src.getActivity()));
        }
        for (Provenance.ProvenanceAgentComponent provenanceAgentComponent : src.getAgent()) {
            tgt.addAgent(VersionConvertor_30_50.convertProvenanceAgentComponent(provenanceAgentComponent));
        }
        for (Provenance.ProvenanceEntityComponent provenanceEntityComponent : src.getEntity()) {
            tgt.addEntity(VersionConvertor_30_50.convertProvenanceEntityComponent(provenanceEntityComponent));
        }
        for (org.hl7.fhir.r5.model.Signature signature : src.getSignature()) {
            tgt.addSignature(VersionConvertor_30_50.convertSignature(signature));
        }
        return tgt;
    }

    public static Provenance.ProvenanceAgentComponent convertProvenanceAgentComponent(Provenance.ProvenanceAgentComponent src) throws FHIRException {
        DataType t;
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceAgentComponent tgt = new Provenance.ProvenanceAgentComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (CodeableConcept t2 : src.getRole()) {
            tgt.addRole(VersionConvertor_30_50.convertCodeableConcept(t2));
        }
        if (src.hasWho()) {
            t = VersionConvertor_30_50.convertType(src.getWho());
            if (t instanceof Reference) {
                tgt.setWho((Reference)t);
            }
            if (t instanceof org.hl7.fhir.r5.model.UriType) {
                tgt.getWho().setReference(t.primitiveValue());
            }
        }
        if (src.hasOnBehalfOf()) {
            t = VersionConvertor_30_50.convertType(src.getOnBehalfOf());
            if (t instanceof Reference) {
                tgt.setOnBehalfOf((Reference)t);
            }
            if (t instanceof org.hl7.fhir.r5.model.UriType) {
                tgt.getOnBehalfOf().setReference(t.primitiveValue());
            }
        }
        return tgt;
    }

    public static Provenance.ProvenanceAgentComponent convertProvenanceAgentComponent(Provenance.ProvenanceAgentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceAgentComponent tgt = new Provenance.ProvenanceAgentComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.CodeableConcept t : src.getRole()) {
            tgt.addRole(VersionConvertor_30_50.convertCodeableConcept(t));
        }
        if (src.hasWho()) {
            tgt.setWho(VersionConvertor_30_50.convertType(src.getWho()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VersionConvertor_30_50.convertType(src.getOnBehalfOf()));
        }
        return tgt;
    }

    public static Provenance.ProvenanceEntityComponent convertProvenanceEntityComponent(Provenance.ProvenanceEntityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceEntityComponent tgt = new Provenance.ProvenanceEntityComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRoleElement(VersionConvertor_30_50.convertProvenanceEntityRole(src.getRoleElement()));
        }
        if (src.hasWhat()) {
            DataType t = VersionConvertor_30_50.convertType(src.getWhat());
            if (t instanceof Reference) {
                tgt.setWhat((Reference)t);
            } else if (t instanceof org.hl7.fhir.r5.model.Identifier) {
                tgt.getWhat().setIdentifier((org.hl7.fhir.r5.model.Identifier)t);
            } else if (t instanceof org.hl7.fhir.r5.model.UriType) {
                tgt.getWhat().setReference(t.primitiveValue());
            }
        }
        for (Provenance.ProvenanceAgentComponent t : src.getAgent()) {
            tgt.addAgent(VersionConvertor_30_50.convertProvenanceAgentComponent(t));
        }
        return tgt;
    }

    public static Provenance.ProvenanceEntityComponent convertProvenanceEntityComponent(Provenance.ProvenanceEntityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceEntityComponent tgt = new Provenance.ProvenanceEntityComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRoleElement(VersionConvertor_30_50.convertProvenanceEntityRole(src.getRoleElement()));
        }
        if (src.hasWhat()) {
            tgt.setWhat(VersionConvertor_30_50.convertType(src.getWhat()));
        }
        for (Provenance.ProvenanceAgentComponent t : src.getAgent()) {
            tgt.addAgent(VersionConvertor_30_50.convertProvenanceAgentComponent(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Provenance.ProvenanceEntityRole> convertProvenanceEntityRole(Enumeration<Provenance.ProvenanceEntityRole> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Provenance.ProvenanceEntityRole> tgt = new org.hl7.fhir.r5.model.Enumeration<Provenance.ProvenanceEntityRole>(new Provenance.ProvenanceEntityRoleEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Provenance.ProvenanceEntityRole.NULL);
        } else {
            switch ((Provenance.ProvenanceEntityRole)((Object)src.getValue())) {
                case DERIVATION: {
                    tgt.setValue((Object)Provenance.ProvenanceEntityRole.DERIVATION);
                    break;
                }
                case REVISION: {
                    tgt.setValue((Object)Provenance.ProvenanceEntityRole.REVISION);
                    break;
                }
                case QUOTATION: {
                    tgt.setValue((Object)Provenance.ProvenanceEntityRole.QUOTATION);
                    break;
                }
                case SOURCE: {
                    tgt.setValue((Object)Provenance.ProvenanceEntityRole.SOURCE);
                    break;
                }
                case REMOVAL: {
                    tgt.setValue((Object)Provenance.ProvenanceEntityRole.REMOVAL);
                    break;
                }
                default: {
                    tgt.setValue((Object)Provenance.ProvenanceEntityRole.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Provenance.ProvenanceEntityRole> convertProvenanceEntityRole(org.hl7.fhir.r5.model.Enumeration<Provenance.ProvenanceEntityRole> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Provenance.ProvenanceEntityRole> tgt = new Enumeration<Provenance.ProvenanceEntityRole>(new Provenance.ProvenanceEntityRoleEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Provenance.ProvenanceEntityRole.NULL);
        } else {
            switch ((Provenance.ProvenanceEntityRole)((Object)src.getValue())) {
                case DERIVATION: {
                    tgt.setValue((Object)Provenance.ProvenanceEntityRole.DERIVATION);
                    break;
                }
                case REVISION: {
                    tgt.setValue((Object)Provenance.ProvenanceEntityRole.REVISION);
                    break;
                }
                case QUOTATION: {
                    tgt.setValue((Object)Provenance.ProvenanceEntityRole.QUOTATION);
                    break;
                }
                case SOURCE: {
                    tgt.setValue((Object)Provenance.ProvenanceEntityRole.SOURCE);
                    break;
                }
                case REMOVAL: {
                    tgt.setValue((Object)Provenance.ProvenanceEntityRole.REMOVAL);
                    break;
                }
                default: {
                    tgt.setValue((Object)Provenance.ProvenanceEntityRole.NULL);
                }
            }
        }
        return tgt;
    }

    public static TestReport.SetupActionComponent convertSetupActionComponent(TestReport.SetupActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionComponent tgt = new TestReport.SetupActionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestReport.SetupActionComponent convertSetupActionComponent(TestReport.SetupActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionComponent tgt = new TestReport.SetupActionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestReport.SetupActionOperationComponent convertSetupActionOperationComponent(TestReport.SetupActionOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionOperationComponent tgt = new TestReport.SetupActionOperationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasResult()) {
            tgt.setResultElement(VersionConvertor_30_50.convertTestReportActionResult(src.getResultElement()));
        }
        if (src.hasMessage()) {
            tgt.setMessageElement(VersionConvertor_30_50.convertMarkdown(src.getMessageElement()));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(VersionConvertor_30_50.convertUri(src.getDetailElement()));
        }
        return tgt;
    }

    public static TestReport.SetupActionOperationComponent convertSetupActionOperationComponent(TestReport.SetupActionOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionOperationComponent tgt = new TestReport.SetupActionOperationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasResult()) {
            tgt.setResultElement(VersionConvertor_30_50.convertTestReportActionResult(src.getResultElement()));
        }
        if (src.hasMessage()) {
            tgt.setMessageElement(VersionConvertor_30_50.convertMarkdown(src.getMessageElement()));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(VersionConvertor_30_50.convertUri(src.getDetailElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportActionResult> convertTestReportActionResult(Enumeration<TestReport.TestReportActionResult> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportActionResult> tgt = new org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportActionResult>(new TestReport.TestReportActionResultEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)TestReport.TestReportActionResult.NULL);
        } else {
            switch ((TestReport.TestReportActionResult)((Object)src.getValue())) {
                case PASS: {
                    tgt.setValue((Object)TestReport.TestReportActionResult.PASS);
                    break;
                }
                case SKIP: {
                    tgt.setValue((Object)TestReport.TestReportActionResult.SKIP);
                    break;
                }
                case FAIL: {
                    tgt.setValue((Object)TestReport.TestReportActionResult.FAIL);
                    break;
                }
                case WARNING: {
                    tgt.setValue((Object)TestReport.TestReportActionResult.WARNING);
                    break;
                }
                case ERROR: {
                    tgt.setValue((Object)TestReport.TestReportActionResult.ERROR);
                    break;
                }
                default: {
                    tgt.setValue((Object)TestReport.TestReportActionResult.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<TestReport.TestReportActionResult> convertTestReportActionResult(org.hl7.fhir.r5.model.Enumeration<TestReport.TestReportActionResult> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestReport.TestReportActionResult> tgt = new Enumeration<TestReport.TestReportActionResult>(new TestReport.TestReportActionResultEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)TestReport.TestReportActionResult.NULL);
        } else {
            switch ((TestReport.TestReportActionResult)((Object)src.getValue())) {
                case PASS: {
                    tgt.setValue((Object)TestReport.TestReportActionResult.PASS);
                    break;
                }
                case SKIP: {
                    tgt.setValue((Object)TestReport.TestReportActionResult.SKIP);
                    break;
                }
                case FAIL: {
                    tgt.setValue((Object)TestReport.TestReportActionResult.FAIL);
                    break;
                }
                case WARNING: {
                    tgt.setValue((Object)TestReport.TestReportActionResult.WARNING);
                    break;
                }
                case ERROR: {
                    tgt.setValue((Object)TestReport.TestReportActionResult.ERROR);
                    break;
                }
                default: {
                    tgt.setValue((Object)TestReport.TestReportActionResult.NULL);
                }
            }
        }
        return tgt;
    }

    public static TestReport.SetupActionAssertComponent convertSetupActionAssertComponent(TestReport.SetupActionAssertComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionAssertComponent tgt = new TestReport.SetupActionAssertComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasResult()) {
            tgt.setResultElement(VersionConvertor_30_50.convertTestReportActionResult(src.getResultElement()));
        }
        if (src.hasMessage()) {
            tgt.setMessageElement(VersionConvertor_30_50.convertMarkdown(src.getMessageElement()));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(VersionConvertor_30_50.convertString(src.getDetailElement()));
        }
        return tgt;
    }

    public static TestReport.SetupActionAssertComponent convertSetupActionAssertComponent(TestReport.SetupActionAssertComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.SetupActionAssertComponent tgt = new TestReport.SetupActionAssertComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasResult()) {
            tgt.setResultElement(VersionConvertor_30_50.convertTestReportActionResult(src.getResultElement()));
        }
        if (src.hasMessage()) {
            tgt.setMessageElement(VersionConvertor_30_50.convertMarkdown(src.getMessageElement()));
        }
        if (src.hasDetail()) {
            tgt.setDetailElement(VersionConvertor_30_50.convertString(src.getDetailElement()));
        }
        return tgt;
    }

    public static TestReport.TestActionComponent convertTestActionComponent(TestReport.TestActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestActionComponent tgt = new TestReport.TestActionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestReport.TestActionComponent convertTestActionComponent(TestReport.TestActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestActionComponent tgt = new TestReport.TestActionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestReport.TeardownActionComponent convertTeardownActionComponent(TestReport.TeardownActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TeardownActionComponent tgt = new TestReport.TeardownActionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static TestReport.TeardownActionComponent convertTeardownActionComponent(TestReport.TeardownActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TeardownActionComponent tgt = new TestReport.TeardownActionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static TestScript.SetupActionComponent convertSetupActionComponent(TestScript.SetupActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionComponent tgt = new TestScript.SetupActionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.SetupActionComponent convertSetupActionComponent(TestScript.SetupActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionComponent tgt = new TestScript.SetupActionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationComponent convertSetupActionOperationComponent(TestScript.SetupActionOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionOperationComponent tgt = new TestScript.SetupActionOperationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCoding(src.getType()));
        }
        if (src.hasResource()) {
            tgt.setResource(TestScript.FHIRDefinedType.fromCode(src.getResource()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_50.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasAccept()) {
            tgt.setAccept(VersionConvertor_30_50.convertContentType(src.getAccept()));
        }
        if (src.hasContentType()) {
            tgt.setContentType(VersionConvertor_30_50.convertContentType(src.getContentType()));
        }
        if (src.hasDestination()) {
            tgt.setDestinationElement(VersionConvertor_30_50.convertInteger(src.getDestinationElement()));
        }
        if (src.hasEncodeRequestUrl()) {
            tgt.setEncodeRequestUrlElement(VersionConvertor_30_50.convertBoolean(src.getEncodeRequestUrlElement()));
        }
        if (src.hasOrigin()) {
            tgt.setOriginElement(VersionConvertor_30_50.convertInteger(src.getOriginElement()));
        }
        if (src.hasParams()) {
            tgt.setParamsElement(VersionConvertor_30_50.convertString(src.getParamsElement()));
        }
        for (TestScript.SetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(VersionConvertor_30_50.convertSetupActionOperationRequestHeaderComponent(t));
        }
        if (src.hasRequestId()) {
            tgt.setRequestIdElement(VersionConvertor_30_50.convertId(src.getRequestIdElement()));
        }
        if (src.hasResponseId()) {
            tgt.setResponseIdElement(VersionConvertor_30_50.convertId(src.getResponseIdElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_30_50.convertId(src.getSourceIdElement()));
        }
        if (src.hasTargetId()) {
            tgt.setTargetId(src.getTargetId());
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertString(src.getUrlElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationComponent convertSetupActionOperationComponent(TestScript.SetupActionOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionOperationComponent tgt = new TestScript.SetupActionOperationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCoding(src.getType()));
        }
        if (src.hasResource()) {
            tgt.setResource(src.getResource().toCode());
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_50.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasAccept()) {
            tgt.setAccept(VersionConvertor_30_50.convertContentType(src.getAccept()));
        }
        if (src.hasContentType()) {
            tgt.setContentType(VersionConvertor_30_50.convertContentType(src.getContentType()));
        }
        if (src.hasDestination()) {
            tgt.setDestinationElement(VersionConvertor_30_50.convertInteger(src.getDestinationElement()));
        }
        if (src.hasEncodeRequestUrl()) {
            tgt.setEncodeRequestUrlElement(VersionConvertor_30_50.convertBoolean(src.getEncodeRequestUrlElement()));
        }
        if (src.hasOrigin()) {
            tgt.setOriginElement(VersionConvertor_30_50.convertInteger(src.getOriginElement()));
        }
        if (src.hasParams()) {
            tgt.setParamsElement(VersionConvertor_30_50.convertString(src.getParamsElement()));
        }
        for (TestScript.SetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(VersionConvertor_30_50.convertSetupActionOperationRequestHeaderComponent(t));
        }
        if (src.hasRequestId()) {
            tgt.setRequestIdElement(VersionConvertor_30_50.convertId(src.getRequestIdElement()));
        }
        if (src.hasResponseId()) {
            tgt.setResponseIdElement(VersionConvertor_30_50.convertId(src.getResponseIdElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_30_50.convertId(src.getSourceIdElement()));
        }
        if (src.hasTargetId()) {
            tgt.setTargetId(src.getTargetId());
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertString(src.getUrlElement()));
        }
        return tgt;
    }

    public static String convertContentType(TestScript.ContentType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case XML: {
                return "application/fhir+xml";
            }
            case JSON: {
                return "application/fhir+json";
            }
            case TTL: {
                return "text/turtle";
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    public static TestScript.ContentType convertContentType(String src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.contains("xml")) {
            return TestScript.ContentType.XML;
        }
        if (src.contains("json")) {
            return TestScript.ContentType.JSON;
        }
        if (src.contains("tu")) {
            return TestScript.ContentType.TTL;
        }
        return TestScript.ContentType.NONE;
    }

    public static TestScript.SetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.SetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionOperationRequestHeaderComponent tgt = new TestScript.SetupActionOperationRequestHeaderComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasField()) {
            tgt.setFieldElement(VersionConvertor_30_50.convertString(src.getFieldElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.SetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionOperationRequestHeaderComponent tgt = new TestScript.SetupActionOperationRequestHeaderComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasField()) {
            tgt.setFieldElement(VersionConvertor_30_50.convertString(src.getFieldElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertComponent convertSetupActionAssertComponent(TestScript.SetupActionAssertComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionAssertComponent tgt = new TestScript.SetupActionAssertComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_50.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDirection()) {
            tgt.setDirectionElement(VersionConvertor_30_50.convertAssertionDirectionType(src.getDirectionElement()));
        }
        if (src.hasCompareToSourceId()) {
            tgt.setCompareToSourceIdElement(VersionConvertor_30_50.convertString(src.getCompareToSourceIdElement()));
        }
        if (src.hasCompareToSourceExpression()) {
            tgt.setCompareToSourceExpressionElement(VersionConvertor_30_50.convertString(src.getCompareToSourceExpressionElement()));
        }
        if (src.hasCompareToSourcePath()) {
            tgt.setCompareToSourcePathElement(VersionConvertor_30_50.convertString(src.getCompareToSourcePathElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentType(VersionConvertor_30_50.convertContentType(src.getContentType()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_50.convertString(src.getExpressionElement()));
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderFieldElement(VersionConvertor_30_50.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasMinimumId()) {
            tgt.setMinimumIdElement(VersionConvertor_30_50.convertString(src.getMinimumIdElement()));
        }
        if (src.hasNavigationLinks()) {
            tgt.setNavigationLinksElement(VersionConvertor_30_50.convertBoolean(src.getNavigationLinksElement()));
        }
        if (src.hasOperator()) {
            tgt.setOperatorElement(VersionConvertor_30_50.convertAssertionOperatorType(src.getOperatorElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_50.convertString(src.getPathElement()));
        }
        if (src.hasRequestMethod()) {
            tgt.setRequestMethodElement(VersionConvertor_30_50.convertTestScriptRequestMethodCode(src.getRequestMethodElement()));
        }
        if (src.hasRequestURL()) {
            tgt.setRequestURLElement(VersionConvertor_30_50.convertString(src.getRequestURLElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(TestScript.FHIRDefinedType.fromCode(src.getResource()));
        }
        if (src.hasResponse()) {
            tgt.setResponseElement(VersionConvertor_30_50.convertAssertionResponseTypes(src.getResponseElement()));
        }
        if (src.hasResponseCode()) {
            tgt.setResponseCodeElement(VersionConvertor_30_50.convertString(src.getResponseCodeElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_30_50.convertId(src.getSourceIdElement()));
        }
        if (src.hasValidateProfileId()) {
            tgt.setValidateProfileIdElement(VersionConvertor_30_50.convertId(src.getValidateProfileIdElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertString(src.getValueElement()));
        }
        if (src.hasWarningOnly()) {
            tgt.setWarningOnlyElement(VersionConvertor_30_50.convertBoolean(src.getWarningOnlyElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertComponent convertSetupActionAssertComponent(TestScript.SetupActionAssertComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionAssertComponent tgt = new TestScript.SetupActionAssertComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_30_50.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDirection()) {
            tgt.setDirectionElement(VersionConvertor_30_50.convertAssertionDirectionType(src.getDirectionElement()));
        }
        if (src.hasCompareToSourceId()) {
            tgt.setCompareToSourceIdElement(VersionConvertor_30_50.convertString(src.getCompareToSourceIdElement()));
        }
        if (src.hasCompareToSourceExpression()) {
            tgt.setCompareToSourceExpressionElement(VersionConvertor_30_50.convertString(src.getCompareToSourceExpressionElement()));
        }
        if (src.hasCompareToSourcePath()) {
            tgt.setCompareToSourcePathElement(VersionConvertor_30_50.convertString(src.getCompareToSourcePathElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentType(VersionConvertor_30_50.convertContentType(src.getContentType()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_50.convertString(src.getExpressionElement()));
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderFieldElement(VersionConvertor_30_50.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasMinimumId()) {
            tgt.setMinimumIdElement(VersionConvertor_30_50.convertString(src.getMinimumIdElement()));
        }
        if (src.hasNavigationLinks()) {
            tgt.setNavigationLinksElement(VersionConvertor_30_50.convertBoolean(src.getNavigationLinksElement()));
        }
        if (src.hasOperator()) {
            tgt.setOperatorElement(VersionConvertor_30_50.convertAssertionOperatorType(src.getOperatorElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(VersionConvertor_30_50.convertString(src.getPathElement()));
        }
        if (src.hasRequestMethod()) {
            tgt.setRequestMethodElement(VersionConvertor_30_50.convertTestScriptRequestMethodCode(src.getRequestMethodElement()));
        }
        if (src.hasRequestURL()) {
            tgt.setRequestURLElement(VersionConvertor_30_50.convertString(src.getRequestURLElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(src.getResource().toCode());
        }
        if (src.hasResponse()) {
            tgt.setResponseElement(VersionConvertor_30_50.convertAssertionResponseTypes(src.getResponseElement()));
        }
        if (src.hasResponseCode()) {
            tgt.setResponseCodeElement(VersionConvertor_30_50.convertString(src.getResponseCodeElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(VersionConvertor_30_50.convertId(src.getSourceIdElement()));
        }
        if (src.hasValidateProfileId()) {
            tgt.setValidateProfileIdElement(VersionConvertor_30_50.convertId(src.getValidateProfileIdElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertString(src.getValueElement()));
        }
        if (src.hasWarningOnly()) {
            tgt.setWarningOnlyElement(VersionConvertor_30_50.convertBoolean(src.getWarningOnlyElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionDirectionType> convertAssertionDirectionType(Enumeration<TestScript.AssertionDirectionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionDirectionType> tgt = new org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionDirectionType>(new TestScript.AssertionDirectionTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)TestScript.AssertionDirectionType.NULL);
        } else {
            switch ((TestScript.AssertionDirectionType)((Object)src.getValue())) {
                case RESPONSE: {
                    tgt.setValue((Object)TestScript.AssertionDirectionType.RESPONSE);
                    break;
                }
                case REQUEST: {
                    tgt.setValue((Object)TestScript.AssertionDirectionType.REQUEST);
                    break;
                }
                default: {
                    tgt.setValue((Object)TestScript.AssertionDirectionType.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionDirectionType> convertAssertionDirectionType(org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionDirectionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionDirectionType> tgt = new Enumeration<TestScript.AssertionDirectionType>(new TestScript.AssertionDirectionTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)TestScript.AssertionDirectionType.NULL);
        } else {
            switch ((TestScript.AssertionDirectionType)((Object)src.getValue())) {
                case RESPONSE: {
                    tgt.setValue((Object)TestScript.AssertionDirectionType.RESPONSE);
                    break;
                }
                case REQUEST: {
                    tgt.setValue((Object)TestScript.AssertionDirectionType.REQUEST);
                    break;
                }
                default: {
                    tgt.setValue((Object)TestScript.AssertionDirectionType.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionOperatorType> convertAssertionOperatorType(Enumeration<TestScript.AssertionOperatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionOperatorType> tgt = new org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionOperatorType>(new TestScript.AssertionOperatorTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)TestScript.AssertionOperatorType.NULL);
        } else {
            switch ((TestScript.AssertionOperatorType)((Object)src.getValue())) {
                case EQUALS: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.EQUALS);
                    break;
                }
                case NOTEQUALS: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEQUALS);
                    break;
                }
                case IN: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.IN);
                    break;
                }
                case NOTIN: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.NOTIN);
                    break;
                }
                case GREATERTHAN: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.GREATERTHAN);
                    break;
                }
                case LESSTHAN: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.LESSTHAN);
                    break;
                }
                case EMPTY: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.EMPTY);
                    break;
                }
                case NOTEMPTY: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEMPTY);
                    break;
                }
                case CONTAINS: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.CONTAINS);
                    break;
                }
                case NOTCONTAINS: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.NOTCONTAINS);
                    break;
                }
                case EVAL: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.EVAL);
                    break;
                }
                default: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionOperatorType> convertAssertionOperatorType(org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionOperatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionOperatorType> tgt = new Enumeration<TestScript.AssertionOperatorType>(new TestScript.AssertionOperatorTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)TestScript.AssertionOperatorType.NULL);
        } else {
            switch ((TestScript.AssertionOperatorType)((Object)src.getValue())) {
                case EQUALS: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.EQUALS);
                    break;
                }
                case NOTEQUALS: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEQUALS);
                    break;
                }
                case IN: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.IN);
                    break;
                }
                case NOTIN: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.NOTIN);
                    break;
                }
                case GREATERTHAN: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.GREATERTHAN);
                    break;
                }
                case LESSTHAN: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.LESSTHAN);
                    break;
                }
                case EMPTY: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.EMPTY);
                    break;
                }
                case NOTEMPTY: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEMPTY);
                    break;
                }
                case CONTAINS: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.CONTAINS);
                    break;
                }
                case NOTCONTAINS: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.NOTCONTAINS);
                    break;
                }
                case EVAL: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.EVAL);
                    break;
                }
                default: {
                    tgt.setValue((Object)TestScript.AssertionOperatorType.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TestScript.TestScriptRequestMethodCode> convertTestScriptRequestMethodCode(Enumeration<TestScript.TestScriptRequestMethodCode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TestScript.TestScriptRequestMethodCode> tgt = new org.hl7.fhir.r5.model.Enumeration<TestScript.TestScriptRequestMethodCode>(new TestScript.TestScriptRequestMethodCodeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.NULL);
        } else {
            switch ((TestScript.TestScriptRequestMethodCode)((Object)src.getValue())) {
                case DELETE: {
                    tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.DELETE);
                    break;
                }
                case GET: {
                    tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.GET);
                    break;
                }
                case OPTIONS: {
                    tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.OPTIONS);
                    break;
                }
                case PATCH: {
                    tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.PATCH);
                    break;
                }
                case POST: {
                    tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.POST);
                    break;
                }
                case PUT: {
                    tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.PUT);
                    break;
                }
                default: {
                    tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.TestScriptRequestMethodCode> convertTestScriptRequestMethodCode(org.hl7.fhir.r5.model.Enumeration<TestScript.TestScriptRequestMethodCode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.TestScriptRequestMethodCode> tgt = new Enumeration<TestScript.TestScriptRequestMethodCode>(new TestScript.TestScriptRequestMethodCodeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.NULL);
        } else {
            switch ((TestScript.TestScriptRequestMethodCode)((Object)src.getValue())) {
                case DELETE: {
                    tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.DELETE);
                    break;
                }
                case GET: {
                    tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.GET);
                    break;
                }
                case OPTIONS: {
                    tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.OPTIONS);
                    break;
                }
                case PATCH: {
                    tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.PATCH);
                    break;
                }
                case POST: {
                    tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.POST);
                    break;
                }
                case PUT: {
                    tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.PUT);
                    break;
                }
                default: {
                    tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionResponseTypes> convertAssertionResponseTypes(Enumeration<TestScript.AssertionResponseTypes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionResponseTypes> tgt = new org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionResponseTypes>(new TestScript.AssertionResponseTypesEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)TestScript.AssertionResponseTypes.NULL);
        } else {
            switch ((TestScript.AssertionResponseTypes)((Object)src.getValue())) {
                case OKAY: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.OKAY);
                    break;
                }
                case CREATED: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.CREATED);
                    break;
                }
                case NOCONTENT: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.NOCONTENT);
                    break;
                }
                case NOTMODIFIED: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTMODIFIED);
                    break;
                }
                case BAD: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.BAD);
                    break;
                }
                case FORBIDDEN: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.FORBIDDEN);
                    break;
                }
                case NOTFOUND: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTFOUND);
                    break;
                }
                case METHODNOTALLOWED: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.METHODNOTALLOWED);
                    break;
                }
                case CONFLICT: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.CONFLICT);
                    break;
                }
                case GONE: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.GONE);
                    break;
                }
                case PRECONDITIONFAILED: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.PRECONDITIONFAILED);
                    break;
                }
                case UNPROCESSABLE: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.UNPROCESSABLE);
                    break;
                }
                default: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionResponseTypes> convertAssertionResponseTypes(org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionResponseTypes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionResponseTypes> tgt = new Enumeration<TestScript.AssertionResponseTypes>(new TestScript.AssertionResponseTypesEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)TestScript.AssertionResponseTypes.NULL);
        } else {
            switch ((TestScript.AssertionResponseTypes)((Object)src.getValue())) {
                case OKAY: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.OKAY);
                    break;
                }
                case CREATED: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.CREATED);
                    break;
                }
                case NOCONTENT: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.NOCONTENT);
                    break;
                }
                case NOTMODIFIED: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTMODIFIED);
                    break;
                }
                case BAD: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.BAD);
                    break;
                }
                case FORBIDDEN: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.FORBIDDEN);
                    break;
                }
                case NOTFOUND: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTFOUND);
                    break;
                }
                case METHODNOTALLOWED: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.METHODNOTALLOWED);
                    break;
                }
                case CONFLICT: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.CONFLICT);
                    break;
                }
                case GONE: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.GONE);
                    break;
                }
                case PRECONDITIONFAILED: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.PRECONDITIONFAILED);
                    break;
                }
                case UNPROCESSABLE: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.UNPROCESSABLE);
                    break;
                }
                default: {
                    tgt.setValue((Object)TestScript.AssertionResponseTypes.NULL);
                }
            }
        }
        return tgt;
    }

    public static TestScript.TestActionComponent convertTestActionComponent(TestScript.TestActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestActionComponent tgt = new TestScript.TestActionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.TestActionComponent convertTestActionComponent(TestScript.TestActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestActionComponent tgt = new TestScript.TestActionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(VersionConvertor_30_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.TeardownActionComponent convertTeardownActionComponent(TestScript.TeardownActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TeardownActionComponent tgt = new TestScript.TeardownActionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static TestScript.TeardownActionComponent convertTeardownActionComponent(TestScript.TeardownActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TeardownActionComponent tgt = new TestScript.TeardownActionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(VersionConvertor_30_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.FilterOperator> convertFilterOperator(Enumeration<ValueSet.FilterOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.FilterOperator> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.FilterOperator>(new Enumerations.FilterOperatorEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getValue() == null) {
            tgt.setValue((Object)Enumerations.FilterOperator.NULL);
        } else {
            switch ((ValueSet.FilterOperator)((Object)src.getValue())) {
                case EQUAL: {
                    tgt.setValue((Object)Enumerations.FilterOperator.EQUAL);
                    break;
                }
                case ISA: {
                    tgt.setValue((Object)Enumerations.FilterOperator.ISA);
                    break;
                }
                case DESCENDENTOF: {
                    tgt.setValue((Object)Enumerations.FilterOperator.DESCENDENTOF);
                    break;
                }
                case ISNOTA: {
                    tgt.setValue((Object)Enumerations.FilterOperator.ISNOTA);
                    break;
                }
                case REGEX: {
                    tgt.setValue((Object)Enumerations.FilterOperator.REGEX);
                    break;
                }
                case IN: {
                    tgt.setValue((Object)Enumerations.FilterOperator.IN);
                    break;
                }
                case NOTIN: {
                    tgt.setValue((Object)Enumerations.FilterOperator.NOTIN);
                    break;
                }
                case GENERALIZES: {
                    tgt.setValue((Object)Enumerations.FilterOperator.GENERALIZES);
                    break;
                }
                case EXISTS: {
                    tgt.setValue((Object)Enumerations.FilterOperator.EXISTS);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.FilterOperator.NULL);
                }
            }
        }
        return tgt;
    }

    public static Resource convertResource(org.hl7.fhir.dstu3.model.Resource src, boolean nullOk) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Parameters) {
            return Parameters30_50.convertParameters((org.hl7.fhir.dstu3.model.Parameters)src);
        }
        if (src instanceof ActivityDefinition) {
            return ActivityDefinition30_50.convertActivityDefinition((ActivityDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.AllergyIntolerance) {
            return AllergyIntolerance30_50.convertAllergyIntolerance((org.hl7.fhir.dstu3.model.AllergyIntolerance)src);
        }
        if (src instanceof Appointment) {
            return Appointment30_50.convertAppointment((Appointment)src);
        }
        if (src instanceof AppointmentResponse) {
            return AppointmentResponse30_50.convertAppointmentResponse((AppointmentResponse)src);
        }
        if (src instanceof AuditEvent) {
            return AuditEvent30_50.convertAuditEvent((AuditEvent)src);
        }
        if (src instanceof Basic) {
            return Basic30_50.convertBasic((Basic)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Binary) {
            return Binary30_50.convertBinary((org.hl7.fhir.dstu3.model.Binary)src);
        }
        if (src instanceof BodySite) {
            return BodySite30_50.convertBodySite((BodySite)src);
        }
        if (src instanceof Bundle) {
            return Bundle30_50.convertBundle((Bundle)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.CapabilityStatement) {
            return CapabilityStatement30_50.convertCapabilityStatement((org.hl7.fhir.dstu3.model.CapabilityStatement)src);
        }
        if (src instanceof CarePlan) {
            return CarePlan30_50.convertCarePlan((CarePlan)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.CareTeam) {
            return CareTeam30_50.convertCareTeam((org.hl7.fhir.dstu3.model.CareTeam)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ClinicalImpression) {
            return ClinicalImpression30_50.convertClinicalImpression((org.hl7.fhir.dstu3.model.ClinicalImpression)src);
        }
        if (src instanceof CodeSystem) {
            return CodeSystem30_50.convertCodeSystem((CodeSystem)src);
        }
        if (src instanceof Communication) {
            return Communication30_50.convertCommunication((Communication)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.CompartmentDefinition) {
            return CompartmentDefinition30_50.convertCompartmentDefinition((org.hl7.fhir.dstu3.model.CompartmentDefinition)src);
        }
        if (src instanceof Composition) {
            return Composition30_50.convertComposition((Composition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ConceptMap) {
            return ConceptMap30_50.convertConceptMap((org.hl7.fhir.dstu3.model.ConceptMap)src);
        }
        if (src instanceof Condition) {
            return Condition30_50.convertCondition((Condition)src);
        }
        if (src instanceof Consent) {
            return Consent30_50.convertConsent((Consent)src);
        }
        if (src instanceof DataElement) {
            return DataElement30_50.convertDataElement((DataElement)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DetectedIssue) {
            return DetectedIssue30_50.convertDetectedIssue((org.hl7.fhir.dstu3.model.DetectedIssue)src);
        }
        if (src instanceof DeviceUseStatement) {
            return DeviceUseStatement30_50.convertDeviceUseStatement((DeviceUseStatement)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DiagnosticReport) {
            return DiagnosticReport30_50.convertDiagnosticReport((org.hl7.fhir.dstu3.model.DiagnosticReport)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DocumentReference) {
            return DocumentReference30_50.convertDocumentReference((org.hl7.fhir.dstu3.model.DocumentReference)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Encounter) {
            return Encounter30_50.convertEncounter((org.hl7.fhir.dstu3.model.Encounter)src);
        }
        if (src instanceof Endpoint) {
            return Endpoint30_50.convertEndpoint((Endpoint)src);
        }
        if (src instanceof EpisodeOfCare) {
            return EpisodeOfCare30_50.convertEpisodeOfCare((EpisodeOfCare)src);
        }
        if (src instanceof ExpansionProfile) {
            return ExpansionProfile30_50.convertExpansionProfile((ExpansionProfile)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.FamilyMemberHistory) {
            return FamilyMemberHistory30_50.convertFamilyMemberHistory((org.hl7.fhir.dstu3.model.FamilyMemberHistory)src);
        }
        if (src instanceof Flag) {
            return Flag30_50.convertFlag((Flag)src);
        }
        if (src instanceof Goal) {
            return Goal30_50.convertGoal((Goal)src);
        }
        if (src instanceof GraphDefinition) {
            return GraphDefinition30_50.convertGraphDefinition((GraphDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Group) {
            return Group30_50.convertGroup((org.hl7.fhir.dstu3.model.Group)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.HealthcareService) {
            return HealthcareService30_50.convertHealthcareService((org.hl7.fhir.dstu3.model.HealthcareService)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ImagingStudy) {
            return ImagingStudy30_50.convertImagingStudy((org.hl7.fhir.dstu3.model.ImagingStudy)src);
        }
        if (src instanceof Immunization) {
            return Immunization30_50.convertImmunization((Immunization)src);
        }
        if (src instanceof ImplementationGuide) {
            return ImplementationGuide30_50.convertImplementationGuide((ImplementationGuide)src);
        }
        if (src instanceof Library) {
            return Library30_50.convertLibrary((Library)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Linkage) {
            return Linkage30_50.convertLinkage((org.hl7.fhir.dstu3.model.Linkage)src);
        }
        if (src instanceof ListResource) {
            return List30_50.convertList((ListResource)src);
        }
        if (src instanceof Location) {
            return Location30_50.convertLocation((Location)src);
        }
        if (src instanceof Measure) {
            return Measure30_50.convertMeasure((Measure)src);
        }
        if (src instanceof Media) {
            return Media30_50.convertMedia((Media)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Medication) {
            return Medication30_50.convertMedication((org.hl7.fhir.dstu3.model.Medication)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.MedicationAdministration) {
            return MedicationAdministration30_50.convertMedicationAdministration((org.hl7.fhir.dstu3.model.MedicationAdministration)src);
        }
        if (src instanceof MedicationDispense) {
            return MedicationDispense30_50.convertMedicationDispense((MedicationDispense)src);
        }
        if (src instanceof MedicationRequest) {
            return MedicationRequest30_50.convertMedicationRequest((MedicationRequest)src);
        }
        if (src instanceof MedicationStatement) {
            return MedicationStatement30_50.convertMedicationStatement((MedicationStatement)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.MessageDefinition) {
            return MessageDefinition30_50.convertMessageDefinition((org.hl7.fhir.dstu3.model.MessageDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.MessageHeader) {
            return MessageHeader30_50.convertMessageHeader((org.hl7.fhir.dstu3.model.MessageHeader)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.NamingSystem) {
            return NamingSystem30_50.convertNamingSystem((org.hl7.fhir.dstu3.model.NamingSystem)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Observation) {
            return Observation30_50.convertObservation((org.hl7.fhir.dstu3.model.Observation)src);
        }
        if (src instanceof OperationDefinition) {
            return OperationDefinition30_50.convertOperationDefinition((OperationDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.OperationOutcome) {
            return OperationOutcome30_50.convertOperationOutcome((org.hl7.fhir.dstu3.model.OperationOutcome)src);
        }
        if (src instanceof Organization) {
            return Organization30_50.convertOrganization((Organization)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Patient) {
            return Patient30_50.convertPatient((org.hl7.fhir.dstu3.model.Patient)src);
        }
        if (src instanceof PaymentNotice) {
            return PaymentNotice30_50.convertPaymentNotice((PaymentNotice)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Person) {
            return Person30_50.convertPerson((org.hl7.fhir.dstu3.model.Person)src);
        }
        if (src instanceof PlanDefinition) {
            return PlanDefinition30_50.convertPlanDefinition((PlanDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Practitioner) {
            return Practitioner30_50.convertPractitioner((org.hl7.fhir.dstu3.model.Practitioner)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.PractitionerRole) {
            return PractitionerRole30_50.convertPractitionerRole((org.hl7.fhir.dstu3.model.PractitionerRole)src);
        }
        if (src instanceof Provenance) {
            return Provenance30_50.convertProvenance((Provenance)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Questionnaire) {
            return Questionnaire30_50.convertQuestionnaire((org.hl7.fhir.dstu3.model.Questionnaire)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.QuestionnaireResponse) {
            return QuestionnaireResponse30_50.convertQuestionnaireResponse((org.hl7.fhir.dstu3.model.QuestionnaireResponse)src);
        }
        if (src instanceof RelatedPerson) {
            return RelatedPerson30_50.convertRelatedPerson((RelatedPerson)src);
        }
        if (src instanceof RiskAssessment) {
            return RiskAssessment30_50.convertRiskAssessment((RiskAssessment)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Schedule) {
            return Schedule30_50.convertSchedule((org.hl7.fhir.dstu3.model.Schedule)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.SearchParameter) {
            return SearchParameter30_50.convertSearchParameter((org.hl7.fhir.dstu3.model.SearchParameter)src);
        }
        if (src instanceof Sequence) {
            return Sequence30_50.convertSequence((Sequence)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Slot) {
            return Slot30_50.convertSlot((org.hl7.fhir.dstu3.model.Slot)src);
        }
        if (src instanceof Specimen) {
            return Specimen30_50.convertSpecimen((Specimen)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.StructureDefinition) {
            return StructureDefinition30_50.convertStructureDefinition((org.hl7.fhir.dstu3.model.StructureDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.StructureMap) {
            return StructureMap30_50.convertStructureMap((org.hl7.fhir.dstu3.model.StructureMap)src);
        }
        if (src instanceof Substance) {
            return Substance30_50.convertSubstance((Substance)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.SupplyDelivery) {
            return SupplyDelivery30_50.convertSupplyDelivery((org.hl7.fhir.dstu3.model.SupplyDelivery)src);
        }
        if (src instanceof TestReport) {
            return TestReport30_50.convertTestReport((TestReport)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.TestScript) {
            return TestScript30_50.convertTestScript((org.hl7.fhir.dstu3.model.TestScript)src);
        }
        if (src instanceof ValueSet) {
            return ValueSet30_50.convertValueSet((ValueSet)src);
        }
        if (!nullOk) {
            throw new FHIRException("Unknown resource " + src.fhirType());
        }
        return null;
    }

    public static org.hl7.fhir.dstu3.model.Resource convertResource(Resource src, boolean nullOk) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src instanceof Parameters) {
            if (((Parameters)src).hasParameter("profile-url")) {
                return ExpansionProfile30_50.convertExpansionProfile((Parameters)src);
            }
            return Parameters30_50.convertParameters((Parameters)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ActivityDefinition) {
            return ActivityDefinition30_50.convertActivityDefinition((org.hl7.fhir.r5.model.ActivityDefinition)src);
        }
        if (src instanceof AllergyIntolerance) {
            return AllergyIntolerance30_50.convertAllergyIntolerance((AllergyIntolerance)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Appointment) {
            return Appointment30_50.convertAppointment((org.hl7.fhir.r5.model.Appointment)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.AppointmentResponse) {
            return AppointmentResponse30_50.convertAppointmentResponse((org.hl7.fhir.r5.model.AppointmentResponse)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.AuditEvent) {
            return AuditEvent30_50.convertAuditEvent((org.hl7.fhir.r5.model.AuditEvent)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Basic) {
            return Basic30_50.convertBasic((org.hl7.fhir.r5.model.Basic)src);
        }
        if (src instanceof Binary) {
            return Binary30_50.convertBinary((Binary)src);
        }
        if (src instanceof BodyStructure) {
            return BodySite30_50.convertBodySite((BodyStructure)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Bundle) {
            return Bundle30_50.convertBundle((org.hl7.fhir.r5.model.Bundle)src);
        }
        if (src instanceof CapabilityStatement) {
            return CapabilityStatement30_50.convertCapabilityStatement((CapabilityStatement)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.CarePlan) {
            return CarePlan30_50.convertCarePlan((org.hl7.fhir.r5.model.CarePlan)src);
        }
        if (src instanceof CareTeam) {
            return CareTeam30_50.convertCareTeam((CareTeam)src);
        }
        if (src instanceof ClinicalImpression) {
            return ClinicalImpression30_50.convertClinicalImpression((ClinicalImpression)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.CodeSystem) {
            return CodeSystem30_50.convertCodeSystem((org.hl7.fhir.r5.model.CodeSystem)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Communication) {
            return Communication30_50.convertCommunication((org.hl7.fhir.r5.model.Communication)src);
        }
        if (src instanceof CompartmentDefinition) {
            return CompartmentDefinition30_50.convertCompartmentDefinition((CompartmentDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Composition) {
            return Composition30_50.convertComposition((org.hl7.fhir.r5.model.Composition)src);
        }
        if (src instanceof ConceptMap) {
            return ConceptMap30_50.convertConceptMap((ConceptMap)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Condition) {
            return Condition30_50.convertCondition((org.hl7.fhir.r5.model.Condition)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Consent) {
            return Consent30_50.convertConsent((org.hl7.fhir.r5.model.Consent)src);
        }
        if (src instanceof DetectedIssue) {
            return DetectedIssue30_50.convertDetectedIssue((DetectedIssue)src);
        }
        if (src instanceof DeviceUsage) {
            return DeviceUseStatement30_50.convertDeviceUseStatement((DeviceUsage)src);
        }
        if (src instanceof DiagnosticReport) {
            return DiagnosticReport30_50.convertDiagnosticReport((DiagnosticReport)src);
        }
        if (src instanceof DocumentReference) {
            return DocumentReference30_50.convertDocumentReference((DocumentReference)src);
        }
        if (src instanceof Encounter) {
            return Encounter30_50.convertEncounter((Encounter)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Endpoint) {
            return Endpoint30_50.convertEndpoint((org.hl7.fhir.r5.model.Endpoint)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.EpisodeOfCare) {
            return EpisodeOfCare30_50.convertEpisodeOfCare((org.hl7.fhir.r5.model.EpisodeOfCare)src);
        }
        if (src instanceof FamilyMemberHistory) {
            return FamilyMemberHistory30_50.convertFamilyMemberHistory((FamilyMemberHistory)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Flag) {
            return Flag30_50.convertFlag((org.hl7.fhir.r5.model.Flag)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Goal) {
            return Goal30_50.convertGoal((org.hl7.fhir.r5.model.Goal)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.GraphDefinition) {
            return GraphDefinition30_50.convertGraphDefinition((org.hl7.fhir.r5.model.GraphDefinition)src);
        }
        if (src instanceof Group) {
            return Group30_50.convertGroup((Group)src);
        }
        if (src instanceof HealthcareService) {
            return HealthcareService30_50.convertHealthcareService((HealthcareService)src);
        }
        if (src instanceof ImagingStudy) {
            return ImagingStudy30_50.convertImagingStudy((ImagingStudy)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Immunization) {
            return Immunization30_50.convertImmunization((org.hl7.fhir.r5.model.Immunization)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ImplementationGuide) {
            return ImplementationGuide30_50.convertImplementationGuide((org.hl7.fhir.r5.model.ImplementationGuide)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Library) {
            return Library30_50.convertLibrary((org.hl7.fhir.r5.model.Library)src);
        }
        if (src instanceof Linkage) {
            return Linkage30_50.convertLinkage((Linkage)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ListResource) {
            return List30_50.convertList((org.hl7.fhir.r5.model.ListResource)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Location) {
            return Location30_50.convertLocation((org.hl7.fhir.r5.model.Location)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Measure) {
            return Measure30_50.convertMeasure((org.hl7.fhir.r5.model.Measure)src);
        }
        if (src instanceof DocumentReference) {
            return Media30_50.convertMedia((DocumentReference)src);
        }
        if (src instanceof Medication) {
            return Medication30_50.convertMedication((Medication)src);
        }
        if (src instanceof MedicationAdministration) {
            return MedicationAdministration30_50.convertMedicationAdministration((MedicationAdministration)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.MedicationDispense) {
            return MedicationDispense30_50.convertMedicationDispense((org.hl7.fhir.r5.model.MedicationDispense)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.MedicationRequest) {
            return MedicationRequest30_50.convertMedicationRequest((org.hl7.fhir.r5.model.MedicationRequest)src);
        }
        if (src instanceof MedicationUsage) {
            return MedicationStatement30_50.convertMedicationStatement((MedicationUsage)src);
        }
        if (src instanceof MessageDefinition) {
            return MessageDefinition30_50.convertMessageDefinition((MessageDefinition)src);
        }
        if (src instanceof MessageHeader) {
            return MessageHeader30_50.convertMessageHeader((MessageHeader)src);
        }
        if (src instanceof NamingSystem) {
            return NamingSystem30_50.convertNamingSystem((NamingSystem)src);
        }
        if (src instanceof Observation) {
            return Observation30_50.convertObservation((Observation)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.OperationDefinition) {
            return OperationDefinition30_50.convertOperationDefinition((org.hl7.fhir.r5.model.OperationDefinition)src);
        }
        if (src instanceof OperationOutcome) {
            return OperationOutcome30_50.convertOperationOutcome((OperationOutcome)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Organization) {
            return Organization30_50.convertOrganization((org.hl7.fhir.r5.model.Organization)src);
        }
        if (src instanceof Patient) {
            return Patient30_50.convertPatient((Patient)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.PaymentNotice) {
            return PaymentNotice30_50.convertPaymentNotice((org.hl7.fhir.r5.model.PaymentNotice)src);
        }
        if (src instanceof Person) {
            return Person30_50.convertPerson((Person)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.PlanDefinition) {
            return PlanDefinition30_50.convertPlanDefinition((org.hl7.fhir.r5.model.PlanDefinition)src);
        }
        if (src instanceof Practitioner) {
            return Practitioner30_50.convertPractitioner((Practitioner)src);
        }
        if (src instanceof PractitionerRole) {
            return PractitionerRole30_50.convertPractitionerRole((PractitionerRole)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Provenance) {
            return Provenance30_50.convertProvenance((org.hl7.fhir.r5.model.Provenance)src);
        }
        if (src instanceof Questionnaire) {
            return Questionnaire30_50.convertQuestionnaire((Questionnaire)src);
        }
        if (src instanceof QuestionnaireResponse) {
            return QuestionnaireResponse30_50.convertQuestionnaireResponse((QuestionnaireResponse)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.RelatedPerson) {
            return RelatedPerson30_50.convertRelatedPerson((org.hl7.fhir.r5.model.RelatedPerson)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.RiskAssessment) {
            return RiskAssessment30_50.convertRiskAssessment((org.hl7.fhir.r5.model.RiskAssessment)src);
        }
        if (src instanceof Schedule) {
            return Schedule30_50.convertSchedule((Schedule)src);
        }
        if (src instanceof SearchParameter) {
            return SearchParameter30_50.convertSearchParameter((SearchParameter)src);
        }
        if (src instanceof MolecularSequence) {
            return Sequence30_50.convertSequence((MolecularSequence)src);
        }
        if (src instanceof Slot) {
            return Slot30_50.convertSlot((Slot)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Specimen) {
            return Specimen30_50.convertSpecimen((org.hl7.fhir.r5.model.Specimen)src);
        }
        if (src instanceof StructureDefinition) {
            return StructureDefinition30_50.convertStructureDefinition((StructureDefinition)src);
        }
        if (src instanceof StructureMap) {
            return StructureMap30_50.convertStructureMap((StructureMap)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Substance) {
            return Substance30_50.convertSubstance((org.hl7.fhir.r5.model.Substance)src);
        }
        if (src instanceof SupplyDelivery) {
            return SupplyDelivery30_50.convertSupplyDelivery((SupplyDelivery)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.TestReport) {
            return TestReport30_50.convertTestReport((org.hl7.fhir.r5.model.TestReport)src);
        }
        if (src instanceof TestScript) {
            return TestScript30_50.convertTestScript((TestScript)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ValueSet) {
            return ValueSet30_50.convertValueSet((org.hl7.fhir.r5.model.ValueSet)src);
        }
        if (!nullOk) {
            throw new FHIRException("Unknown resource " + src.fhirType());
        }
        return null;
    }

    public static TerminologyCapabilities convertTerminologyCapabilities(org.hl7.fhir.dstu3.model.Parameters src, boolean b) {
        TerminologyCapabilities res = new TerminologyCapabilities();
        for (Parameters.ParametersParameterComponent p : src.getParameter()) {
            if (p.getName().equals("system")) {
                res.addCodeSystem().setUri(p.getValue().primitiveValue());
            }
            if (!p.getName().equals("expansion.parameter")) continue;
            res.getExpansion().addParameter().setName(p.getValue().primitiveValue());
        }
        return res;
    }

    public static boolean convertsResource(String rt) {
        return Utilities.existsInList(rt, "Parameters", "ActivityDefinition", "AllergyIntolerance", "Appointment", "AppointmentResponse", "AuditEvent", "Basic", "Binary", "BodyStructure", "Bundle", "CapabilityStatement", "CarePlan", "CareTeam", "ClinicalImpression", "CodeSystem", "Communication", "CompartmentDefinition", "Composition", "ConceptMap", "Condition", "Consent", "DetectedIssue", "DeviceUseStatement", "DiagnosticReport", "DocumentReference", "Encounter", "Endpoint", "EpisodeOfCare", "FamilyMemberHistory", "Flag", "Goal", "GraphDefinition", "Group", "HealthcareService", "ImagingStudy", "Immunization", "ImplementationGuide", "Library", "Linkage", "ListResource", "Location", "Media", "Medication", "MedicationAdministration", "MedicationDispense", "MedicationRequest", "MedicationStatement", "MessageDefinition", "MessageHeader", "NamingSystem", "Observation", "OperationDefinition", "OperationOutcome", "Organization", "Patient", "PaymentNotice", "Person", "PlanDefinition", "Practitioner", "PractitionerRole", "ProcessRequest", "Questionnaire", "QuestionnaireResponse", "RelatedPerson", "RiskAssessment", "Schedule", "SearchParameter", "Sequence", "Slot", "Specimen", "StructureDefinition", "StructureMap", "Subscription", "Substance", "SupplyDelivery", "TestReport", "TestScript", "ValueSet");
    }

    static {
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/11179-permitted-value-conceptmap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/11179-permitted-value-valueset");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/codesystem-map");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/cqif-library");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-inheritedExtensibleValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/event-instantiatesCanonical");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-allowedProfile");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-deMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-sourceStructureMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-targetStructureMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-unit-valueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-map");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-supplement");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-system");
    }
}

