/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.hl7.fhir.convertors.TransformContextR2R3;
import org.hl7.fhir.convertors.loaders.R2ToR3Loader;
import org.hl7.fhir.dstu2.formats.JsonParser;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu3.context.SimpleWorkerContext;
import org.hl7.fhir.dstu3.elementmodel.Element;
import org.hl7.fhir.dstu3.elementmodel.Manager;
import org.hl7.fhir.dstu3.elementmodel.XmlParser;
import org.hl7.fhir.dstu3.formats.FormatUtilities;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ExpansionProfile;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.PractitionerRole;
import org.hl7.fhir.dstu3.model.ResourceFactory;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.StructureMap;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.utils.StructureMapUtilities;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.TextFile;

public class R2R3ConversionManager
implements StructureMapUtilities.ITransformerServices {
    private SimpleWorkerContext contextR2;
    private SimpleWorkerContext contextR3;
    private Map<String, StructureMap> library = new HashMap<String, StructureMap>();
    private boolean needPrepare = false;
    private List<org.hl7.fhir.dstu3.model.Resource> extras = new ArrayList<org.hl7.fhir.dstu3.model.Resource>();
    private StructureMapUtilities smu3;
    private StructureMapUtilities smu2;
    private IParser.OutputStyle style = IParser.OutputStyle.PRETTY;

    public IParser.OutputStyle getStyle() {
        return this.style;
    }

    public void setStyle(IParser.OutputStyle style) {
        this.style = style;
    }

    public List<org.hl7.fhir.dstu3.model.Resource> getExtras() {
        return this.extras;
    }

    public void setR2Definitions(InputStream stream) throws IOException, FHIRException {
        this.needPrepare = true;
        R2ToR3Loader ldr = new R2ToR3Loader();
        ldr.setPatchUrls(true).setKillPrimitives(true);
        Map<String, InputStream> files = this.readInputStream(stream);
        this.contextR2 = new SimpleWorkerContext();
        this.contextR2.setAllowLoadingDuplicates(true);
        this.contextR2.loadFromFile(files.get("profiles-types.xml"), "profiles-types.xml", ldr);
        this.contextR2.loadFromFile(files.get("profiles-resources.xml"), "profiles-resources.xml", ldr);
        this.contextR2.loadFromFile(files.get("valuesets.xml"), "valuesets.xml", ldr);
    }

    public void setR2Definitions(String source) throws IOException, FHIRException {
        File f = new File(source);
        if (f.exists()) {
            this.setR2Definitions(new FileInputStream(f));
        } else {
            this.setR2Definitions(this.fetch(source));
        }
    }

    public void setR3Definitions(InputStream stream) throws IOException, FHIRException {
        this.needPrepare = true;
        Map<String, InputStream> files = this.readInputStream(stream);
        this.contextR3 = new SimpleWorkerContext();
        this.contextR2.setAllowLoadingDuplicates(true);
        this.contextR3.loadFromFile(files.get("profiles-types.xml"), "profiles-types.xml", null);
        this.contextR3.loadFromFile(files.get("profiles-resources.xml"), "profiles-resources.xml", null);
        this.contextR3.loadFromFile(files.get("extension-definitions.xml"), "extension-definitions.xml", null);
        this.contextR3.loadFromFile(files.get("valuesets.xml"), "valuesets.xml", null);
        this.contextR3.setCanRunWithoutTerminology(true);
    }

    public void setR3Definitions(String source) throws FileNotFoundException, IOException, FHIRException {
        File f = new File(source);
        if (f.exists()) {
            this.setR3Definitions(new FileInputStream(f));
        } else {
            this.setR3Definitions(this.fetch(source));
        }
    }

    public void setMappingLibrary(InputStream stream) throws IOException, FHIRException {
        this.needPrepare = true;
        Map<String, InputStream> files = this.readInputStream(stream);
        for (InputStream s2 : files.values()) {
            StructureMap sm = new StructureMapUtilities(this.contextR3).parse(TextFile.streamToString(s2));
            this.library.put(sm.getUrl(), sm);
        }
    }

    public void setMappingLibrary(String source) throws IOException, FHIRException {
        File f = new File(source);
        if (f.exists()) {
            this.setMappingLibrary(new FileInputStream(f));
        } else {
            this.setMappingLibrary(this.fetch(source));
        }
    }

    private InputStream fetch(String source) {
        throw new Error("not done yet");
    }

    private Map<String, InputStream> readInputStream(InputStream stream) throws IOException {
        HashMap<String, InputStream> res = new HashMap<String, InputStream>();
        ZipInputStream zip2 = new ZipInputStream(stream);
        ZipEntry ze = null;
        while ((ze = zip2.getNextEntry()) != null) {
            String n = ze.getName();
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            int c = zip2.read();
            while (c != -1) {
                bs.write(c);
                c = zip2.read();
            }
            bs.close();
            res.put(n, new ByteArrayInputStream(bs.toByteArray()));
            zip2.closeEntry();
        }
        zip2.close();
        return res;
    }

    private void prepare() throws FHIRException {
        if (this.contextR2 == null) {
            throw new FHIRException("No R2 definitions provided");
        }
        if (this.contextR3 == null) {
            throw new FHIRException("No R3 definitions provided");
        }
        if (this.library == null) {
            throw new FHIRException("No R2/R# conversion maps provided");
        }
        if (this.needPrepare) {
            StructureDefinition sdn;
            for (StructureDefinition sd : this.contextR2.allStructures()) {
                sdn = sd.copy();
                sdn.getExtension().clear();
                this.contextR3.seeResource(sdn.getUrl(), sdn);
            }
            for (StructureDefinition sd : this.contextR3.allStructures()) {
                if (sd.getKind() != StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) continue;
                this.contextR2.seeResource(sd.getUrl(), sd);
                sdn = sd.copy();
                sdn.setUrl(sdn.getUrl().replace("http://hl7.org/fhir/", "http://hl7.org/fhir/DSTU2/"));
                sdn.addExtension().setUrl("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace").setValue(new UriType("http://hl7.org/fhir"));
                this.contextR2.seeResource(sdn.getUrl(), sdn);
                this.contextR3.seeResource(sdn.getUrl(), sdn);
            }
            this.contextR2.setExpansionProfile(new ExpansionProfile().setUrl("urn:uuid:" + UUID.randomUUID().toString().toLowerCase()));
            this.contextR3.setExpansionProfile(new ExpansionProfile().setUrl("urn:uuid:" + UUID.randomUUID().toString().toLowerCase()));
            this.smu3 = new StructureMapUtilities(this.contextR3, this.library, this);
            this.smu2 = new StructureMapUtilities(this.contextR2, this.library, this);
            this.needPrepare = false;
        }
    }

    public byte[] convert(byte[] source, boolean r2ToR3, Manager.FhirFormat format) throws FHIRException, IOException {
        this.prepare();
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        if (r2ToR3) {
            this.convertToR3(new ByteArrayInputStream(source), bs, format);
        } else {
            this.convertToR2(new ByteArrayInputStream(source), bs, format);
        }
        bs.close();
        return bs.toByteArray();
    }

    public void convert(InputStream source, OutputStream dest, boolean r2ToR3, Manager.FhirFormat format) throws FHIRException, IOException {
        this.prepare();
        if (r2ToR3) {
            this.convertToR3(source, dest, format);
        } else {
            this.convertToR2(source, dest, format);
        }
    }

    public Resource convert(org.hl7.fhir.dstu3.model.Resource source) throws IOException, FHIRFormatError, FHIRException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        new org.hl7.fhir.dstu3.formats.JsonParser().compose(bs, source);
        bs.close();
        return new JsonParser().parse(this.convert(bs.toByteArray(), false, Manager.FhirFormat.JSON));
    }

    public org.hl7.fhir.dstu3.model.Resource convert(Resource source) throws IOException, FHIRFormatError, FHIRException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        new JsonParser().compose((OutputStream)bs, source);
        bs.close();
        return new org.hl7.fhir.dstu3.formats.JsonParser().parse(this.convert(bs.toByteArray(), false, Manager.FhirFormat.JSON));
    }

    private void convertToR3(InputStream source, OutputStream dest, Manager.FhirFormat format) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        Element r2 = new XmlParser(this.contextR2).parse(source);
        StructureMap map = this.library.get("http://hl7.org/fhir/StructureMap/" + r2.fhirType() + "2to3");
        if (map == null) {
            throw new FHIRException("No Map Found from R2 to R3 for " + r2.fhirType());
        }
        String tn = this.smu3.getTargetType(map).getType();
        org.hl7.fhir.dstu3.model.Resource r3 = ResourceFactory.createResource(tn);
        this.smu3.transform(new TransformContextR2R3(this.contextR3, r2.getChildValue("id")), r2, map, r3);
        FormatUtilities.makeParser(format).setOutputStyle(this.style).compose(dest, r3);
    }

    private void convertToR2(InputStream source, OutputStream dest, Manager.FhirFormat format) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        Element r3 = new XmlParser(this.contextR3).parse(source);
        StructureMap map = this.library.get("??");
        String tn = this.smu3.getTargetType(map).getType();
        StructureDefinition sd = this.smu2.getTargetType(map);
        Element r2 = Manager.build(this.contextR2, sd);
        this.smu2.transform(this.contextR2, r3, map, r2);
        Manager.compose(this.contextR2, r2, dest, format, this.style, null);
    }

    @Override
    public void log(String message) {
    }

    @Override
    public Base createType(Object appInfo, String name) throws FHIRException {
        SimpleWorkerContext context = ((TransformContextR2R3)appInfo).getContext();
        if (context == this.contextR2) {
            StructureDefinition sd = context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/DSTU2/StructureDefinition/" + name);
            if (sd == null) {
                throw new FHIRException("Type not found: '" + name + "'");
            }
            return Manager.build(context, sd);
        }
        return ResourceFactory.createResourceOrType(name);
    }

    @Override
    public Base createResource(Object appInfo, Base res) {
        if (res instanceof org.hl7.fhir.dstu3.model.Resource && (res.fhirType().equals("CodeSystem") || res.fhirType().equals("CareTeam")) || res.fhirType().equals("PractitionerRole")) {
            org.hl7.fhir.dstu3.model.Resource r = (org.hl7.fhir.dstu3.model.Resource)res;
            this.extras.add(r);
            r.setId(((TransformContextR2R3)appInfo).getId() + "-" + this.extras.size());
        }
        return res;
    }

    @Override
    public Coding translate(Object appInfo, Coding source, String conceptMapUrl) throws FHIRException {
        throw new Error("translate not done yet");
    }

    @Override
    public Base resolveReference(Object appContext, String url) {
        for (org.hl7.fhir.dstu3.model.Resource r : this.extras) {
            MetadataResource mr;
            if (r instanceof MetadataResource && url.equals((mr = (MetadataResource)r).getUrl())) {
                return mr;
            }
            if (!url.equals(r.fhirType() + "/" + r.getId())) continue;
            return r;
        }
        return null;
    }

    @Override
    public List<Base> performSearch(Object appContext, String url) {
        String[] vals;
        ArrayList<Base> results = new ArrayList<Base>();
        String[] parts = url.split("\\?");
        if (parts.length == 2 && parts[0].substring(1).equals("PractitionerRole") && (vals = parts[1].split("\\=")).length == 2 && vals[0].equals("practitioner")) {
            for (org.hl7.fhir.dstu3.model.Resource r : this.extras) {
                if (!(r instanceof PractitionerRole) || !((PractitionerRole)r).getPractitioner().getReference().equals("Practitioner/" + vals[1])) continue;
                results.add(r);
            }
        }
        return results;
    }

    public static void main(String[] args2) throws IOException, FHIRException {
        if (!(args2.length != 0 && R2R3ConversionManager.hasParam(args2, "-d2") && R2R3ConversionManager.hasParam(args2, "-d3") && R2R3ConversionManager.hasParam(args2, "-maps") && R2R3ConversionManager.hasParam(args2, "-src") && R2R3ConversionManager.hasParam(args2, "-dest") && (R2R3ConversionManager.hasParam(args2, "-r2") || R2R3ConversionManager.hasParam(args2, "-r3")))) {
            System.out.println("R2 <--> R3 Convertor");
            System.out.println("====================");
            System.out.println("");
            System.out.println("parameters: -d2 [r2 definitions] -d3 [r3 definitions] -maps [map source] -src [source] -dest [dest] -r2/3 - fmt [format]");
            System.out.println("");
            System.out.println("d2: definitions from http://hl7.org/fhir/DSTU2/downloads.html");
            System.out.println("d3: definitions from http://hl7.org/fhir/STU3/downloads.html");
            System.out.println("maps: R2/R3 maps from http://hl7.org/fhir/r2r3maps.zip");
            System.out.println("src: filename for source to convert");
            System.out.println("dest: filename for destination of conversion");
            System.out.println("-r2: source is r2, convert to r3");
            System.out.println("-r3: source is r3, convert to r2");
            System.out.println("-fmt: xml | json (xml is default)");
        } else {
            R2R3ConversionManager self = new R2R3ConversionManager();
            self.setR2Definitions(R2R3ConversionManager.getNamedParam(args2, "-d2"));
            self.setR3Definitions(R2R3ConversionManager.getNamedParam(args2, "-d3"));
            self.setMappingLibrary(R2R3ConversionManager.getNamedParam(args2, "-maps"));
            Manager.FhirFormat fmt = R2R3ConversionManager.hasParam(args2, "-fmt") ? (R2R3ConversionManager.getNamedParam(args2, "-fmt").equalsIgnoreCase("json") ? Manager.FhirFormat.JSON : Manager.FhirFormat.XML) : Manager.FhirFormat.XML;
            FileInputStream src = new FileInputStream(R2R3ConversionManager.getNamedParam(args2, "-src"));
            FileOutputStream dst = new FileOutputStream(R2R3ConversionManager.getNamedParam(args2, "-dest"));
            self.convert(src, dst, R2R3ConversionManager.hasParam(args2, "-r2"), fmt);
        }
    }

    private static boolean hasParam(String[] args2, String param) {
        for (String a : args2) {
            if (!a.equals(param)) continue;
            return true;
        }
        return false;
    }

    private static String getNamedParam(String[] args2, String param) {
        boolean found = false;
        for (String a : args2) {
            if (found) {
                return a;
            }
            if (!a.equals(param)) continue;
            found = true;
        }
        return null;
    }
}

