/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import net.sf.saxon.tree.util.FastStringBuffer;

public class ProcInstParser {
    private ProcInstParser() {
    }

    public static String getPseudoAttribute(String content, String name) {
        int pos = 0;
        while (pos <= content.length() - 4) {
            int nextQuote = -1;
            for (int q = pos; q < content.length(); ++q) {
                if (content.charAt(q) != '\"' && content.charAt(q) != '\'') continue;
                nextQuote = q;
                break;
            }
            if (nextQuote < 0) {
                return null;
            }
            int closingQuote = content.indexOf(content.charAt(nextQuote), nextQuote + 1);
            if (closingQuote < 0) {
                return null;
            }
            int nextName = content.indexOf(name, pos);
            if (nextName < 0) {
                return null;
            }
            if (nextName < nextQuote) {
                boolean found = true;
                for (int s2 = nextName + name.length(); s2 < nextQuote; ++s2) {
                    char c = content.charAt(s2);
                    if (Character.isWhitespace(c) || c == '=') continue;
                    found = false;
                    break;
                }
                if (found) {
                    String val = content.substring(nextQuote + 1, closingQuote);
                    String u = ProcInstParser.unescape(val);
                    if (u == null) {
                        return val;
                    }
                    return u;
                }
            }
            pos = closingQuote + 1;
        }
        return null;
    }

    private static String unescape(String value) {
        if (value.indexOf(38) < 0) {
            return value;
        }
        FastStringBuffer sb = new FastStringBuffer(value.length());
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c = value.charAt(i2);
            if (c == '&') {
                if (i2 + 2 < value.length() && value.charAt(i2 + 1) == '#') {
                    int digit;
                    int x;
                    int charval;
                    if (value.charAt(i2 + 2) == 'x') {
                        charval = 0;
                        for (x = i2 + 3; x < value.length() && value.charAt(x) != ';'; ++x) {
                            digit = "0123456789abcdef".indexOf(value.charAt(x));
                            if (digit < 0) {
                                digit = "0123456789ABCDEF".indexOf(value.charAt(x));
                            }
                            if (digit < 0) {
                                return null;
                            }
                            charval = charval * 16 + digit;
                        }
                        char hexchar = (char)charval;
                        sb.append(hexchar);
                        i2 = x;
                        continue;
                    }
                    charval = 0;
                    for (x = i2 + 2; x < value.length() && value.charAt(x) != ';'; ++x) {
                        digit = "0123456789".indexOf(value.charAt(x));
                        if (digit < 0) {
                            return null;
                        }
                        charval = charval * 10 + digit;
                    }
                    char decchar = (char)charval;
                    sb.append(decchar);
                    i2 = x;
                    continue;
                }
                if (value.substring(i2 + 1).startsWith("lt;")) {
                    sb.append('<');
                    i2 += 3;
                    continue;
                }
                if (value.substring(i2 + 1).startsWith("gt;")) {
                    sb.append('>');
                    i2 += 3;
                    continue;
                }
                if (value.substring(i2 + 1).startsWith("amp;")) {
                    sb.append('&');
                    i2 += 4;
                    continue;
                }
                if (value.substring(i2 + 1).startsWith("quot;")) {
                    sb.append('\"');
                    i2 += 5;
                    continue;
                }
                if (value.substring(i2 + 1).startsWith("apos;")) {
                    sb.append('\'');
                    i2 += 5;
                    continue;
                }
                return null;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

