/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize.charcode;

import net.sf.saxon.serialize.charcode.CharacterSet;

public final class UTF8CharacterSet
implements CharacterSet {
    private static UTF8CharacterSet theInstance = new UTF8CharacterSet();

    private UTF8CharacterSet() {
    }

    public static UTF8CharacterSet getInstance() {
        return theInstance;
    }

    public boolean inCharset(int c) {
        return true;
    }

    public String getCanonicalName() {
        return "UTF-8";
    }

    public static int getUTF8Encoding(char in, char in2, byte[] out) {
        char i2 = in;
        if (i2 <= '\u007f') {
            out[0] = (byte)i2;
            return 1;
        }
        if (i2 <= '\u07ff') {
            out[0] = (byte)(0xC0 | in >> 6 & 0x1F);
            out[1] = (byte)(0x80 | in & 0x3F);
            return 2;
        }
        if (i2 >= '\ud800' && i2 <= '\udbff') {
            char j = in2;
            if (j < '\udc00' || j > '\udfff') {
                throw new IllegalArgumentException("Malformed Unicode Surrogate Pair (" + i2 + ',' + j + ')');
            }
            byte xxxxxx = (byte)(j & 0x3F);
            byte yyyyyy = (byte)((i2 & 3) << 4 | j >> 6 & 0xF);
            byte zzzz = (byte)(i2 >> 2 & 0xF);
            byte uuuuu = (byte)((i2 >> 6 & 0xF) + 1);
            out[0] = (byte)(0xF0 | uuuuu >> 2 & 7);
            out[1] = (byte)(0x80 | (uuuuu & 3) << 4 | zzzz);
            out[2] = (byte)(0x80 | yyyyyy);
            out[3] = (byte)(0x80 | xxxxxx);
            return 4;
        }
        if (i2 >= '\udc00' && i2 <= '\udfff') {
            return 0;
        }
        out[0] = (byte)(0xE0 | in >> 12 & 0xF);
        out[1] = (byte)(0x80 | in >> 6 & 0x3F);
        out[2] = (byte)(0x80 | in & 0x3F);
        return 3;
    }

    public static int decodeUTF8(byte[] in, int used) throws IllegalArgumentException {
        int bottom = 0;
        for (int i2 = 1; i2 < used; ++i2) {
            if ((in[i2] & 0xC0) != 128) {
                throw new IllegalArgumentException("Byte " + (i2 + 1) + " in UTF-8 sequence has wrong top bits");
            }
            bottom = (bottom << 6) + (in[i2] & 0x3F);
        }
        if ((in[0] & 0x80) == 0) {
            if (used == 1) {
                return in[0];
            }
            throw new IllegalArgumentException("UTF8 single byte expected");
        }
        if ((in[0] & 0xE0) == 192) {
            if (used != 2) {
                throw new IllegalArgumentException("UTF8 sequence of two bytes expected");
            }
            return ((in[0] & 0x1F) << 6) + bottom;
        }
        if ((in[0] & 0xF0) == 224) {
            if (used != 3) {
                throw new IllegalArgumentException("UTF8 sequence of three bytes expected");
            }
            return ((in[0] & 0xF) << 12) + bottom;
        }
        if ((in[0] & 0xF8) == 248) {
            if (used != 4) {
                throw new IllegalArgumentException("UTF8 sequence of four bytes expected");
            }
            return ((in[0] & 7) << 24) + bottom;
        }
        throw new IllegalArgumentException("UTF8 invalid first byte");
    }
}

