/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.ma.json.JsonReceiver;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.ExpandedStreamResult;
import net.sf.saxon.serialize.charcode.CharacterSet;
import net.sf.saxon.serialize.codenorm.Normalizer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.z.IntPredicate;

public class JSONWriter {
    private ExpandedStreamResult result;
    private Writer writer;
    private Normalizer normalizer;
    private CharacterMap characterMap;
    private Properties outputProperties;
    private CharacterSet characterSet;
    private boolean indent;
    private boolean first = true;
    private boolean afterKey = false;
    private int level;
    private boolean unfailing = false;

    public JSONWriter(PipelineConfiguration pipe, StreamResult result, Properties outputProperties) throws XPathException {
        this.setOutputProperties(outputProperties);
        this.result = new ExpandedStreamResult(pipe.getConfiguration(), result, outputProperties);
    }

    public void setOutputProperties(Properties details) throws XPathException {
        this.outputProperties = details;
        if ("yes".equals(details.getProperty("indent"))) {
            this.indent = true;
        }
        if ("yes".equals(details.getProperty("{http://saxon.sf.net/}unfailing"))) {
            this.unfailing = true;
        }
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public void setNormalizer(Normalizer normalizer) {
        this.normalizer = normalizer;
    }

    public void setCharacterMap(CharacterMap map) {
        this.characterMap = map;
    }

    public void writeKey(String key) throws XPathException {
        this.conditionalComma();
        this.emit('\"');
        this.emit(this.escape(key));
        this.emit("\":");
        this.afterKey = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeAtomicValue(AtomicValue item) throws XPathException {
        this.conditionalComma();
        if (item == null) {
            this.emit("null");
            return;
        } else if (item instanceof NumericValue) {
            if (((NumericValue)item).isNaN()) {
                if (!this.unfailing) throw new XPathException("JSON has no way of representing NaN", "SERE0020");
                this.emit("NaN");
                return;
            } else if (Double.isInfinite(((NumericValue)item).getDoubleValue())) {
                if (!this.unfailing) throw new XPathException("JSON has no way of representing Infinity", "SERE0020");
                this.emit(((NumericValue)item).getDoubleValue() < 0.0 ? "-INF" : "INF");
                return;
            } else {
                this.emit(item.getStringValue());
            }
            return;
        } else if (item instanceof BooleanValue) {
            this.emit(item.getStringValue());
            return;
        } else {
            this.emit('\"');
            this.emit(this.escape(item.getStringValue()));
            this.emit('\"');
        }
    }

    public void startArray() throws XPathException {
        this.emitOpen('[', this.level++);
    }

    public void endArray() throws XPathException {
        this.emitClose(']', this.level--);
    }

    public void startMap() throws XPathException {
        this.emitOpen('{', this.level++);
    }

    public void endMap() throws XPathException {
        this.emitClose('}', this.level--);
    }

    private void emitOpen(char bracket, int level) throws XPathException {
        this.conditionalComma();
        if (this.indent) {
            this.emit(' ');
        }
        this.emit(bracket);
        this.first = true;
        if (this.indent) {
            this.emit('\n');
            for (int i2 = 0; i2 < 2 * (level + 1); ++i2) {
                this.emit(' ');
            }
        }
    }

    private void emitClose(char bracket, int level) throws XPathException {
        if (this.indent) {
            this.emit('\n');
            for (int i2 = 0; i2 <= 2 * level; ++i2) {
                this.emit(' ');
            }
        }
        this.emit(bracket);
        this.first = false;
    }

    private void conditionalComma() throws XPathException {
        if (this.first) {
            this.first = false;
        } else if (!this.afterKey) {
            this.emit(',');
        }
        this.afterKey = false;
        if (this.indent) {
            this.emit('\n');
            for (int i2 = 0; i2 < 2 * (this.level + 1); ++i2) {
                this.emit(' ');
            }
        }
    }

    private CharSequence escape(CharSequence cs) throws XPathException {
        if (this.characterMap != null) {
            int start;
            FastStringBuffer out = new FastStringBuffer(cs.length());
            cs = this.characterMap.map(cs, true);
            String s2 = cs.toString();
            int prev = 0;
            while ((start = s2.indexOf(0, prev)) >= 0) {
                out.append(this.simpleEscape(s2.substring(prev, start)));
                int end = s2.indexOf(0, start + 1);
                out.append(s2.substring(start + 1, end));
                prev = end + 1;
            }
            out.append(this.simpleEscape(s2.substring(prev)));
            return out;
        }
        return this.simpleEscape(cs);
    }

    private CharSequence simpleEscape(CharSequence cs) throws XPathException {
        if (this.normalizer != null) {
            cs = this.normalizer.normalize(cs);
        }
        return JsonReceiver.escape(cs, false, new IntPredicate(){

            public boolean matches(int c) {
                return c < 31 || c >= 127 && c <= 159 || !JSONWriter.this.characterSet.inCharset(c);
            }
        });
    }

    private void emit(CharSequence s2) throws XPathException {
        if (this.writer == null) {
            this.writer = this.result.obtainWriter();
            this.characterSet = this.result.getCharacterSet();
        }
        try {
            this.writer.append(s2);
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    private void emit(char c) throws XPathException {
        this.emit(c + "");
    }

    public void close() throws XPathException {
        if (this.first) {
            this.emit("null");
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

