/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.Arrays;
import java.util.HashSet;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.HTMLTagHashSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.type.SchemaType;

public class HTMLIndenter
extends ProxyReceiver {
    private int level = 0;
    protected char[] indentChars = new char[]{'\n', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private boolean sameLine = false;
    private boolean inFormattedTag = false;
    private boolean afterInline = false;
    private boolean afterFormatted = true;
    private boolean afterEndElement = false;
    private int[] propertyStack = new int[20];
    private NameClassifier classifier;
    private static final String[] inlineTags = new String[]{"a", "abbr", "acronym", "applet", "area", "audio", "b", "basefont", "bdi", "bdo", "big", "br", "button", "canvas", "cite", "code", "data", "datalist", "del", "dfn", "em", "embed", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "link", "map", "mark", "math", "meter", "noscript", "object", "output", "picture", "progress", "q", "ruby", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "svg", "template", "textarea", "time", "tt", "u", "var", "video", "wbr"};
    static final String[] formattedTags = new String[]{"pre", "script", "style", "textarea", "title", "xmp"};

    public HTMLIndenter(Receiver next, String method) {
        super(next);
        this.classifier = "xhtml".equals(method) ? XHTML4NameClassifier.THE_INSTANCE : ("xhtml5".equals(method) ? XHTML5NameClassifier.THE_INSTANCE : HTMLNameClassifier.THE_INSTANCE);
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        int tagProps = this.classifier.classifyTag(nameCode);
        if (this.level >= this.propertyStack.length) {
            this.propertyStack = Arrays.copyOf(this.propertyStack, this.level * 2);
        }
        this.propertyStack[this.level] = tagProps;
        boolean inlineTag = (tagProps & 1) != 0;
        boolean bl = this.inFormattedTag = this.inFormattedTag || (tagProps & 2) != 0;
        if (!(inlineTag || this.inFormattedTag || this.afterInline || this.afterFormatted)) {
            this.indent();
        }
        this.nextReceiver.startElement(nameCode, typeCode, location, properties);
        ++this.level;
        this.sameLine = true;
        this.afterInline = false;
        this.afterFormatted = false;
        this.afterEndElement = false;
    }

    public void endElement() throws XPathException {
        boolean thisFormatted;
        --this.level;
        boolean thisInline = (this.propertyStack[this.level] & 1) != 0;
        boolean bl = thisFormatted = (this.propertyStack[this.level] & 2) != 0;
        if (!(thisInline || thisFormatted || this.afterInline || this.sameLine || this.afterFormatted || this.inFormattedTag)) {
            this.indent();
            this.afterInline = false;
            this.afterFormatted = false;
        } else {
            this.afterInline = thisInline;
            this.afterFormatted = thisFormatted;
        }
        this.nextReceiver.endElement();
        this.inFormattedTag = this.inFormattedTag && !thisFormatted;
        this.sameLine = false;
        this.afterEndElement = true;
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.inFormattedTag || (properties & 0x100) != 0 || (properties & 1) != 0) {
            this.nextReceiver.characters(chars, locationId, properties);
        } else {
            int lastNL = 0;
            for (int i2 = 0; i2 < chars.length(); ++i2) {
                if (chars.charAt(i2) != '\n' && (i2 - lastNL <= this.getLineLength() || chars.charAt(i2) != ' ')) continue;
                this.sameLine = false;
                this.nextReceiver.characters(chars.subSequence(lastNL, i2), locationId, properties);
                this.indent();
                for (lastNL = i2 + 1; lastNL < chars.length() && chars.charAt(lastNL) == ' '; ++lastNL) {
                }
            }
            if (lastNL < chars.length()) {
                this.nextReceiver.characters(chars.subSequence(lastNL, chars.length()), locationId, properties);
            }
        }
        this.afterInline = false;
        this.afterEndElement = false;
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.indent();
        this.nextReceiver.comment(chars, locationId, properties);
        this.afterEndElement = false;
    }

    private void indent() throws XPathException {
        int spaces = this.level * this.getIndentation();
        if (spaces + 1 >= this.indentChars.length) {
            int increment = 5 * this.getIndentation();
            if (spaces + 1 > this.indentChars.length + increment) {
                increment += spaces + 1;
            }
            char[] c2 = new char[this.indentChars.length + increment];
            System.arraycopy(this.indentChars, 0, c2, 0, this.indentChars.length);
            Arrays.fill(c2, this.indentChars.length, c2.length, ' ');
            this.indentChars = c2;
        }
        this.nextReceiver.characters(new CharSlice(this.indentChars, 0, spaces + 1), ExplicitLocation.UNKNOWN_LOCATION, 0);
        this.sameLine = false;
    }

    protected int getIndentation() {
        return 3;
    }

    protected int getLineLength() {
        return 80;
    }

    static class XHTML5NameClassifier
    implements NameClassifier {
        static final XHTML5NameClassifier THE_INSTANCE = new XHTML5NameClassifier();
        private static HTMLTagHashSet inlineTable = new HTMLTagHashSet(101);
        private static HTMLTagHashSet formattedTable = new HTMLTagHashSet(23);
        private static NodeName SVG = new FingerprintedQName("svg", "http://www.w3.org/2000/svg", "svg");
        private static NodeName MATH = new FingerprintedQName("math", "http://www.w3.org/1998/Math/MathML", "math");

        XHTML5NameClassifier() {
        }

        public int classifyTag(NodeName name) {
            if (name.hasURI("http://www.w3.org/1999/xhtml") || name.hasURI("") || name.equals(SVG) || name.equals(MATH)) {
                int r = 0;
                if (inlineTable.contains(name.getLocalPart())) {
                    r |= 1;
                }
                if (formattedTable.contains(name.getLocalPart())) {
                    r |= 2;
                }
                return r;
            }
            return 0;
        }

        static {
            for (String inlineTag : inlineTags) {
                inlineTable.add(inlineTag);
            }
            for (String formattedTag : formattedTags) {
                formattedTable.add(formattedTag);
            }
        }
    }

    static class XHTML4NameClassifier
    implements NameClassifier {
        static final XHTML4NameClassifier THE_INSTANCE = new XHTML4NameClassifier();
        private static final HashSet<NodeName> inlineTagSet = new HashSet(50);
        private static final HashSet<NodeName> formattedTagSet = new HashSet(10);

        XHTML4NameClassifier() {
        }

        public int classifyTag(NodeName name) {
            int r = 0;
            if (inlineTagSet.contains(name)) {
                r |= 1;
            }
            if (formattedTagSet.contains(name)) {
                r |= 2;
            }
            return r;
        }

        static {
            for (String inlineTag : inlineTags) {
                String ns = "http://www.w3.org/1999/xhtml";
                if (inlineTag.equals("math")) {
                    ns = "http://www.w3.org/2005/xpath-functions/math";
                } else if (inlineTag.equals("svg")) {
                    ns = "http://www.w3.org/2000/svg";
                }
                inlineTagSet.add(new FingerprintedQName("", ns, inlineTag));
            }
            for (String formattedTag : formattedTags) {
                formattedTagSet.add(new FingerprintedQName("", "http://www.w3.org/1999/xhtml", formattedTag));
            }
        }
    }

    static class HTMLNameClassifier
    implements NameClassifier {
        static final HTMLNameClassifier THE_INSTANCE = new HTMLNameClassifier();
        private static HTMLTagHashSet inlineTable = new HTMLTagHashSet(101);
        private static HTMLTagHashSet formattedTable = new HTMLTagHashSet(23);

        HTMLNameClassifier() {
        }

        public int classifyTag(NodeName elemName) {
            int r = 0;
            String tag = elemName.getDisplayName();
            if (inlineTable.contains(tag)) {
                r |= 1;
            }
            if (formattedTable.contains(tag)) {
                r |= 2;
            }
            return r;
        }

        static {
            for (String inlineTag : inlineTags) {
                inlineTable.add(inlineTag);
            }
            for (String formattedTag : formattedTags) {
                formattedTable.add(formattedTag);
            }
        }
    }

    static interface NameClassifier {
        public static final int IS_INLINE = 1;
        public static final int IS_FORMATTED = 2;

        public int classifyTag(NodeName var1);
    }
}

