/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmFunctionItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.value.AtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XdmMap
extends XdmFunctionItem {
    public XdmMap() {
        this.setValue(new HashTrieMap());
    }

    public XdmMap(MapItem map) {
        super(map);
    }

    public XdmMap(Map<? extends XdmAtomicValue, ? extends XdmValue> map) {
        HashTrieMap val = new HashTrieMap();
        for (Map.Entry<? extends XdmAtomicValue, ? extends XdmValue> entry : map.entrySet()) {
            val.initialPut(entry.getKey().getUnderlyingValue(), entry.getValue().getUnderlyingValue());
        }
        this.setValue(val);
    }

    @Override
    public MapItem getUnderlyingValue() {
        return (MapItem)super.getUnderlyingValue();
    }

    public int mapSize() {
        return this.getUnderlyingValue().size();
    }

    public XdmMap put(XdmAtomicValue key, XdmValue value) {
        XdmMap map2 = new XdmMap();
        map2.setValue(this.getUnderlyingValue().addEntry(key.getUnderlyingValue(), value.getUnderlyingValue()));
        return map2;
    }

    public XdmMap remove(XdmAtomicValue key) {
        XdmMap map2 = new XdmMap();
        map2.setValue(this.getUnderlyingValue().remove(key.getUnderlyingValue()));
        return map2;
    }

    public Set<XdmAtomicValue> keySet() {
        AtomicValue key;
        HashSet<XdmAtomicValue> result = new HashSet<XdmAtomicValue>();
        AtomicIterator iter = this.getUnderlyingValue().keys();
        while ((key = iter.next()) != null) {
            result.add((XdmAtomicValue)XdmValue.wrap(key));
        }
        return result;
    }

    public Map<XdmAtomicValue, XdmValue> asImmutableMap() {
        final XdmMap base = this;
        return new AbstractMap<XdmAtomicValue, XdmValue>(){

            @Override
            public Set<Map.Entry<XdmAtomicValue, XdmValue>> entrySet() {
                return base.entrySet();
            }

            @Override
            public int size() {
                return base.mapSize();
            }

            @Override
            public boolean isEmpty() {
                return base.isEmpty();
            }

            @Override
            public boolean containsValue(Object value) {
                for (Map.Entry<XdmAtomicValue, XdmValue> e : this.entrySet()) {
                    if (!value.equals(e.getValue())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean containsKey(Object key) {
                return base.containsKey(key);
            }

            @Override
            public XdmValue get(Object key) {
                return base.get(key);
            }

            @Override
            public XdmValue put(XdmAtomicValue key, XdmValue value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public XdmValue remove(Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends XdmAtomicValue, ? extends XdmValue> m3) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<XdmAtomicValue> keySet() {
                return base.keySet();
            }

            @Override
            public Collection<XdmValue> values() {
                return base.values();
            }
        };
    }

    @Override
    public Map<XdmAtomicValue, XdmValue> asMap() {
        return new HashMap<XdmAtomicValue, XdmValue>(this.asImmutableMap());
    }

    public void clear() {
        throw new UnsupportedOperationException("XdmMap is immutable");
    }

    public boolean isEmpty() {
        return this.getUnderlyingValue().isEmpty();
    }

    public boolean containsKey(Object key) {
        AtomicValue k = ((XdmAtomicValue)key).getUnderlyingValue();
        return this.getUnderlyingValue().get(k) != null;
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Not implemented: cannot compare sequences");
    }

    public XdmValue get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof XdmAtomicValue)) {
            try {
                key = XdmAtomicValue.makeAtomicValue(key);
            }
            catch (IllegalArgumentException err) {
                throw new ClassCastException(err.toString());
            }
        }
        AtomicValue k = ((XdmAtomicValue)key).getUnderlyingValue();
        Sequence v = this.getUnderlyingValue().get(k);
        return v == null ? null : XdmValue.wrap(v);
    }

    public XdmValue remove(Object key) {
        throw new UnsupportedOperationException("XdmMap is immutable");
    }

    public void putAll(Map<? extends XdmAtomicValue, ? extends XdmValue> m3) {
        throw new UnsupportedOperationException("XdmMap is immutable");
    }

    public Collection<XdmValue> values() {
        ArrayList<XdmValue> result = new ArrayList<XdmValue>();
        for (KeyValuePair keyValuePair : this.getUnderlyingValue()) {
            result.add(XdmValue.wrap(keyValuePair.value));
        }
        return result;
    }

    public Set<Map.Entry<XdmAtomicValue, XdmValue>> entrySet() {
        HashSet<Map.Entry<XdmAtomicValue, XdmValue>> result = new HashSet<Map.Entry<XdmAtomicValue, XdmValue>>();
        for (KeyValuePair keyValuePair : this.getUnderlyingValue()) {
            XdmMapEntry entry = new XdmMapEntry(keyValuePair);
            result.add(entry);
        }
        return result;
    }

    public static XdmMap makeMap(Map input) throws IllegalArgumentException {
        HashTrieMap result = new HashTrieMap();
        for (Map.Entry entry : input.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            XdmAtomicValue xKey = XdmAtomicValue.makeAtomicValue(key);
            XdmValue xValue = XdmValue.makeValue(value);
            result.initialPut(xKey.getUnderlyingValue(), xValue.getUnderlyingValue());
        }
        return new XdmMap(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XdmMapEntry
    implements Map.Entry<XdmAtomicValue, XdmValue> {
        KeyValuePair pair;

        public XdmMapEntry(KeyValuePair pair) {
            this.pair = pair;
        }

        @Override
        public XdmAtomicValue getKey() {
            return (XdmAtomicValue)XdmValue.wrap(this.pair.key);
        }

        @Override
        public XdmValue getValue() {
            return XdmValue.wrap(this.pair.value);
        }

        @Override
        public XdmValue setValue(XdmValue value) {
            throw new UnsupportedOperationException();
        }
    }
}

