/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CodepointMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.tree.util.FastStringBuffer;

public class HTML5CaseBlindCollator
implements StringCollator,
SubstringMatcher {
    private static HTML5CaseBlindCollator theInstance = new HTML5CaseBlindCollator();

    public static HTML5CaseBlindCollator getInstance() {
        return theInstance;
    }

    public String getCollationURI() {
        return "http://www.w3.org/2005/xpath-functions/collation/html-ascii-case-insensitive";
    }

    public int compareStrings(CharSequence a, CharSequence b) {
        return this.compareCS(a, b);
    }

    public int compareCS(CharSequence a, CharSequence b) {
        int nextb;
        int nexta;
        int c;
        int alen = a.length();
        int blen = b.length();
        int i2 = 0;
        int j = 0;
        do {
            if (i2 == alen) {
                if (j == blen) {
                    return 0;
                }
                return -1;
            }
            if (j == blen) {
                return 1;
            }
            nexta = a.charAt(i2++);
            nextb = b.charAt(j++);
            if (nexta >= 97 && nexta <= 122) {
                nexta -= 32;
            }
            if (nextb < 97 || nextb > 122) continue;
            nextb -= 32;
        } while ((c = nexta - nextb) == 0);
        return c;
    }

    public boolean comparesEqual(CharSequence s1, CharSequence s2) {
        return this.compareCS(s1, s2) == 0;
    }

    public boolean contains(String s1, String s2) {
        return this.normalize(s1).contains(this.normalize(s2));
    }

    public boolean endsWith(String s1, String s2) {
        return this.normalize(s1).endsWith(this.normalize(s2));
    }

    public boolean startsWith(String s1, String s2) {
        return this.normalize(s1).startsWith(this.normalize(s2));
    }

    public String substringAfter(String s1, String s2) {
        int i2 = this.normalize(s1).indexOf(this.normalize(s2));
        if (i2 < 0) {
            return "";
        }
        return s1.substring(i2 + s2.length());
    }

    public String substringBefore(String s1, String s2) {
        int j = this.normalize(s1).indexOf(this.normalize(s2));
        if (j < 0) {
            return "";
        }
        return s1.substring(0, j);
    }

    public AtomicMatchKey getCollationKey(CharSequence s2) {
        return new CodepointMatchKey(this.normalize(s2));
    }

    private String normalize(CharSequence cs) {
        FastStringBuffer fsb = new FastStringBuffer(cs.length());
        for (int i2 = 0; i2 < cs.length(); ++i2) {
            char c = cs.charAt(i2);
            if ('a' <= c && c <= 'z') {
                fsb.append((char)(c + 65 - 97));
                continue;
            }
            fsb.append(c);
        }
        return fsb.toString();
    }
}

