/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.GroupByClause;
import net.sf.saxon.expr.flwor.Tuple;
import net.sf.saxon.expr.flwor.TupleExpression;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public class GroupByClausePull
extends TuplePull {
    private TuplePull base;
    private GroupByClause groupByClause;
    Iterator<List<GroupByClause.ObjectToBeGrouped>> groupIterator;
    private XPathContext context;
    private GenericAtomicComparer[] comparers;

    public GroupByClausePull(TuplePull base, GroupByClause groupBy, XPathContext context) {
        this.base = base;
        this.groupByClause = groupBy;
        this.context = context;
        this.comparers = new GenericAtomicComparer[groupBy.comparers.length];
        for (int i2 = 0; i2 < this.comparers.length; ++i2) {
            this.comparers[i2] = groupBy.comparers[i2].provideContext(context);
        }
    }

    public boolean nextTuple(XPathContext context) throws XPathException {
        if (this.groupIterator == null) {
            TupleExpression groupingTupleExpr = this.groupByClause.getGroupingTupleExpression();
            TupleExpression retainedTupleExpr = this.groupByClause.getRetainedTupleExpression();
            HashMap<GroupByClause.TupleComparisonKey, List> map = new HashMap<GroupByClause.TupleComparisonKey, List>();
            while (this.base.nextTuple(context)) {
                GroupByClause.ObjectToBeGrouped otbg = new GroupByClause.ObjectToBeGrouped();
                Sequence[] groupingValues = groupingTupleExpr.evaluateItem(context).getMembers();
                for (int i2 = 0; i2 < groupingValues.length; ++i2) {
                    Sequence v = groupingValues[i2];
                    if (v instanceof EmptySequence || v instanceof AtomicValue) continue;
                    if (SequenceTool.getLength(v = SequenceExtent.makeSequenceExtent(Atomizer.getAtomizingIterator(v.iterate(), false))) > 1) {
                        throw new XPathException("Grouping key value cannot be a sequence of more than one item", "XPTY0004");
                    }
                    groupingValues[i2] = v;
                }
                otbg.groupingValues = new Tuple(groupingValues);
                otbg.retainedValues = retainedTupleExpr.evaluateItem(context);
                GroupByClause.TupleComparisonKey key = this.groupByClause.getComparisonKey(otbg.groupingValues, this.comparers);
                List group = (List)map.get(key);
                if (group != null) {
                    group.add(otbg);
                    map.put(key, group);
                    continue;
                }
                ArrayList<GroupByClause.ObjectToBeGrouped> list = new ArrayList<GroupByClause.ObjectToBeGrouped>();
                list.add(otbg);
                map.put(key, list);
            }
            this.groupIterator = map.values().iterator();
        }
        if (this.groupIterator.hasNext()) {
            List<GroupByClause.ObjectToBeGrouped> group = this.groupIterator.next();
            this.groupByClause.processGroup(group, context);
            return true;
        }
        return false;
    }

    public void close() {
        this.base.close();
        this.groupIterator = null;
    }
}

