/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;

public abstract class SequenceWriter
extends SequenceReceiver {
    private Receiver outputter = null;
    private TreeModel treeModel = null;
    private Builder builder = null;
    private int level = 0;
    private boolean inStartTag = false;

    public SequenceWriter(PipelineConfiguration pipe) {
        super(pipe);
    }

    public abstract void write(Item var1) throws XPathException;

    public void startDocument(int properties) throws XPathException {
        if (this.outputter == null) {
            this.createTree((properties & 0x8000) != 0);
        }
        if (this.level++ == 0) {
            this.outputter.startDocument(properties);
        }
    }

    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
        if (this.builder != null) {
            this.builder.setUnparsedEntity(name, systemID, publicID);
        }
    }

    private void createTree(boolean mutable) throws XPathException {
        TreeModel model;
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        this.builder = this.treeModel != null ? this.treeModel.makeBuilder(pipe) : (mutable ? ((model = pipe.getController().getModel()).isMutable() ? pipe.getController().makeBuilder() : new LinkedTreeBuilder(pipe)) : pipe.getController().makeBuilder());
        this.builder.setPipelineConfiguration(pipe);
        this.builder.setSystemId(this.systemId);
        this.builder.setBaseURI(this.systemId);
        this.builder.setTiming(false);
        NamespaceReducer reducer = new NamespaceReducer(this.builder);
        ComplexContentOutputter cco = new ComplexContentOutputter(pipe);
        cco.setHostLanguage(pipe.getHostLanguage());
        cco.setReceiver(reducer);
        this.outputter = cco;
        this.outputter.setSystemId(this.systemId);
        this.outputter.setPipelineConfiguration(pipe);
        this.outputter.open();
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(TreeModel treeModel) {
        this.treeModel = treeModel;
    }

    public void endDocument() throws XPathException {
        if (--this.level == 0) {
            this.outputter.endDocument();
            this.outputter = null;
            NodeInfo doc = this.builder.getCurrentRoot();
            this.append(doc, ExplicitLocation.UNKNOWN_LOCATION, 2);
        }
        this.previousAtomic = false;
    }

    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.outputter == null) {
            this.createTree((properties & 0x8000) != 0);
        }
        this.outputter.startElement(elemName, typeCode, location, properties);
        ++this.level;
        this.inStartTag = true;
        this.previousAtomic = false;
    }

    public void endElement() throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        this.outputter.endElement();
        if (--this.level == 0) {
            this.outputter.close();
            this.outputter = null;
            NodeInfo element = this.builder.getCurrentRoot();
            this.append(element, ExplicitLocation.UNKNOWN_LOCATION, 2);
        }
        this.previousAtomic = false;
    }

    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        if (this.level == 0) {
            for (NamespaceBinding ns : namespaceBindings) {
                Orphan o = new Orphan(this.getConfiguration());
                o.setNodeKind((short)13);
                o.setNodeName(new NoNamespaceName(ns.getPrefix()));
                o.setStringValue(ns.getURI());
                this.append(o, ExplicitLocation.UNKNOWN_LOCATION, 2);
            }
        } else {
            this.outputter.namespace(namespaceBindings, properties);
        }
        this.previousAtomic = false;
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind((short)2);
            o.setNodeName(attName);
            o.setStringValue(value);
            o.setTypeAnnotation(typeCode);
            this.append(o, locationId, 2);
        } else {
            this.outputter.attribute(attName, typeCode, value, locationId, properties);
        }
        this.previousAtomic = false;
    }

    public void startContent() throws XPathException {
        this.inStartTag = false;
        this.outputter.startContent();
        this.previousAtomic = false;
    }

    public void characters(CharSequence s2, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind((short)3);
            o.setStringValue(s2.toString());
            this.append(o, locationId, 2);
        } else if (s2.length() > 0) {
            if (this.inStartTag) {
                this.startContent();
            }
            this.outputter.characters(s2, locationId, properties);
        }
        this.previousAtomic = false;
    }

    public void comment(CharSequence comment, Location locationId, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind((short)8);
            o.setStringValue(comment);
            this.append(o, locationId, 2);
        } else {
            this.outputter.comment(comment, locationId, properties);
        }
        this.previousAtomic = false;
    }

    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeName(new NoNamespaceName(target));
            o.setNodeKind((short)7);
            o.setStringValue(data);
            this.append(o, locationId, 2);
        } else {
            this.outputter.processingInstruction(target, data, locationId, properties);
        }
        this.previousAtomic = false;
    }

    public void close() throws XPathException {
        this.previousAtomic = false;
        if (this.outputter != null) {
            this.outputter.close();
        }
    }

    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (item == null) {
            return;
        }
        if (this.level == 0) {
            this.write(item);
            this.previousAtomic = false;
        } else if (item instanceof AtomicValue || item instanceof ObjectValue) {
            if (this.previousAtomic) {
                this.outputter.characters(" ", ExplicitLocation.UNKNOWN_LOCATION, 0);
            }
            this.outputter.characters(item.getStringValueCS(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            this.previousAtomic = true;
        } else if (item instanceof ArrayItem) {
            for (Sequence member : (ArrayItem)item) {
                Item it;
                SequenceIterator iter = member.iterate();
                while ((it = iter.next()) != null) {
                    this.append(it, locationId, copyNamespaces);
                }
            }
        } else {
            if (item instanceof Function) {
                XPathException err = new XPathException("Cannot write a function item to an XML tree", "FOTY0013");
                err.setLocator(locationId.saveLocation());
                throw err;
            }
            NodeInfo node = (NodeInfo)item;
            if (node.getNodeKind() == 2 && ((SimpleType)node.getSchemaType()).isNamespaceSensitive()) {
                XPathException err = new XPathException("Cannot copy attributes whose type is namespace-sensitive (QName or NOTATION): " + Err.wrap(node.getDisplayName(), 2));
                err.setErrorCode(this.getPipelineConfiguration().getHostLanguage() == 50 ? "XTTE0950" : "XQTY0086");
                throw err;
            }
            ((NodeInfo)item).copy(this.outputter, 6, locationId);
            this.previousAtomic = false;
        }
    }

    public boolean usesTypeAnnotations() {
        return this.outputter == null || this.outputter.usesTypeAnnotations();
    }
}

