/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.TerserUtil;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;

public class ExtensionUtil {
    private ExtensionUtil() {
    }

    public static IBaseExtension<?, ?> getOrCreateExtension(IBase theBase, String theUrl) {
        IBaseHasExtensions baseHasExtensions = ExtensionUtil.validateExtensionSupport(theBase);
        IBaseExtension<?, ?> extension = ExtensionUtil.getExtensionByUrl(baseHasExtensions, theUrl);
        if (extension == null) {
            extension = baseHasExtensions.addExtension();
            extension.setUrl(theUrl);
        }
        return extension;
    }

    public static IBaseExtension<?, ?> addExtension(IBase theBase) {
        return ExtensionUtil.addExtension(theBase, null);
    }

    public static IBaseExtension<?, ?> addExtension(IBase theBase, String theUrl) {
        IBaseHasExtensions baseHasExtensions = ExtensionUtil.validateExtensionSupport(theBase);
        IBaseExtension<?, ?> extension = baseHasExtensions.addExtension();
        if (theUrl != null) {
            extension.setUrl(theUrl);
        }
        return extension;
    }

    public static void addExtension(FhirContext theFhirContext, IBase theBase, String theUrl, String theValueType, Object theValue) {
        IBaseExtension<?, ?> ext = ExtensionUtil.addExtension(theBase, theUrl);
        ExtensionUtil.setExtension(theFhirContext, ext, theValueType, theValue);
    }

    private static IBaseHasExtensions validateExtensionSupport(IBase theBase) {
        if (!(theBase instanceof IBaseHasExtensions)) {
            throw new IllegalArgumentException(String.format("Expected instance that supports extensions, but got %s", theBase));
        }
        return (IBaseHasExtensions)theBase;
    }

    public static boolean hasExtension(IBase theBase, String theExtensionUrl) {
        IBaseHasExtensions baseHasExtensions;
        try {
            baseHasExtensions = ExtensionUtil.validateExtensionSupport(theBase);
        }
        catch (Exception e) {
            return false;
        }
        return ExtensionUtil.getExtensionByUrl(baseHasExtensions, theExtensionUrl) != null;
    }

    public static boolean hasExtension(IBase theBase, String theExtensionUrl, String theExtensionValue) {
        if (!ExtensionUtil.hasExtension(theBase, theExtensionUrl)) {
            return false;
        }
        IBaseDatatype value = ExtensionUtil.getExtensionByUrl(theBase, theExtensionUrl).getValue();
        if (value == null) {
            return theExtensionValue == null;
        }
        return value.toString().equals(theExtensionValue);
    }

    public static IBaseExtension<?, ?> getExtensionByUrl(IBase theBase, String theExtensionUrl) {
        Predicate<IBaseExtension> filter = theExtensionUrl == null ? e -> true : e -> theExtensionUrl.equals(e.getUrl());
        return ExtensionUtil.getExtensionsMatchingPredicate(theBase, filter).stream().findFirst().orElse(null);
    }

    public static List<IBaseExtension<?, ?>> getExtensionsMatchingPredicate(IBase theBase, Predicate<? super IBaseExtension<?, ?>> theFilter) {
        return ExtensionUtil.validateExtensionSupport(theBase).getExtension().stream().filter(theFilter).collect(Collectors.toList());
    }

    public static List<IBaseExtension<?, ?>> clearAllExtensions(IBase theBase) {
        return ExtensionUtil.clearExtensionsMatchingPredicate(theBase, e -> true);
    }

    public static List<IBaseExtension<?, ?>> clearExtensionsByUrl(IBase theBase, String theUrl) {
        return ExtensionUtil.clearExtensionsMatchingPredicate(theBase, e -> theUrl.equals(e.getUrl()));
    }

    private static List<IBaseExtension<?, ?>> clearExtensionsMatchingPredicate(IBase theBase, Predicate<? super IBaseExtension<?, ?>> theFilter) {
        List<IBaseExtension<?, ?>> retVal = ExtensionUtil.getExtensionsMatchingPredicate(theBase, theFilter);
        ExtensionUtil.validateExtensionSupport(theBase).getExtension().removeIf(theFilter);
        return retVal;
    }

    public static List<IBaseExtension<?, ?>> getExtensionsByUrl(IBaseHasExtensions theBase, String theExtensionUrl) {
        Predicate<IBaseExtension> urlEqualityPredicate = e -> theExtensionUrl.equals(e.getUrl());
        return ExtensionUtil.getExtensionsMatchingPredicate(theBase, urlEqualityPredicate);
    }

    public static void setExtension(FhirContext theFhirContext, IBaseExtension<?, ?> theExtension, String theValue) {
        ExtensionUtil.setExtension(theFhirContext, theExtension, "string", theValue);
    }

    public static void setExtension(FhirContext theFhirContext, IBaseExtension<?, ?> theExtension, String theExtensionType, Object theValue) {
        theExtension.setValue((IBaseDatatype)TerserUtil.newElement(theFhirContext, theExtensionType, theValue));
    }

    public static void setExtensionAsString(FhirContext theFhirContext, IBase theBase, String theUrl, String theValue) {
        IBaseExtension<?, ?> ext = ExtensionUtil.getOrCreateExtension(theBase, theUrl);
        ExtensionUtil.setExtension(theFhirContext, ext, theValue);
    }

    public static void setExtension(FhirContext theFhirContext, IBase theBase, String theUrl, String theValueType, Object theValue) {
        IBaseExtension<?, ?> ext = ExtensionUtil.getOrCreateExtension(theBase, theUrl);
        ExtensionUtil.setExtension(theFhirContext, ext, theValueType, theValue);
    }

    public static boolean equals(IBaseExtension<?, ?> theLeftExtension, IBaseExtension<?, ?> theRightExtension) {
        return TerserUtil.equals(theLeftExtension, theRightExtension);
    }
}

