/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.model.base.composite.BaseQuantityDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.param.CompositeAndListParam;
import ca.uhn.fhir.rest.param.CompositeOrListParam;
import ca.uhn.fhir.rest.param.CompositeParam;
import ca.uhn.fhir.rest.param.DateAndListParam;
import ca.uhn.fhir.rest.param.DateOrListParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.HasOrListParam;
import ca.uhn.fhir.rest.param.HasParam;
import ca.uhn.fhir.rest.param.NumberAndListParam;
import ca.uhn.fhir.rest.param.NumberOrListParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.QuantityAndListParam;
import ca.uhn.fhir.rest.param.QuantityOrListParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.ReferenceOrListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.SpecialAndListParam;
import ca.uhn.fhir.rest.param.SpecialOrListParam;
import ca.uhn.fhir.rest.param.SpecialParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.StringOrListParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import ca.uhn.fhir.rest.param.UriOrListParam;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.param.binder.CalendarBinder;
import ca.uhn.fhir.rest.param.binder.DateBinder;
import ca.uhn.fhir.rest.param.binder.FhirPrimitiveBinder;
import ca.uhn.fhir.rest.param.binder.IParamBinder;
import ca.uhn.fhir.rest.param.binder.QueryParameterAndBinder;
import ca.uhn.fhir.rest.param.binder.QueryParameterOrBinder;
import ca.uhn.fhir.rest.param.binder.QueryParameterTypeBinder;
import ca.uhn.fhir.rest.param.binder.StringBinder;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseQueryParameter;
import ca.uhn.fhir.util.CollectionUtil;
import ca.uhn.fhir.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class SearchParameter
extends BaseQueryParameter {
    private static final String EMPTY_STRING = "";
    private static final HashMap<RestSearchParameterTypeEnum, Set<String>> ourParamQualifiers;
    private static final HashMap<Class<?>, RestSearchParameterTypeEnum> ourParamTypes;
    static final String QUALIFIER_ANY_TYPE = ":*";
    private List<Class<? extends IQueryParameterType>> myCompositeTypes = Collections.emptyList();
    private List<Class<? extends IBaseResource>> myDeclaredTypes;
    private String myDescription;
    private String myName;
    private IParamBinder<?> myParamBinder;
    private RestSearchParameterTypeEnum myParamType;
    private Set<String> myQualifierBlacklist;
    private Set<String> myQualifierWhitelist;
    private boolean myRequired;
    private Class<?> myType;
    private boolean mySupportsRepetition = false;

    public SearchParameter() {
    }

    public SearchParameter(String theName, boolean theRequired) {
        this.myName = theName;
        this.myRequired = theRequired;
    }

    @Override
    public List<QualifiedParamList> encode(FhirContext theContext, Object theObject) throws InternalErrorException {
        ArrayList<QualifiedParamList> retVal = new ArrayList<QualifiedParamList>();
        IParamBinder<?> paramBinder = this.myParamBinder;
        List<IQueryParameterOr<?>> val = paramBinder.encode(theContext, theObject);
        for (IQueryParameterOr<?> nextOr : val) {
            retVal.add(new QualifiedParamList(nextOr, theContext));
        }
        return retVal;
    }

    public List<Class<? extends IBaseResource>> getDeclaredTypes() {
        return Collections.unmodifiableList(this.myDeclaredTypes);
    }

    public String getDescription() {
        return this.myDescription;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public RestSearchParameterTypeEnum getParamType() {
        return this.myParamType;
    }

    @Override
    public Set<String> getQualifierBlacklist() {
        return this.myQualifierBlacklist;
    }

    @Override
    public Set<String> getQualifierWhitelist() {
        return this.myQualifierWhitelist;
    }

    public Class<?> getType() {
        return this.myType;
    }

    @Override
    public boolean handlesMissing() {
        return false;
    }

    @Override
    public boolean isRequired() {
        return this.myRequired;
    }

    @Override
    public Object parse(FhirContext theContext, List<QualifiedParamList> theString) throws InternalErrorException, InvalidRequestException {
        return this.myParamBinder.parse(theContext, this.getName(), theString);
    }

    public void setChainLists(String[] theChainWhitelist, String[] theChainBlacklist) {
        this.myQualifierWhitelist = new HashSet<String>(theChainWhitelist.length);
        this.myQualifierWhitelist.add(QUALIFIER_ANY_TYPE);
        for (String nextChain : theChainWhitelist) {
            if (nextChain.equals("*")) {
                this.myQualifierWhitelist.add(".*");
                continue;
            }
            if (nextChain.equals(EMPTY_STRING)) {
                this.myQualifierWhitelist.add(".");
                continue;
            }
            this.myQualifierWhitelist.add('.' + nextChain);
        }
        if (theChainBlacklist.length > 0) {
            this.myQualifierBlacklist = new HashSet<String>(theChainBlacklist.length);
            for (String next : theChainBlacklist) {
                if (next.equals(EMPTY_STRING)) {
                    this.myQualifierBlacklist.add(EMPTY_STRING);
                    continue;
                }
                this.myQualifierBlacklist.add('.' + next);
            }
        }
    }

    public void setCompositeTypes(Class<? extends IQueryParameterType>[] theCompositeTypes) {
        this.myCompositeTypes = Arrays.asList(theCompositeTypes);
    }

    public void setDeclaredTypes(Class<? extends IBaseResource>[] theTypes) {
        this.myDeclaredTypes = Arrays.asList(theTypes);
    }

    public void setDescription(String theDescription) {
        this.myDescription = theDescription;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setRequired(boolean required) {
        this.myRequired = required;
    }

    @Override
    protected boolean supportsRepetition() {
        return this.mySupportsRepetition;
    }

    public void setType(FhirContext theContext, Class<?> theType, Class<? extends Collection<?>> theInnerCollectionType, Class<? extends Collection<?>> theOuterCollectionType) {
        Set<String> builtInQualifiers;
        this.myType = theType;
        if (IQueryParameterType.class.isAssignableFrom(theType)) {
            this.myParamBinder = new QueryParameterTypeBinder((Class<? extends IQueryParameterType>)theType, this.myCompositeTypes);
        } else if (IQueryParameterOr.class.isAssignableFrom(theType)) {
            this.myParamBinder = new QueryParameterOrBinder((Class<? extends IQueryParameterOr<?>>)theType, this.myCompositeTypes);
        } else if (IQueryParameterAnd.class.isAssignableFrom(theType)) {
            this.myParamBinder = new QueryParameterAndBinder((Class<? extends IQueryParameterAnd<?>>)theType, this.myCompositeTypes);
            this.mySupportsRepetition = true;
        } else if (String.class.equals(theType)) {
            this.myParamBinder = new StringBinder();
            this.myParamType = RestSearchParameterTypeEnum.STRING;
        } else if (Date.class.equals(theType)) {
            this.myParamBinder = new DateBinder();
            this.myParamType = RestSearchParameterTypeEnum.DATE;
        } else if (Calendar.class.equals(theType)) {
            this.myParamBinder = new CalendarBinder();
            this.myParamType = RestSearchParameterTypeEnum.DATE;
        } else if (IPrimitiveType.class.isAssignableFrom(theType) && ReflectionUtil.isInstantiable(theType)) {
            RuntimePrimitiveDatatypeDefinition def = (RuntimePrimitiveDatatypeDefinition)theContext.getElementDefinition(theType);
            if (def.getNativeType() != null) {
                if (def.getNativeType().equals(Date.class)) {
                    this.myParamBinder = new FhirPrimitiveBinder(theType);
                    this.myParamType = RestSearchParameterTypeEnum.DATE;
                } else if (def.getNativeType().equals(String.class)) {
                    this.myParamBinder = new FhirPrimitiveBinder(theType);
                    this.myParamType = RestSearchParameterTypeEnum.STRING;
                }
            }
        } else {
            throw new ConfigurationException("Unsupported data type for parameter: " + theType.getCanonicalName());
        }
        RestSearchParameterTypeEnum typeEnum = ourParamTypes.get(theType);
        if (typeEnum != null && (builtInQualifiers = ourParamQualifiers.get((Object)typeEnum)) != null) {
            if (this.myQualifierWhitelist != null) {
                HashSet<String> qualifierWhitelist = new HashSet<String>();
                qualifierWhitelist.addAll(this.myQualifierWhitelist);
                qualifierWhitelist.addAll(builtInQualifiers);
                this.myQualifierWhitelist = qualifierWhitelist;
            } else {
                this.myQualifierWhitelist = Collections.unmodifiableSet(builtInQualifiers);
            }
        }
        if (this.myParamType == null) {
            this.myParamType = typeEnum;
        }
        if (this.myParamType == null) {
            if (StringDt.class.isAssignableFrom(theType)) {
                this.myParamType = RestSearchParameterTypeEnum.STRING;
            } else if (BaseIdentifierDt.class.isAssignableFrom(theType)) {
                this.myParamType = RestSearchParameterTypeEnum.TOKEN;
            } else if (BaseQuantityDt.class.isAssignableFrom(theType)) {
                this.myParamType = RestSearchParameterTypeEnum.QUANTITY;
            } else if (ReferenceParam.class.isAssignableFrom(theType)) {
                this.myParamType = RestSearchParameterTypeEnum.REFERENCE;
            } else if (HasParam.class.isAssignableFrom(theType)) {
                this.myParamType = RestSearchParameterTypeEnum.STRING;
            } else {
                throw new ConfigurationException("Unknown search parameter type: " + theType);
            }
        }
    }

    public String toString() {
        ToStringBuilder retVal = new ToStringBuilder((Object)this);
        retVal.append("name", (Object)this.myName);
        retVal.append("required", this.myRequired);
        return retVal.toString();
    }

    static {
        ourParamTypes = new HashMap();
        ourParamQualifiers = new HashMap();
        ourParamTypes.put(StringParam.class, RestSearchParameterTypeEnum.STRING);
        ourParamTypes.put(StringOrListParam.class, RestSearchParameterTypeEnum.STRING);
        ourParamTypes.put(StringAndListParam.class, RestSearchParameterTypeEnum.STRING);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.STRING, CollectionUtil.newSet(":exact", ":contains", ":missing", EMPTY_STRING));
        ourParamTypes.put(UriParam.class, RestSearchParameterTypeEnum.URI);
        ourParamTypes.put(UriOrListParam.class, RestSearchParameterTypeEnum.URI);
        ourParamTypes.put(UriAndListParam.class, RestSearchParameterTypeEnum.URI);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.URI, CollectionUtil.newSet(":exact", ":missing", EMPTY_STRING));
        ourParamTypes.put(TokenParam.class, RestSearchParameterTypeEnum.TOKEN);
        ourParamTypes.put(TokenOrListParam.class, RestSearchParameterTypeEnum.TOKEN);
        ourParamTypes.put(TokenAndListParam.class, RestSearchParameterTypeEnum.TOKEN);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.TOKEN, CollectionUtil.newSet(":text", ":missing", EMPTY_STRING));
        ourParamTypes.put(DateParam.class, RestSearchParameterTypeEnum.DATE);
        ourParamTypes.put(DateOrListParam.class, RestSearchParameterTypeEnum.DATE);
        ourParamTypes.put(DateAndListParam.class, RestSearchParameterTypeEnum.DATE);
        ourParamTypes.put(DateRangeParam.class, RestSearchParameterTypeEnum.DATE);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.DATE, CollectionUtil.newSet(":missing", EMPTY_STRING));
        ourParamTypes.put(QuantityParam.class, RestSearchParameterTypeEnum.QUANTITY);
        ourParamTypes.put(QuantityOrListParam.class, RestSearchParameterTypeEnum.QUANTITY);
        ourParamTypes.put(QuantityAndListParam.class, RestSearchParameterTypeEnum.QUANTITY);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.QUANTITY, CollectionUtil.newSet(":missing", EMPTY_STRING));
        ourParamTypes.put(NumberParam.class, RestSearchParameterTypeEnum.NUMBER);
        ourParamTypes.put(NumberOrListParam.class, RestSearchParameterTypeEnum.NUMBER);
        ourParamTypes.put(NumberAndListParam.class, RestSearchParameterTypeEnum.NUMBER);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.NUMBER, CollectionUtil.newSet(":missing", EMPTY_STRING));
        ourParamTypes.put(ReferenceParam.class, RestSearchParameterTypeEnum.REFERENCE);
        ourParamTypes.put(ReferenceOrListParam.class, RestSearchParameterTypeEnum.REFERENCE);
        ourParamTypes.put(ReferenceAndListParam.class, RestSearchParameterTypeEnum.REFERENCE);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.REFERENCE, CollectionUtil.newSet(":missing"));
        ourParamTypes.put(CompositeParam.class, RestSearchParameterTypeEnum.COMPOSITE);
        ourParamTypes.put(CompositeOrListParam.class, RestSearchParameterTypeEnum.COMPOSITE);
        ourParamTypes.put(CompositeAndListParam.class, RestSearchParameterTypeEnum.COMPOSITE);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.COMPOSITE, CollectionUtil.newSet(":missing", EMPTY_STRING));
        ourParamTypes.put(HasParam.class, RestSearchParameterTypeEnum.HAS);
        ourParamTypes.put(HasOrListParam.class, RestSearchParameterTypeEnum.HAS);
        ourParamTypes.put(HasAndListParam.class, RestSearchParameterTypeEnum.HAS);
        ourParamTypes.put(SpecialParam.class, RestSearchParameterTypeEnum.SPECIAL);
        ourParamTypes.put(SpecialOrListParam.class, RestSearchParameterTypeEnum.SPECIAL);
        ourParamTypes.put(SpecialAndListParam.class, RestSearchParameterTypeEnum.SPECIAL);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.SPECIAL, CollectionUtil.newSet(":missing"));
    }
}

