/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RequiredParam;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.server.method.MethodMatchEnum;
import ca.uhn.fhir.rest.server.method.OperationParameter;
import ca.uhn.fhir.rest.server.method.ResourceParameter;
import ca.uhn.fhir.util.ParametersUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class OperationMethodBinding
extends BaseResourceReturningMethodBinding {
    public static final String WILDCARD_NAME = "$*";
    private final boolean myIdempotent;
    private final Integer myIdParamIndex;
    private final String myName;
    private final RestOperationTypeEnum myOtherOperationType;
    private final BaseResourceReturningMethodBinding.ReturnTypeEnum myReturnType;
    private final String myShortDescription;
    private boolean myGlobal;
    private BundleTypeEnum myBundleType;
    private boolean myCanOperateAtInstanceLevel;
    private boolean myCanOperateAtServerLevel;
    private boolean myCanOperateAtTypeLevel;
    private String myDescription;
    private List<ReturnType> myReturnParams;
    private boolean myManualRequestMode;
    private boolean myManualResponseMode;

    public OperationMethodBinding(Class<?> theReturnResourceType, Class<? extends IBaseResource> theReturnTypeFromRp, Method theMethod, FhirContext theContext, Object theProvider, Operation theAnnotation) {
        this(theReturnResourceType, theReturnTypeFromRp, theMethod, theContext, theProvider, theAnnotation.idempotent(), theAnnotation.name(), theAnnotation.type(), theAnnotation.typeName(), theAnnotation.returnParameters(), theAnnotation.bundleType(), theAnnotation.global());
        this.myManualRequestMode = theAnnotation.manualRequest();
        this.myManualResponseMode = theAnnotation.manualResponse();
    }

    protected OperationMethodBinding(Class<?> theReturnResourceType, Class<? extends IBaseResource> theReturnTypeFromRp, Method theMethod, FhirContext theContext, Object theProvider, boolean theIdempotent, String theOperationName, Class<? extends IBaseResource> theOperationType, String theOperationTypeName, OperationParam[] theReturnParams, BundleTypeEnum theBundleType, boolean theGlobal) {
        super(theReturnResourceType, theMethod, theContext, theProvider);
        this.myBundleType = theBundleType;
        this.myIdempotent = theIdempotent;
        this.myDescription = ParametersUtil.extractDescription(theMethod);
        this.myShortDescription = ParametersUtil.extractShortDefinition(theMethod);
        this.myGlobal = theGlobal;
        Annotation[][] annotationArray = theMethod.getParameterAnnotations();
        int n = annotationArray.length;
        for (int j = 0; j < n; ++j) {
            Annotation[] annotationArray2;
            for (Annotation nextParam : annotationArray2 = annotationArray[j]) {
                if (!(nextParam instanceof OptionalParam) && !(nextParam instanceof RequiredParam)) continue;
                throw new ConfigurationException("Illegal method parameter annotation @" + nextParam.annotationType().getSimpleName() + " on method: " + theMethod.toString());
            }
        }
        if (StringUtils.isBlank((CharSequence)theOperationName)) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' on type " + theMethod.getDeclaringClass().getName() + " is annotated with @" + Operation.class.getSimpleName() + " but this annotation has no name defined");
        }
        if (!theOperationName.startsWith("$")) {
            theOperationName = "$" + theOperationName;
        }
        this.myName = theOperationName;
        try {
            if (theReturnTypeFromRp != null) {
                this.setResourceName(theContext.getResourceType(theReturnTypeFromRp));
            } else if (theOperationType != null && !Modifier.isAbstract(theOperationType.getModifiers())) {
                this.setResourceName(theContext.getResourceType(theOperationType));
            } else if (StringUtils.isNotBlank((CharSequence)theOperationTypeName)) {
                this.setResourceName(theContext.getResourceType(theOperationTypeName));
            } else {
                this.setResourceName(null);
            }
        }
        catch (DataFormatException e) {
            throw new ConfigurationException("Failed to bind method " + theMethod + " - " + e.getMessage(), e);
        }
        this.myReturnType = theMethod.getReturnType().equals(IBundleProvider.class) ? BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE : BaseResourceReturningMethodBinding.ReturnTypeEnum.RESOURCE;
        this.myIdParamIndex = ParameterUtil.findIdParameterIndex(theMethod, this.getContext());
        if (this.getResourceName() == null) {
            this.myOtherOperationType = RestOperationTypeEnum.EXTENDED_OPERATION_SERVER;
            if (this.myIdParamIndex != null) {
                this.myCanOperateAtInstanceLevel = true;
            } else {
                this.myCanOperateAtServerLevel = true;
            }
        } else if (this.myIdParamIndex == null) {
            this.myOtherOperationType = RestOperationTypeEnum.EXTENDED_OPERATION_TYPE;
            this.myCanOperateAtTypeLevel = true;
        } else {
            this.myOtherOperationType = RestOperationTypeEnum.EXTENDED_OPERATION_INSTANCE;
            this.myCanOperateAtInstanceLevel = true;
            for (Annotation[] annotationArray3 : theMethod.getParameterAnnotations()[this.myIdParamIndex]) {
                if (!(annotationArray3 instanceof IdParam)) continue;
                this.myCanOperateAtTypeLevel = ((IdParam)annotationArray3).optional();
            }
        }
        this.myReturnParams = new ArrayList<ReturnType>();
        if (theReturnParams != null) {
            for (Annotation[] annotationArray4 : theReturnParams) {
                ReturnType type = new ReturnType();
                type.setName(annotationArray4.name());
                type.setMin(annotationArray4.min());
                type.setMax(annotationArray4.max());
                if (type.getMax() == -2) {
                    type.setMax(1);
                }
                if (!annotationArray4.type().equals(IBase.class)) {
                    if (annotationArray4.type().isInterface() || Modifier.isAbstract(annotationArray4.type().getModifiers())) {
                        throw new ConfigurationException("Invalid value for @OperationParam.type(): " + annotationArray4.type().getName());
                    }
                    type.setType(theContext.getElementDefinition(annotationArray4.type()).getName());
                }
                this.myReturnParams.add(type);
            }
        }
        if (this.myCanOperateAtInstanceLevel && !this.isGlobalMethod() && this.getResourceName() == null) {
            throw new ConfigurationException("@" + Operation.class.getSimpleName() + " method is an instance level method (it has an @" + IdParam.class.getSimpleName() + " parameter) but is not marked as global() and is not declared in a resource provider: " + theMethod.getName());
        }
    }

    public String getShortDescription() {
        return this.myShortDescription;
    }

    @Override
    public boolean isGlobalMethod() {
        return this.myGlobal;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String theDescription) {
        this.myDescription = theDescription;
    }

    public String getName() {
        return this.myName;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return this.myBundleType;
    }

    @Override
    @Nonnull
    public RestOperationTypeEnum getRestOperationType() {
        return this.myOtherOperationType;
    }

    public List<ReturnType> getReturnParams() {
        return Collections.unmodifiableList(this.myReturnParams);
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return this.myReturnType;
    }

    @Override
    public MethodMatchEnum incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        boolean requestHasId;
        if (StringUtils.isBlank((CharSequence)theRequest.getOperation())) {
            return MethodMatchEnum.NONE;
        }
        if (!this.myName.equals(theRequest.getOperation()) && !this.myName.equals(WILDCARD_NAME)) {
            return MethodMatchEnum.NONE;
        }
        if (this.getResourceName() == null && StringUtils.isNotBlank((CharSequence)theRequest.getResourceName()) && !this.isGlobalMethod()) {
            return MethodMatchEnum.NONE;
        }
        if (this.getResourceName() != null && !this.getResourceName().equals(theRequest.getResourceName())) {
            return MethodMatchEnum.NONE;
        }
        RequestTypeEnum requestType = theRequest.getRequestType();
        if (requestType != RequestTypeEnum.GET && requestType != RequestTypeEnum.POST) {
            return MethodMatchEnum.NONE;
        }
        boolean bl = requestHasId = theRequest.getId() != null;
        if (requestHasId) {
            return this.myCanOperateAtInstanceLevel ? MethodMatchEnum.EXACT : MethodMatchEnum.NONE;
        }
        if (StringUtils.isNotBlank((CharSequence)theRequest.getResourceName())) {
            return this.myCanOperateAtTypeLevel ? MethodMatchEnum.EXACT : MethodMatchEnum.NONE;
        }
        return this.myCanOperateAtServerLevel ? MethodMatchEnum.EXACT : MethodMatchEnum.NONE;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType(RequestDetails theRequestDetails) {
        RestOperationTypeEnum retVal = super.getRestOperationType(theRequestDetails);
        if (retVal == RestOperationTypeEnum.EXTENDED_OPERATION_INSTANCE && theRequestDetails.getId() == null) {
            retVal = RestOperationTypeEnum.EXTENDED_OPERATION_TYPE;
        }
        if (this.myGlobal && theRequestDetails.getId() != null && theRequestDetails.getId().hasIdPart()) {
            retVal = RestOperationTypeEnum.EXTENDED_OPERATION_INSTANCE;
        } else if (this.myGlobal && StringUtils.isNotBlank((CharSequence)theRequestDetails.getResourceName())) {
            retVal = RestOperationTypeEnum.EXTENDED_OPERATION_TYPE;
        }
        return retVal;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.myName).append("methodName", (Object)(this.getMethod().getDeclaringClass().getSimpleName() + "." + this.getMethod().getName())).append("serverLevel", this.myCanOperateAtServerLevel).append("typeLevel", this.myCanOperateAtTypeLevel).append("instanceLevel", this.myCanOperateAtInstanceLevel).toString();
    }

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) throws BaseServerResponseException, IOException {
        if (theRequest.getRequestType() == RequestTypeEnum.POST && !this.myManualRequestMode) {
            Object requestContents = ResourceParameter.loadResourceFromRequest(theRequest, this, null);
            theRequest.getUserData().put(OperationParameter.REQUEST_CONTENTS_USERDATA_KEY, requestContents);
        }
        return super.invokeServer(theServer, theRequest);
    }

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest, Object[] theMethodParams) throws BaseServerResponseException {
        if (theRequest.getRequestType() != RequestTypeEnum.POST) {
            if (theRequest.getRequestType() == RequestTypeEnum.GET) {
                if (!this.myIdempotent) {
                    String message = this.getContext().getLocalizer().getMessage(OperationMethodBinding.class, "methodNotSupported", new Object[]{theRequest.getRequestType(), RequestTypeEnum.POST.name()});
                    throw new MethodNotAllowedException(message, RequestTypeEnum.POST);
                }
            } else {
                if (!this.myIdempotent) {
                    String message = this.getContext().getLocalizer().getMessage(OperationMethodBinding.class, "methodNotSupported", new Object[]{theRequest.getRequestType(), RequestTypeEnum.POST.name()});
                    throw new MethodNotAllowedException(message, RequestTypeEnum.POST);
                }
                String message = this.getContext().getLocalizer().getMessage(OperationMethodBinding.class, "methodNotSupported", new Object[]{theRequest.getRequestType(), RequestTypeEnum.GET.name(), RequestTypeEnum.POST.name()});
                throw new MethodNotAllowedException(message, RequestTypeEnum.GET, RequestTypeEnum.POST);
            }
        }
        if (this.myIdParamIndex != null) {
            theMethodParams[this.myIdParamIndex.intValue()] = theRequest.getId();
        }
        Object response = this.invokeServerMethod(theRequest, theMethodParams);
        if (this.myManualResponseMode) {
            return null;
        }
        IBundleProvider retVal = this.toResourceList(response);
        return retVal;
    }

    public boolean isCanOperateAtInstanceLevel() {
        return this.myCanOperateAtInstanceLevel;
    }

    public boolean isCanOperateAtServerLevel() {
        return this.myCanOperateAtServerLevel;
    }

    public boolean isCanOperateAtTypeLevel() {
        return this.myCanOperateAtTypeLevel;
    }

    public boolean isIdempotent() {
        return this.myIdempotent;
    }

    @Override
    protected void populateActionRequestDetailsForInterceptor(RequestDetails theRequestDetails, IServerInterceptor.ActionRequestDetails theDetails, Object[] theMethodParams) {
        super.populateActionRequestDetailsForInterceptor(theRequestDetails, theDetails, theMethodParams);
        IBaseResource resource = (IBaseResource)theRequestDetails.getUserData().get(OperationParameter.REQUEST_CONTENTS_USERDATA_KEY);
        theRequestDetails.setResource(resource);
        if (theDetails != null) {
            theDetails.setResource(resource);
        }
    }

    public boolean isManualRequestMode() {
        return this.myManualRequestMode;
    }

    public static class ReturnType {
        private int myMax;
        private int myMin;
        private String myName;
        private String myType;

        public int getMax() {
            return this.myMax;
        }

        public void setMax(int theMax) {
            this.myMax = theMax;
        }

        public int getMin() {
            return this.myMin;
        }

        public void setMin(int theMin) {
            this.myMin = theMin;
        }

        public String getName() {
            return this.myName;
        }

        public void setName(String theName) {
            this.myName = theName;
        }

        public String getType() {
            return this.myType;
        }

        public void setType(String theType) {
            this.myType = theType;
        }
    }
}

