/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.messaging;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import ca.uhn.fhir.rest.server.messaging.IResourceMessage;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public abstract class BaseResourceModifiedMessage
extends BaseResourceMessage
implements IResourceMessage,
IModelJson {
    @JsonProperty(value="resourceId")
    protected String myId;
    @JsonProperty(value="payload")
    protected String myPayload;
    @JsonProperty(value="payloadId")
    protected String myPayloadId;
    @JsonIgnore
    protected transient IBaseResource myPayloadDecoded;

    public BaseResourceModifiedMessage() {
    }

    public BaseResourceModifiedMessage(FhirContext theFhirContext, IBaseResource theResource, BaseResourceMessage.OperationTypeEnum theOperationType) {
        this();
        this.setId(theResource.getIdElement());
        this.setOperationType(theOperationType);
        if (theOperationType != BaseResourceMessage.OperationTypeEnum.DELETE) {
            this.setNewPayload(theFhirContext, theResource);
        }
    }

    public BaseResourceModifiedMessage(FhirContext theFhirContext, IBaseResource theNewResource, BaseResourceMessage.OperationTypeEnum theOperationType, RequestDetails theRequest) {
        this(theFhirContext, theNewResource, theOperationType);
        if (theRequest != null) {
            this.setTransactionId(theRequest.getTransactionGuid());
        }
    }

    @Override
    public String getPayloadId() {
        return this.myPayloadId;
    }

    public String getId() {
        return this.myId;
    }

    public IIdType getId(FhirContext theCtx) {
        IIdType retVal = null;
        if (this.myId != null) {
            retVal = theCtx.getVersion().newIdType().setValue(this.myId);
        }
        return retVal;
    }

    public IBaseResource getNewPayload(FhirContext theCtx) {
        if (this.myPayloadDecoded == null && StringUtils.isNotBlank((CharSequence)this.myPayload)) {
            this.myPayloadDecoded = theCtx.newJsonParser().parseResource(this.myPayload);
        }
        return this.myPayloadDecoded;
    }

    public IBaseResource getPayload(FhirContext theCtx) {
        IBaseResource retVal = this.myPayloadDecoded;
        if (retVal == null && StringUtils.isNotBlank((CharSequence)this.myPayload)) {
            IParser parser = EncodingEnum.detectEncoding(this.myPayload).newParser(theCtx);
            this.myPayloadDecoded = retVal = parser.parseResource(this.myPayload);
        }
        return retVal;
    }

    public String getPayloadString() {
        if (this.myPayload != null) {
            return this.myPayload;
        }
        return "";
    }

    public void setId(IIdType theId) {
        this.myId = null;
        if (theId != null) {
            this.myId = theId.getValue();
        }
    }

    protected void setNewPayload(FhirContext theCtx, IBaseResource theNewPayload) {
        assert (BaseResourceModifiedMessage.payloadContainsNoPlaceholderReferences(theCtx, theNewPayload));
        this.myPayload = theCtx.newJsonParser().encodeResourceToString(theNewPayload);
        this.myPayloadId = theNewPayload.getIdElement().toUnqualified().getValue();
    }

    protected static boolean payloadContainsNoPlaceholderReferences(FhirContext theCtx, IBaseResource theNewPayload) {
        List<ResourceReferenceInfo> refs = theCtx.newTerser().getAllResourceReferences(theNewPayload);
        for (ResourceReferenceInfo next : refs) {
            IBaseResource resource;
            String ref = next.getResourceReference().getReferenceElement().getValue();
            if (StringUtils.isBlank((CharSequence)ref) && (resource = next.getResourceReference().getResource()) != null) {
                ref = resource.getIdElement().getValue();
            }
            if (StringUtils.isNotBlank((CharSequence)ref) && !ref.startsWith("#") && ref.startsWith("urn:uuid:")) {
                throw new AssertionError((Object)("Reference at " + next.getName() + " is invalid: " + ref));
            }
        }
        return true;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("myId", (Object)this.myId).append("myOperationType", (Object)this.myOperationType).append("myPayloadId", (Object)this.myPayloadId).toString();
    }
}

