/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.validation.fields;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.ConfigLoader;
import ca.uhn.fhir.rest.server.interceptor.validation.fields.EmailValidator;
import ca.uhn.fhir.rest.server.interceptor.validation.fields.IValidator;
import ca.uhn.fhir.util.ExtensionUtil;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class FieldValidatingInterceptor {
    public static final String FHIR_PATH_VALUE = "value";
    private static final Logger ourLog = LoggerFactory.getLogger(FieldValidatingInterceptor.class);
    public static final String VALIDATION_DISABLED_HEADER = "HAPI-Field-Validation-Disabled";
    public static final String PROPERTY_EXTENSION_URL = "validation.extension.url";
    private Map<String, String> myConfig;

    public FieldValidatingInterceptor() {
        ourLog.info("Starting FieldValidatingInterceptor {}", (Object)this);
        this.myConfig = ConfigLoader.loadJson("classpath:field-validation-rules.json", Map.class);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED)
    public void resourcePreCreate(RequestDetails theRequest, IBaseResource theResource) {
        ourLog.debug("Validating address on create for resource {} / request {}", (Object)theResource, (Object)theRequest);
        this.handleRequest(theRequest, theResource);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    public void resourcePreUpdate(RequestDetails theRequest, IBaseResource theOldResource, IBaseResource theNewResource) {
        ourLog.debug("Validating address on update for resource {} / old resource {} / request {}", new Object[]{theOldResource, theNewResource, theRequest});
        this.handleRequest(theRequest, theNewResource);
    }

    protected void handleRequest(RequestDetails theRequest, IBaseResource theResource) {
        if (theRequest == null) {
            ourLog.debug("RequestDetails is null - unable to validate {}", (Object)theResource);
            return;
        }
        if (!theRequest.getHeaders(VALIDATION_DISABLED_HEADER).isEmpty()) {
            ourLog.debug("Address validation is disabled for this request via header");
            return;
        }
        FhirContext ctx = theRequest.getFhirContext();
        IFhirPath fhirPath = ctx.newFhirPath();
        for (Map.Entry<String, String> e : this.myConfig.entrySet()) {
            IValidator validator = this.getValidator(e.getValue());
            if (validator == null) continue;
            List<IBase> fields = fhirPath.evaluate(theResource, e.getKey(), IBase.class);
            for (IBase field : fields) {
                List<IPrimitiveType> values2 = fhirPath.evaluate(field, FHIR_PATH_VALUE, IPrimitiveType.class);
                boolean isValid = true;
                for (IPrimitiveType value : values2) {
                    String valueAsString = value.getValueAsString();
                    isValid = validator.isValid(valueAsString);
                    ourLog.debug("Field {} at path {} validated {}", new Object[]{value, e.getKey(), isValid});
                    if (isValid) continue;
                    break;
                }
                this.setValidationStatus(ctx, field, isValid);
            }
        }
    }

    private void setValidationStatus(FhirContext ctx, IBase theBase, boolean isValid) {
        ExtensionUtil.clearExtensionsByUrl(theBase, this.getValidationExtensionUrl());
        ExtensionUtil.setExtension(ctx, theBase, this.getValidationExtensionUrl(), "boolean", !isValid);
    }

    private String getValidationExtensionUrl() {
        if (this.myConfig.containsKey(PROPERTY_EXTENSION_URL)) {
            return this.myConfig.get(PROPERTY_EXTENSION_URL);
        }
        return "https://hapifhir.org/StructureDefinition/ext-validation-field-has-error";
    }

    private IValidator getValidator(String theValue) {
        if (PROPERTY_EXTENSION_URL.equals(theValue)) {
            return null;
        }
        if (ValidatorType.EMAIL.name().equals(theValue)) {
            return new EmailValidator();
        }
        try {
            return (IValidator)Class.forName(theValue).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to create validator for %s", theValue), e);
        }
    }

    public Map<String, String> getConfig() {
        return this.myConfig;
    }

    public void setConfig(Map<String, String> theConfig) {
        this.myConfig = theConfig;
    }

    public static enum ValidatorType {
        EMAIL;

    }
}

