/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.s13n;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.FhirPathExecutionException;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.ConfigLoader;
import ca.uhn.fhir.rest.server.interceptor.s13n.standardizers.EmailStandardizer;
import ca.uhn.fhir.rest.server.interceptor.s13n.standardizers.FirstNameStandardizer;
import ca.uhn.fhir.rest.server.interceptor.s13n.standardizers.IStandardizer;
import ca.uhn.fhir.rest.server.interceptor.s13n.standardizers.LastNameStandardizer;
import ca.uhn.fhir.rest.server.interceptor.s13n.standardizers.PhoneStandardizer;
import ca.uhn.fhir.rest.server.interceptor.s13n.standardizers.TextStandardizer;
import ca.uhn.fhir.rest.server.interceptor.s13n.standardizers.TitleStandardizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class StandardizingInterceptor {
    public static final String STANDARDIZATION_DISABLED_HEADER = "HAPI-Standardization-Disabled";
    private static final Logger ourLog = LoggerFactory.getLogger(StandardizingInterceptor.class);
    private Map<String, Map<String, String>> myConfig;
    private Map<String, IStandardizer> myStandardizers = new HashMap<String, IStandardizer>();

    public StandardizingInterceptor() {
        ourLog.info("Starting StandardizingInterceptor {}", (Object)this);
        this.myConfig = ConfigLoader.loadJson("classpath:field-s13n-rules.json", Map.class);
        this.initStandardizers();
    }

    public StandardizingInterceptor(Map<String, Map<String, String>> theConfig) {
        this.myConfig = theConfig;
        this.initStandardizers();
    }

    public void initStandardizers() {
        this.myStandardizers.put(StandardizationType.NAME_FAMILY.name(), new LastNameStandardizer());
        this.myStandardizers.put(StandardizationType.NAME_GIVEN.name(), new FirstNameStandardizer());
        this.myStandardizers.put(StandardizationType.EMAIL.name(), new EmailStandardizer());
        this.myStandardizers.put(StandardizationType.TITLE.name(), new TitleStandardizer());
        this.myStandardizers.put(StandardizationType.PHONE.name(), new PhoneStandardizer());
        this.myStandardizers.put(StandardizationType.TEXT.name(), new TextStandardizer());
        ourLog.info("Initialized standardizers {}", this.myStandardizers);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED)
    public void resourcePreCreate(RequestDetails theRequest, IBaseResource theResource) {
        ourLog.debug("Standardizing on pre-create for - {}, {}", (Object)theRequest, (Object)theResource);
        this.standardize(theRequest, theResource);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    public void resourcePreUpdate(RequestDetails theRequest, IBaseResource theOldResource, IBaseResource theNewResource) {
        ourLog.debug("Standardizing on pre-update for - {}, {}, {}", new Object[]{theRequest, theOldResource, theNewResource});
        this.standardize(theRequest, theNewResource);
    }

    private void standardize(RequestDetails theRequest, IBaseResource theResource) {
        if (theRequest == null) {
            ourLog.debug("RequestDetails is null - unable to standardize {}", (Object)theResource);
            return;
        }
        if (!theRequest.getHeaders(STANDARDIZATION_DISABLED_HEADER).isEmpty()) {
            ourLog.debug("Standardization for {} is disabled via header {}", (Object)theResource, (Object)STANDARDIZATION_DISABLED_HEADER);
            return;
        }
        if (theResource == null) {
            ourLog.debug("Nothing to standardize for {}", (Object)theRequest);
            return;
        }
        FhirContext ctx = theRequest.getFhirContext();
        String resourceType = ctx.getResourceType(theResource);
        IFhirPath fhirPath = ctx.newFhirPath();
        for (Map.Entry<String, Map<String, String>> rule : this.myConfig.entrySet()) {
            String resourceFromConfig = rule.getKey();
            if (!this.appliesToResource(resourceFromConfig, resourceType)) continue;
            this.standardize(theResource, rule.getValue(), fhirPath);
        }
    }

    private void standardize(IBaseResource theResource, Map<String, String> theRules, IFhirPath theFhirPath) {
        for (Map.Entry<String, String> rule : theRules.entrySet()) {
            List<IBase> values2;
            IStandardizer std = this.getStandardizer(rule);
            try {
                values2 = theFhirPath.evaluate(theResource, rule.getKey(), IBase.class);
            }
            catch (FhirPathExecutionException e) {
                ourLog.warn("Unable to evaluate path at {} for {}", (Object)rule.getKey(), (Object)theResource);
                return;
            }
            for (IBase v : values2) {
                if (!(v instanceof IPrimitiveType)) {
                    ourLog.warn("Value at path {} is of type {}, which is not of primitive type - skipping", (Object)rule.getKey(), (Object)v.fhirType());
                    continue;
                }
                IPrimitiveType value = (IPrimitiveType)v;
                String valueString = value.getValueAsString();
                String standardizedValueString = std.standardize(valueString);
                value.setValueAsString(standardizedValueString);
                ourLog.debug("Standardized {} to {}", (Object)valueString, (Object)standardizedValueString);
            }
        }
    }

    private IStandardizer getStandardizer(Map.Entry<String, String> rule) {
        IStandardizer standardizer;
        String standardizerName = rule.getValue();
        if (this.myStandardizers.containsKey(standardizerName)) {
            return this.myStandardizers.get(standardizerName);
        }
        try {
            standardizer = (IStandardizer)Class.forName(standardizerName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to create standardizer %s", standardizerName), e);
        }
        this.myStandardizers.put(standardizerName, standardizer);
        return standardizer;
    }

    private boolean appliesToResource(String theResourceFromConfig, String theActualResourceType) {
        return theResourceFromConfig.equals(theActualResourceType);
    }

    public Map<String, Map<String, String>> getConfig() {
        return this.myConfig;
    }

    public void setConfig(Map<String, Map<String, String>> theConfig) {
        this.myConfig = theConfig;
    }

    public Map<String, IStandardizer> getStandardizers() {
        return this.myStandardizers;
    }

    public void setStandardizers(Map<String, IStandardizer> theStandardizers) {
        this.myStandardizers = theStandardizers;
    }

    public static enum StandardizationType {
        NAME_FAMILY,
        NAME_GIVEN,
        EMAIL,
        TITLE,
        PHONE,
        TEXT;

    }
}

